package com.ejianc.business.promaterial.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.promaterial.plan.bean.MasterPlanEntity;
import com.ejianc.business.promaterial.plan.mapper.MasterPlanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.promaterial.plan.mapper.MasterPlanDetailMapper;
import com.ejianc.business.promaterial.plan.bean.MasterPlanDetailEntity;
import com.ejianc.business.promaterial.plan.service.IMasterPlanDetailService;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 消耗材总计划子表
 * 
 * @author generator
 * 
 */
@Service("masterPlanDetailService")
public class MasterPlanDetailServiceImpl extends BaseServiceImpl<MasterPlanDetailMapper, MasterPlanDetailEntity> implements IMasterPlanDetailService{

    @Autowired
    private MasterPlanDetailMapper masterPlanDetailMapper;

    @Autowired
    private MasterPlanMapper masterPlanMapper;

    @Override
    public void delByPlanIdAndDetailIds(List<Long> delDetailIds, Long planId) {
        if(CollectionUtils.isNotEmpty(delDetailIds)) {
            masterPlanDetailMapper.delByPlanIdAndDetailIds(delDetailIds, planId);
        }
    }

    @Override
    public List<MasterPlanDetailEntity> getByProjectId(Long projectId, Integer planType) {
        QueryWrapper<MasterPlanEntity> masterPlanQuery = new QueryWrapper<>();
        masterPlanQuery.eq("project_id", projectId);
        masterPlanQuery.eq("dr", BaseVO.DR_UNDELETE);
        masterPlanQuery.eq("plan_type", planType);
        masterPlanQuery.in("bill_state", new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        MasterPlanEntity masterPlanEntity = masterPlanMapper.selectOne(masterPlanQuery);

        if(null == masterPlanEntity) {
            return new ArrayList<>();
        }
        QueryWrapper<MasterPlanDetailEntity> planDetailQuery = new QueryWrapper<>();
        planDetailQuery.eq("material_master_plan_id", masterPlanEntity.getId());
        planDetailQuery.eq("dr", BaseVO.DR_UNDELETE);

        return masterPlanDetailMapper.selectList(planDetailQuery);
    }

    @Override
    public List<Map> getDetailLastNum(List<Long> detailIds) {
        return masterPlanDetailMapper.getDetailLastNum(detailIds);
    }


}
