package com.ejianc.business.promaterial.check.service;

import com.ejianc.business.promaterial.check.bean.CheckEntity;
import com.ejianc.business.promaterial.check.vo.CheckVO;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 消耗材-验收主表
 *
 * @author generator
 *
 */
public interface ICheckService extends IBaseService<CheckEntity> {

    CheckVO saveOrUpdates(CheckVO saveOrUpdateVO, Boolean isControl);

    void deletes(List<CheckVO> vos);

    boolean pushBillToSupCenter(String datInfo, Long supplierId, Long sourceId, String billTypeCode, CooperateVO cooperate, String url);

    String updateBillSupSignSyncInfo(HttpServletRequest request);

    CheckVO getRateAndPrice(CheckVO saveOrUpdateVO);

    CheckVO hntgetRateAndPrice(Long sourceDetailId);

    CheckVO hntOrderRateAndPrice(Long sourceDetailId);

    void costPush(CheckEntity outStoreEntity);

    CommonResponse<CheckVO> pushCost(CheckVO checkVO);

    CheckVO getDetailListData(CheckVO checkVO);

    ParamsCheckVO viewTargetCostCtrlInfo(Long id);

    ParamsCheckVO targetCostCtrl(CheckVO checkVO);

    ParamsCheckVO checkParams(CheckVO vo, ParamsCheckVO paramsCheckVO2);






    /*
     * 材料验收、混凝土验收—无合同验收-单个供应商无合同验收金额控制
     */

    /*
     * 材料验收、混凝土验收—无合同验收-单次无合同验收金额控制*/
    List<ParamsCheckVO> checkParamsCheckNum(BigDecimal checkTaxMny, Long orgId);



    /*
     * 材料验收、混凝土验收—无合同验收-单个供应商无合同验收金额控制
     */
    List<ParamsCheckVO> checkParamsCheckSubNum(BigDecimal currentMny, BigDecimal checkTaxMnyAll, Long orgId);

    List<ParamsCheckVO> checkParamsNum(ContractEntity contractEntity, CheckVO vo);

    CheckEntity syncCost(Long id);
    /*历史价 控 明细价
     *        @param

     * */
    ParamsCheckVO priceCheckParams(CheckVO vo);

    CheckVO queryDetailWeigh(CheckVO vo);
    /*
     * 【施工合同金额】控【无合同验收、零星机械金额】*/
    List<ParamsCheckVO> checkParamsConstruction(CheckVO vo);

    /**
     * 根据项目id、验收日期查询消耗材、混凝土单据数量
     *
     * @param projectId 项目id
     * @param checkDate 验收日期
     * @return Map<String, Integer>
     */
    Map<String, Integer> countBillNum(Long projectId, Date checkDate);

    /**
     * 单个供应商无合同验收金额：根据项目+供应商查询所有状态的无合同材料验收+无合同混凝土验收金额
     *
     * @param projectId  项目id
     * @param supplierId 供应商id
     * @return 金额汇总
     */
    BigDecimal getSupplierNoContractMny(Long projectId, Long supplierId);

    void inStore(CheckEntity entity);
}
