package com.ejianc.business.promaterial.plan.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.plan.bean.PlanEntity;
import com.ejianc.business.promaterial.plan.service.IPlanDetailService;
import com.ejianc.business.promaterial.plan.service.IPlanService;
import com.ejianc.business.promaterial.plan.vo.PlanDetailRefVO;
import com.ejianc.business.promaterial.plan.vo.PlanDetailVO;
import com.ejianc.business.promaterial.plan.vo.PlanVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 消耗材-需用计划
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("plan")
@Api(value = "消耗材-需用计划", tags = {"消耗材-需用计划"})
public class PlanController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "XYPLAN_CODE";//此处需要根据实际修改

    @Autowired
    private IPlanService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IPlanDetailService planDetailService;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PlanVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody PlanVO saveOrUpdateVO) {
        return  service.saveOrUpdate(saveOrUpdateVO);
    }
    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PlanVO> queryDetail(@RequestParam Long id) {
    	PlanEntity entity = service.selectById(id);
    	PlanVO vo = BeanMapper.map(entity, PlanVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PlanVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (PlanVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(PlanVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PlanVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("deptName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(!param.getParams().containsKey("orgId")){
            /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
            UserContext userContextCache =sessionManager.getUserContext();
            //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
            String authOrgIds = userContextCache.getAuthOrgIds();
            List<OrgVO> orgVOList = null;
//            if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
//                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
//            }else {//pc端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
//            }
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if(5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if(CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if(CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
            /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        }
        IPage<PlanEntity> page = service.queryPage(param,false);
        IPage<PlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PlanVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("construction");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi
                .findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId)
                .collect(Collectors.toList())));
        List<PlanEntity> list = service.queryList(param);
        List<PlanVO> voList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)) {
            voList = BeanMapper.mapList(list, PlanVO.class);
            for (PlanVO vo : voList) {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("Plan-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refPlanData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PlanVO>> refPlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PlanEntity> page = service.queryPage(param,false);
        IPage<PlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PlanVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 计划参照-列表二级树
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @GetMapping("/planRef")
    @ResponseBody
    public CommonResponse<JSONObject> planRef(@RequestParam(defaultValue = "1") Integer pageNumber,
                                              @RequestParam(defaultValue = "10") Integer pageSize,
                                              @RequestParam(value = "condition", required = false) String condition,
                                              @RequestParam(value = "searchText", required = false) String searchText) {

        /** 模糊搜索配置字段示例 */
        QueryParam queryParam = new QueryParam();
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        //queryParam.getParams().put("tenantId", new Parameter("eq", InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("planFlag", new Parameter("eq", true));
        queryParam.getParams().put("materialId1", new Parameter(QueryParam.SQL,"material_id is not null"));
        Long projectId = null;
        Integer materialType = null;
        if(StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if(null != conditionMap.get("projectId")) {
                projectId = Long.valueOf(conditionMap.get("projectId").toString());
                queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            }
//            if(null != conditionMap.get("materialType")) {
//                materialType = Integer.valueOf(conditionMap.get("materialType").toString());
//                queryParam.getParams().put("materialType", new Parameter(QueryParam.EQ, materialType));
//            }
        }
        Page<PlanDetailVO> page = new Page<>((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        PlanVO planVO = new PlanVO();
        planVO.setTenantId(InvocationInfoProxy.getTenantid());
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        List<PlanDetailVO> list = planDetailService.geMaterialDetail(page,wrapper);
        List<Long> materialListId = new ArrayList<>();
        for (PlanDetailVO planDetailVO : list){
            planDetailVO.setParentId(999L);
            planDetailVO.setTid(planDetailVO.getMaterialId());
            materialListId.add(planDetailVO.getMaterialId());
        }
        QueryParam queryDetailParam = new QueryParam();
        queryDetailParam.getParams().put("materialId", new Parameter(QueryParam.IN, materialListId));
        List<PlanDetailRefVO> planVOList = service.getPlanByMaterialId(materialListId,wrapper);
        //遍历集合,添加children, 计划明细
        for(PlanDetailVO planDetailVO : list){
            ArrayList<PlanDetailRefVO> planDetail = new ArrayList<>();
            for(PlanDetailRefVO planVOChild : planVOList){
                if (planDetailVO.getMaterialId().equals(planVOChild.getMaterialId())){
                    planVOChild.setParentId(planDetailVO.getMaterialId());
                    planVOChild.setOrderNumsSum(planVOChild.getSurplusNumsSum());
                    planVOChild.setRowState("add");
                    planVOChild.setSourceName(planVOChild.getPlanBillCode()+planVOChild.getPlanEmployeeName());
                    planDetail.add(planVOChild);
                }
            }
            planDetailVO.setPlanDetail(planDetail);
        }
        JSONObject res = new JSONObject();
        res.put("records", list);
        res.put("total", page.getTotal());
        res.put("current", page.getCurrent());
        res.put("size", page.getSize());
        res.put("pages", page.getPages());
        return CommonResponse.success("查询列表数据成功！", res);
    }

    @ApiOperation("需用计划参数控制")
    @RequestMapping(value = "/paramCheck", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> paramCheck(@RequestBody PlanVO planVO) {
        List<ParamsCheckVO> allCheck = new ArrayList<>();
        ParamsCheckVO resp = new ParamsCheckVO();

//        logger.info("【消耗材总计划量】控制【消耗材需用计划量】 start");
//        allCheck.addAll(service.masterPlanNumCtrl(planVO));
//        logger.info("【消耗材总计划量】控制【消耗材需用计划量】 end");
//
//        logger.info("【消耗材总计划单价】控制【消耗材需用计划单价 start");
//        allCheck.addAll(service.masterPlanPriceCtrl(planVO));
//        logger.info("【消耗材总计划单价】控制【消耗材需用计划单价 end");

        logger.info("【总需用计划量】控制【分项需用计划量 start");
        allCheck.addAll(service.monthPlanNumCtrl(planVO));
        logger.info("【总需用计划量】控制【分项需用计划量 end");

        //设置最高预警登记
        Map<String, List<ParamsCheckVO>> checkListMap = allCheck.stream().filter(e -> e.getDataSource().size() > 0).collect(Collectors.groupingBy(ParamsCheckVO::getWarnType));
        List<ParamsCheckVO> result = new ArrayList<>();
        if(null != checkListMap.get("alert")) {
            result = checkListMap.get("alert");
            resp.setWarnType("alert");
        } else if(null != checkListMap.get("warn")) {
            result = checkListMap.get("warn");
            resp.setWarnType("warn");
        } else {
            resp.setWarnType("none");
        }
        for(ParamsCheckVO p : result) {
            resp.getDataSource().addAll(p.getDataSource());
        }
        return CommonResponse.success("参数校验成功！", resp);
    }
}
