package com.ejianc.business.promaterial.order.service.impl;

import com.ejianc.business.promaterial.check.bean.CheckDetailEntity;
import com.ejianc.business.promaterial.check.bean.CheckEntity;
import com.ejianc.business.promaterial.check.service.ICheckDetailService;
import com.ejianc.business.promaterial.check.service.ICheckService;
import com.ejianc.business.promaterial.order.bean.OrderDetailEntity;
import com.ejianc.business.promaterial.order.bean.OrderEntity;
import com.ejianc.business.promaterial.order.service.IOrderService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Service("order") 
public class OrderBpmServiceImpl implements ICommonBusinessService {
	private final Logger logger = LoggerFactory.getLogger(getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
	@Autowired
	private IOrderService service;
	private final String DEL_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/materialOrder/deleteOrder";

	@Autowired
	private ICheckService checkService;

	@Autowired
	private ICheckDetailService checkDetailService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		OrderEntity orderEntity = service.selectById(billId);
		orderEntity.setCommitId(InvocationInfoProxy.getUserid());
		service.saveOrUpdate(orderEntity,false);
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		OrderEntity orderEntity = service.selectById(billId);
		//处理推送数据，只推送子表父级
		if(CollectionUtils.isNotEmpty(orderEntity.getOrderDetailList())){
			List<OrderDetailEntity> orderDetail = new ArrayList<>();
			for (OrderDetailEntity orderDetailEntity : orderEntity.getOrderDetailList()) {
				if(!orderDetailEntity.getLeafFlag()){//判断是否是父级
					orderDetail.add(orderDetailEntity);
				}
			}
			orderEntity.setOrderDetailList(orderDetail);
		}
//		//推送供方
//		Boolean pushFlag = service.pushBillToSupCenter(orderEntity,billTypeCode);
//		logger.info("获取推送供方结果--"+pushFlag);
//		if(pushFlag){
//			//推送成功后处理逻辑
//			if(BillStateEnum.COMMITED_STATE.getBillStateCode() == state){
//				orderEntity.setCommitId(InvocationInfoProxy.getUserid());
//			}
//			orderEntity.setReceiveState(0);
//			service.saveOrUpdate(orderEntity,false);
//		}else{
//			return CommonResponse.error("推送供方失败");
//		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		OrderEntity entity = service.selectById(billId);
		List<Long> ids = entity.getOrderDetailList().stream().map(x->x.getId()).collect(Collectors.toList());
		if(CollectionUtils.isNotEmpty(ids)){
			QueryParam param = new QueryParam();
			param.getParams().put("orderDetailId", new Parameter(QueryParam.IN, ids));
			List<CheckDetailEntity> list = checkDetailService.queryList(param);
			if(CollectionUtils.isNotEmpty(list)){
				List<Long> pIds = list.stream().map(x->x.getCheckId()).distinct().collect(Collectors.toList());
				QueryParam queryParam = new QueryParam();
				queryParam.getParams().put("id", new Parameter(QueryParam.IN, pIds));
				List<CheckEntity> pList = checkService.queryList(queryParam);
				List<Long> pIds2 = pList.stream().map(x->x.getId()).collect(Collectors.toList());
				list = list.stream().filter(x->pIds2.contains(x.getCheckId())).collect(Collectors.toList());
			}
			if(CollectionUtils.isNotEmpty(list)){
				throw new BusinessException("下游单据已引用，不允许撤回！");
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		OrderEntity orderEntity = service.selectById(billId);
		service.updatePushBill(orderEntity,billTypeCode,DEL_BILL_SERVER_URL);
		orderEntity.setReceiveState(null);
		service.updateById(orderEntity);
		return CommonResponse.success("");
	}

}
