package com.ejianc.business.promaterial.plan.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.order.vo.OrderDetailVO;
import com.ejianc.business.promaterial.plan.vo.SinglePlanDetailVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.promaterial.plan.bean.SinglePlanDetailEntity;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 单项采购计划子表
 * 
 * @author generator
 * 
 */
public interface ISinglePlanDetailService extends IBaseService<SinglePlanDetailEntity> {

    List<SinglePlanDetailVO> geMaterialDetail(Page<SinglePlanDetailVO> page, QueryWrapper queryWrapper);

    List<OrderDetailVO> queryMaterialDetail(Long projectId, Long materialId);

    BigDecimal getSurplusNumsSum(Long projectId, Long materialId);

    List<Map<String, Object>> countDetailTotalNum(Long planId, List<Long> detailIds, Long projectId);

    List<Map<String, Object>> contractNumCtrl(Long planId, List<Long> detailIds, Long contractId);
}
