/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.deBalance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.procost.api.ICostSettingApi;
import com.ejianc.business.procost.vo.SettingVO;
import com.ejianc.business.proequipmentcorpout.util.DateUtil;
import com.ejianc.business.promaterial.deBalance.bean.DeBalanceDetailEntity;
import com.ejianc.business.promaterial.deBalance.bean.DeBalanceEntity;
import com.ejianc.business.promaterial.deBalance.mapper.DeBalanceMapper;
import com.ejianc.business.promaterial.deBalance.service.IDeBalanceDetailService;
import com.ejianc.business.promaterial.deBalance.service.IDeBalanceService;
import com.ejianc.business.promaterial.deBalance.vo.DeBalanceDetailVO;
import com.ejianc.business.promaterial.deBalance.vo.DeBalanceVO;
import com.ejianc.business.promaterial.out.service.IOutStoreService;
import com.ejianc.business.promaterial.out.service.IOutStoreSubService;
import com.ejianc.business.promaterial.settlement.bean.SettlementDetailEntity;
import com.ejianc.business.promaterial.settlement.service.ISettlementDetailService;
import com.ejianc.business.promaterial.settlement.service.ISettlementService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"deBalance"})
public class DeBalanceController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ICostSettingApi costSettingApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IDeBalanceService service;
    @Autowired
    private IDeBalanceDetailService detailService;
    @Autowired
    private ISettlementService settlementService;
    @Autowired
    private ISettlementDetailService settlementDetailService;
    @Autowired
    private IOutStoreService outStoreService;
    @Autowired
    private IOutStoreSubService outStoreSubService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private DeBalanceMapper mapper;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<DeBalanceVO> saveOrUpdate(@RequestBody DeBalanceVO saveOrUpdateVO) {
        DeBalanceEntity entity = (DeBalanceEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, DeBalanceEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        DeBalanceVO vo = (DeBalanceVO)BeanMapper.map((Object)((Object)entity), DeBalanceVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/checkSave"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DeBalanceVO> checkSave(@RequestParam Long projectId, @RequestParam Date month, @RequestParam String levyFlag, @RequestParam Long id) throws ParseException {
        List<DeBalanceDetailVO> list;
        List<DeBalanceDetailVO> allotInDetails;
        List settlementEntities;
        Object entity;
        Integer monthNumber;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = df.format(month);
        String[] dateArray = dateString.split("-");
        String startMonth = null;
        String endMonth = null;
        String startQueryMonth = null;
        String endQueryMonth = null;
        String queryMonth = dateArray[0] + "-" + dateArray[1] + "-01";
        String queryPrevMonth = null;
        if (dateArray[1].equals("1")) {
            monthNumber = new Integer(12);
            Integer yearNumber = new Integer(dateArray[0]) - 1;
            startMonth = yearNumber + "-" + monthNumber;
            endMonth = dateArray[0] + "-" + dateArray[1];
            startQueryMonth = yearNumber + "-11";
            endQueryMonth = dateArray[0] + "-12";
            queryPrevMonth = yearNumber + "-12-01";
        } else {
            monthNumber = new Integer(dateArray[1]) - 1;
            startMonth = dateArray[0] + "-" + monthNumber;
            endMonth = dateArray[0] + "-" + dateArray[1];
            startQueryMonth = dateArray[0] + "-" + (new Integer(dateArray[1]) - 2);
            endQueryMonth = dateArray[0] + "-" + (new Integer(dateArray[1]) - 1);
            queryPrevMonth = dateArray[0] + "-" + (new Integer(dateArray[1]) - 1) + "-01";
        }
        CommonResponse settingResp = this.costSettingApi.getSettingInfo(InvocationInfoProxy.getOrgId());
        if (!settingResp.isSuccess()) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u6210\u672c\u671f\u95f4\u8bbe\u7f6e\u4fe1\u606f\u5931\u8d25\uff01");
        }
        SettingVO setting = (SettingVO)settingResp.getData();
        if (null == setting) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u5f53\u524d\u7ec4\u7ec7\u672a\u8bbe\u7f6e\u8fdb\u884c\u6210\u672c\u5176\u95f4\u8bbe\u7f6e\uff01");
        }
        DeBalanceVO deBalanceVO = this.countDate(startMonth, endMonth, setting);
        List entities1 = this.service.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"project_id", (Object)projectId)).eq((Object)"month", (Object)queryMonth)).ne(id != null, (Object)"id", (Object)id));
        if (CollectionUtils.isNotEmpty((Collection)entities1)) {
            throw new BusinessException("\u76f8\u540c\u9879\u76ee\u76f8\u540c\u6708\u4efd\u4e0d\u5141\u8bb8\u51fa\u73b0\u4e24\u4efd\u7ed3\u5b58\u8868!");
        }
        List entities2 = this.service.list((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"project_id", (Object)projectId)).le((Object)"month", (Object)queryMonth)).notIn((Object)"bill_state", new Object[]{1, 3})).ne(id != null, (Object)"id", (Object)id));
        if (CollectionUtils.isNotEmpty((Collection)entities2)) {
            throw new BusinessException("\u8be5\u9879\u76ee\u5b58\u5728\u672a\u751f\u6548\u7684\u7ed3\u5b58\u8868!");
        }
        List entities3 = this.service.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"project_id", (Object)projectId)).gt((Object)"month", (Object)month)).ne(id != null, (Object)"id", (Object)id));
        if (CollectionUtils.isNotEmpty((Collection)entities3)) {
            throw new BusinessException("\u8be5\u9879\u76ee\u5b58\u5728\u5927\u4e8e\u8be5\u6708\u4efd\u7684\u7ed3\u5b58\u8868!");
        }
        DeBalanceVO deBalanceQueryVO = this.countDate(startQueryMonth, endQueryMonth, setting);
        List entities4 = this.service.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"project_id", (Object)projectId)).eq((Object)"month", (Object)queryPrevMonth));
        if (CollectionUtils.isEmpty((Collection)entities4)) {
            List settlementEntities2 = this.settlementService.list((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"project_id", (Object)projectId)).ge((Object)"update_time", (Object)deBalanceQueryVO.getStartDate())).le((Object)"update_time", (Object)deBalanceQueryVO.getEndDate())).eq((Object)"settlement_type", (Object)0)).in((Object)"bill_state", new Object[]{1, 3}));
            List outStoreEntities = this.outStoreService.list((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"project_id", (Object)projectId)).ge((Object)"update_time", (Object)deBalanceQueryVO.getStartDate())).le((Object)"update_time", (Object)deBalanceQueryVO.getEndDate())).in((Object)"bill_state", new Object[]{1, 3}));
            Integer allotOutCounts = this.mapper.queryAllotOut(projectId, deBalanceQueryVO.getStartDate(), deBalanceQueryVO.getEndDate());
            Integer allotInCounts = this.mapper.queryAllotIn(projectId, deBalanceQueryVO.getStartDate(), deBalanceQueryVO.getEndDate());
            Integer handleCounts = this.mapper.queryHandle(projectId, deBalanceQueryVO.getStartDate(), deBalanceQueryVO.getEndDate());
            Integer pickReturnCounts = this.mapper.queryPickReturn(projectId, deBalanceQueryVO.getStartDate(), deBalanceQueryVO.getEndDate());
            if (CollectionUtils.isNotEmpty((Collection)settlementEntities2) || CollectionUtils.isNotEmpty((Collection)outStoreEntities) || allotOutCounts != 0 || allotInCounts != 0 || handleCounts != 0 || pickReturnCounts != 0) {
                throw new BusinessException("\u8bf7\u5148\u751f\u6210\u4e0a\u6708\u7684\u7ed3\u5b58\u8868!");
            }
        }
        DeBalanceEntity deBalanceAddEntity = (DeBalanceEntity)((Object)this.service.getOne((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"project_id", (Object)projectId)).in((Object)"bill_state", new Object[]{1, 3})).orderByDesc((Object)"month")).last("LIMIT 1")));
        List detailEntityList = new ArrayList();
        if (deBalanceAddEntity != null) {
            detailEntityList = this.detailService.list((Wrapper)new QueryWrapper().eq((Object)"pid", (Object)deBalanceAddEntity.getId()));
        }
        Map<Object, Object> detailMap = new HashMap();
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            ArrayList<DeBalanceDetailEntity> deBalanceDetailEntities = new ArrayList<DeBalanceDetailEntity>();
            for (DeBalanceDetailEntity detailEntity : detailEntityList) {
                entity = new DeBalanceDetailEntity();
                ((DeBalanceDetailEntity)((Object)entity)).setMaterialId(detailEntity.getMaterialId());
                ((DeBalanceDetailEntity)((Object)entity)).setMaterialName(detailEntity.getMaterialName());
                ((DeBalanceDetailEntity)((Object)entity)).setMaterialCode(detailEntity.getMaterialCode());
                ((DeBalanceDetailEntity)((Object)entity)).setSpecs(detailEntity.getSpecs());
                ((DeBalanceDetailEntity)((Object)entity)).setUnit(detailEntity.getUnit());
                ((DeBalanceDetailEntity)((Object)entity)).setOpeningBalanceNum(detailEntity.getClosingBalanceTotalNum() != null ? detailEntity.getClosingBalanceTotalNum() : BigDecimal.ZERO);
                ((DeBalanceDetailEntity)((Object)entity)).setOpeningBalanceMny(detailEntity.getClosingBalanceTotalMny() != null ? detailEntity.getClosingBalanceTotalMny() : BigDecimal.ZERO);
                deBalanceDetailEntities.add((DeBalanceDetailEntity)((Object)entity));
            }
            detailMap = deBalanceDetailEntities.stream().filter(t -> t.getMaterialId() != null).collect(Collectors.toMap(DeBalanceDetailEntity::getMaterialId, Function.identity()));
        }
        if (CollectionUtils.isNotEmpty((Collection)(settlementEntities = this.settlementService.list((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"project_id", (Object)projectId)).ge((Object)"update_time", (Object)deBalanceVO.getStartDate())).le((Object)"update_time", (Object)deBalanceVO.getEndDate())).eq((Object)"settlement_type", (Object)0)).in((Object)"bill_state", new Object[]{1, 3}))))) {
            List settlementIds = settlementEntities.stream().map(BaseEntity::getId).collect(Collectors.toList());
            List settlementDetailEntities = this.settlementDetailService.list((Wrapper)new QueryWrapper().in((Object)"settlement_id", settlementIds));
            entity = settlementDetailEntities.iterator();
            while (entity.hasNext()) {
                Object detailEntity = (SettlementDetailEntity)((Object)entity.next());
                if (detailMap.containsKey(detailEntity.getMaterialId())) {
                    ((DeBalanceDetailEntity)((Object)detailMap.get(detailEntity.getMaterialId()))).setCurrentIncomePurchaseNum(ComputeUtil.safeAdd((BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(detailEntity.getMaterialId()))).getCurrentIncomePurchaseNum(), (BigDecimal)detailEntity.getNum()));
                    if (levyFlag.equals("0")) {
                        ((DeBalanceDetailEntity)((Object)detailMap.get(detailEntity.getMaterialId()))).setCurrentIncomePurchaseMny(ComputeUtil.safeAdd((BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(detailEntity.getMaterialId()))).getCurrentIncomePurchaseMny(), (BigDecimal)detailEntity.getMny()));
                        continue;
                    }
                    ((DeBalanceDetailEntity)((Object)detailMap.get(detailEntity.getMaterialId()))).setCurrentIncomePurchaseMny(ComputeUtil.safeAdd((BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(detailEntity.getMaterialId()))).getCurrentIncomePurchaseMny(), (BigDecimal)detailEntity.getTaxMny()));
                    continue;
                }
                DeBalanceDetailEntity deBalanceDetailEntity = new DeBalanceDetailEntity();
                deBalanceDetailEntity.setMaterialId(detailEntity.getMaterialId());
                deBalanceDetailEntity.setMaterialName(detailEntity.getMaterialName());
                deBalanceDetailEntity.setMaterialCode(detailEntity.getMaterialCode());
                deBalanceDetailEntity.setSpecs(detailEntity.getSpec());
                deBalanceDetailEntity.setUnit(detailEntity.getUnit());
                deBalanceDetailEntity.setCurrentIncomePurchaseNum(detailEntity.getNum());
                if (levyFlag.equals("0")) {
                    deBalanceDetailEntity.setCurrentIncomePurchaseMny(detailEntity.getMny());
                } else {
                    deBalanceDetailEntity.setCurrentIncomePurchaseMny(detailEntity.getTaxMny());
                }
                detailMap.put(detailEntity.getMaterialId(), (Object)deBalanceDetailEntity);
            }
        }
        if (CollectionUtils.isNotEmpty(allotInDetails = this.mapper.queryAllotInDetail(projectId, deBalanceVO.getStartDate(), deBalanceVO.getEndDate()))) {
            for (DeBalanceDetailVO detailVO : allotInDetails) {
                if (detailMap.containsKey(detailVO.getMaterialId())) {
                    ((DeBalanceDetailEntity)((Object)detailMap.get(detailVO.getMaterialId()))).setCurrentIncomeCallNum(ComputeUtil.safeAdd((BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(detailVO.getMaterialId()))).getCurrentIncomeCallNum(), (BigDecimal)detailVO.getNum()));
                    if (levyFlag.equals("0")) {
                        ((DeBalanceDetailEntity)((Object)detailMap.get(detailVO.getMaterialId()))).setCurrentIncomeCallMny(ComputeUtil.safeAdd((BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(detailVO.getMaterialId()))).getCurrentIncomeCallMny(), (BigDecimal)detailVO.getMny()));
                        continue;
                    }
                    ((DeBalanceDetailEntity)((Object)detailMap.get(detailVO.getMaterialId()))).setCurrentIncomeCallMny(ComputeUtil.safeAdd((BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(detailVO.getMaterialId()))).getCurrentIncomeCallMny(), (BigDecimal)detailVO.getTaxMny()));
                    continue;
                }
                detailVO.setCurrentIncomeCallNum(detailVO.getNum());
                if (levyFlag.equals("0")) {
                    detailVO.setCurrentIncomeCallMny(detailVO.getMny());
                } else {
                    detailVO.setCurrentIncomeCallMny(detailVO.getTaxMny());
                }
                detailMap.put(detailVO.getMaterialId(), BeanMapper.map((Object)detailVO, DeBalanceDetailEntity.class));
            }
        }
        List<DeBalanceDetailVO> outStoreDetailVOS = this.mapper.queryOutStore(projectId, deBalanceVO.getStartDate(), deBalanceVO.getEndDate());
        List<DeBalanceDetailVO> pickReturnDetailVOS = this.mapper.queryPickReturnDetail(projectId, deBalanceVO.getStartDate(), deBalanceVO.getEndDate());
        for (DeBalanceDetailVO deBalanceDetailVO : outStoreDetailVOS) {
            if (detailMap.containsKey(deBalanceDetailVO.getMaterialId())) {
                switch (deBalanceDetailVO.getMaterialUse()) {
                    case "\u5de5\u7a0b\u6d88\u8017": {
                        ((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).setCurrentExpenditureConsumeNum(ComputeUtil.safeAdd((BigDecimal)deBalanceDetailVO.getNum(), (BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).getCurrentExpenditureConsumeNum()));
                        if (levyFlag.equals("0")) {
                            ((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).setCurrentExpenditureConsumeMny(ComputeUtil.safeAdd((BigDecimal)deBalanceDetailVO.getMny(), (BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).getCurrentExpenditureConsumeMny()));
                            break;
                        }
                        ((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).setCurrentExpenditureConsumeMny(ComputeUtil.safeAdd((BigDecimal)deBalanceDetailVO.getTaxMny(), (BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).getCurrentExpenditureConsumeMny()));
                        break;
                    }
                    case "\u5b89\u5168\u65bd\u5de5": {
                        ((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).setCurrentExpenditureSecureNum(ComputeUtil.safeAdd((BigDecimal)deBalanceDetailVO.getNum(), (BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).getCurrentExpenditureSecureNum()));
                        if (levyFlag.equals("0")) {
                            ((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).setCurrentExpenditureSecureMny(ComputeUtil.safeAdd((BigDecimal)deBalanceDetailVO.getMny(), (BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).getCurrentExpenditureSecureMny()));
                            break;
                        }
                        ((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).setCurrentExpenditureSecureMny(ComputeUtil.safeAdd((BigDecimal)deBalanceDetailVO.getTaxMny(), (BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).getCurrentExpenditureSecureMny()));
                        break;
                    }
                    case "\u6587\u660e\u65bd\u5de5": {
                        ((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).setCurrentExpenditureCivilizationNum(ComputeUtil.safeAdd((BigDecimal)deBalanceDetailVO.getNum(), (BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).getCurrentExpenditureCivilizationNum()));
                        if (levyFlag.equals("0")) {
                            ((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).setCurrentExpenditureCivilizationMny(ComputeUtil.safeAdd((BigDecimal)deBalanceDetailVO.getMny(), (BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).getCurrentExpenditureCivilizationMny()));
                            break;
                        }
                        ((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).setCurrentExpenditureCivilizationMny(ComputeUtil.safeAdd((BigDecimal)deBalanceDetailVO.getTaxMny(), (BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).getCurrentExpenditureCivilizationMny()));
                        break;
                    }
                    case "\u4e34\u65f6\u8bbe\u65bd": {
                        ((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).setCurrentExpenditureTemporaryNum(ComputeUtil.safeAdd((BigDecimal)deBalanceDetailVO.getNum(), (BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).getCurrentExpenditureTemporaryNum()));
                        if (levyFlag.equals("0")) {
                            ((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).setCurrentExpenditureTemporaryMny(ComputeUtil.safeAdd((BigDecimal)deBalanceDetailVO.getMny(), (BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).getCurrentExpenditureTemporaryMny()));
                            break;
                        }
                        ((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).setCurrentExpenditureTemporaryMny(ComputeUtil.safeAdd((BigDecimal)deBalanceDetailVO.getTaxMny(), (BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).getCurrentExpenditureTemporaryMny()));
                        break;
                    }
                    case "\u5176\u4ed6\u63aa\u65bd\u8d39": {
                        ((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).setCurrentExpenditureOtherNum(ComputeUtil.safeAdd((BigDecimal)deBalanceDetailVO.getNum(), (BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).getCurrentExpenditureOtherNum()));
                        if (levyFlag.equals("0")) {
                            ((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).setCurrentExpenditureOtherMny(ComputeUtil.safeAdd((BigDecimal)deBalanceDetailVO.getMny(), (BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).getCurrentExpenditureOtherMny()));
                            break;
                        }
                        ((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).setCurrentExpenditureOtherMny(ComputeUtil.safeAdd((BigDecimal)deBalanceDetailVO.getTaxMny(), (BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).getCurrentExpenditureOtherMny()));
                        break;
                    }
                    case "\u52b3\u4fdd\u3001\u884c\u653f\u7528\u54c1": {
                        ((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).setCurrentExpenditureArticlesNum(ComputeUtil.safeAdd((BigDecimal)deBalanceDetailVO.getNum(), (BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).getCurrentExpenditureArticlesNum()));
                        if (levyFlag.equals("0")) {
                            ((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).setCurrentExpenditureArticlesMny(ComputeUtil.safeAdd((BigDecimal)deBalanceDetailVO.getMny(), (BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).getCurrentExpenditureArticlesMny()));
                            break;
                        }
                        ((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).setCurrentExpenditureArticlesMny(ComputeUtil.safeAdd((BigDecimal)deBalanceDetailVO.getTaxMny(), (BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).getCurrentExpenditureArticlesMny()));
                        break;
                    }
                    case "\u673a\u68b0\u8017\u7528": {
                        ((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).setCurrentExpenditureExpendNum(ComputeUtil.safeAdd((BigDecimal)deBalanceDetailVO.getNum(), (BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).getCurrentExpenditureExpendNum()));
                        if (levyFlag.equals("0")) {
                            ((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).setCurrentExpenditureExpendMny(ComputeUtil.safeAdd((BigDecimal)deBalanceDetailVO.getMny(), (BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).getCurrentExpenditureExpendMny()));
                            break;
                        }
                        ((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).setCurrentExpenditureExpendMny(ComputeUtil.safeAdd((BigDecimal)deBalanceDetailVO.getTaxMny(), (BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).getCurrentExpenditureExpendMny()));
                    }
                }
                continue;
            }
            switch (deBalanceDetailVO.getMaterialUse()) {
                case "\u5de5\u7a0b\u6d88\u8017": {
                    deBalanceDetailVO.setCurrentExpenditureConsumeNum(deBalanceDetailVO.getNum());
                    if (levyFlag.equals("0")) {
                        deBalanceDetailVO.setCurrentExpenditureConsumeMny(deBalanceDetailVO.getMny());
                    } else {
                        deBalanceDetailVO.setCurrentExpenditureConsumeMny(deBalanceDetailVO.getTaxMny());
                    }
                    detailMap.put(deBalanceDetailVO.getMaterialId(), BeanMapper.map((Object)deBalanceDetailVO, DeBalanceDetailEntity.class));
                    break;
                }
                case "\u5b89\u5168\u65bd\u5de5": {
                    deBalanceDetailVO.setCurrentExpenditureSecureNum(deBalanceDetailVO.getNum());
                    if (levyFlag.equals("0")) {
                        deBalanceDetailVO.setCurrentExpenditureSecureMny(deBalanceDetailVO.getMny());
                    } else {
                        deBalanceDetailVO.setCurrentExpenditureSecureMny(deBalanceDetailVO.getTaxMny());
                    }
                    detailMap.put(deBalanceDetailVO.getMaterialId(), BeanMapper.map((Object)deBalanceDetailVO, DeBalanceDetailEntity.class));
                    break;
                }
                case "\u6587\u660e\u65bd\u5de5": {
                    deBalanceDetailVO.setCurrentExpenditureCivilizationNum(deBalanceDetailVO.getNum());
                    if (levyFlag.equals("0")) {
                        deBalanceDetailVO.setCurrentExpenditureCivilizationMny(deBalanceDetailVO.getMny());
                    } else {
                        deBalanceDetailVO.setCurrentExpenditureCivilizationMny(deBalanceDetailVO.getTaxMny());
                    }
                    detailMap.put(deBalanceDetailVO.getMaterialId(), BeanMapper.map((Object)deBalanceDetailVO, DeBalanceDetailEntity.class));
                    break;
                }
                case "\u4e34\u65f6\u8bbe\u65bd": {
                    deBalanceDetailVO.setCurrentExpenditureTemporaryNum(deBalanceDetailVO.getNum());
                    if (levyFlag.equals("0")) {
                        deBalanceDetailVO.setCurrentExpenditureTemporaryMny(deBalanceDetailVO.getMny());
                    } else {
                        deBalanceDetailVO.setCurrentExpenditureTemporaryMny(deBalanceDetailVO.getTaxMny());
                    }
                    detailMap.put(deBalanceDetailVO.getMaterialId(), BeanMapper.map((Object)deBalanceDetailVO, DeBalanceDetailEntity.class));
                    break;
                }
                case "\u5176\u4ed6\u63aa\u65bd\u8d39": {
                    deBalanceDetailVO.setCurrentExpenditureOtherNum(deBalanceDetailVO.getNum());
                    if (levyFlag.equals("0")) {
                        deBalanceDetailVO.setCurrentExpenditureOtherMny(deBalanceDetailVO.getMny());
                    } else {
                        deBalanceDetailVO.setCurrentExpenditureOtherMny(deBalanceDetailVO.getTaxMny());
                    }
                    detailMap.put(deBalanceDetailVO.getMaterialId(), BeanMapper.map((Object)deBalanceDetailVO, DeBalanceDetailEntity.class));
                    break;
                }
                case "\u52b3\u4fdd\u3001\u884c\u653f\u7528\u54c1": {
                    deBalanceDetailVO.setCurrentExpenditureArticlesNum(deBalanceDetailVO.getNum());
                    if (levyFlag.equals("0")) {
                        deBalanceDetailVO.setCurrentExpenditureArticlesMny(deBalanceDetailVO.getMny());
                    } else {
                        deBalanceDetailVO.setCurrentExpenditureArticlesMny(deBalanceDetailVO.getTaxMny());
                    }
                    detailMap.put(deBalanceDetailVO.getMaterialId(), BeanMapper.map((Object)deBalanceDetailVO, DeBalanceDetailEntity.class));
                    break;
                }
                case "\u673a\u68b0\u8017\u7528": {
                    deBalanceDetailVO.setCurrentExpenditureExpendNum(deBalanceDetailVO.getNum());
                    if (levyFlag.equals("0")) {
                        deBalanceDetailVO.setCurrentExpenditureExpendMny(deBalanceDetailVO.getMny());
                    } else {
                        deBalanceDetailVO.setCurrentExpenditureExpendMny(deBalanceDetailVO.getTaxMny());
                    }
                    detailMap.put(deBalanceDetailVO.getMaterialId(), BeanMapper.map((Object)deBalanceDetailVO, DeBalanceDetailEntity.class));
                }
            }
        }
        for (DeBalanceDetailVO deBalanceDetailVO : pickReturnDetailVOS) {
            if (detailMap.containsKey(deBalanceDetailVO.getMaterialId())) {
                switch (deBalanceDetailVO.getMaterialUse()) {
                    case "\u5de5\u7a0b\u6d88\u8017": {
                        ((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).setCurrentExpenditureConsumeNum(ComputeUtil.safeSub((BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).getCurrentExpenditureConsumeNum(), (BigDecimal)deBalanceDetailVO.getNum()));
                        if (levyFlag.equals("0")) {
                            ((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).setCurrentExpenditureConsumeMny(ComputeUtil.safeSub((BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).getCurrentExpenditureConsumeMny(), (BigDecimal)deBalanceDetailVO.getMny()));
                            break;
                        }
                        ((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).setCurrentExpenditureConsumeMny(ComputeUtil.safeSub((BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).getCurrentExpenditureConsumeMny(), (BigDecimal)deBalanceDetailVO.getTaxMny()));
                        break;
                    }
                    case "\u5b89\u5168\u65bd\u5de5": {
                        ((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).setCurrentExpenditureSecureNum(ComputeUtil.safeSub((BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).getCurrentExpenditureSecureNum(), (BigDecimal)deBalanceDetailVO.getNum()));
                        if (levyFlag.equals("0")) {
                            ((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).setCurrentExpenditureSecureMny(ComputeUtil.safeSub((BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).getCurrentExpenditureSecureMny(), (BigDecimal)deBalanceDetailVO.getMny()));
                            break;
                        }
                        ((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).setCurrentExpenditureSecureMny(ComputeUtil.safeSub((BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).getCurrentExpenditureSecureMny(), (BigDecimal)deBalanceDetailVO.getTaxMny()));
                        break;
                    }
                    case "\u6587\u660e\u65bd\u5de5": {
                        ((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).setCurrentExpenditureCivilizationNum(ComputeUtil.safeSub((BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).getCurrentExpenditureCivilizationNum(), (BigDecimal)deBalanceDetailVO.getNum()));
                        if (levyFlag.equals("0")) {
                            ((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).setCurrentExpenditureCivilizationMny(ComputeUtil.safeSub((BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).getCurrentExpenditureCivilizationMny(), (BigDecimal)deBalanceDetailVO.getMny()));
                            break;
                        }
                        ((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).setCurrentExpenditureCivilizationMny(ComputeUtil.safeSub((BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).getCurrentExpenditureCivilizationMny(), (BigDecimal)deBalanceDetailVO.getTaxMny()));
                        break;
                    }
                    case "\u4e34\u65f6\u8bbe\u65bd": {
                        ((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).setCurrentExpenditureTemporaryNum(ComputeUtil.safeSub((BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).getCurrentExpenditureTemporaryNum(), (BigDecimal)deBalanceDetailVO.getNum()));
                        if (levyFlag.equals("0")) {
                            ((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).setCurrentExpenditureTemporaryMny(ComputeUtil.safeSub((BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).getCurrentExpenditureTemporaryMny(), (BigDecimal)deBalanceDetailVO.getMny()));
                            break;
                        }
                        ((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).setCurrentExpenditureTemporaryMny(ComputeUtil.safeSub((BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).getCurrentExpenditureTemporaryMny(), (BigDecimal)deBalanceDetailVO.getTaxMny()));
                        break;
                    }
                    case "\u5176\u4ed6\u63aa\u65bd\u8d39": {
                        ((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).setCurrentExpenditureOtherNum(ComputeUtil.safeSub((BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).getCurrentExpenditureOtherNum(), (BigDecimal)deBalanceDetailVO.getNum()));
                        if (levyFlag.equals("0")) {
                            ((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).setCurrentExpenditureOtherMny(ComputeUtil.safeSub((BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).getCurrentExpenditureOtherMny(), (BigDecimal)deBalanceDetailVO.getMny()));
                            break;
                        }
                        ((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).setCurrentExpenditureOtherMny(ComputeUtil.safeSub((BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).getCurrentExpenditureOtherMny(), (BigDecimal)deBalanceDetailVO.getTaxMny()));
                        break;
                    }
                    case "\u52b3\u4fdd\u3001\u884c\u653f\u7528\u54c1": {
                        ((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).setCurrentExpenditureArticlesNum(ComputeUtil.safeSub((BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).getCurrentExpenditureArticlesNum(), (BigDecimal)deBalanceDetailVO.getNum()));
                        if (levyFlag.equals("0")) {
                            ((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).setCurrentExpenditureArticlesMny(ComputeUtil.safeSub((BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).getCurrentExpenditureArticlesMny(), (BigDecimal)deBalanceDetailVO.getMny()));
                            break;
                        }
                        ((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).setCurrentExpenditureArticlesMny(ComputeUtil.safeSub((BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).getCurrentExpenditureArticlesMny(), (BigDecimal)deBalanceDetailVO.getTaxMny()));
                        break;
                    }
                    case "\u673a\u68b0\u8017\u7528": {
                        ((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).setCurrentExpenditureExpendNum(ComputeUtil.safeSub((BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).getCurrentExpenditureExpendNum(), (BigDecimal)deBalanceDetailVO.getNum()));
                        if (levyFlag.equals("0")) {
                            ((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).setCurrentExpenditureExpendMny(ComputeUtil.safeSub((BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).getCurrentExpenditureExpendMny(), (BigDecimal)deBalanceDetailVO.getMny()));
                            break;
                        }
                        ((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).setCurrentExpenditureExpendMny(ComputeUtil.safeSub((BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).getCurrentExpenditureExpendMny(), (BigDecimal)deBalanceDetailVO.getTaxMny()));
                    }
                }
                continue;
            }
            switch (deBalanceDetailVO.getMaterialUse()) {
                case "\u5de5\u7a0b\u6d88\u8017": {
                    deBalanceDetailVO.setCurrentExpenditureConsumeNum(ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)deBalanceDetailVO.getNum()));
                    if (levyFlag.equals("0")) {
                        deBalanceDetailVO.setCurrentExpenditureConsumeMny(ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)deBalanceDetailVO.getMny()));
                    } else {
                        deBalanceDetailVO.setCurrentExpenditureConsumeMny(ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)deBalanceDetailVO.getTaxMny()));
                    }
                    detailMap.put(deBalanceDetailVO.getMaterialId(), BeanMapper.map((Object)deBalanceDetailVO, DeBalanceDetailEntity.class));
                    break;
                }
                case "\u5b89\u5168\u65bd\u5de5": {
                    deBalanceDetailVO.setCurrentExpenditureSecureNum(ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)deBalanceDetailVO.getNum()));
                    if (levyFlag.equals("0")) {
                        deBalanceDetailVO.setCurrentExpenditureSecureMny(ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)deBalanceDetailVO.getMny()));
                    } else {
                        deBalanceDetailVO.setCurrentExpenditureSecureMny(ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)deBalanceDetailVO.getTaxMny()));
                    }
                    detailMap.put(deBalanceDetailVO.getMaterialId(), BeanMapper.map((Object)deBalanceDetailVO, DeBalanceDetailEntity.class));
                    break;
                }
                case "\u6587\u660e\u65bd\u5de5": {
                    deBalanceDetailVO.setCurrentExpenditureCivilizationNum(ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)deBalanceDetailVO.getNum()));
                    if (levyFlag.equals("0")) {
                        deBalanceDetailVO.setCurrentExpenditureCivilizationMny(ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)deBalanceDetailVO.getMny()));
                    } else {
                        deBalanceDetailVO.setCurrentExpenditureCivilizationMny(ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)deBalanceDetailVO.getTaxMny()));
                    }
                    detailMap.put(deBalanceDetailVO.getMaterialId(), BeanMapper.map((Object)deBalanceDetailVO, DeBalanceDetailEntity.class));
                    break;
                }
                case "\u4e34\u65f6\u8bbe\u65bd": {
                    if (detailMap.containsKey(deBalanceDetailVO.getMaterialId())) {
                        ((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).setCurrentExpenditureTemporaryNum(ComputeUtil.safeSub((BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).getCurrentExpenditureTemporaryNum(), (BigDecimal)deBalanceDetailVO.getNum()));
                        if (levyFlag.equals("0")) {
                            ((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).setCurrentExpenditureTemporaryMny(ComputeUtil.safeSub((BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).getCurrentExpenditureTemporaryMny(), (BigDecimal)deBalanceDetailVO.getMny()));
                            break;
                        }
                        ((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).setCurrentExpenditureTemporaryMny(ComputeUtil.safeSub((BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).getCurrentExpenditureTemporaryMny(), (BigDecimal)deBalanceDetailVO.getTaxMny()));
                        break;
                    }
                    deBalanceDetailVO.setCurrentExpenditureTemporaryNum(ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)deBalanceDetailVO.getNum()));
                    if (levyFlag.equals("0")) {
                        deBalanceDetailVO.setCurrentExpenditureTemporaryMny(ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)deBalanceDetailVO.getMny()));
                    } else {
                        deBalanceDetailVO.setCurrentExpenditureTemporaryMny(ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)deBalanceDetailVO.getTaxMny()));
                    }
                    detailMap.put(deBalanceDetailVO.getMaterialId(), BeanMapper.map((Object)deBalanceDetailVO, DeBalanceDetailEntity.class));
                    break;
                }
                case "\u5176\u4ed6\u63aa\u65bd\u8d39": {
                    deBalanceDetailVO.setCurrentExpenditureOtherNum(ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)deBalanceDetailVO.getNum()));
                    if (levyFlag.equals("0")) {
                        deBalanceDetailVO.setCurrentExpenditureOtherMny(ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)deBalanceDetailVO.getMny()));
                    } else {
                        deBalanceDetailVO.setCurrentExpenditureOtherMny(ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)deBalanceDetailVO.getTaxMny()));
                    }
                    detailMap.put(deBalanceDetailVO.getMaterialId(), BeanMapper.map((Object)deBalanceDetailVO, DeBalanceDetailEntity.class));
                    break;
                }
                case "\u52b3\u4fdd\u3001\u884c\u653f\u7528\u54c1": {
                    deBalanceDetailVO.setCurrentExpenditureArticlesNum(ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)deBalanceDetailVO.getNum()));
                    if (levyFlag.equals("0")) {
                        deBalanceDetailVO.setCurrentExpenditureArticlesMny(ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)deBalanceDetailVO.getMny()));
                    } else {
                        deBalanceDetailVO.setCurrentExpenditureArticlesMny(ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)deBalanceDetailVO.getTaxMny()));
                    }
                    detailMap.put(deBalanceDetailVO.getMaterialId(), BeanMapper.map((Object)deBalanceDetailVO, DeBalanceDetailEntity.class));
                    break;
                }
                case "\u673a\u68b0\u8017\u7528": {
                    deBalanceDetailVO.setCurrentExpenditureExpendNum(ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)deBalanceDetailVO.getNum()));
                    if (levyFlag.equals("0")) {
                        deBalanceDetailVO.setCurrentExpenditureExpendMny(ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)deBalanceDetailVO.getMny()));
                    } else {
                        deBalanceDetailVO.setCurrentExpenditureExpendMny(ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)deBalanceDetailVO.getTaxMny()));
                    }
                    detailMap.put(deBalanceDetailVO.getMaterialId(), BeanMapper.map((Object)deBalanceDetailVO, DeBalanceDetailEntity.class));
                }
            }
        }
        List<DeBalanceDetailVO> allotOutDetails = this.mapper.queryAllotOutDetail(projectId, deBalanceVO.getStartDate(), deBalanceVO.getEndDate());
        if (CollectionUtils.isNotEmpty(allotOutDetails)) {
            for (DeBalanceDetailVO deBalanceDetailVO : allotOutDetails) {
                if (detailMap.containsKey(deBalanceDetailVO.getMaterialId())) {
                    ((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).setCurrentExpenditureOutNum(ComputeUtil.safeAdd((BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).getCurrentExpenditureOutNum(), (BigDecimal)deBalanceDetailVO.getNum()));
                    if (levyFlag.equals("0")) {
                        ((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).setCurrentExpenditureOutMny(ComputeUtil.safeAdd((BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).getCurrentExpenditureOutMny(), (BigDecimal)deBalanceDetailVO.getMny()));
                        continue;
                    }
                    ((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).setCurrentExpenditureOutMny(ComputeUtil.safeAdd((BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(deBalanceDetailVO.getMaterialId()))).getCurrentExpenditureOutMny(), (BigDecimal)deBalanceDetailVO.getTaxMny()));
                    continue;
                }
                deBalanceDetailVO.setCurrentExpenditureOutNum(deBalanceDetailVO.getNum());
                if (levyFlag.equals("0")) {
                    deBalanceDetailVO.setCurrentExpenditureOutMny(deBalanceDetailVO.getMny());
                } else {
                    deBalanceDetailVO.setCurrentExpenditureOutMny(deBalanceDetailVO.getTaxMny());
                }
                detailMap.put(deBalanceDetailVO.getMaterialId(), BeanMapper.map((Object)deBalanceDetailVO, DeBalanceDetailEntity.class));
            }
        }
        if (CollectionUtils.isNotEmpty(list = this.mapper.queryHandleDetail(projectId, deBalanceVO.getStartDate(), deBalanceVO.getEndDate()))) {
            for (DeBalanceDetailVO detailVO : list) {
                if (detailMap.containsKey(detailVO.getMaterialId())) {
                    ((DeBalanceDetailEntity)((Object)detailMap.get(detailVO.getMaterialId()))).setCurrentExpenditureMaterialNum(ComputeUtil.safeAdd((BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(detailVO.getMaterialId()))).getCurrentExpenditureMaterialNum(), (BigDecimal)detailVO.getNum()));
                    if (levyFlag.equals("0")) {
                        ((DeBalanceDetailEntity)((Object)detailMap.get(detailVO.getMaterialId()))).setCurrentExpenditureMaterialDifference(ComputeUtil.safeAdd((BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(detailVO.getMaterialId()))).getCurrentExpenditureMaterialDifference(), (BigDecimal)detailVO.getDifference()));
                        ((DeBalanceDetailEntity)((Object)detailMap.get(detailVO.getMaterialId()))).setCurrentExpenditureMaterialMny(ComputeUtil.safeAdd((BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(detailVO.getMaterialId()))).getCurrentExpenditureMaterialMny(), (BigDecimal)detailVO.getMny()));
                        continue;
                    }
                    ((DeBalanceDetailEntity)((Object)detailMap.get(detailVO.getMaterialId()))).setCurrentExpenditureMaterialDifference(ComputeUtil.safeAdd((BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(detailVO.getMaterialId()))).getCurrentExpenditureMaterialDifference(), (BigDecimal)detailVO.getTaxDifference()));
                    ((DeBalanceDetailEntity)((Object)detailMap.get(detailVO.getMaterialId()))).setCurrentExpenditureMaterialMny(ComputeUtil.safeAdd((BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(detailVO.getMaterialId()))).getCurrentExpenditureMaterialMny(), (BigDecimal)detailVO.getTaxMny()));
                    continue;
                }
                detailVO.setCurrentExpenditureMaterialNum(detailVO.getNum());
                if (levyFlag.equals("0")) {
                    ((DeBalanceDetailEntity)((Object)detailMap.get(detailVO.getMaterialId()))).setCurrentExpenditureMaterialDifference(ComputeUtil.safeAdd((BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(detailVO.getMaterialId()))).getCurrentExpenditureMaterialDifference(), (BigDecimal[])new BigDecimal[0]));
                    detailVO.setCurrentExpenditureMaterialMny(detailVO.getMny());
                } else {
                    ((DeBalanceDetailEntity)((Object)detailMap.get(detailVO.getMaterialId()))).setCurrentExpenditureMaterialDifference(ComputeUtil.safeAdd((BigDecimal)((DeBalanceDetailEntity)((Object)detailMap.get(detailVO.getMaterialId()))).getCurrentExpenditureMaterialDifference(), (BigDecimal[])new BigDecimal[0]));
                    detailVO.setCurrentExpenditureMaterialMny(detailVO.getTaxMny());
                }
                detailMap.put(detailVO.getMaterialId(), BeanMapper.map((Object)detailVO, DeBalanceDetailEntity.class));
            }
        }
        DeBalanceVO deBalanceVO2 = new DeBalanceVO();
        deBalanceVO2.setDeBalanceDetailList(BeanMapper.mapList(detailMap.values(), DeBalanceDetailVO.class));
        for (DeBalanceDetailVO detailVO : deBalanceVO2.getDeBalanceDetailList()) {
            detailVO.setId(Long.valueOf(IdWorker.getId()));
            detailVO.setCurrentIncomeTotalNum(ComputeUtil.safeAdd((BigDecimal)detailVO.getCurrentIncomePurchaseNum(), (BigDecimal)detailVO.getCurrentIncomeCallNum()));
            detailVO.setCurrentIncomeTotalMny(ComputeUtil.safeAdd((BigDecimal)detailVO.getCurrentIncomePurchaseMny(), (BigDecimal)detailVO.getCurrentIncomeCallMny()));
            detailVO.setCurrentIncomePurchasePrice(ComputeUtil.safeDiv((BigDecimal)detailVO.getCurrentIncomePurchaseMny(), (BigDecimal)detailVO.getCurrentIncomePurchaseNum()));
            detailVO.setCurrentIncomeCallPrice(ComputeUtil.safeDiv((BigDecimal)detailVO.getCurrentIncomeCallMny(), (BigDecimal)detailVO.getCurrentIncomeCallNum()));
            detailVO.setCurrentExpenditureConsumePrice(ComputeUtil.safeDiv((BigDecimal)detailVO.getCurrentExpenditureConsumeMny(), (BigDecimal)detailVO.getCurrentExpenditureConsumeNum()));
            detailVO.setCurrentExpenditureSecurePrice(ComputeUtil.safeDiv((BigDecimal)detailVO.getCurrentExpenditureSecureMny(), (BigDecimal)detailVO.getCurrentExpenditureSecureNum()));
            detailVO.setCurrentExpenditureCivilizationPrice(ComputeUtil.safeDiv((BigDecimal)detailVO.getCurrentExpenditureCivilizationMny(), (BigDecimal)detailVO.getCurrentExpenditureCivilizationNum()));
            detailVO.setCurrentExpenditureTemporaryPrice(ComputeUtil.safeDiv((BigDecimal)detailVO.getCurrentExpenditureTemporaryMny(), (BigDecimal)detailVO.getCurrentExpenditureTemporaryNum()));
            detailVO.setCurrentExpenditureOtherPrice(ComputeUtil.safeDiv((BigDecimal)detailVO.getCurrentExpenditureOtherMny(), (BigDecimal)detailVO.getCurrentExpenditureOtherNum()));
            detailVO.setCurrentExpenditureArticlesPrice(ComputeUtil.safeDiv((BigDecimal)detailVO.getCurrentExpenditureArticlesMny(), (BigDecimal)detailVO.getCurrentExpenditureArticlesNum()));
            detailVO.setCurrentExpenditureExpendPrice(ComputeUtil.safeDiv((BigDecimal)detailVO.getCurrentExpenditureExpendMny(), (BigDecimal)detailVO.getCurrentExpenditureExpendNum()));
            detailVO.setCurrentExpenditureOutPrice(ComputeUtil.safeDiv((BigDecimal)detailVO.getCurrentExpenditureOutMny(), (BigDecimal)detailVO.getCurrentExpenditureOutNum()));
            detailVO.setCurrentExpenditureMaterialPrice(ComputeUtil.safeDiv((BigDecimal)detailVO.getCurrentExpenditureMaterialMny(), (BigDecimal)detailVO.getCurrentExpenditureMaterialNum()));
            detailVO.setCurrentExpenditureTotalNum(this.countNum(detailVO));
            detailVO.setCurrentExpenditureTotalMny(this.countMny(detailVO));
            detailVO.setClosingBalanceTotalNum(ComputeUtil.safeSub((BigDecimal)ComputeUtil.safeAdd((BigDecimal)detailVO.getOpeningBalanceNum(), (BigDecimal)detailVO.getCurrentIncomeTotalNum()), (BigDecimal)detailVO.getCurrentExpenditureTotalNum()));
            detailVO.setClosingBalanceTotalMny(ComputeUtil.safeSub((BigDecimal)ComputeUtil.safeAdd((BigDecimal)detailVO.getOpeningBalanceMny(), (BigDecimal)detailVO.getCurrentIncomeTotalMny()), (BigDecimal)detailVO.getCurrentExpenditureTotalMny()));
        }
        return CommonResponse.success((String)"\u6821\u9a8c\u6210\u529f\uff01", (Object)deBalanceVO2);
    }

    private BigDecimal countMny(DeBalanceDetailVO detailVO) {
        BigDecimal currentExpenditureTotalMny = ComputeUtil.safeAdd((BigDecimal)ComputeUtil.safeAdd((BigDecimal)ComputeUtil.safeAdd((BigDecimal)ComputeUtil.safeAdd((BigDecimal)ComputeUtil.safeAdd((BigDecimal)ComputeUtil.safeAdd((BigDecimal)ComputeUtil.safeAdd((BigDecimal)ComputeUtil.safeAdd((BigDecimal)detailVO.getCurrentExpenditureConsumeMny(), (BigDecimal)detailVO.getCurrentExpenditureSecureMny()), (BigDecimal)detailVO.getCurrentExpenditureCivilizationMny()), (BigDecimal)detailVO.getCurrentExpenditureTemporaryMny()), (BigDecimal)detailVO.getCurrentExpenditureOtherMny()), (BigDecimal)detailVO.getCurrentExpenditureArticlesMny()), (BigDecimal)detailVO.getCurrentExpenditureExpendMny()), (BigDecimal)detailVO.getCurrentExpenditureOutMny()), (BigDecimal)detailVO.getCurrentExpenditureMaterialMny());
        return currentExpenditureTotalMny;
    }

    private BigDecimal countNum(DeBalanceDetailVO detailVO) {
        BigDecimal currentExpenditureTotalNum = ComputeUtil.safeAdd((BigDecimal)ComputeUtil.safeAdd((BigDecimal)ComputeUtil.safeAdd((BigDecimal)ComputeUtil.safeAdd((BigDecimal)ComputeUtil.safeAdd((BigDecimal)ComputeUtil.safeAdd((BigDecimal)ComputeUtil.safeAdd((BigDecimal)ComputeUtil.safeAdd((BigDecimal)detailVO.getCurrentExpenditureConsumeNum(), (BigDecimal)detailVO.getCurrentExpenditureSecureNum()), (BigDecimal)detailVO.getCurrentExpenditureCivilizationNum()), (BigDecimal)detailVO.getCurrentExpenditureTemporaryNum()), (BigDecimal)detailVO.getCurrentExpenditureOtherNum()), (BigDecimal)detailVO.getCurrentExpenditureArticlesNum()), (BigDecimal)detailVO.getCurrentExpenditureExpendNum()), (BigDecimal)detailVO.getCurrentExpenditureOutNum()), (BigDecimal)detailVO.getCurrentExpenditureMaterialNum());
        return currentExpenditureTotalNum;
    }

    private DeBalanceVO countDate(String startMonth, String endMonth, SettingVO setting) throws ParseException {
        DeBalanceVO deBalanceVO = new DeBalanceVO();
        if ("0".equals(setting.getPeriodRule())) {
            int maxDaysOfEndDate = DateUtil.getDaysOfMonth((Date)DateFormatUtil.parseDate((String)"yyyy-MM", (String)endMonth));
            int maxDaysOfStartDate = DateUtil.getDaysOfMonth((Date)DateFormatUtil.parseDate((String)"yyyy-MM", (String)startMonth));
            endMonth = endMonth + "-" + (maxDaysOfEndDate > Integer.valueOf(setting.getEndDay()) ? setting.getEndDay() : maxDaysOfEndDate);
            startMonth = startMonth + "-" + (maxDaysOfStartDate > Integer.valueOf(setting.getEndDay()) ? setting.getEndDay() : maxDaysOfStartDate);
            startMonth = DateUtil.addDay((Date)DateFormatUtil.parseDate((String)"yyyy-MM-dd", (String)DateUtil.getLastMonth((Date)DateFormatUtil.parseDate((String)"yyyy-MM-dd", (String)endMonth), (String)"yyyy-MM-dd")), (int)1);
        } else {
            startMonth = endMonth + "-01";
            endMonth = endMonth + "-" + DateUtil.getDaysOfMonth((Date)DateFormatUtil.parseDate((String)"yyyy-MM", (String)endMonth));
        }
        deBalanceVO.setStartDate(startMonth);
        deBalanceVO.setEndDate(endMonth);
        return deBalanceVO;
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DeBalanceVO> queryDetail(Long id) {
        DeBalanceEntity entity = (DeBalanceEntity)((Object)this.service.selectById(id));
        DeBalanceVO vo = (DeBalanceVO)BeanMapper.map((Object)((Object)entity), DeBalanceVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DeBalanceVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (DeBalanceVO deBalanceVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<DeBalanceVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DeBalanceVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("DeBalance-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refDeBalanceData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<DeBalanceVO>> refDeBalanceData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DeBalanceVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

