/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.order.api;

import com.ejianc.business.promaterial.check.bean.CheckDetailEntity;
import com.ejianc.business.promaterial.check.service.ICheckDetailService;
import com.ejianc.business.promaterial.order.bean.OrderDetailEntity;
import com.ejianc.business.promaterial.order.service.IOrderDetailService;
import com.ejianc.business.promaterial.order.vo.WriteBackVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/order/"})
public class OrderApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICheckDetailService checkDetailService;
    @Autowired
    private IOrderDetailService orderDetailService;

    @RequestMapping(value={"/writeBackOccupyNum"}, method={RequestMethod.POST})
    CommonResponse<String> writeBackOccupyNum(@RequestBody WriteBackVO vo) {
        String reduceType = vo.getReduceType();
        Long checkId = vo.getCheckId();
        Long orderId = vo.getOrderId();
        Map numMap = vo.getNumMap();
        if (MapUtils.isEmpty((Map)numMap)) {
            return CommonResponse.success((String)"\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        Map orderMap = vo.getNumMap();
        if ("1".equals(reduceType)) {
            QueryParam param = new QueryParam();
            param.getParams().put("checkId", new Parameter("eq", (Object)checkId));
            param.getParams().put("materialId", new Parameter("in", new ArrayList(numMap.keySet())));
            List list = this.checkDetailService.queryList(param);
            for (CheckDetailEntity detail : list) {
                if (!numMap.containsKey(detail.getMaterialId())) continue;
                orderMap.put(detail.getSourceId(), numMap.get(detail.getMaterialId()));
            }
        } else if ("2".equals(reduceType)) {
            QueryParam param = new QueryParam();
            param.getParams().put("orderId", new Parameter("eq", (Object)orderId));
            param.getParams().put("materialId", new Parameter("in", new ArrayList(numMap.keySet())));
            List list = this.orderDetailService.queryList(param);
            for (OrderDetailEntity detail : list) {
                if (!numMap.containsKey(detail.getMaterialId())) continue;
                orderMap.put(detail.getId(), numMap.get(detail.getMaterialId()));
            }
        }
        if (MapUtils.isNotEmpty((Map)orderMap)) {
            if ("2".equals(reduceType)) {
                this.orderDetailService.writeBackActualNum(orderMap);
            } else {
                this.orderDetailService.writeBackOccupyNum(orderMap);
            }
        }
        return CommonResponse.success((String)"\u56de\u5199\u5360\u7528\u91cf\u6210\u529f\uff01");
    }
}

