/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.order.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.check.service.ICheckDetailService;
import com.ejianc.business.promaterial.check.vo.CheckDetailVO;
import com.ejianc.business.promaterial.contract.bean.ContractDetailEntity;
import com.ejianc.business.promaterial.contract.enums.ChangeTypeEnum;
import com.ejianc.business.promaterial.contract.service.IContractDetailService;
import com.ejianc.business.promaterial.order.bean.OrderDetailEntity;
import com.ejianc.business.promaterial.order.bean.OrderEntity;
import com.ejianc.business.promaterial.order.enums.OrderFlagEnum;
import com.ejianc.business.promaterial.order.enums.SourceTypeEnum;
import com.ejianc.business.promaterial.order.mapper.OrderMapper;
import com.ejianc.business.promaterial.order.service.IOrderDetailService;
import com.ejianc.business.promaterial.order.service.IOrderService;
import com.ejianc.business.promaterial.order.vo.OrderDetailVO;
import com.ejianc.business.promaterial.order.vo.OrderVO;
import com.ejianc.business.promaterial.order.vo.SupOrderDetailVO;
import com.ejianc.business.promaterial.order.vo.SupOrderVO;
import com.ejianc.business.promaterial.plan.bean.SinglePlanDetailEntity;
import com.ejianc.business.promaterial.plan.service.ISinglePlanDetailService;
import com.ejianc.business.promaterial.utils.CommonUtils;
import com.ejianc.business.promaterial.utils.OrgUtil;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="orderService")
public class OrderServiceImpl
extends BaseServiceImpl<OrderMapper, OrderEntity>
implements IOrderService {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "XHC_ORDER";
    private static final String PLAN_NUM_CTRL_PARAM_CODE = "P-F9KW9X0013";
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IOrderService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ISinglePlanDetailService planDetailService;
    @Autowired
    private IOrderDetailService orderDetailService;
    @Autowired
    private ICheckDetailService checkDetailService;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IContractDetailService contractDetailService;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    private final String OPERATE = "MATERIAL_ORDER_SYNC";
    private final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/materialOrder/saveOrUpdate";
    private final String UPDATE_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/materialOrder/updateOrderCloseFlag";
    @Autowired
    private OrgUtil orgUtil;
    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IOrderDetailService detailService;

    @Override
    public CommonResponse<OrderVO> saveOrUpdate(OrderVO saveOrUpdateVO) {
        CommonResponse resp;
        OrderEntity entity = (OrderEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, OrderEntity.class));
        if (StringUtils.isNotBlank((CharSequence)entity.getBillCode())) {
            OrderVO voByCode = this.queryByCode(entity.getBillCode());
            if (!(null == voByCode || null != entity.getId() && voByCode.getId().equals(entity.getId()))) {
                throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u7f16\u7801\u91cd\u590d\uff01");
            }
        } else {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                String code = this.orgUtil.getBillCodeByCorp(entity.getOrgId(), entity.getProjectId(), (String)billCode.getData());
                entity.setBillCode(code);
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        List<OrderDetailEntity> detailList = entity.getOrderDetailList();
        List materialIds = detailList.stream().map(x -> x.getMaterialId()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(materialIds) && (resp = this.materialApi.queryMaterialByIds(materialIds)).isSuccess() && null != resp.getData()) {
            Map<Long, MaterialVO> map = ((List)resp.getData()).stream().collect(Collectors.toMap(x -> x.getId(), x -> x));
            detailList.forEach(e -> {
                if (map.containsKey(e.getMaterialId())) {
                    MaterialVO material = (MaterialVO)map.get(e.getMaterialId());
                    e.setFinancialId(material.getFinancialId());
                    e.setFinancialName(material.getFinancialName());
                }
            });
        }
        OrderEntity data = new OrderEntity();
        if (null != entity.getId()) {
            data = (OrderEntity)((Object)super.selectById((Serializable)entity.getId()));
        }
        Map<Long, OrderDetailEntity> dataMap = data.getOrderDetailList().stream().collect(Collectors.toMap(x -> x.getId(), x -> x));
        HashMap<Long, BigDecimal> numMap = new HashMap<Long, BigDecimal>();
        for (OrderDetailEntity detail : detailList) {
            detail.setActualNumsSum(detail.getOrderNumsSum());
            detail.setSurplusNumsSum(ComputeUtil.safeSub((BigDecimal)detail.getActualNumsSum(), (BigDecimal)detail.getOccupyNumsSum()));
            if ("del".equals(detail.getRowState())) {
                numMap.put(detail.getSourceDetailId(), ComputeUtil.safeSub((BigDecimal)((BigDecimal)numMap.get(detail.getSourceDetailId())), (BigDecimal)detail.getOrderNumsSum()));
                continue;
            }
            BigDecimal num = detail.getOrderNumsSum();
            if (dataMap.containsKey(detail.getId())) {
                num = ComputeUtil.safeSub((BigDecimal)detail.getOrderNumsSum(), (BigDecimal)dataMap.get(detail.getId()).getOrderNumsSum());
            }
            numMap.put(detail.getSourceDetailId(), ComputeUtil.safeAdd((BigDecimal)((BigDecimal)numMap.get(detail.getSourceDetailId())), (BigDecimal)num));
        }
        if (MapUtils.isNotEmpty(numMap)) {
            this.planDetailService.writeBackOccupyNum(numMap);
        }
        entity.setOrderFlag(0);
        super.saveOrUpdate((Object)entity, false);
        OrderVO vo = (OrderVO)BeanMapper.map((Object)((Object)entity), OrderVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    private OrderVO queryByCode(String planCode) {
        OrderVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"bill_code", (Object)planCode);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        OrderEntity entity = (OrderEntity)((Object)super.getOne((Wrapper)query));
        if (null != entity) {
            resp = (OrderVO)BeanMapper.map((Object)((Object)entity), OrderVO.class);
        }
        return resp;
    }

    @Override
    public CommonResponse<OrderVO> queryDetail(Long id) {
        OrderEntity entity = (OrderEntity)((Object)this.service.selectById(id));
        OrderVO orderVO = (OrderVO)BeanMapper.map((Object)((Object)entity), OrderVO.class);
        ArrayList orderDetailVOS = new ArrayList();
        List orderDetailList = orderVO.getOrderDetailList();
        if (CollectionUtils.isNotEmpty((Collection)orderDetailList)) {
            orderDetailList.forEach(vo -> {
                if (vo.getLeafFlag() == null || !vo.getLeafFlag().booleanValue()) {
                    BigDecimal surplusNumsSum = this.planDetailService.getSurplusNumsSum(orderVO.getProjectId(), vo.getMaterialId());
                    surplusNumsSum = surplusNumsSum == null ? BigDecimal.ZERO : surplusNumsSum;
                    vo.setNewSurplusNumsSum(surplusNumsSum);
                    orderDetailVOS.add(vo);
                }
            });
            if (CollectionUtils.isNotEmpty(orderDetailVOS)) {
                Map<Long, List<OrderDetailVO>> map = orderDetailList.stream().filter(t -> t.getParentId() != null && t.getLeafFlag() != null && t.getLeafFlag() != false).collect(Collectors.groupingBy(OrderDetailVO::getParentId));
                for (OrderDetailVO orderDetailVO : orderDetailVOS) {
                    List<OrderDetailVO> orderDetailVOS1 = map.get(orderDetailVO.getMaterialId());
                    if (orderDetailVO.getSourceType() != 0 || !CollectionUtils.isNotEmpty(orderDetailVOS1)) continue;
                    orderDetailVO.setOrderDetailVOS(orderDetailVOS1);
                }
            }
        }
        orderVO.setOrderDetailList(orderDetailVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)orderVO);
    }

    @Override
    public CommonResponse<String> delete(List<OrderVO> vos) {
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryParam param = new QueryParam();
        param.getParams().put("orderId", new Parameter("in", ids));
        List detailList = this.orderDetailService.queryList(param);
        HashMap<Long, BigDecimal> numMap = new HashMap<Long, BigDecimal>();
        for (OrderDetailEntity detail : detailList) {
            numMap.put(detail.getSourceDetailId(), ComputeUtil.safeSub((BigDecimal)((BigDecimal)numMap.get(detail.getSourceDetailId())), (BigDecimal)detail.getOrderNumsSum()));
        }
        if (MapUtils.isNotEmpty(numMap)) {
            this.planDetailService.writeBackOccupyNum(numMap);
        }
        this.service.removeByIds(ids, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public Map<String, Object> savaHintFlag(OrderVO orderVO) {
        HashMap<String, Object> stringObjectMap = new HashMap<String, Object>();
        String hint = "";
        Boolean hintFlag = true;
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(ContractDetailEntity::getContractId, (Object)orderVO.getContractId());
        lambda.ne(ContractDetailEntity::getChangeType, (Object)ChangeTypeEnum.\u4e2d\u6b62\u9879.toString());
        List list3 = this.contractDetailService.list((Wrapper)lambda);
        Map<Long, ContractDetailEntity> detailVOMap = list3.stream().filter(t -> t.getMaterialId() != null).collect(Collectors.toMap(ContractDetailEntity::getMaterialId, item -> item, (v1, v2) -> v2));
        if (CollectionUtils.isNotEmpty((Collection)orderVO.getOrderDetailList())) {
            ArrayList contractOrderDetail = new ArrayList();
            for (OrderDetailVO orderDetailVO : orderVO.getOrderDetailList()) {
                if (!orderDetailVO.getSourceType().equals(SourceTypeEnum.\u5355\u9879\u91c7\u8d2d\u8ba1\u5212.getCode()) || "del".equals(orderDetailVO.getRowState()) || detailVOMap.containsKey(orderDetailVO.getMaterialId())) continue;
                if (hint.equals("")) {
                    hint = orderDetailVO.getDetailIndex();
                    continue;
                }
                hint = hint + "\u3001" + orderDetailVO.getDetailIndex();
            }
        }
        if (!hint.equals("")) {
            hintFlag = false;
        }
        stringObjectMap.put("hintFlag", hintFlag);
        stringObjectMap.put("hint", "\u7b2c" + hint + "\u884c\u6750\u6599\u4e0d\u5728\u5408\u540c\u6e05\u5355\u5185\uff0c\u662f\u5426\u7ee7\u7eed\u4fdd\u5b58\uff1f");
        return stringObjectMap;
    }

    public void delOrderDetail(List<OrderDetailEntity> delOrderDetailList, Long orderId) {
        ArrayList<SinglePlanDetailEntity> planDetailList = new ArrayList<SinglePlanDetailEntity>();
        ArrayList<OrderDetailEntity> orderDetailList = new ArrayList<OrderDetailEntity>();
        if (CollectionUtils.isNotEmpty(delOrderDetailList)) {
            for (OrderDetailEntity delOrderDetail : delOrderDetailList) {
                LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
                lambda.eq(OrderDetailEntity::getParentId, (Object)delOrderDetail.getTid());
                lambda.eq(OrderDetailEntity::getOrderId, (Object)orderId);
                List list = this.orderDetailService.list((Wrapper)lambda);
                if (!CollectionUtils.isNotEmpty((Collection)list)) continue;
                for (OrderDetailEntity orderDetail : list) {
                    SinglePlanDetailEntity entity = (SinglePlanDetailEntity)((Object)this.planDetailService.getById(orderDetail.getSourceDetailId()));
                    BigDecimal nums = entity.getActualNums() == null ? BigDecimal.ZERO : entity.getActualNums();
                    BigDecimal occupyNums = entity.getOccupyNums() == null ? BigDecimal.ZERO : entity.getOccupyNums();
                    BigDecimal orderNums = orderDetail.getOrderNumsSum() == null ? BigDecimal.ZERO : orderDetail.getOrderNumsSum();
                    entity.setOccupyNums(occupyNums.subtract(orderNums));
                    entity.setSurplusNums(nums.subtract(entity.getOccupyNums()));
                    planDetailList.add(entity);
                    orderDetailList.add(orderDetail);
                }
            }
            this.logger.info("\u5220\u9664\u4fee\u6539\u8ba1\u5212-----" + JSONObject.toJSONString(planDetailList));
            if (CollectionUtils.isNotEmpty(planDetailList)) {
                this.planDetailService.updateBatchById(planDetailList);
            }
            this.logger.info("\u5220\u9664\u4fee\u6539\u8ba2\u5355-----" + JSONObject.toJSONString(orderDetailList));
            if (CollectionUtils.isNotEmpty(orderDetailList)) {
                this.orderDetailService.removeByIds(orderDetailList.stream().map(BaseEntity::getId).collect(Collectors.toList()), true);
            }
        }
    }

    public void addOrderDetail(List<OrderDetailEntity> addOrderDetailList, Long projectId, Long orderId) {
        ArrayList<Object> orderDetail = new ArrayList<Object>();
        ArrayList<SinglePlanDetailEntity> planDetail = new ArrayList<SinglePlanDetailEntity>();
        if (CollectionUtils.isNotEmpty(addOrderDetailList)) {
            for (OrderDetailEntity addOrderDetail : addOrderDetailList) {
                BigDecimal orderNumsSum;
                List<OrderDetailVO> orderDetailVOS = this.planDetailService.queryMaterialDetail(projectId, addOrderDetail.getMaterialId());
                BigDecimal bigDecimal = orderNumsSum = addOrderDetail.getOrderNumsSum() == null ? BigDecimal.ZERO : addOrderDetail.getOrderNumsSum();
                if (CollectionUtils.isNotEmpty(orderDetailVOS)) {
                    for (int i = 0; i < orderDetailVOS.size(); ++i) {
                        BigDecimal orderNums;
                        BigDecimal surplusNums;
                        orderDetailVOS.get(i).setLeafFlag(Boolean.valueOf(true));
                        orderDetailVOS.get(i).setOrderId(orderId);
                        orderDetailVOS.get(i).setParentId(addOrderDetail.getTid());
                        if (orderNumsSum.compareTo(BigDecimal.ZERO) <= 0) continue;
                        if (addOrderDetail.getConstruction() == null) {
                            addOrderDetail.setConstruction(orderDetailVOS.get(i).getConstruction());
                        } else {
                            addOrderDetail.setConstruction(addOrderDetail.getConstruction() + "\u3001" + orderDetailVOS.get(i).getConstruction());
                        }
                        SinglePlanDetailEntity entity = (SinglePlanDetailEntity)((Object)this.planDetailService.getById(orderDetailVOS.get(i).getSourceDetailId()));
                        BigDecimal nums = entity.getActualNums() == null ? BigDecimal.ZERO : entity.getActualNums();
                        BigDecimal occupyNums = entity.getOccupyNums() == null ? BigDecimal.ZERO : entity.getOccupyNums();
                        BigDecimal bigDecimal2 = surplusNums = entity.getSurplusNums() == null ? BigDecimal.ZERO : entity.getSurplusNums();
                        if (orderNumsSum.compareTo(surplusNums) < 0) {
                            orderDetailVOS.get(i).setOrderNumsSum(orderNumsSum);
                        } else {
                            orderDetailVOS.get(i).setOrderNumsSum(surplusNums);
                        }
                        BigDecimal bigDecimal3 = orderNums = orderDetailVOS.get(i).getOrderNumsSum() == null ? BigDecimal.ZERO : orderDetailVOS.get(i).getOrderNumsSum();
                        if (surplusNums.compareTo(orderNums) < 0) {
                            throw new BusinessException("\u3010\u8ba2\u5355\u6570\u91cf\u3011\u4e0d\u80fd\u8d85\u8fc7\u8ba1\u5212\u5269\u4f59\u91cf\uff0c\u8be5\u6750\u6599\u660e\u7ec6\u5b9e\u9645\u5269\u4f59\u91cf\u4e3a\u3010" + surplusNums + "\u3011!");
                        }
                        entity.setOccupyNums(occupyNums.add(orderNums));
                        entity.setSurplusNums(nums.subtract(entity.getOccupyNums()));
                        orderDetailVOS.get(i).setSurplusNumsSum(entity.getSurplusNums());
                        orderNumsSum = orderNumsSum.subtract(orderNums);
                        orderDetail.add(BeanMapper.map((Object)orderDetailVOS.get(i), OrderDetailEntity.class));
                        planDetail.add(entity);
                    }
                }
                orderDetail.add((Object)addOrderDetail);
            }
            this.logger.info("\u65b0\u589e\u4fee\u6539\u8ba1\u5212-----" + JSONObject.toJSONString(planDetail));
            if (CollectionUtils.isNotEmpty(planDetail)) {
                this.planDetailService.updateBatchById(planDetail);
            }
            this.logger.info("\u65b0\u589e/\u4fee\u6539\u8ba2\u5355-----" + JSONObject.toJSONString(orderDetail));
            if (CollectionUtils.isNotEmpty(orderDetail)) {
                this.orderDetailService.saveOrUpdateBatch(orderDetail);
            }
        }
    }

    public void updateOrderDetail(List<OrderDetailEntity> updateOrderDetailList, Long projectId, Long orderId) {
        if (CollectionUtils.isNotEmpty(updateOrderDetailList)) {
            this.delOrderDetail(updateOrderDetailList, orderId);
            this.addOrderDetail(updateOrderDetailList, projectId, orderId);
        }
    }

    @Override
    public CommonResponse<OrderVO> updateReceived(SupOrderVO orderVO) {
        this.logger.info("---\u63a5\u6536\u5f00\u59cb---", (Object)JSONObject.toJSONString((Object)orderVO));
        OrderEntity orderEntity = (OrderEntity)((Object)super.selectById((Serializable)orderVO.getId()));
        if (null != orderEntity && null != orderEntity.getReceiveState() && orderEntity.getReceiveState() > 0 && 4 != orderVO.getReceiveState()) {
            return CommonResponse.error((String)"\u8be5\u8ba2\u5355\u5df2\u88ab\u64cd\u4f5c,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
        }
        ArrayList<String> messageType = new ArrayList<String>();
        messageType.add("sys");
        ArrayList<String> sender = new ArrayList<String>();
        sender.add(String.valueOf(orderEntity.getCommitId()));
        String frontendBaseHost = "";
        frontendBaseHost = StringUtils.isNotBlank((CharSequence)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.baseHost;
        this.logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u53d1\u5e03\u4eba:>----------" + sender + frontendBaseHost);
        String formurl = frontendBaseHost + "ejc-promaterial-mobile/#/purchaseOrder/card?id=" + orderEntity.getId();
        String subject = "";
        String content = "";
        if (1 == orderVO.getReceiveState()) {
            this.logger.info("---\u5168\u90e8\u63a5\u53d7\u5f00\u59cb---");
            orderEntity.setReceiveState(1);
            orderEntity.setDeliverState(0);
            subject = "\u60a8\u7684\u8ba2\u5355\u3010" + orderEntity.getProjectName() + "--" + orderEntity.getMaterialName() + "\u3011\u5df2\u7ecf\u5728" + DateFormater.getInstance().format("yyyy-MM-dd") + "\u88ab\u4f9b\u5e94\u5546\u3010" + orderEntity.getSupplierName() + "\u3011\u5168\u90e8\u63a5\u6536\u3002";
            content = "\u60a8\u7684\u8ba2\u5355\u3010" + orderEntity.getProjectName() + "--" + orderEntity.getMaterialName() + "\u3011\u5df2\u7ecf\u5728" + DateFormater.getInstance().format("yyyy-MM-dd") + "\u88ab\u4f9b\u5e94\u5546\u3010" + orderEntity.getSupplierName() + "\u3011\u5168\u90e8\u63a5\u6536\u3002<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
            this.logger.info("---\u62c6\u5206\u63a5\u6536\u6570\u91cf---");
            this.OrderDetailBack(orderVO.getMaterialOrderDetailList(), 1);
            orderEntity.getOrderDetailList().forEach(vo -> {
                vo.setReceiveNumsSum(vo.getOrderNumsSum());
                vo.setDeliverNumsSum(BigDecimal.ZERO);
            });
        } else if (2 == orderVO.getReceiveState()) {
            this.logger.info("---\u90e8\u5206\u63a5\u53d7\u5f00\u59cb---");
            orderEntity.setReceiveState(2);
            orderEntity.setDeliverState(0);
            subject = "\u60a8\u7684\u8ba2\u5355\u3010" + orderEntity.getProjectName() + "--" + orderEntity.getMaterialName() + "\u3011\u5df2\u7ecf\u5728" + DateFormater.getInstance().format("yyyy-MM-dd") + "\u88ab\u4f9b\u5e94\u5546\u3010" + orderEntity.getSupplierName() + "\u3011\u90e8\u5206\u63a5\u6536\u3002";
            content = "\u60a8\u7684\u8ba2\u5355\u3010" + orderEntity.getProjectName() + "--" + orderEntity.getMaterialName() + "\u3011\u5df2\u7ecf\u5728" + DateFormater.getInstance().format("yyyy-MM-dd") + "\u88ab\u4f9b\u5e94\u5546\u3010" + orderEntity.getSupplierName() + "\u3011\u90e8\u5206\u63a5\u6536\u3002<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
            if (CollectionUtils.isNotEmpty((Collection)orderVO.getMaterialOrderDetailList())) {
                this.logger.info("---\u62c6\u5206\u63a5\u6536\u6570\u91cf---");
                this.OrderDetailBack(orderVO.getMaterialOrderDetailList(), 1);
                Map<Long, BigDecimal> map = orderVO.getMaterialOrderDetailList().stream().collect(Collectors.toMap(SupOrderDetailVO::getId, SupOrderDetailVO::getReceiveNumsSum));
                this.logger.debug("map------" + map);
                orderEntity.getOrderDetailList().forEach(vo -> {
                    vo.setReceiveNumsSum((BigDecimal)map.get(vo.getId()));
                    this.logger.debug("ReceiveNumsSum------" + vo.getReceiveNumsSum());
                    vo.setDeliverNumsSum(BigDecimal.ZERO);
                });
            }
        } else if (3 == orderVO.getReceiveState()) {
            this.logger.info("---\u4e0d\u4e88\u63a5\u53d7\u5f00\u59cb---");
            orderEntity.setReceiveState(3);
            orderEntity.setReceiveReason(orderVO.getReceiveReason());
            subject = "\u60a8\u7684\u8ba2\u5355\u3010" + orderEntity.getProjectName() + "--" + orderEntity.getMaterialName() + "\u3011\u5df2\u7ecf\u5728" + DateFormater.getInstance().format("yyyy-MM-dd") + "\u88ab\u4f9b\u5e94\u5546\u3010" + orderEntity.getSupplierName() + "\u3011\u62d2\u7edd\u63a5\u6536\u3002";
            content = "\u60a8\u7684\u8ba2\u5355\u3010" + orderEntity.getProjectName() + "--" + orderEntity.getMaterialName() + "\u3011\u5df2\u7ecf\u5728" + DateFormater.getInstance().format("yyyy-MM-dd") + "\u88ab\u4f9b\u5e94\u5546\u3010" + orderEntity.getSupplierName() + "\u3011\u62d2\u7edd\u63a5\u6536\u3002<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
            this.logger.info("---\u62c6\u5206\u63a5\u6536\u6570\u91cf---");
            this.OrderDetailBack(orderVO.getMaterialOrderDetailList(), 1);
            orderEntity.getOrderDetailList().forEach(vo -> {
                vo.setReceiveNumsSum(BigDecimal.ZERO);
                vo.setDeliverNumsSum(BigDecimal.ZERO);
            });
        }
        this.sendMsg(messageType, sender, "notice", subject, content, String.valueOf(orderEntity.getTenantId()), orderEntity);
        this.logger.debug("-----\u4e3b\u952e" + orderEntity.getId());
        super.saveOrUpdate((Object)orderEntity, false);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f");
    }

    public void OrderDetailBack(List<SupOrderDetailVO> detailList, int type) {
        ArrayList entityList = new ArrayList();
        ArrayList planDetailList = new ArrayList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            detailList.forEach(vo -> {
                OrderDetailEntity orderDetailEntity = (OrderDetailEntity)((Object)((Object)this.orderDetailService.getById(vo.getId())));
                LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
                lambda.eq(OrderDetailEntity::getParentId, (Object)orderDetailEntity.getTid());
                lambda.eq(OrderDetailEntity::getOrderId, (Object)orderDetailEntity.getOrderId());
                lambda.eq(OrderDetailEntity::getLeafFlag, (Object)true);
                lambda.orderByAsc(BaseEntity::getId);
                List details = this.orderDetailService.list((Wrapper)lambda);
                if (CollectionUtils.isNotEmpty((Collection)details)) {
                    BigDecimal receiveNumsSum = vo.getReceiveNumsSum() == null ? BigDecimal.ZERO : vo.getReceiveNumsSum();
                    for (int i = 0; i < details.size(); ++i) {
                        BigDecimal nums;
                        BigDecimal occupyNums;
                        SinglePlanDetailEntity planDetailEntity;
                        BigDecimal orderNumsSum;
                        BigDecimal bigDecimal = orderNumsSum = ((OrderDetailEntity)((Object)((Object)details.get(i)))).getOrderNumsSum() == null ? BigDecimal.ZERO : ((OrderDetailEntity)((Object)((Object)details.get(i)))).getOrderNumsSum();
                        if (receiveNumsSum.compareTo(BigDecimal.ZERO) > 0) {
                            if (receiveNumsSum.compareTo(orderNumsSum) >= 0) {
                                ((OrderDetailEntity)((Object)((Object)details.get(i)))).setReceiveNumsSum(orderNumsSum);
                                receiveNumsSum = receiveNumsSum.subtract(orderNumsSum);
                            } else {
                                ((OrderDetailEntity)((Object)((Object)details.get(i)))).setReceiveNumsSum(receiveNumsSum);
                                planDetailEntity = (SinglePlanDetailEntity)((Object)((Object)this.planDetailService.selectById(((OrderDetailEntity)((Object)((Object)details.get(i)))).getSourceDetailId())));
                                occupyNums = planDetailEntity.getOccupyNums() == null ? BigDecimal.ZERO : planDetailEntity.getOccupyNums();
                                nums = planDetailEntity.getActualNums() == null ? BigDecimal.ZERO : planDetailEntity.getActualNums();
                                planDetailEntity.setOccupyNums(occupyNums.subtract(orderNumsSum).add(receiveNumsSum));
                                planDetailEntity.setSurplusNums(nums.subtract(planDetailEntity.getOccupyNums()));
                                receiveNumsSum = receiveNumsSum.subtract(receiveNumsSum);
                                planDetailList.add(planDetailEntity);
                            }
                            entityList.add(details.get(i));
                            continue;
                        }
                        planDetailEntity = (SinglePlanDetailEntity)((Object)((Object)this.planDetailService.selectById(((OrderDetailEntity)((Object)((Object)details.get(i)))).getSourceDetailId())));
                        occupyNums = planDetailEntity.getOccupyNums() == null ? BigDecimal.ZERO : planDetailEntity.getOccupyNums();
                        nums = planDetailEntity.getActualNums() == null ? BigDecimal.ZERO : planDetailEntity.getActualNums();
                        planDetailEntity.setOccupyNums(occupyNums.subtract(orderNumsSum));
                        planDetailEntity.setSurplusNums(nums.subtract(planDetailEntity.getOccupyNums()));
                        planDetailList.add(planDetailEntity);
                    }
                    if (CollectionUtils.isNotEmpty((Collection)entityList)) {
                        this.orderDetailService.updateBatchById(entityList);
                    }
                    if (CollectionUtils.isNotEmpty((Collection)planDetailList)) {
                        this.planDetailService.updateBatchById(planDetailList);
                    }
                }
            });
        }
    }

    @Override
    public CommonResponse<String> updateDeliver(Long orderId, Integer deliverState) {
        this.logger.info("\u8ba2\u5355id:-{},\u4fee\u6539\u53d1\u8d27\u72b6\u6001\u5f00\u59cb!", (Object)orderId);
        OrderEntity byId = (OrderEntity)((Object)super.getById((Serializable)orderId));
        byId.setDeliverState(deliverState);
        super.saveOrUpdate((Object)byId);
        this.logger.info("\u8ba2\u5355id:-{},\u4fee\u6539\u53d1\u8d27\u72b6\u6001\u4e3a:-{}\u6210\u529f!", (Object)orderId, (Object)deliverState);
        return CommonResponse.success((String)("\u8ba2\u5355id:" + orderId + "\u4fee\u6539\u53d1\u8d27\u72b6\u6001\u4e3a\uff1a" + deliverState + "\u6210\u529f!"));
    }

    @Override
    public BigDecimal getSurplusNumsSum(Long orderDetailId, Long projectId, Long materialId) {
        BigDecimal surplusNumsSum = this.planDetailService.getSurplusNumsSum(projectId, materialId);
        if (orderDetailId != null) {
            OrderDetailEntity orderDetailEntity = (OrderDetailEntity)((Object)this.orderDetailService.selectById(orderDetailId));
            BigDecimal orderNumsSum = orderDetailEntity.getOrderNumsSum() == null ? BigDecimal.ZERO : orderDetailEntity.getOrderNumsSum();
            surplusNumsSum = orderNumsSum.add(surplusNumsSum);
        }
        return surplusNumsSum;
    }

    @Override
    public List<OrderDetailVO> getMaterialDetail(Page<OrderDetailVO> page, QueryWrapper queryWrapper) {
        List<OrderDetailVO> list = ((OrderMapper)this.baseMapper).getMaterialDetail(page, queryWrapper);
        return list;
    }

    @Override
    public List<ParamsCheckVO> planNumCtrl(OrderVO vo) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckList = new ArrayList<ParamsCheckVO>();
        CommonResponse resp = this.paramConfigApi.getBillParamByCodeAndOrgId(PLAN_NUM_CTRL_PARAM_CODE, vo.getOrgId());
        if (!resp.isSuccess() || null == resp.getData()) {
            return paramsCheckList;
        }
        this.logger.info("\u5355\u636e\u63a7\u5236\u53c2\u6570\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)resp));
        List paramList = (List)resp.getData();
        List detailList = vo.getOrderDetailList().stream().filter(item -> !"del".equals(item.getRowState())).collect(Collectors.toList());
        List<Long> materialIds = detailList.stream().map(OrderDetailVO::getMaterialId).collect(Collectors.toList());
        Map<Long, OrderDetailVO> detailMap = detailList.stream().collect(Collectors.toMap(OrderDetailVO::getMaterialId, item -> item));
        List<Map<String, Object>> totalNumList = this.detailService.countDetailTotalNum(vo.getId(), materialIds, vo.getProjectId());
        HashMap detailNumMap = new HashMap();
        Map numMap = null;
        for (Map<String, Object> item2 : totalNumList) {
            if (!detailMap.containsKey(Long.valueOf(item2.get("materialId").toString()))) continue;
            numMap = new HashMap<String, BigDecimal>();
            numMap.put("totalNum", ComputeUtil.safeAdd((BigDecimal)detailMap.get(Long.valueOf(item2.get("materialId").toString())).getOrderNumsSum(), (BigDecimal)(null != item2.get("totalNum") ? new BigDecimal(item2.get("totalNum").toString()) : BigDecimal.ZERO)));
            numMap.put("maxNum", new BigDecimal(item2.get("maxNum").toString()));
            detailNumMap.put(Long.valueOf(item2.get("materialId").toString()), numMap);
        }
        BigDecimal roleValue = null;
        ArrayList<ParamsCheckDsVO> dataSource = null;
        ParamsCheckVO paramsCheck = null;
        ParamsCheckDsVO dsVO = null;
        OrderDetailVO detail = null;
        String maxNumName = "\u5355\u9879\u91c7\u8d2d\u8ba1\u5212\u91cf";
        String totalNumName = "\u914d\u9001\u8ba1\u5212\u91cf";
        for (BillParamVO billParam : paramList) {
            dataSource = new ArrayList<ParamsCheckDsVO>();
            paramsCheck = new ParamsCheckVO();
            roleValue = ComputeUtil.safeDiv((BigDecimal)billParam.getRoleValue(), (BigDecimal)new BigDecimal("100"));
            if (1 == billParam.getControlType()) {
                paramsCheck.setWarnType(paramsArray[1]);
            } else {
                paramsCheck.setWarnType(paramsArray[billParam.getControlType()]);
            }
            if ("none".equals(paramsCheck.getWarnType())) continue;
            for (Long materialId : detailNumMap.keySet()) {
                numMap = (Map)detailNumMap.get(materialId);
                detail = detailMap.get(materialId);
                if (((BigDecimal)numMap.get("maxNum")).compareTo(new BigDecimal("-1")) == 0) {
                    this.logger.info("\u660e\u7ec6\uff1a\u5206\u7c7b-{},\u540d\u79f0-{},\u578b\u53f7-{},id-{}\u5728\u4e0a\u6e38\u5355\u636e\u4e0d\u5b58\u5728\uff0c\u4e0d\u8fdb\u884c\u4ef7\u63a7\uff01", new Object[]{detail.getMaterialTypeName(), detail.getMaterialName(), detail.getSpec(), detail.getMaterialId()});
                }
                if (((BigDecimal)numMap.get("totalNum")).compareTo(ComputeUtil.safeMultiply((BigDecimal)((BigDecimal)numMap.get("maxNum")), (BigDecimal)roleValue)) <= 0) continue;
                dsVO = new ParamsCheckDsVO();
                dsVO.setWarnItem(detail.getMaterialName() + detail.getSpec());
                dsVO.setWarnName(totalNumName + "\u8d85\u8fc7" + maxNumName);
                StringBuffer buffer = new StringBuffer();
                buffer.append("\u672c\u6b21" + totalNumName + "\uff1a");
                buffer.append(detail.getOrderNumsSum().setScale(2, RoundingMode.DOWN));
                buffer.append("\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1" + totalNumName + "\uff1a");
                buffer.append(((BigDecimal)numMap.get("totalNum")).setScale(2, RoundingMode.DOWN));
                buffer.append("\uff0c" + maxNumName + "*");
                buffer.append(billParam.getRoleValue().setScale(2, RoundingMode.DOWN));
                buffer.append("%\uff1a").append(((BigDecimal)numMap.get("maxNum")).setScale(2, RoundingMode.DOWN));
                buffer.append("\u3002\u8d85\u51fa\u6570\u91cf\uff1a");
                buffer.append(ComputeUtil.safeSub((BigDecimal)((BigDecimal)numMap.get("totalNum")), (BigDecimal)ComputeUtil.safeMultiply((BigDecimal)((BigDecimal)numMap.get("maxNum")), (BigDecimal)roleValue)).setScale(2, RoundingMode.DOWN));
                dsVO.setContent(String.valueOf(buffer));
                dsVO.setOrgName(billParam.getOrgName());
                dataSource.add(dsVO);
                paramsCheck.setDataSource(dataSource);
            }
            paramsCheckList.add(paramsCheck);
        }
        return paramsCheckList;
    }

    @Override
    public CommonResponse<String> close(Long orderId) {
        OrderEntity orderEntity = (OrderEntity)((Object)super.selectById((Serializable)orderId));
        CommonResponse<String> res = this.updatePushBill(orderEntity, "BT220223000000006", "/ejc-supbusiness-web/openapi/materialOrder/updateOrderCloseFlag");
        orderEntity.setOrderFlag(OrderFlagEnum.\u5df2\u5173\u95ed.getCode());
        LambdaQueryWrapper ordLambda = new LambdaQueryWrapper();
        ordLambda.eq(OrderDetailEntity::getOrderId, (Object)orderId);
        ordLambda.eq(OrderDetailEntity::getLeafFlag, (Object)false);
        List list1 = this.orderDetailService.list((Wrapper)ordLambda);
        List<CheckDetailVO> list = ((OrderMapper)this.baseMapper).getCheckDetail(orderId);
        ArrayList<OrderDetailEntity> orderDetailList = new ArrayList<OrderDetailEntity>();
        ArrayList<SinglePlanDetailEntity> planDetailList = new ArrayList<SinglePlanDetailEntity>();
        Map<Long, CheckDetailVO> map = list.stream().filter(t -> t.getOrderDetailId() != null).collect(Collectors.toMap(CheckDetailVO::getOrderDetailId, item -> item, (v1, v2) -> v2));
        for (OrderDetailEntity orderDetail : list1) {
            if (map.containsKey(orderDetail.getId())) {
                CheckDetailVO checkDetail = map.get(orderDetail.getId());
                BigDecimal checkNum = checkDetail.getCheckNum() == null ? BigDecimal.ZERO : checkDetail.getCheckNum();
                orderDetail.setCheckNumsSum(checkNum);
                if (orderDetail.getSourceType().equals(SourceTypeEnum.\u5355\u9879\u91c7\u8d2d\u8ba1\u5212.getCode())) {
                    LambdaQueryWrapper lambda = new LambdaQueryWrapper();
                    lambda.eq(OrderDetailEntity::getParentId, (Object)orderDetail.getTid());
                    lambda.orderByDesc(OrderDetailEntity::getPlanDate);
                    lambda.eq(OrderDetailEntity::getOrderId, (Object)orderDetail.getOrderId());
                    lambda.eq(OrderDetailEntity::getLeafFlag, (Object)true);
                    List list2 = this.orderDetailService.list((Wrapper)lambda);
                    for (OrderDetailEntity detailEntity : list2) {
                        BigDecimal receiveNumsSum;
                        BigDecimal bigDecimal = receiveNumsSum = detailEntity.getReceiveNumsSum() == null ? BigDecimal.ZERO : detailEntity.getReceiveNumsSum();
                        if (checkNum.compareTo(BigDecimal.ZERO) > 0) {
                            if (checkNum.compareTo(receiveNumsSum) >= 0) {
                                detailEntity.setCheckNumsSum(receiveNumsSum);
                                checkNum = checkNum.subtract(receiveNumsSum);
                            } else {
                                detailEntity.setCheckNumsSum(checkNum);
                                BigDecimal subtract = receiveNumsSum.subtract(checkNum);
                                SinglePlanDetailEntity planDetailEntity = (SinglePlanDetailEntity)((Object)this.planDetailService.selectById(detailEntity.getSourceDetailId()));
                                BigDecimal occupyNums = planDetailEntity.getOccupyNums() == null ? BigDecimal.ZERO : planDetailEntity.getOccupyNums();
                                BigDecimal nums = planDetailEntity.getActualNums() == null ? BigDecimal.ZERO : planDetailEntity.getActualNums();
                                planDetailEntity.setOccupyNums(occupyNums.subtract(subtract));
                                planDetailEntity.setSurplusNums(nums.subtract(planDetailEntity.getOccupyNums()));
                                planDetailList.add(planDetailEntity);
                            }
                        } else {
                            detailEntity.setCheckNumsSum(BigDecimal.ZERO);
                            SinglePlanDetailEntity planDetailEntity = (SinglePlanDetailEntity)((Object)this.planDetailService.selectById(detailEntity.getSourceDetailId()));
                            BigDecimal occupyNums = planDetailEntity.getOccupyNums() == null ? BigDecimal.ZERO : planDetailEntity.getOccupyNums();
                            BigDecimal nums = planDetailEntity.getActualNums() == null ? BigDecimal.ZERO : planDetailEntity.getActualNums();
                            planDetailEntity.setOccupyNums(occupyNums.subtract(receiveNumsSum));
                            planDetailEntity.setSurplusNums(nums.subtract(planDetailEntity.getOccupyNums()));
                            planDetailList.add(planDetailEntity);
                        }
                        orderDetailList.add(detailEntity);
                    }
                }
            } else {
                orderDetail.setCheckNumsSum(BigDecimal.ZERO);
                if (orderDetail.getSourceType().equals(SourceTypeEnum.\u5355\u9879\u91c7\u8d2d\u8ba1\u5212.getCode())) {
                    LambdaQueryWrapper lambda = new LambdaQueryWrapper();
                    lambda.eq(OrderDetailEntity::getParentId, (Object)orderDetail.getTid());
                    lambda.eq(OrderDetailEntity::getLeafFlag, (Object)true);
                    lambda.eq(OrderDetailEntity::getOrderId, (Object)orderDetail.getOrderId());
                    lambda.orderByDesc(OrderDetailEntity::getPlanDate);
                    List list2 = this.orderDetailService.list((Wrapper)lambda);
                    for (OrderDetailEntity detailEntity : list2) {
                        BigDecimal receiveNumsSum = detailEntity.getReceiveNumsSum() == null ? BigDecimal.ZERO : detailEntity.getReceiveNumsSum();
                        SinglePlanDetailEntity planDetailEntity = (SinglePlanDetailEntity)((Object)this.planDetailService.selectById(detailEntity.getSourceDetailId()));
                        BigDecimal occupyNums = planDetailEntity.getOccupyNums() == null ? BigDecimal.ZERO : planDetailEntity.getOccupyNums();
                        BigDecimal nums = planDetailEntity.getActualNums() == null ? BigDecimal.ZERO : planDetailEntity.getActualNums();
                        planDetailEntity.setOccupyNums(occupyNums.subtract(receiveNumsSum));
                        planDetailEntity.setSurplusNums(nums.subtract(planDetailEntity.getOccupyNums()));
                        detailEntity.setCheckNumsSum(BigDecimal.ZERO);
                        planDetailList.add(planDetailEntity);
                        orderDetailList.add(detailEntity);
                    }
                }
            }
            orderDetailList.add(orderDetail);
        }
        if (CollectionUtils.isNotEmpty(orderDetailList)) {
            this.orderDetailService.saveOrUpdateBatch(orderDetailList);
        }
        if (CollectionUtils.isNotEmpty(planDetailList)) {
            this.planDetailService.saveOrUpdateBatch(planDetailList);
        }
        super.updateById((Object)orderEntity);
        return CommonResponse.success((String)"\u5173\u95ed\u6210\u529f");
    }

    @Override
    public CommonResponse<String> stop(Long orderId, String stopReason, String stopState) {
        OrderEntity entity = (OrderEntity)((Object)super.selectById((Serializable)orderId));
        if (StringUtils.isNotEmpty((CharSequence)entity.getStopState())) {
            throw new BusinessException("\u8be5\u914d\u9001\u8ba1\u5212\u5df2\u7ec8\u6b62\uff01");
        }
        entity.setStopDate(new Date());
        entity.setStopReason(stopReason);
        entity.setStopState(stopState);
        entity.setStopUserId(InvocationInfoProxy.getUserid());
        entity.setStopUserName(this.sessionManager.getUserContext().getUserName());
        this.updatePushBill(entity, "BT220223000000006", "/ejc-supbusiness-web/openapi/materialOrder/updateOrderCloseFlag");
        entity.setOrderFlag(OrderFlagEnum.\u5df2\u5173\u95ed.getCode());
        List<OrderDetailEntity> detailList = entity.getOrderDetailList();
        HashMap<Long, BigDecimal> numMap = new HashMap<Long, BigDecimal>();
        for (OrderDetailEntity detail : detailList) {
            BigDecimal num = ComputeUtil.safeSub((BigDecimal)detail.getActualNumsSum(), (BigDecimal)detail.getOccupyNumsSum());
            detail.setActualNumsSum(detail.getOccupyNumsSum());
            detail.setSurplusNumsSum(BigDecimal.ZERO);
            numMap.put(detail.getSourceDetailId(), ComputeUtil.safeSub((BigDecimal)((BigDecimal)numMap.get(detail.getSourceDetailId())), (BigDecimal)num));
        }
        if (MapUtils.isNotEmpty(numMap)) {
            if ("2".equals(stopState)) {
                this.planDetailService.writeBackActualNum(numMap);
            } else {
                this.planDetailService.writeBackOccupyNum(numMap);
            }
        }
        super.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u5173\u95ed\u6210\u529f");
    }

    @Override
    public boolean pushBillToSupCenter(OrderEntity orderEntity, String billTypeCode) {
        boolean syncFlag;
        block11: {
            boolean locked = false;
            syncFlag = false;
            Jedis jedis = this.jedisPool.getResource();
            String key = billTypeCode + "::" + orderEntity.getId().toString();
            CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
            if (!ejcCloudSystemCode.isSuccess()) {
                this.logger.error("\u63a8\u9001\u8ba1\u91cf\u5355\u636e-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)orderEntity.getId(), (Object)ejcCloudSystemCode.getMsg());
                return false;
            }
            orderEntity.setSystemId((String)ejcCloudSystemCode.getData());
            try {
                locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"MATERIAL_ORDER_SYNC", (int)600);
                if (!locked) {
                    this.logger.error("\u5355\u636e\u63a8\u9001\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25\uff01");
                    this.releaseLock(jedis, false, key, "MATERIAL_ORDER_SYNC");
                    boolean bl = false;
                    return bl;
                }
                HashMap<String, String> paramMap = new HashMap<String, String>();
                SupOrderVO supOrderVO = (SupOrderVO)BeanMapper.map((Object)((Object)orderEntity), SupOrderVO.class);
                List supOrderDetailVOS = BeanMapper.mapList(orderEntity.getOrderDetailList(), SupOrderDetailVO.class);
                supOrderVO.setMaterialOrderDetailList(supOrderDetailVOS);
                paramMap.put("order", JSONObject.toJSONString((Object)supOrderVO));
                CommonResponse fileResp = this.attachmentApi.queryListBySourceId(orderEntity.getId(), "BT220223000000006", "material-order-attaches", null);
                if (fileResp.isSuccess()) {
                    HashMap files = new HashMap();
                    List fileList = (List)fileResp.getData();
                    ArrayList<Long> fileIds = new ArrayList<Long>();
                    for (AttachmentVO attach : fileList) {
                        fileIds.add(attach.getId());
                    }
                    if (CollectionUtils.isNotEmpty((Collection)fileList)) {
                        Map fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
                        fileMap.keySet().stream().forEach(fileKey -> {
                            HashMap file = new HashMap(1);
                            file.put((String)fileKey, fileMap.get(fileKey));
                            files.put("file", file);
                        });
                    }
                    this.logger.info("\u5411\u4f9b\u5e94\u5546-{}\u63a8\u9001\u8ba1\u91cf\u5355\u636e\u53c2\u6570-{}", (Object)orderEntity.getSupplierId(), (Object)JSONObject.toJSONString(paramMap));
                    CommonResponse syncReqResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem("/ejc-supbusiness-web/openapi/materialOrder/saveOrUpdate", paramMap, orderEntity.getSupplierId().toString(), files);
                    syncFlag = CommonUtils.checkCommonResponse(syncReqResp, this.logger);
                    break block11;
                }
                this.logger.error("\u83b7\u53d6\u8ba2\u5355\u5355\u636eid-{}\u5bf9\u5e94\u9644\u4ef6\u4fe1\u606f\u5931\u8d25, {}", (Object)orderEntity.getId(), (Object)fileResp.getMsg());
                throw new BusinessException(fileResp.getMsg());
            }
            catch (Exception e) {
                this.logger.error("\u63a8\u9001\u8ba2\u5355\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{} \u5f02\u5e38\uff0c", new Object[]{orderEntity.getId(), orderEntity.getSupplierId(), e});
                throw new BusinessException("\u63a8\u9001\u4f9b\u65b9\u5f02\u5e38!");
            }
            finally {
                this.releaseLock(jedis, locked, key, "MATERIAL_ORDER_SYNC");
            }
        }
        return syncFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CommonResponse<String> updatePushBill(OrderEntity orderEntity, String billTypeCode, String url) {
        locked = false;
        jedis = this.jedisPool.getResource();
        key = billTypeCode + "::" + orderEntity.getId().toString();
        ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            this.logger.error("\u63a8\u9001\u5355\u636e-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)orderEntity.getId(), (Object)ejcCloudSystemCode.getMsg());
            return CommonResponse.error((String)"\u63a8\u9001\u4f9b\u65b9\u5f02\u5e38!");
        }
        orderEntity.setSystemId((String)ejcCloudSystemCode.getData());
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"MATERIAL_ORDER_SYNC", (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636e\u4f5c\u5e9f\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25\uff01");
                this.releaseLock(jedis, false, key, "MATERIAL_ORDER_SYNC");
                var8_8 = CommonResponse.error((String)"\u5355\u636e\u4f5c\u5e9f\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25!");
                return var8_8;
            }
            paramMap = new HashMap<String, String>();
            paramMap.put("id", orderEntity.getId().toString());
            paramMap.put("systemId", orderEntity.getSystemId());
            this.logger.info("\u5355\u636eid-{}\u5f03\u5ba1\uff0c\u901a\u77e5\u4f9b\u65b9-{}\u5355\u636e\u4f5c\u5e9f!", (Object)orderEntity.getSupplierId(), (Object)orderEntity.getId());
            syncReqResp = this.systemDataPushService.exchangeDataWithEachLinkSystem(url, RequestMethod.POST, JSONObject.toJSONString(paramMap), orderEntity.getSupplierId().toString());
            if (!syncReqResp.isSuccess()) ** GOTO lbl32
            supHandleResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
            if (supHandleResp.isSuccess()) {
                var11_13 = supHandleResp;
                return var11_13;
            }
            try {
                this.logger.error("\u4f9b\u65b9-{}\u5904\u7406\u4f5c\u5e9f\u5355\u636eid-{}\u4f5c\u5e9f\u5931\u8d25, {}", new Object[]{orderEntity.getSupplierId(), orderEntity.getId(), supHandleResp.getMsg()});
                throw new BusinessException(supHandleResp.getMsg());
lbl32:
                // 1 sources

                this.logger.error("\u53d1\u9001\u8bf7\u6c42\u901a\u77e5\u4f9b\u65b9-{} \u5355\u636eid-{}\u4f5c\u5e9f\u5931\u8d25, {}", new Object[]{orderEntity.getSupplierId(), orderEntity.getId(), syncReqResp.getMsg()});
                throw new BusinessException(syncReqResp.getMsg());
            }
            catch (Exception e) {
                this.logger.error("\u901a\u77e5\u4f9b\u65b9\u5355\u636eid-{}\u4f5c\u5e9f\u5f02\u5e38\uff0c", (Object)orderEntity.getId(), (Object)e);
                throw e;
            }
        }
        finally {
            this.releaseLock(jedis, locked, key, "MATERIAL_ORDER_SYNC");
        }
    }

    public void sendMsg(List<String> messageType, List<String> user, String msgType, String subject, String content, String tenantId, OrderEntity orderEntity) {
        this.logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb\uff01===========");
        PushMsgParameter parameter = new PushMsgParameter();
        ArrayList<String> channel = new ArrayList<String>();
        if (messageType.contains("sys")) {
            channel.add("sys");
        }
        String[] receivers = user.toArray(new String[user.size()]);
        parameter.setReceivers(receivers);
        parameter.setChannel(channel.toArray(new String[channel.size()]));
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);
        parameter.setContent(content);
        parameter.setTenantId(tenantId);
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        try {
            CommonResponse result = this.pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
            } else {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3RPC\u670d\u52a1\u5f02\u5e38--------------" + e);
        }
    }
}

