package com.ejianc.business.promaterial.plan.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 物资月计划子表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_promaterial_month_plan_detail")
public class MonthPlanDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="material_month_plan_id")
    private Long materialMonthPlanId; // 所属总计划Id
    @TableField(value="material_category_id")
    private Long materialCategoryId; // 物资分类Id
    @TableField(value="material_category_name")
    private String materialCategoryName; // 物资分类名称
    @TableField(value="material_id")
    private Long materialId; // 物资Id
    @TableField(value="material_name")
    private String materialName; // 物资名称
    @TableField(value="material_code")
    private String materialCode; // 物料编码
    @TableField(value="spec")
    private String spec; // 规格型号
    @TableField(value="unit")
    private String unit; // 计量单位
    @TableField(value="month_plan_num")
    private BigDecimal monthPlanNum; // 月计划数量
    @TableField(value="month_plan_price")
    private BigDecimal monthPlanPrice; // 月计划单价
    @TableField(value="month_plan_mny")
    private BigDecimal monthPlanMny; // 月计划金额
    @TableField(value="source_type")
    private Integer sourceType; // 来源类型 1：总计划，2：物料档案
    @TableField(value="remark")
    private String remark; // 备注
    @ApiModelProperty("参照名称(月份+编码)")
    @TableField(value="name")
    private String name;
    @TableField(value="source_id")
    private Long sourceId; // 来源Id
    @TableField(value="surplus_nums")
    private BigDecimal surplusNums; // 剩余数量
    @TableField(value="unit_id")
    private Long unitId; // 计量单位
    @TableField(value="plan_date")
    private Date planDate; // 需用日期
    @TableField(value="construction")
    private String construction; // 使用部位
    @TableField(value="first_state")
    private Integer firstState; // 是否为一级采购目录清单：0-否，1-是
    @TableField(value="texture")
    private String texture; // 材质
    @TableField(value="item_desc")
    private String itemDesc; // 物料描述
    @TableField(value="occupy_nums")
    private BigDecimal occupyNums; // 占用数量


    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public BigDecimal getSurplusNums() {
        return surplusNums;
    }

    public void setSurplusNums(BigDecimal surplusNums) {
        this.surplusNums = surplusNums;
    }

    /**
     * 物资编码
     */
    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }

    /**
     * 参照树名称
     */
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    /**
     * 所属总计划Id
     */
    public Long getMaterialMonthPlanId() {
        return materialMonthPlanId;
    }

    /**
     * 所属总计划Id
     */
    public void setMaterialMonthPlanId(Long materialMonthPlanId) {
        this.materialMonthPlanId = materialMonthPlanId;
    }
    /**
     * 物资分类Id
     */
    public Long getMaterialCategoryId() {
        return materialCategoryId;
    }

    /**
     * 物资分类Id
     */
    public void setMaterialCategoryId(Long materialCategoryId) {
        this.materialCategoryId = materialCategoryId;
    }
    /**
     * 物资分类名称
     */
    public String getMaterialCategoryName() {
        return materialCategoryName;
    }

    /**
     * 物资分类名称
     */
    public void setMaterialCategoryName(String materialCategoryName) {
        this.materialCategoryName = materialCategoryName;
    }
    /**
     * 物资Id
     */
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * 物资Id
     */
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    /**
     * 物资名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 计量单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 计量单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 月计划数量
     */
    public BigDecimal getMonthPlanNum() {
        return monthPlanNum;
    }

    /**
     * 月计划数量
     */
    public void setMonthPlanNum(BigDecimal monthPlanNum) {
        this.monthPlanNum = monthPlanNum;
    }
    /**
     * 月计划单价
     */
    public BigDecimal getMonthPlanPrice() {
        return monthPlanPrice;
    }

    /**
     * 月计划单价
     */
    public void setMonthPlanPrice(BigDecimal monthPlanPrice) {
        this.monthPlanPrice = monthPlanPrice;
    }
    /**
     * 月计划金额
     */
    public BigDecimal getMonthPlanMny() {
        return monthPlanMny;
    }

    /**
     * 月计划金额
     */
    public void setMonthPlanMny(BigDecimal monthPlanMny) {
        this.monthPlanMny = monthPlanMny;
    }
    /**
     * 物资来源
     */
    public Integer getSourceType() {
        return sourceType;
    }
    /**
     * 物资来源
     */
    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }
    /**
     * 备注
     */
    public String getRemark() {
        return remark;
    }

    /**
     * 备注
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Date getPlanDate() {
        return planDate;
    }

    public void setPlanDate(Date planDate) {
        this.planDate = planDate;
    }

    public String getConstruction() {
        return construction;
    }

    public void setConstruction(String construction) {
        this.construction = construction;
    }

    public Integer getFirstState() {
        return firstState;
    }

    public void setFirstState(Integer firstState) {
        this.firstState = firstState;
    }

    public String getTexture() {
        return texture;
    }

    public void setTexture(String texture) {
        this.texture = texture;
    }

    public String getItemDesc() {
        return itemDesc;
    }

    public void setItemDesc(String itemDesc) {
        this.itemDesc = itemDesc;
    }

    public BigDecimal getOccupyNums() {
        return occupyNums;
    }

    public void setOccupyNums(BigDecimal occupyNums) {
        this.occupyNums = occupyNums;
    }
}
