package com.ejianc.business.promaterial.plan.bean;

import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.promaterial.plan.bean.MonthPlanDetailEntity;
import io.swagger.annotations.ApiModelProperty;

/**
 * 物资月计划
 * 
 * @author generator
 * 
 */
 @TableName("ejc_promaterial_month_plan")
public class MonthPlanEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="org_id")
    private Long orgId; // 所属项目部Id
    @TableField(value="org_name")
    private String orgName; // 所属项目部名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 组织ID
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 组织名称
    @TableField(value="project_id")
    private Long projectId; // 所属项目Id
    @TableField(value="project_name")
    private String projectName; // 所属项目名称
    @TableField(value="project_code")
    private String projectCode; // 所属项目编码
    @TableField(value="plan_month")
    private Date planMonth; // 计划月份
    @TableField(value="operator_id")
    private Long operatorId; // 编制人id
    @TableField(value="operator_name")
    private String operatorName; // 编制人
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="bill_date")
    private Date billDate; // 编制日期
    @TableField(value="plan_type")
    private Integer planType; // 计划类型（0-消耗材，1-混泥土）
    @ApiModelProperty("参照树名称(月份+编码)")
    @TableField(value="name")
    private String name;
    @TableField(value="org_code")
    private String orgCode; // 所属项目部编码

    @TableField(value="dept_name")
    private String deptName;// 需用部门
    @TableField(value="urgent_state")
    private Integer urgentState; // 紧急采购（0-否，1-是）
    @TableField(value="plan_name")
    private String planName; // 计划名称

    @TableField(exist=false)
    @SubEntity(serviceName="monthPlanDetailService",pidName = "materialMonthPlanId")
    private List<MonthPlanDetailEntity> monthPlanDetailEntities = new ArrayList<>(); // 物资月计划子表

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    /**
     * 参照树名称
     */
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    /**
     * 计划类型
     */
    public Integer getPlanType() {
        return planType;
    }

    public void setPlanType(Integer planType) {
        this.planType = planType;
    }

    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 单据编码
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编码
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 所属项目部Id
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 所属项目部Id
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属项目部名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 所属项目部名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 组织ID
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 组织ID
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    /**
     * 组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 所属项目Id
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 所属项目Id
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 所属项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 所属项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 所属项目编码
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 所属项目编码
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 计划月份
     */
    public Date getPlanMonth() {
        return planMonth;
    }

    /**
     * 计划月份
     */
    public void setPlanMonth(Date planMonth) {
        this.planMonth = planMonth;
    }
    /**
     * 编制人id
     */
    public Long getOperatorId() {
        return operatorId;
    }

    /**
     * 编制人id
     */
    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    /**
     * 编制人
     */
    public String getOperatorName() {
        return operatorName;
    }

    /**
     * 编制人
     */
    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    /**
     * 备注
     */
    public String getRemark() {
        return remark;
    }
    /**
     * 备注
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }

    /**
     * 编制日期
     */
    public Date getBillDate() {
        return billDate;
    }

    /**
     * 编制日期
     */
    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public Integer getUrgentState() {
        return urgentState;
    }

    public void setUrgentState(Integer urgentState) {
        this.urgentState = urgentState;
    }

    public String getPlanName() {
        return planName;
    }

    public void setPlanName(String planName) {
        this.planName = planName;
    }

    /**
     * 物资月计划子表
     */
    public List<MonthPlanDetailEntity> getMonthPlanDetailEntities() {
        return monthPlanDetailEntities;
    }

    /**
     * 物资月计划子表
     */
    public void setMonthPlanDetailEntities(List<MonthPlanDetailEntity> monthPlanDetailEntities) {
        this.monthPlanDetailEntities = monthPlanDetailEntities;
    }
}
