package com.ejianc.business.promaterial.plan.service;

import com.ejianc.business.promaterial.plan.vo.MasterPlanVO;
import com.ejianc.business.promaterial.plan.vo.MasterPlanContrastV0;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.promaterial.plan.bean.MasterPlanEntity;

import java.util.List;


/**
 * 消耗材总计划
 *
 * @author generator
 *
 */
public interface IMasterPlanService extends IBaseService<MasterPlanEntity> {

    /**
     * 根据编码查询物资总计划
     *
     * @param planCode
     * @return
     */
    MasterPlanVO queryByCode(String planCode, Integer planType);

    /**
     * 根据项目Id来查询物资总计划
     *
     * @param projectId
     * @return
     */
    MasterPlanVO queryByProjectId(Long projectId, Integer planType);

    /**
     * 保存或更新物资总计划
     *
     */
    CommonResponse<MasterPlanVO> saveOrUpdateMasterPlan(MasterPlanVO masterPlanVo, Boolean isControl);

    MasterPlanVO queryDetail(Long id, boolean detailHasChildren);
    /**
     * 获取消耗材总计划对比信息
     *
     * @param
     */
    List<MasterPlanContrastV0> getContrastInfo(Long materialMasterPlanId, Long oldMaterialMasterPlanId);

    ExecutionVO targetCost(MasterPlanVO masterPlanVO, String linkUrl, String billType, Integer planType);

    ParamsCheckVO targetCostCtrl(MasterPlanVO masterPlanVo);

    ParamsCheckVO viewTargetCostCtrlInfo(Long id);

    CommonResponse<String> pushTargetCost(Long id);
}
