package com.ejianc.business.promaterial.plan.service.impl;

import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.promaterial.plan.mapper.BatPlanDetailMapper;
import com.ejianc.business.promaterial.plan.bean.BatPlanDetailEntity;
import com.ejianc.business.promaterial.plan.service.IBatPlanDetailService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 材料批次采购计划字表（采购清单）
 * 
 * @author generator
 * 
 */
@Service("batPlanDetailService")
public class BatPlanDetailServiceImpl extends BaseServiceImpl<BatPlanDetailMapper, BatPlanDetailEntity> implements IBatPlanDetailService{

    @Override
    public List<Map<String, Object>> countDetailTotalNum(Long planId, List<Long> detailIds, Long projectId) {
        return baseMapper.countDetailTotalNum(planId, detailIds, projectId);
    }

    @Override
    public Map<Long, BigDecimal> writeBackOccupyNum(Map<Long, BigDecimal> numMap) {
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter(QueryParam.IN, new ArrayList<>(numMap.keySet())));
        List<BatPlanDetailEntity> list = super.queryList(param);
        for(BatPlanDetailEntity detail : list){
            detail.setOccupyNums(ComputeUtil.safeAdd(detail.getOccupyNums(), numMap.get(detail.getId())));
            detail.setSurplusNums(ComputeUtil.safeSub(detail.getNum(), detail.getOccupyNums()));
        }
        if(CollectionUtils.isNotEmpty(list)){
            super.saveOrUpdateBatch(list);
        }
        Map<Long, BigDecimal> result = list.stream().collect(Collectors.toMap(x->x.getId(), x->x.getOccupyNums()));
        return result;
    }

}
