package com.ejianc.business.promaterial.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.order.vo.OrderDetailVO;
import com.ejianc.business.promaterial.plan.service.IPlanDetailService;
import com.ejianc.business.promaterial.plan.vo.SinglePlanDetailVO;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.promaterial.plan.mapper.SinglePlanDetailMapper;
import com.ejianc.business.promaterial.plan.bean.SinglePlanDetailEntity;
import com.ejianc.business.promaterial.plan.service.ISinglePlanDetailService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 单项采购计划子表
 * 
 * @author generator
 * 
 */
@Service("singlePlanDetailService")
public class SinglePlanDetailServiceImpl extends BaseServiceImpl<SinglePlanDetailMapper, SinglePlanDetailEntity> implements ISinglePlanDetailService{

    @Autowired
    private IPlanDetailService planDetailService;

    @Override
    public List<SinglePlanDetailVO> geMaterialDetail(Page<SinglePlanDetailVO> page, QueryWrapper queryWrapper) {
        List<SinglePlanDetailVO> list = baseMapper.geMaterialDetail(page,queryWrapper);
        return list;
    }

    @Override
    public List<OrderDetailVO> queryMaterialDetail(Long projectId, Long materialId) {
        List<OrderDetailVO> orderDetailVOS = baseMapper.queryMaterialDetail(projectId, materialId);
        return orderDetailVOS;
    }

    @Override
    public BigDecimal getSurplusNumsSum(Long projectId, Long materialId) {
        BigDecimal surplusNumsSum = baseMapper.getSurplusNumsSum(projectId, materialId);
        return surplusNumsSum;
    }

    @Override
    public List<Map<String, Object>> countDetailTotalNum(Long planId, List<Long> detailIds, Long projectId) {
        return baseMapper.countDetailTotalNum(planId, detailIds, projectId);
    }

    @Override
    public List<Map<String, Object>> contractNumCtrl(Long planId, List<Long> detailIds, Long contractId) {
        return baseMapper.contractNumCtrl(planId, detailIds, contractId);
    }

    @Override
    public Map<Long, BigDecimal> writeBackOccupyNum(Map<Long, BigDecimal> numMap) {
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter(QueryParam.IN, new ArrayList<>(numMap.keySet())));
        List<SinglePlanDetailEntity> list = super.queryList(param);
        for(SinglePlanDetailEntity detail : list){
            detail.setOccupyNums(ComputeUtil.safeAdd(detail.getOccupyNums(), numMap.get(detail.getId())));
            detail.setSurplusNums(ComputeUtil.safeSub(detail.getActualNums(), detail.getOccupyNums()));
        }
        if(CollectionUtils.isNotEmpty(list)){
            super.saveOrUpdateBatch(list);
        }
        Map<Long, BigDecimal> result = list.stream().collect(Collectors.toMap(x->x.getId(), x->x.getOccupyNums()));
        return result;
    }

    @Override
    public Map<Long, BigDecimal> writeBackActualNum(Map<Long, BigDecimal> numMap) {
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter(QueryParam.IN, new ArrayList<>(numMap.keySet())));
        List<SinglePlanDetailEntity> list = super.queryList(param);
        Map<Long, BigDecimal> planMap = new HashMap<>();
        for(SinglePlanDetailEntity detail : list){
            detail.setOccupyNums(ComputeUtil.safeAdd(detail.getOccupyNums(), numMap.get(detail.getId())));
            detail.setActualNums(ComputeUtil.safeAdd(detail.getActualNums(), numMap.get(detail.getId())));
            detail.setSurplusNums(ComputeUtil.safeSub(detail.getActualNums(), detail.getOccupyNums()));
            planMap.put(detail.getSourceId(), numMap.get(detail.getId()));
        }
        if(CollectionUtils.isNotEmpty(list)){
            super.saveOrUpdateBatch(list);
        }
        if(MapUtils.isNotEmpty(planMap)){
            planDetailService.writeBackOccupyNum(planMap);
        }
        Map<Long, BigDecimal> result = list.stream().collect(Collectors.toMap(x->x.getId(), x->x.getOccupyNums()));
        return result;
    }
}
