package com.ejianc.business.promaterial.contract.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.promaterial.check.bean.CheckEntity;
import com.ejianc.business.promaterial.contract.bean.ContractDetailEntity;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.enums.ChangeTypeEnum;
import com.ejianc.business.promaterial.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.promaterial.contract.enums.PurchaseTypeEnum;
import com.ejianc.business.promaterial.contract.enums.SignatureStatusEnum;
import com.ejianc.business.promaterial.contract.service.IContractDetailService;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.contract.vo.ContractMaterialReportVO;
import com.ejianc.business.promaterial.contract.vo.ContractVO;
import com.ejianc.business.promaterial.contract.vo.MaterialReportVO;
import com.ejianc.business.promaterial.order.vo.OrderVO;
import com.ejianc.business.promaterial.plan.bean.MasterPlanEntity;
import com.ejianc.business.promaterial.plan.vo.MasterPlanVO;
import com.ejianc.business.promaterial.settlement.bean.SettlementEntity;
import com.ejianc.business.promaterial.settlement.vo.ExportSettlementVO;
import com.ejianc.business.prosub.vo.ContractPaymentResultVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.business.tender.api.ITenderApi;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;
import static java.math.BigDecimal.ROUND_HALF_DOWN;

/**
 * 主合同实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("contract")
@Api(value = "主合同实体", tags = {"主合同实体"})
public class ContractController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ITenderApi tenderApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IContractService service;

    @Autowired
    private IExecutionApi executionApi;

    @Autowired
    private IEmployeeApi employeeApi;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IContractDetailService contractDetailService;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ContractVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody ContractVO saveorUpdateVO, HttpServletRequest req) {
        String authority = req.getHeader("authority");
        return service.saveOrUpdate(saveorUpdateVO,authority,false);
    }

    /**
     * 新增或者修改补充协议
     *
     * @param supplement
     * @return
     */
    @RequestMapping(value = "/saveOrUpdateSupplement", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ContractVO> saveOrUpdateSupplement(@RequestBody ContractVO supplement, HttpServletRequest req) {
        if (supplement.getMainContractId() == null) {
            return CommonResponse.error("保存失败，主合同信息为空！");
        }
        String authority = req.getHeader("authority");
        ContractVO vo = service.saveOrUpdateSupplement(supplement,authority,false);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Author
     * @Description  新增根据合同主键查询补充协议需要的主合同字段
     * @param contractId
     * @Return
     */
    @RequestMapping(value = "/addConvertByConId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractVO> addConvertByConId(Long contractId) {
        ContractVO vo = service.addConvertByConId(contractId);
        return CommonResponse.success("新增转换数据成功！",vo);
    }

    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractVO> queryDetail(@RequestParam Long id) {
        return CommonResponse.success("查询详情数据成功！",service.queryDetail(id));
    }
    @ApiOperation("获取当前登录人手机号")
    @RequestMapping(value = "/queryPhone", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> queryPhone() {
        String mobilePhone = employeeApi.getById(sessionManager.getUserContext().getEmployeeId()).getData().getMobilePhone();
        return CommonResponse.success("查询列表数据成功！",mobilePhone);
    }

    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ContractVO> vos) {
        service.delete(vos);
        return CommonResponse.success("删除成功！");
    }
    /**
     * @Author
     * @Description  判断当前合同是否能新增补充协议
     * @param
     * @Return
     * @return
     */
    @RequestMapping(value = "/addSupplementFlag", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> addSupplementFlag(Long id) {
        Boolean flag = service.addSupplementFlag(id);
        if (flag) {
            boolean filingFlag = service.checkContractFiling(id);
            if (!filingFlag) {
                return CommonResponse.error("合同未归档，不允许新增补充协议！");
            }
            return CommonResponse.success("校验通过，该合同可以新增补充协议！");
        }
        return CommonResponse.error("当前合同无法新增补充协议！");
    }

//    @ApiOperation("查询列表")
//    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
//    @ResponseBody
//    public CommonResponse<IPage<ContractVO>> queryList(@RequestBody QueryParam param) {
//        /** 模糊搜索配置字段示例 */
//        List<String> fuzzyFields = param.getFuzzyFields();
//        fuzzyFields.add("contractName");
//        fuzzyFields.add("billCode");
//        fuzzyFields.add("employeeName");
//        fuzzyFields.add("customerName");
//        fuzzyFields.add("supplierName");
//        /** 租户隔离 */
//        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
//
//        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
//        UserContext userContextCache =sessionManager.getUserContext();
//        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
//        String authOrgIds = userContextCache.getAuthOrgIds();
//        List<OrgVO> orgVOList = null;
//        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
//        }else {//pc端查询
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
//        }
//        //普通组织 id
//        List<Long> commonOrgIds = new ArrayList<>();
//        //项目部 id
//        List<Long> departmentIds = new ArrayList<>();
//        orgVOList.stream().forEach(org -> {
//            if(5 == org.getOrgType()) {
//                //项目部
//                departmentIds.add(org.getId());
//            } else {
//                //普通组织
//                commonOrgIds.add(org.getId());
//            }
//        });
//        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
//            /** 要求主表有orgId字段，保存单据所属组织 */addSupplementFlag
//            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
//        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
//            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
//            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
//        }
//        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
//
//        IPage<ContractEntity> page = service.queryPage(param,false);
//        IPage<ContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
//  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ContractVO.class));
//
//        return CommonResponse.success("查询列表数据成功！",pageData);
//    }

    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam param) {
        // 物资采购合同合同类型
        param.getParams().put("contract_type",new Parameter(QueryParam.EQ,0));
        return CommonResponse.success("查询列表数据成功！",this.queryContractList(param));
    }

    @RequestMapping(value = "/pageConcreteList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> pageConcreteList(@RequestBody QueryParam param) {
        // 混凝土合同合同类型
        param.getParams().put("contract_type",new Parameter(QueryParam.EQ,1));
        return CommonResponse.success("查询列表数据成功！",this.queryContractList(param));
    }

    /**
     * 查询合同
     * @param param 查询参数
     * @return 查询结果
     */
    private JSONObject queryContractList(QueryParam param){
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenant_id", new Parameter("eq", InvocationInfoProxy.getTenantid()));
        param.getComplexParams().add(getPageQueryParam(null, false));

        //设置排序：为了保证主合同与补充协议排列在一起，先用主合同创建时间排序
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        if (null != param.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", param.getOrderMap().get("createTime"));
        }
        else {
            orderMap.put("main_contract_create_date", QueryParam.DESC);
        }
        orderMap.put("supplement_flag", QueryParam.ASC);
//        orderMap.put("create_time", QueryParam.DESC);
        // 前端传入的排序
        orderMap.putAll(param.getOrderMap());
        param.setOrderMap(orderMap);
        IPage<ContractEntity> pageData= service.queryPage(param,false);

        //页面统计，查询原合同金额，现合同金额
        Map<String, Object> contractAmountMap = service.countContractAmount(param);
        JSONObject page = new JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), ContractVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        page.put("sumMnyMap", contractAmountMap);
        return page;
    }

    /**
     * 查询当前合同下补充协议信息
     * @param id
     * @return
     */
    @RequestMapping(value = "/querySupplementRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractVO> querySupplementRecord(Long id) {
        ContractVO vo = service.querySupplementRecord(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * 查询合同解除单据成功
     * @param id
     * @return
     */
    @RequestMapping(value = "/addRelieveFlag", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> addRelieveFlag(Long id) {
        return CommonResponse.success("查询合同解除单据成功！",service.addRelieveFlag(id));
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        // 物资采购合同合同类型
        param.getParams().put("contract_type",new Parameter(QueryParam.EQ,0));
        Map<String, Object> beans = this.commonExcelExport(param, response);
        ExcelExport.getInstance().export("proMaterialContract-export.xlsx", beans, response);
    }

    @ApiOperation("混凝土合同导出")
    @RequestMapping(value = "/concreteExcelExport", method = RequestMethod.POST)
    @ResponseBody
    public void concreteExcelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        // 物资采购合同合同类型
        param.getParams().put("contract_type",new Parameter(QueryParam.EQ,1));
        Map<String, Object> beans = this.commonExcelExport(param, response);
        ExcelExport.getInstance().export("proConcreteContract-export.xlsx", beans, response);
    }

    /**
     * 组织导出列表
     * @param param 查询条件
     * @param response 请求信息
     * @return 导出列表
     */
    private Map<String, Object> commonExcelExport(QueryParam param, HttpServletResponse response){
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("parent_org_id");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenant_id", new Parameter("eq", InvocationInfoProxy.getTenantid()));
        param.getComplexParams().add(getPageQueryParam(null, false));
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();

        //设置排序：为了保证主合同与补充协议排列在一起，先用主合同创建时间排序
        if(null != param.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", param.getOrderMap().get("createTime"));
        }else {
            orderMap.put("main_contract_create_date", QueryParam.DESC);
        }
        orderMap.put("supplement_flag", QueryParam.ASC);
        orderMap.put("create_time", QueryParam.DESC);
        param.setOrderMap(orderMap);
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<ContractEntity> list = service.queryList(param);
        List<ContractVO> voList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)){
            voList = BeanMapper.mapList(list,ContractVO.class);
            voList.forEach(c -> {
                //设置合同履约状态：1、未签订；2、履约中；3、已封账；4、已解除；
                // 默认为未签定，签章状态为已签章时，状态自动更改为【履约中】。
                // 当合同存在生效的最终结算时，状态自动改为【已封账】
                if(org.apache.commons.lang.StringUtils.isBlank(c.getPerformanceStatus())) {
                    c.setPerformanceStatus(PerformanceStatusEnum.未签订.getDescription());
                } else {
                    c.setPerformanceStatus(PerformanceStatusEnum.getEnumByCode(c.getPerformanceStatus()).getDescription());
                }

                //设置签章状态：1、未签章；2、待乙方签章；3、待甲方签章；4、已签章；  单据新增后默认为未签章
                if(org.apache.commons.lang.StringUtils.isBlank(c.getSignatureStatus())) {
                    c.setSignatureStatus(SignatureStatusEnum.未签章.getDescription());
                } else {
                    c.setSignatureStatus(SignatureStatusEnum.getEnumByCode(c.getSignatureStatus()).getDescription());
                }

                //流程状态
                c.setBillStateName(BillStateEnum.getEnumByStateCode(c.getBillState()).getDescription());
            });
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        return beans;
    }

    @ApiOperation("参照")
    @RequestMapping(value = "/refContractData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ContractVO>> refContractData(@RequestParam Integer pageNumber,
                                                             @RequestParam Integer pageSize,
                                                             String condition,
                                                             String searchObject,
                                                             String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);

        // 物资采购合同合同类型
        param.getParams().put("contract_type", new Parameter(QueryParam.EQ, 0));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("contractType") && _con.getString("contractType").equals("all")) {
                param.getParams().remove("contract_type");
            }
            if (_con.containsKey("projectId")) {
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, _con.getString("projectId")));
            }
        }

        IPage<ContractEntity> page = this.queryContractListByRef(param, condition);
        IPage<ContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<ContractVO> records = BeanMapper.mapList(page.getRecords(), ContractVO.class);
        if(CollectionUtils.isNotEmpty(records)){
            List<Long> ids = records.stream().map(x->x.getId()).collect(Collectors.toList());
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("contractId", new Parameter(QueryParam.IN, ids));
            List<ContractDetailEntity> detailList = contractDetailService.queryList(queryParam);
            Map<Long, BigDecimal> numMap = detailList.stream().collect(Collectors.groupingBy(x->x.getContractId(),
                    Collectors.reducing(BigDecimal.ZERO, x->x.getNum(), ComputeUtil::safeAdd)));
            records.forEach(vo->{
                if(numMap.containsKey(vo.getId())){
                    vo.setContractNum(numMap.get(vo.getId()));
                }
            });
        }
        pageData.setRecords(records);
        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    @ApiOperation("混凝土参照")
    @RequestMapping(value = "/refContractConcreteData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ContractVO>> refContractConcreteData(@RequestParam Integer pageNumber,
                                                                     @RequestParam Integer pageSize,
                                                                     String condition,
                                                                     String searchObject,
                                                                     String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);

        // 混凝土采购合同合同类型
        param.getParams().put("contract_type", new Parameter(QueryParam.EQ, 1));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("projectId")) {
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, _con.getString("projectId")));
            }
        }


        IPage<ContractEntity> page = this.queryContractListByRef(param, condition);
        IPage<ContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<ContractVO> records = BeanMapper.mapList(page.getRecords(), ContractVO.class);
        if(CollectionUtils.isNotEmpty(records)){
            List<Long> ids = records.stream().map(x->x.getId()).collect(Collectors.toList());
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("contractId", new Parameter(QueryParam.IN, ids));
            List<ContractDetailEntity> detailList = contractDetailService.queryList(queryParam);
            Map<Long, BigDecimal> numMap = detailList.stream().collect(Collectors.groupingBy(x->x.getContractId(),
                    Collectors.reducing(BigDecimal.ZERO, x->x.getNum(), ComputeUtil::safeAdd)));
            records.forEach(vo->{
                if(numMap.containsKey(vo.getId())){
                    vo.setContractNum(numMap.get(vo.getId()));
                }
            });
        }
        pageData.setRecords(records);
        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * 查询参照
     *
     * @param param     查询参数
     * @param condition condition
     * @return 查询结果
     */
    private IPage<ContractEntity> queryContractListByRef(QueryParam param, String condition) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("parent_org_id");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenant_id", new Parameter("eq", InvocationInfoProxy.getTenantid()));
        param.getParams().put("signature_status", new Parameter("eq", SignatureStatusEnum.已签章.getCode()));
        param.getParams().put("performanceStatus", new Parameter(QueryParam.EQ, PerformanceStatusEnum.履约中.getCode()));
        // 获取合同归档控制参数
        String valueData = service.getContractFilingCode();

        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("orgId")) {
                param.getComplexParams().add(getPageQueryParam(Long.valueOf(String.valueOf(_con.get("orgId"))), true));
            }
            else {
                param.getComplexParams().add(getPageQueryParam(null, true));
            }
            // 控制参数0：不控制
            // 控制参数1：部分控制，需要传入参数filingType并且值=1，查询已归档合同
            if ("1".equals(valueData)) {
                // 如果传入查询条件中有filingType参数，并且参数值=1，则查询已归档的合同参照
                if (_con.containsKey("filingType") && "1".equals(_con.getString("filingType"))) {
                    param.getParams()
                            .put("filingStatus", new Parameter(QueryParam.EQ, FilingStatusEnum.已归档.getTypeCode()));
                }
            }
            // 控制参数2：合同未归档限制全部业务，只查询已归档合同
            else if ("2".equals(valueData)) {
                param.getParams().put("filingStatus", new Parameter(QueryParam.EQ, FilingStatusEnum.已归档.getTypeCode()));
            }
        }
        else {
            param.getComplexParams().add(getPageQueryParam(null, true));
            if ("2".equals(valueData)) {
                param.getParams().put("filingStatus", new Parameter(QueryParam.EQ, FilingStatusEnum.已归档.getTypeCode()));
            }
        }

        //设置排序：为了保证主合同与补充协议排列在一起，先用主合同创建时间排序
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        if (null != param.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", param.getOrderMap().get("createTime"));
        }
        else {
            orderMap.put("main_contract_create_date", QueryParam.DESC);
        }
        orderMap.put("supplement_flag", QueryParam.ASC);
        orderMap.put("create_time", QueryParam.DESC);

        param.setOrderMap(orderMap);
        return service.queryPage(param, false);
    }

    /**
     * 获取合同查询复杂参数
     *
     * @param orgId 组织id
     * @param isRef 是否查询参照（true：查询参照，审批通过数据，false：包括自由态数据）
     * @return 复杂参数集合
     */
    public ComplexParam getPageQueryParam(Long orgId, boolean isRef) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);
        List<OrgVO> orgVOList = null;
        if (null == orgId) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        CommonResponse<OrgVO> orgResp = iOrgApi.getOneById(orgId);
        CommonResponse<List<OrgVO>> childOrgResp = iOrgApi.findChildrenByParentId(orgId);
        CommonResponse<List<OrgVO>> parentOrgResp = iOrgApi.findParentsByOrgId(orgId);
        if (!orgResp.isSuccess() || !childOrgResp.isSuccess() || !parentOrgResp.isSuccess()) {
            throw new BusinessException("合同分页列表查询失败, 查询组织信息失败！");
        }
        List<Long> parentOrgIds = new ArrayList<>();
        List<Long> childIds = new ArrayList<>();
        childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        parentOrgIds.addAll(parentOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));

        parentOrgIds.remove(orgId);
        OrgVO orgVO = orgResp.getData();
        if (5 == orgVO.getOrgType()) {
            //说明是项目部   取自己本身和集采本上
            // 本下
            ComplexParam c2 = new ComplexParam();
            c2.setLogic(ComplexParam.OR);
            c2.getParams().put("org_id", new Parameter(QueryParam.EQ, orgId));
            if (isRef) {
                c2.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
            }
            c1.getComplexParams().add(c2);

            // 本上集采+已生效
            if (CollectionUtils.isNotEmpty(parentOrgIds)) {
                ComplexParam c3 = new ComplexParam();
                c3.setLogic(ComplexParam.OR);
                c3.getParams().put("purchase_type", new Parameter(QueryParam.EQ, PurchaseTypeEnum.公司集采.getCode()));
                c3.getParams().put("org_id", new Parameter(QueryParam.IN, parentOrgIds));
                c3.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
                c1.getComplexParams().add(c3);

            }

        }
        else {
            //说明不是项目部，  取本下  和  集采本上
            // 本下
            ComplexParam c2 = new ComplexParam();
            c2.setLogic(ComplexParam.OR);
//            c2.getParams().put("parent_org_id", new Parameter(QueryParam.IN, childIds));
            c2.getParams().put("org_id", new Parameter(QueryParam.IN, childIds));
            // 参照查询审批通过的
            if (isRef) {
                c2.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
            }
            c1.getComplexParams().add(c2);

            // 本上集采+已生效
            if (CollectionUtils.isNotEmpty(parentOrgIds)) {
                ComplexParam c3 = new ComplexParam();
                c3.setLogic(ComplexParam.OR);
                c3.getParams().put("purchase_type", new Parameter(QueryParam.EQ, PurchaseTypeEnum.公司集采.getCode()));
                c3.getParams().put("org_id", new Parameter(QueryParam.IN, parentOrgIds));
                c3.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
                c1.getComplexParams().add(c3);

            }
        }
        return c1;
    }
    @RequestMapping(value = "/targetCostCtrl", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> targetCostCtrl(@RequestBody ContractVO contractVO,HttpServletRequest req) {
        String authority = req.getHeader("authority");
        return CommonResponse.success("参数校验成功！", service.targetCostCtrl(contractVO,authority));
    }

    @GetMapping(value = "/viewTargetCostCtrlInfo")
    @ResponseBody
    public CommonResponse<ParamsCheckVO> viewTargetCostCtrlInfo(@RequestParam(value = "id") Long id) {
        return CommonResponse.success("参数校验成功！", service.viewTargetCostCtrlInfo(id));
    }

    @ApiOperation("同步合同池数据")
    @RequestMapping(value = "/pushContract", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractVO> pushContract(@RequestParam Long id) {
        return CommonResponse.success("推送合同池成功！",service.syncPushContract(id));
    }

    /**
     * 目标成本推送
     * @param id
     * @return
     */
    @RequestMapping(value = "/pushTargetCost", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> pushTargetCost(Long id) {
        return service.pushTargetCost(id);
    }

    /**
     * @Description saveOrUpdate 查询当前合同下付款申请单列表
     * @param id
     */
    @RequestMapping(value = "/queryPaymentApplyList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractPaymentResultVO> query(Long id) {
        ContractPaymentResultVO vo = service.queryPaymentApplyList(id);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

/*
* 项目材料执行情况查询列表查询
* */
    @RequestMapping(value = "/quueryMaterialByProject", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> quueryMaterialByProject(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        Long projectId = null;
        if(param.getParams().containsKey("projectId")){
            projectId = Long.valueOf( param.getParams().get("projectId").getValue().toString());
        }
        Page<MaterialReportVO> page = new Page<>((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<MaterialReportVO> list = service.quueryMaterialByProject(page,wrapper,projectId);
        JSONObject res = new JSONObject();
        res.put("records", list);
        res.put("total", page.getTotal());
        res.put("current", page.getCurrent());
        res.put("size", page.getSize());
        res.put("pages", page.getPages());
        return CommonResponse.success("查询列表数据成功！",res);
    }

    @ApiOperation("项目材料执行情况导出")
    @RequestMapping(value = "/projectMaterialExcelExport", method = RequestMethod.POST)
    @ResponseBody
    public void projectMaterialExcelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        param.setPageIndex(1);
        param.setPageSize(-1);
        Long projectId = null;
        if(param.getParams().containsKey("projectId")){
            projectId = Long.valueOf( param.getParams().get("projectId").getValue().toString());
        }
        Page<MaterialReportVO> page = new Page<>((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<MaterialReportVO> list = service.quueryMaterialByProject(page,wrapper,projectId);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ProjectMaterial-export.xlsx", beans, response);
    }




    @ApiOperation("合同材料执行情况列表查询")
    @RequestMapping(value = "/quueryMaterialByOrg", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> quueryMaterialByOrg(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("spec");
        Long orgId = null;

        if(param.getParams().containsKey("treeOrgId")){
            orgId = Long.valueOf( param.getParams().get("treeOrgId").getValue().toString());
            Integer orgType = Integer.valueOf( param.getParams().get("orgType").getValue().toString());
            if (OrgVO.ORG_TYPE_DEPARTMENT.equals(orgType)){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
            }else{
                param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(
                        orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }

        if (!param.getParams().containsKey("treeOrgId")){
            if(OrgVO.ORG_TYPE_DEPARTMENT.equals(InvocationInfoProxy.getOrgType())){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }
        param.getParams().remove("orgType");
        param.getParams().remove("treeOrgId");

        Page<ContractMaterialReportVO> page = new Page<>((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<ContractMaterialReportVO> contractMaterialReportVOList = service.quueryMaterialByOrg(page,wrapper);
        JSONObject res = new JSONObject();
        res.put("records", contractMaterialReportVOList);
        res.put("total", page.getTotal());
        res.put("current", page.getCurrent());
        res.put("size", page.getSize());
        res.put("pages", page.getPages());
        return CommonResponse.success("查询列表数据成功！",res);
    }

    @ApiOperation("合同材料执行情况导出")
    @RequestMapping(value = "/contractExcelExport", method = RequestMethod.POST)
    @ResponseBody
    public void contractExcelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("spec");
        Long orgId = null;
        param.setPageIndex(1);
        param.setPageSize(-1);
        if(param.getParams().containsKey("treeOrgId")){
            orgId = Long.valueOf( param.getParams().get("treeOrgId").getValue().toString());
            Integer orgType = Integer.valueOf( param.getParams().get("orgType").getValue().toString());
            if (OrgVO.ORG_TYPE_DEPARTMENT.equals(orgType)){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
            }else{
                param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(
                        orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }

        if (!param.getParams().containsKey("treeOrgId")){
            if(OrgVO.ORG_TYPE_DEPARTMENT.equals(InvocationInfoProxy.getOrgType())){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }
        param.getParams().remove("orgType");
        param.getParams().remove("treeOrgId");

        Page<ContractMaterialReportVO> page = new Page<>((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<ContractMaterialReportVO> contractMaterialReportVOList = service.quueryMaterialByOrg(page,wrapper);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", contractMaterialReportVOList);
        ExcelExport.getInstance().export("ContractExcelExport-export.xlsx", beans, response);
    }


    /**
     * 手动添加水印
     * @param id 变更合同id
     * @return 添加结果
     */
    @RequestMapping(value = "/asyncWatermarkById", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> asyncWatermarkById(@RequestParam(value = "id") Long id) {
        service.asyncWatermarkById(id);
        return CommonResponse.success("水印添加成功！");
    }

    /**
     * 校验合同能否新增变更、补充协议
     *
     * @param id 合同id
     * @return 校验结果
     */
    @RequestMapping(value = "/checkContractFiling", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> checkContractFiling(Long id) {
        boolean filingFlag = service.checkContractFiling(id);
        if (filingFlag) {
            return CommonResponse.success("校验通过！");
        }
        return CommonResponse.error("当前合同无法新增");
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "Contract-import.xlsx", "采购明细导入模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        return service.excelImport(request,response);
    }
}
