package com.ejianc.business.promaterial.sync.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.promaterial.contract.bean.ContractDetailEntity;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.service.IContractDetailService;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.order.bean.OrderDetailEntity;
import com.ejianc.business.promaterial.order.bean.OrderEntity;
import com.ejianc.business.promaterial.order.service.IOrderDetailService;
import com.ejianc.business.promaterial.order.service.IOrderService;
import com.ejianc.business.promaterial.plan.bean.BatPlanDetailEntity;
import com.ejianc.business.promaterial.plan.bean.BatPlanEntity;
import com.ejianc.business.promaterial.plan.service.*;
import com.ejianc.business.promaterial.sync.consts.HTConstants;
import com.ejianc.business.promaterial.sync.vo.FileDto;
import com.ejianc.business.promaterial.utils.CommonUtils;
import com.ejianc.business.promaterial.utils.DateUtils;
import com.ejianc.business.promaterial.utils.JSONUtils;
import com.ejianc.business.promaterial.utils.OrgUtil;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.UploadFileForNetParam;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IShareCustomerApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.*;
import java.util.stream.Collectors;


/**
 * 中核华泰消息拉取监听类
 */
@Component("materialListener")
public class ZhHtCommonListener {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IContractService contractService;

    @Autowired
    private IContractDetailService contractDetailService;

    @Autowired
    private IBatPlanService batPlanService;

    @Autowired
    private IBatPlanDetailService batPlanDetailService;

    @Autowired
    private IOrderService orderService;

    @Autowired
    private IOrderDetailService orderDetailService;

    @Autowired
    private OrgUtil orgUtil;

    @Autowired
    private IShareCustomerApi customerApi;

    @Autowired
    private IShareSupplierApi supplierApi;

    @Autowired
    private IShareMaterialApi materialApi;

    @Autowired
    private IUserApi userApi;

    @Autowired
    private IAttachmentApi attachmentApi;

    /**
     * 监听合同同步
     * @param message
     * @throws IOException
     */
//    @JmsListener(destination="cnecht.zh.contractCallback.test")
    @JmsListener(destination="${zhht.contractCallback}")
    public void receive_cnecht_zh_contractCallback(String message){
//        String msg = this.transferMessage(message);
//        msg = msg.substring(12);   // outputValue={....} 去除字符串中的outputValue=
        logger.info("cnecht.zh.contractCallback message: " + message);
        JSONObject json = JSONObject.parseObject(message);
        JSONObject data = json.getJSONObject("data");
        JSONArray messageBody = data.getJSONArray("messageBody");
        // 初始化上下文，模拟登录
        orgUtil.initContext(HTConstants.SYSTEM_USER_ID);

        List<String> bpoIds = messageBody.stream().map(x->((JSONObject)x).getString("bpoId")).collect(Collectors.toList());
        // 查询对应合同及合同明细
        Map<String, ContractEntity> map = this.getContractMap(bpoIds);

        // 查询物料参照
        List<String> itemIds = messageBody.stream().map(x->((JSONObject)x).getJSONArray("contractDetailList")).
                flatMap(JSONArray::stream).map(x->(JSONObject)x).map(x->x.getString("itemId")).distinct().collect(Collectors.toList());
        Map<String, MaterialVO> materialMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(itemIds)){
            CommonResponse<List<MaterialVO>> materialResp = materialApi.queryMaterialListByCodes(itemIds);
            if(materialResp.isSuccess()){
                materialMap = materialResp.getData().stream().collect(Collectors.toMap(x->x.getCode(), x->x));
            } else {
                logger.error("materialResp ==== ", materialResp.getMsg());
            }
        }

        List<ContractEntity> saveList = new ArrayList<>();
        for(Object o : messageBody){
            JSONObject obj = (JSONObject)o;
            // 转换ContractEntity
            ContractEntity vo = this.transferContractVO(map, obj);
            Map<String, ContractDetailEntity> detailMap = vo.getContractDetailList().stream().collect(Collectors.toMap(x->x.getBpoLineId(), x->x));
            // 转换合同明细
            List<ContractDetailEntity> detailList = this.transferContractDetail(obj.getJSONArray("contractDetailList"), detailMap, materialMap);
            String sourceId = null;
            if(CollectionUtils.isNotEmpty(detailList)){
                vo.setContractDetailList(detailList);
                sourceId = detailList.get(0).getSourceId();
            }
            // 根据采购计划明细主键查询项目信息
            BatPlanEntity plan = this.setProjectInfo(vo, sourceId);
            if(null == plan){
                logger.error("sourceId-{}查询采购计划-{} ==== ", sourceId, plan);
            }
            // 合同附件
            if(obj.containsKey("otherDirList") && obj.getJSONArray("otherDirList").size() > 0){
                List<FileDto> otherDirList = JSONUtils.json2List(obj.getString("otherDirList"), FileDto.class);// 其它附件
                uploadFileFormNet(otherDirList, "BT211227000000003", vo.getId(), "proMaterialContractBill");
            }
            if(obj.containsKey("signedDirList") && obj.getJSONArray("signedDirList").size() > 0){
                List<FileDto> signedDirList = JSONUtils.json2List(obj.getString("signedDirList"), FileDto.class);// 合同签署附件
                uploadFileFormNet(signedDirList, "BT211227000000003", vo.getId(), "mContractFile");
            }
            saveList.add(vo);
        }
        if(CollectionUtils.isNotEmpty(saveList)){
            for(ContractEntity entity : saveList){
//                contractService.writeBackOccupyNum(entity);
                contractService.saveOrUpdate(entity, false);
            }
        }
        logger.info("监听采购合同同步执行成功-新增{}条！", saveList.size());
    }

    /**
     * 监听订单同步， 合同记录集采平台订单主键，有值则为已生成集采平台订单
     * @param message
     * @throws IOException
     */
    @JmsListener(destination="${zhht.orderCallback}")
    public void receive_cnecht_zh_orderCallback(String message){
//        String msg = this.transferMessage(message);
//        msg = msg.substring(12);   // outputValue={....} 去除字符串中的outputValue=
        logger.info("cnecht.zh.orderCallback message: " + message);
        JSONObject json = JSONObject.parseObject(message);
        JSONObject data = json.getJSONObject("data");
        JSONArray messageBody = data.getJSONArray("messageBody");
        // 初始化上下文，模拟登录
        orgUtil.initContext(HTConstants.SYSTEM_USER_ID);

        List<String> bpoIds = messageBody.stream().map(x->((JSONObject)x).getString("bpoId")).collect(Collectors.toList());
        Map<String, ContractEntity> contractMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(bpoIds)){
            QueryParam param = new QueryParam();
            param.getParams().put("bpoId", new Parameter(QueryParam.IN, bpoIds));
            List<ContractEntity> list = contractService.queryList(param);
            contractMap = list.stream().collect(Collectors.toMap(x->x.getBpoId(), x->x, (v1, v2)->v2));
        }

        List<ContractEntity> saveList = new ArrayList<>();
        for(Object o : messageBody){
            JSONObject obj = (JSONObject)o;
            if(contractMap.containsKey(obj.getString("bpoId"))){
                ContractEntity entity = contractMap.get(obj.getString("bpoId"));
                entity.setOrderId(obj.getString("orderId"));
                saveList.add(entity);
            }
        }
        if(CollectionUtils.isNotEmpty(saveList)){
            contractService.saveOrUpdateBatch(saveList, saveList.size());
        }
        logger.info("监听订单同步执行成功-修改{}条-{}！", saveList.size(), JSON.toJSONString(bpoIds));
    }

//    /**
//     * 监听订单同步
//     * @param message
//     * @throws IOException
//     */
////    @JmsListener(destination="${zhht.orderCallback}")
//    public void receive_cnecht_zh_orderCallback(String message){
////        String msg = this.transferMessage(message);
////        msg = msg.substring(12);   // outputValue={....} 去除字符串中的outputValue=
//        logger.info("cnecht.zh.orderCallback message: " + message);
//        JSONObject json = JSONObject.parseObject(message);
//        JSONObject data = json.getJSONObject("data");
//        JSONArray messageBody = data.getJSONArray("messageBody");
//        // 初始化上下文，模拟登录
//        orgUtil.initContext(HTConstants.SYSTEM_USER_ID);
//
//        List<String> orderIds = messageBody.stream().map(x->((JSONObject)x).getString("orderId")).collect(Collectors.toList());
//        // 查询对应订单及订单明细
//        Map<String, OrderEntity> map = this.getOrderMap(orderIds);
//
//        // 查询合同
//        List<String> bpoIds = messageBody.stream().map(x->((JSONObject)x).getString("bpoId")).collect(Collectors.toList());
//        Map<String, ContractEntity> contractMap = new HashMap<>();
//        if(CollectionUtils.isNotEmpty(bpoIds)){
//            QueryParam param = new QueryParam();
//            param.getParams().put("bpoId", new Parameter(QueryParam.IN, bpoIds));
//            List<ContractEntity> list = contractService.queryList(param);
//            contractMap = list.stream().collect(Collectors.toMap(x->x.getBpoId(), x->x, (v1, v2)->v2));
//        }
//
//        // 查询物料参照
//        List<String> itemIds = messageBody.stream().map(x->((JSONObject)x).getJSONArray("orderDetails")).
//                flatMap(JSONArray::stream).map(x->(JSONObject)x).map(x->x.getString("itemId")).distinct().collect(Collectors.toList());
//        Map<String, MaterialVO> materialMap = new HashMap<>();
//        if(CollectionUtils.isNotEmpty(itemIds)){
//            CommonResponse<List<MaterialVO>> materialResp = materialApi.queryMaterialListByCodes(itemIds);
//            if(materialResp.isSuccess()){
//                materialMap = materialResp.getData().stream().collect(Collectors.toMap(x->x.getCode(), x->x));
//            } else {
//                logger.error("materialResp ==== ", materialResp.getMsg());
//            }
//        }
//
//        List<OrderEntity> saveList = new ArrayList<>();
//        for(Object o : messageBody){
//            JSONObject obj = (JSONObject)o;
//            // 转换OrderEntity
//            OrderEntity vo = this.transferOrderVO(map, obj, contractMap);
//            Map<String, OrderDetailEntity> detailMap = vo.getOrderDetailList().stream().collect(Collectors.toMap(x->x.getOrderLineId(), x->x));
//            // 转换订单明细
//            List<OrderDetailEntity> detailList = this.transferOrderDetail(obj.getJSONArray("orderDetails"), detailMap, materialMap);
//            if(CollectionUtils.isNotEmpty(detailList)){
//                vo.setOrderDetailList(detailList);
//            }
//            saveList.add(vo);
//        }
//        if(CollectionUtils.isNotEmpty(saveList)){
//            for(OrderEntity entity : saveList){
////                orderService.writeBackOccupyNum(entity);
//                orderService.saveOrUpdate(entity, false);
//            }
//        }
//        logger.info("监听订单同步执行成功-新增{}条！", saveList.size());
//    }

    /**
     * 根据采购计划明细主键查询项目信息
     * @param vo
     * @param sourceId
     * @return
     */
    private BatPlanEntity setProjectInfo(ContractEntity vo, String sourceId) {
        if(StringUtils.isEmpty(sourceId)){
            return null;
        }
        BatPlanDetailEntity planDetail = batPlanDetailService.selectById(sourceId);
        if(null == planDetail){
            return null;
        }
        BatPlanEntity plan = batPlanService.selectById(planDetail.getPlanId());
        if(null == plan){
            return null;
        }
        vo.setProjectId(plan.getProjectId());
        vo.setProjectName(plan.getProjectName());
        vo.setOrgId(plan.getOrgId());
        vo.setOrgCode(plan.getOrgCode());
        vo.setOrgName(plan.getOrgName());
        vo.setParentOrgId(plan.getParentOrgId());
        vo.setParentOrgCode(plan.getParentOrgCode());
        vo.setParentOrgName(plan.getParentOrgName());
        return plan;
    }

    /**
     * 转换ContractEntity
     * @param map
     * @param obj
     * @return
     */
    private ContractEntity transferContractVO(Map<String, ContractEntity> map, JSONObject obj) {
        String code = obj.getString("bpoId");
        ContractEntity vo = new ContractEntity();
        vo.setId(IdWorker.getId());
        vo.setContractType(0);
        vo.setSignatureStatus("1");
        vo.setFilingStatus(0);
        vo.setPurchaseType("1");
        vo.setPurchaseTypeName("自采");
        vo.setFilingRef(0);
        vo.setChangeVersion(0);
        vo.setChangeStatus(1);
        vo.setContractCategoryId(1871172853848608769L);
        vo.setContractCategoryName("通用物资");
        vo.setContractPropertyCode("proMaterial-1");
        vo.setContractPropertyName("大宗材");
        vo.setEffectiveDate(new Date());
        vo.setMainContractCreateDate(new Date());

        vo.setBillState(BillStateEnum.PASSED_STATE.getBillStateCode());// 默认已审批通过
        if(map.containsKey(code)){
            vo = map.get(code);
        }
        vo.setBillCode(code);// 编码
        vo.setBpoId(obj.getString("bpoId"));// 集采系统-合同编号
        vo.setContractName(obj.getString("bpoName"));// 名称
        vo.setSignDate(DateUtils.createDate(obj.getString("bpoSignedDate"), "YYYYMMDD"));// 签订日期
        vo.setSignPlace(obj.getString("bpoSignedAddress"));// 签约地址
        vo.setProjectPlace(obj.getString("deliveryLocation"));// 项目地点

        // 甲方
        vo.setCustomerName(obj.getString("signOrgName"));// 甲方名称
        CommonResponse<SupplierVO> customerResp = supplierApi.findOneByName(vo.getCustomerName(), InvocationInfoProxy.getTenantid());
        if(customerResp.isSuccess() && null != customerResp.getData()){
            vo.setCustomerId(customerResp.getData().getId());
        } else {
            logger.error("customerResp ==== ", customerResp.getMsg());
        }
        // 甲方经办人
        vo.setCustomerEmployeeName(obj.getString("bpoEditPerson"));
        vo.setCustomerEmployeeMobile(obj.getString("bpoEditPersonTel"));
        CommonResponse<UserVO> userResp = userApi.findByUserMobile(vo.getCustomerEmployeeMobile());
        if(userResp.isSuccess() && null != userResp.getData()){
            vo.setCustomerEmployeeId(userResp.getData().getId());
        } else {
            logger.error("userResp ==== ", userResp.getMsg());
        }
        // 乙方
        vo.setSupplierName(obj.getString("supplierName"));
        CommonResponse<SupplierVO> supplierResp = supplierApi.findOneByName(vo.getSupplierName(), InvocationInfoProxy.getTenantid());
        if(supplierResp.isSuccess() && null != supplierResp.getData()){
            vo.setSupplierId(supplierResp.getData().getId());
        } else {
            logger.error("supplierResp ==== ", supplierResp.getMsg());
        }
        // 金额
        vo.setContractTaxMny(obj.getBigDecimal("bpoTaxAmt"));
        vo.setContractMny(obj.getBigDecimal("bpoNotaxAmt"));
        vo.setContractTax(ComputeUtil.safeSub(vo.getContractTaxMny(), vo.getContractMny()));
        vo.setTaxRate(CommonUtils.getTaxRate(vo.getContractTaxMny(), vo.getContractMny()));
        vo.setBaseMoneyWithTax(vo.getContractTaxMny());
        vo.setBaseMoney(vo.getContractMny());
        vo.setBeforeChangeMnyWithTax(vo.getContractTaxMny());
        vo.setBeforeChangeMny(vo.getContractMny());
        vo.setDetailTaxMny(vo.getContractTaxMny());
        vo.setDetailMny(vo.getContractMny());
        vo.setDetailTax(vo.getContractTax());
        // 状态值
        vo.setPerformanceStatus(tranferStatus(obj.getString("apprState")));// 合同履约状态
        vo.setDraftType("2-2".equals(obj.getString("signFunc")) ? "2" : "3");// 起草方式：1、在线起草，2、上传合同，3、线下签订
        vo.setPricingType("10".equals(obj.getString("bpoType")) ? "3" : "11".equals(obj.getString("bpoType")) ? "1" : "2");// pricingType; // 计价方式：1-固定单价、2-浮动单价、3-固定总价
        vo.setSupplementFlag("2".equals(obj.getString("bpoRelation")) ? 1 : 0);
        return vo;
    }

    /**
     * 转换合同明细
     * @param detailArray
     * @param detailMap
     * @param materialMap
     * @return
     */
    private List<ContractDetailEntity> transferContractDetail(JSONArray detailArray, Map<String, ContractDetailEntity> detailMap, Map<String, MaterialVO> materialMap){
        List<String> bpoLineIds = detailArray.stream().map(x->(JSONObject)x).map(x->x.getString("bpoLineId")).collect(Collectors.toList());
        List<ContractDetailEntity> detailList = new ArrayList<>();
        for(Object dd : detailArray){
            JSONObject dObj = (JSONObject)dd;
            ContractDetailEntity detail = new ContractDetailEntity();
            String bpoLineId = dObj.getString("bpoLineId");
            detail.setSourceType("5");
            detail.setChangeType("0");
            if(detailMap.containsKey(bpoLineId)){
                detail = detailMap.get(bpoLineId);
            }
            detail.setBpoLineId(bpoLineId);
            detail.setSourceId(CommonUtils.split(dObj.getString("outPlanLineNo"), "_", 1));// 采购计划明细
            detail.setNum(dObj.getBigDecimal("bpoQty"));// 合同数量
            // 金额/单价
            detail.setPrice(dObj.getBigDecimal("bpoNotaxPrice"));// 单价
            detail.setDetailTaxPrice(dObj.getBigDecimal("bpoPrice"));// 含税单价
            detail.setDetailTaxRate(dObj.getBigDecimal("taxRate"));// 税率
            detail.setMoney(dObj.getBigDecimal("bpoNotaxAmt"));// 金额
            detail.setDetailTaxMny(dObj.getBigDecimal("bpoAmt"));// 含税金额
            detail.setDetailTax(dObj.getBigDecimal("bpoTaxAmt"));// 税额
            // 物料
            detail.setMaterialName(dObj.getString("itemName"));
            detail.setMaterialCode(dObj.getString("itemId"));
            detail.setUnitName(dObj.getString("itemUom"));
            if(materialMap.containsKey(detail.getMaterialCode())){
                MaterialVO material = materialMap.get(detail.getMaterialCode());
                detail.setMaterialId(material.getId());
                detail.setMaterialTypeId(material.getCategoryId());
                detail.setMaterialTypeName(material.getCategoryName());
                detail.setSpec(material.getSpec());
                detail.setUnitId(material.getUnitId());
                detail.setUnitName(material.getUnitName());
                detail.setTexture(material.getDef1());
            }
            detailList.add(detail);
        }
        for(ContractDetailEntity detail : detailMap.values()){
            if(StringUtils.isNotEmpty(detail.getBpoLineId()) && !bpoLineIds.contains(detail.getBpoLineId())){
                detail.setRowState("del");
                detailList.add(detail);
            }
        }
        return detailList;
    }

//    /**
//     * 转换OrderEntity
//     * @param map
//     * @param obj
//     * @return
//     */
//    private OrderEntity transferOrderVO(Map<String, OrderEntity> map, JSONObject obj, Map<String, ContractEntity> contractMap) {
//        String code = obj.getString("orderId");
//        OrderEntity vo = new OrderEntity();
//        vo.setId(IdWorker.getId());
//        vo.setContractType(0);
//        vo.setOrderFlag(0);
//        vo.setBillState(BillStateEnum.PASSED_STATE.getBillStateCode());// 默认已审批通过
//        if(map.containsKey(code)){
//            vo = map.get(code);
//        }
//        vo.setBillCode(code);// 编码
//        vo.setOrderId(obj.getString("orderId"));// 集采系统-订单号
//        vo.setContractName(obj.getString("bpoName"));// 合同名称
//        // 带出合同信息
//        if(contractMap.containsKey(obj.getString("bpoId"))){
//            ContractEntity contract = contractMap.get(obj.getString("bpoId"));
//            vo.setContractId(contract.getId());
//            vo.setContractCode(contract.getBillCode());
//            vo.setProjectId(contract.getProjectId());
//            vo.setProjectName(contract.getProjectName());
//            vo.setOrgId(contract.getOrgId());
//            vo.setOrgCode(contract.getOrgCode());
//            vo.setOrgName(contract.getOrgName());
//            vo.setParentOrgId(contract.getParentOrgId());
//            vo.setParentOrgCode(contract.getParentOrgCode());
//            vo.setParentOrgName(contract.getParentOrgName());
//            vo.setSupplierId(contract.getSupplierId());
//            vo.setSupplierName(contract.getSupplierName());
//        }
//        vo.setSupplierName(obj.getString("supplierName"));
//        CommonResponse<SupplierVO> supplierResp = supplierApi.findOneByName(vo.getSupplierName(), InvocationInfoProxy.getTenantid());
//        if(supplierResp.isSuccess() && null != supplierResp.getData()){
//            vo.setSupplierId(supplierResp.getData().getId());
//        } else {
//            logger.error("supplierResp ==== ", supplierResp.getMsg());
//        }
//
//        List<String> exeBuyerId = obj.getJSONArray("orderDetails").stream().map(x->(JSONObject)x).map(x->x.getString("exeBuyerId")).collect(Collectors.toList());
//        String userCode = obj.getString("createUser");
//        if(CollectionUtils.isNotEmpty(exeBuyerId)){
//            userCode = exeBuyerId.get(0);
//        }
//        vo.setEmployeeName(obj.getString("createUserName"));
//        CommonResponse<UserVO> userResp = userApi.queryUserByUserCode(userCode);
//        if(userResp.isSuccess() && null != userResp.getData()){
//            vo.setEmployeeId(userResp.getData().getId());
//            vo.setEmployeeName(userResp.getData().getUserName());
//        } else {
//            logger.error("userResp ==== ", userResp.getMsg());
//        }
//        return vo;
//    }
//
//    /**
//     * 转换订单明细
//     * @param detailArray
//     * @param detailMap
//     * @param materialMap
//     * @return
//     */
//    private List<OrderDetailEntity> transferOrderDetail(JSONArray detailArray, Map<String, OrderDetailEntity> detailMap,
//            Map<String, MaterialVO> materialMap){
//        List<String> orderLineIds = detailArray.stream().map(x->(JSONObject)x).map(x->x.getString("orderLineId")).collect(Collectors.toList());
//        List<OrderDetailEntity> detailList = new ArrayList<>();
//        for(Object dd : detailArray){
//            JSONObject dObj = (JSONObject)dd;
//            OrderDetailEntity detail = new OrderDetailEntity();
//            String orderLineId = dObj.getString("orderLineId");
//            if(detailMap.containsKey(orderLineId)){
//                detail = detailMap.get(orderLineId);
//            }
//            detail.setOrderLineId(orderLineId);
//            // TODO 需要根据合同明细ID查询对应的单项采购计划
////            detail.setSourceId(CommonUtils.split(dObj.getString("outPlanLineNo"), "_", 1));// 采购计划明细
//            detail.setOrderNumsSum(dObj.getBigDecimal("orderQty"));// 订单数量
//            detail.setSurplusNumsSum(detail.getOrderNumsSum());// 剩余数量
//            detail.setReceiveNumsSum(dObj.getBigDecimal("receiveQty"));// 收货数量
//            detail.setDeliverNumsSum(dObj.getBigDecimal("shippedQty"));// 发货量
//            // 金额/单价
//            detail.setPrice(dObj.getBigDecimal("orderPrice"));// 单价
//            detail.setTaxPrice(dObj.getBigDecimal("orderTaxPrice"));// 含税单价
//            detail.setTaxRate(CommonUtils.getTaxRate(detail.getTaxPrice(), detail.getPrice()));// 税率
//            detail.setMny(dObj.getBigDecimal("orderTotalPrice"));// 金额
//            detail.setTaxMny(dObj.getBigDecimal("orderTaxTotalPrice"));// 含税金额
//            // 物料
//            detail.setMaterialName(dObj.getString("itemName"));
//            detail.setMaterialCode(dObj.getString("itemId"));
//            detail.setUnit(dObj.getString("itemUom"));
//            if(materialMap.containsKey(detail.getMaterialCode())){
//                MaterialVO material = materialMap.get(detail.getMaterialCode());
//                detail.setMaterialId(material.getId());
//                detail.setMaterialTypeId(material.getCategoryId());
//                detail.setMaterialTypeName(material.getCategoryName());
//                detail.setSpec(material.getSpec());
//                detail.setUnitId(material.getUnitId());
//                detail.setUnit(material.getUnitName());
//                detail.setTexture(material.getDef1());
//                detail.setFinancialId(material.getFinancialId());
//                detail.setFinancialName(material.getFinancialName());
//            }
//            detailList.add(detail);
//        }
//        for(OrderDetailEntity detail : detailMap.values()){
//            if(StringUtils.isNotEmpty(detail.getOrderLineId()) && !orderLineIds.contains(detail.getOrderLineId())){
//                detail.setRowState("del");
//                detailList.add(detail);
//            }
//        }
//        return detailList;
//    }

    /**
     * 上传附件-先删后增
     * @param fileList
     * @param billType
     * @param sourceId
     * @param sourceType
     */
    private void uploadFileFormNet(List<FileDto> fileList, String billType, Long sourceId, String sourceType) {
        UploadFileForNetParam param = new UploadFileForNetParam();
        param.setTenantId(InvocationInfoProxy.getTenantid());
        param.setBillType(billType);
        param.setSourceId(sourceId);
        param.setSourceType(sourceType);
        List<String> filePathList = new ArrayList<>();
        for (FileDto dto : fileList) {
            filePathList.add(dto.getDownloadUrl());
        }
        attachmentApi.deleteFileByParam(sourceId, billType, sourceType);
        CommonResponse<String> resp = attachmentApi.uploadFileFormNet(param);
        if (!resp.isSuccess()) {
            logger.error("参数-{},附件上传异常-{}", JSONObject.toJSONString(param), resp.getMsg());
        }
    }

    /**
     * 合同履约状态：1、未签订；2、履约中；3、已封账；4、已解除；   默认为未签定，签章状态为已签章时，状态自动更改为【履约中】。当合同存在生效的最终结算时，状态自动改为【已封账】
     * @param apprState
     * @return
     */
    private static String tranferStatus(String apprState){
        String status = null;
        switch (apprState) {
//            case "DRAFT":// 草稿
//                status = "1";
//                break;
//            case "SUPPAPPROVED":// 供应商已确认
//                status = "1";
//                break;
//            case "SUPPREFUSE":// 供应商拒绝
//                status = "1";
//                break;
//            case "WAITINGFORSUPP":// 待供应商确认
//                status = "1";
//                break;
//            case "INPROCESSING":// 审批中
//                status = "1";
//                break;
//            case "APPROVED":// 审批通过
//                status = "1";
//                break;
            case "REJECT":// 驳回
                status = "4";
                break;
//            case "ECONSENDING":// 发送电子合同
//                status = "1";
//                break;
//            case "ECONSENDED":// 电子合同发送成功
//                status = "1";
//                break;
            case "ECONSIGNED":// 已签约
                status = "2";
                break;
            case "ACTIVE":// 合同生效
                status = "2";
                break;
            case "REVISION":// 低版本修订
                status = "2";
                break;
            case "LOCK":// 合同冻结
                status = "5";
                break;
            case "STOP":// 合同终止
                status = "3";
                break;
            default:
                status = "1";
                break;
        }
        return status;
    }

    /**
     * 查询对应合同及合同明细
     * @param bpoIds
     * @return
     */
    private Map<String, ContractEntity> getContractMap(List<String> bpoIds) {
        if(CollectionUtils.isEmpty(bpoIds)){
            return new HashMap<>();
        }
        QueryParam param = new QueryParam();
        param.getParams().put("bpoId", new Parameter(QueryParam.IN, bpoIds));
        List<ContractEntity> list = contractService.queryList(param);
        if(CollectionUtils.isEmpty(list)){
            return new HashMap<>();
        }
        List<Long> ids = list.stream().map(x->x.getId()).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.IN, ids));
        List<ContractDetailEntity> detailList = contractDetailService.queryList(queryParam);
        Map<Long, List<ContractDetailEntity>> detailMap = detailList.stream().collect(Collectors.groupingBy(x->x.getContractId()));
        for(ContractEntity entity : list){
            if(detailMap.containsKey(entity.getId())){
                entity.setContractDetailList(detailMap.get(entity.getId()));
            }
        }
        Map<String, ContractEntity> map = list.stream().collect(Collectors.toMap(x->x.getBpoId(), x->x, (v1, v2)->v2));
        return map;
    }

    /**
     * 查询对应订单及订单明细
     * @param orderIds
     * @return
     */
    private Map<String, OrderEntity> getOrderMap(List<String> orderIds) {
        if(CollectionUtils.isEmpty(orderIds)){
            return new HashMap<>();
        }
        QueryParam param = new QueryParam();
        param.getParams().put("orderId", new Parameter(QueryParam.IN, orderIds));
        List<OrderEntity> list = orderService.queryList(param);
        if(CollectionUtils.isEmpty(list)){
            return new HashMap<>();
        }
        List<Long> ids = list.stream().map(x->x.getId()).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("orderId", new Parameter(QueryParam.IN, ids));
        List<OrderDetailEntity> detailList = orderDetailService.queryList(queryParam);
        Map<Long, List<OrderDetailEntity>> detailMap = detailList.stream().collect(Collectors.groupingBy(x->x.getOrderId()));
        for(OrderEntity entity : list){
            if(detailMap.containsKey(entity.getId())){
                entity.setOrderDetailList(detailMap.get(entity.getId()));
            }
        }
        Map<String, OrderEntity> map = list.stream().collect(Collectors.toMap(x->x.getOrderId(), x->x, (v1, v2)->v2));
        return map;
    }

//    /**
//     * message转换
//     * @param message
//     * @return
//     */
//    public static String transferMessage(String message) {
//        message = message.replaceAll("%(![0-9a-fA-F]{2})", "%25");
//        message = message.replaceAll("\\+", "%2B");
//        String msg= null;
//        try {
//            msg = URLDecoder.decode(message, "utf-8");
//        } catch (UnsupportedEncodingException e) {
//            throw new BusinessException(e.getMessage());
//        }
//        return msg;
//    }
}
