package com.ejianc.business.promaterial.utils;

import com.ejianc.framework.mq.common.MqMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QueueUtils {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private RabbitTemplate rabbitTemplate;

    public String sendMq(String queueName, String body) {
        logger.info("MQ队列标识：{}, msg-{}", queueName, body);
        MqMessage mqMessage = new MqMessage();
        mqMessage.setBody(body);
        rabbitTemplate.convertAndSend(queueName, mqMessage);
        return "消息发送MQ队列成功！";
    }

}