package com.ejianc.business.promaterial.contract.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.vo.ContractMaterialReportVO;
import com.ejianc.business.promaterial.contract.vo.ContractVO;
import com.ejianc.business.promaterial.contract.vo.MaterialMnyVO;
import com.ejianc.business.promaterial.contract.vo.MaterialReportVO;
import com.ejianc.business.prosub.vo.ContractPaymentResultVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.tender.common.vo.SignContractVo;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;
import java.util.Map;

/**
 * 主合同实体
 * 
 * @author generator
 * 
 */
public interface IContractService extends IBaseService<ContractEntity> {

    /**
     * 保存或修改信息
     *
     * @param contractVo
     * @return
     */
    CommonResponse<ContractVO> saveOrUpdate(ContractVO contractVo, String authority, Boolean isControl);

    /**
     * 根据主键ID查询详情
     *
     * @param id
     * @return
     */
    ContractVO queryDetail(Long id);

    /**
     * 汇总合同原始金额--现合同金额
     *
     * @param queryParam
     */
    Map<String, Object> countContractAmount(QueryParam queryParam);

    ContractVO querySupplementRecord(Long id);

    Boolean changeSignStatus(Long billId, int status, String refCode);

    ContractVO saveOrUpdateSupplement(ContractVO saveorUpdateVO, String authority, Boolean isControl);

    ContractVO addConvertByConId(Long contractId);

    Boolean addSupplementFlag(Long id);

    ExecutionVO targetCost(ContractVO contractVO, String linkUrl,Integer type, Integer contractType);

    /**
     * 推送合同池
     *
     * @param contractVO 需要推送的合同数据
     */
    Boolean pushContract(ContractVO contractVO);

    /**
     * 弃审后删除合同池中的合同
     *
     * @param contractVO 需要删除的合同数据
     */
    void pushDelContract(ContractVO contractVO);

    /**
     * 将合同重新推送合同池
     *
     * @param id 合同id
     * @return 推送结果
     */
    ContractVO syncPushContract(Long id);

    /**
     * 是否可以添加合同解除
     *
     * @param id
     * @return
     */
    boolean addRelieveFlag(Long id);

    /**
     * 校验合同是否能做其他业务
     * 合同只能存在一个未生效的下游业务
     *
     * @param id      合同id
     * @param otherId 其他单据id
     */
    boolean checkContract(Long id, Long otherId);

    ParamsCheckVO targetCostCtrl(ContractVO contractVO, String authority);

    ParamsCheckVO viewTargetCostCtrlInfo(Long id);

    /**
     * 推送目标成本
     *
     * @param id 合同id
     * @return 推送结果
     */
    CommonResponse<String> pushTargetCost(Long id);
/*合同金额 控 补充协议
*        @param 最新合同vo  或 协议vo

 * */
    List<ParamsCheckVO> checkParamsMnySup(ContractVO vo);
    /*参数控制 拼接
     *      * @param 最新合同vo  或 协议vo
               @param   成本参数结果
     * */
    ParamsCheckVO checkParams(ContractVO vo, ParamsCheckVO paramsCheckVO2);
    /*总计划 控 补充协议,主合同
     *        @param 最新合同vo  或 协议vo

     * */
    List<ParamsCheckVO> checkParamsMnyPlan(ContractVO vo);

    /*施工合同 控 补充协议,主合同
     *        @param 最新合同vo  或 协议vo

     * */
    List<ParamsCheckVO> checkParamsConstruction(ContractVO vo);
    /*历史价 控 明细价
     *        @param 最新合同vo  或 协议vo

     * */
    ParamsCheckVO priceCheckParams(ContractVO vo);
    /**
     * 删除文件中心水印文件
     *
     * @param watermarkFileId 水印合同附件id
     * @return boolean 是否删除标识
     */
    boolean delWatermarkContractFile(Long watermarkFileId);

    /**
     * 查询合同付款申请列表
     *
     * @param id 合同id
     * @return 查询结果
     */
    ContractPaymentResultVO queryPaymentApplyList(Long id);

    List<MaterialReportVO> quueryMaterialByProject(Page pages, QueryWrapper queryWrapper, Long projectId);

    List<ContractMaterialReportVO> quueryMaterialByOrg(Page page, QueryWrapper wrapper);

    /**
     * 占用/释放 定标结果
     *
     * @param vo   合同vo
     * @param type 0占用，1释放
     */
    void updateTargetResult(ContractVO vo, Integer type);

    /**
     * 根据定标结果id查询对应合同
     *
     * @param targetResultIdList 定标结果id
     * @return 查询结果
     */
    List<SignContractVo> queryContractByTargetResultId(List<String> targetResultIdList);

    /**
     * 根据变更合同id给水印文件赋值
     *
     * @param id 变更合同id
     */
    void asyncWatermarkById(Long id);

    /**
     * 获取合同归档控制参数  没有获取到参数默认不限制
     *
     * @return 合同归档控制参数(0：不限制，1：部分限制，2：全部限制)
     */
    String getContractFilingCode();

    /**
     * 根据合同归档控制参数，校验合同能否新增变更、补充协议
     *
     * @param contractId 合同id
     * @return true：可以新增，false：不能新增
     */
    boolean checkContractFiling(Long contractId);

    CommonResponse<List<MaterialMnyVO>> queryMaterialMnyByYear(String year, Long orgId);
}
