/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.settlement.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.different.bean.DifferentEntity;
import com.ejianc.business.promaterial.different.service.IDifferentService;
import com.ejianc.business.promaterial.different.vo.DifferentDetailVO;
import com.ejianc.business.promaterial.different.vo.DifferentVO;
import com.ejianc.business.promaterial.enums.BillPushStatusEnum;
import com.ejianc.business.promaterial.reconciliation.service.IReconciliationDetailService;
import com.ejianc.business.promaterial.settlement.bean.SettlementDetailEntity;
import com.ejianc.business.promaterial.settlement.bean.SettlementEntity;
import com.ejianc.business.promaterial.settlement.service.ISettlementService;
import com.ejianc.business.promaterial.settlement.vo.SettlementVO;
import com.ejianc.business.store.api.IAccountSettleApi;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreApiVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="settlement")
public class SettlementBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private ISettlementService service;
    @Autowired
    private IReconciliationDetailService reconciliationDetailService;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IDifferentService differentService;
    @Autowired
    private IAccountSettleApi accountSettleApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String DEL_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/settlement/delSettlement";
    @Autowired
    private IContractService contractService;
    private static final String MDBILL_TYPE = "BT220315000000004";
    private static final String CDBILL_TYPE = "BT220316000000004";
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IShareCooperateApi shareCooperateApi;
    @Autowired
    private IShareMaterialApi shareMaterialApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        SettlementEntity entity = (SettlementEntity)((Object)this.service.selectById(billId));
        if (entity.getContractId() != null) {
            ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
            if (PerformanceStatusEnum.\u5df2\u51bb\u7ed3.getCode().equals(contractEntity.getPerformanceStatus()) || PerformanceStatusEnum.\u5df2\u89e3\u9664.getCode().equals(contractEntity.getPerformanceStatus())) {
                throw new BusinessException("\u5408\u540c{" + contractEntity.getContractName() + "},\u72b6\u6001\u4e3a\uff1a" + PerformanceStatusEnum.getEnumByCode(contractEntity.getPerformanceStatus()).getDescription() + "\u4e0d\u53ef\u8fdb\u884c\u6b64\u64cd\u4f5c\uff01");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u5f03\u5ba1\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        SettlementEntity entity = (SettlementEntity)((Object)this.service.selectById(billId));
        if (entity.getContractId() != null) {
            ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
            if (PerformanceStatusEnum.\u5df2\u51bb\u7ed3.getCode().equals(contractEntity.getPerformanceStatus()) || PerformanceStatusEnum.\u5df2\u89e3\u9664.getCode().equals(contractEntity.getPerformanceStatus())) {
                throw new BusinessException("\u5408\u540c{" + contractEntity.getContractName() + "},\u5408\u540c\u72b6\u6001\u4e3a\uff1a" + PerformanceStatusEnum.getEnumByCode(contractEntity.getPerformanceStatus()).getDescription() + "\u4e0d\u53ef\u8fdb\u884c\u6b64\u64cd\u4f5c\uff01");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        SettlementEntity entity = (SettlementEntity)((Object)this.service.selectById(billId));
        if (entity.getContractId() != null) {
            ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
            if (PerformanceStatusEnum.\u5df2\u51bb\u7ed3.getCode().equals(contractEntity.getPerformanceStatus()) || PerformanceStatusEnum.\u5df2\u89e3\u9664.getCode().equals(contractEntity.getPerformanceStatus())) {
                throw new BusinessException("\u5408\u540c{" + contractEntity.getContractName() + "},\u5408\u540c\u72b6\u6001\u4e3a\uff1a" + PerformanceStatusEnum.getEnumByCode(contractEntity.getPerformanceStatus()).getDescription() + "\u4e0d\u53ef\u8fdb\u884c\u6b64\u64cd\u4f5c\uff01");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(state) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(state)) {
            this.logger.info("\u5ba1\u6279\u901a\u8fc7\u4e1a\u52a1\u5f00\u59cb\uff01");
            SettlementEntity entity = (SettlementEntity)((Object)this.service.selectById(billId));
            SettlementVO settlementVO = (SettlementVO)BeanMapper.map((Object)((Object)entity), SettlementVO.class);
            StoreApiVO storeApiVO = new StoreApiVO();
            ArrayList<FlowVO> flowVOS = new ArrayList<FlowVO>();
            storeApiVO.setSettleFlag(Integer.valueOf(1));
            storeApiVO.setSettleId(entity.getId());
            storeApiVO.setSettleDate(entity.getSettlementDate());
            storeApiVO.setSettleCode(entity.getBillCode());
            ArrayList<Long> ids = new ArrayList<Long>();
            this.logger.info("\u8be5\u7ed3\u7b97\u5355\u72b6\u6001---{}", (Object)entity.getSettlementType());
            Boolean flag = true;
            if (entity.getSettlementType() == 0 && "proMaterial-2".equals(entity.getContractPropertyCode())) {
                flag = false;
            }
            if (CollectionUtils.isNotEmpty(entity.getSettlementDetailList()) && flag.booleanValue()) {
                this.logger.info("\u5b50\u8868\u4fe1\u606f\u5904\u7406\u5f00\u59cb\uff01" + JSONObject.toJSONString(entity.getSettlementDetailList()));
                for (SettlementDetailEntity detail : entity.getSettlementDetailList()) {
                    BigDecimal taxPrice;
                    BigDecimal storeTaxPrice;
                    if (detail.getReconciliationDetailId() != null) {
                        ids.add(detail.getReconciliationDetailId());
                    }
                    if ((storeTaxPrice = detail.getStoreTaxPrice() == null ? BigDecimal.ZERO : detail.getStoreTaxPrice()).compareTo(taxPrice = detail.getTaxPrice() == null ? BigDecimal.ZERO : detail.getTaxPrice()) == 0) continue;
                    FlowVO flowVO = new FlowVO();
                    flowVO.setSettleDetailId(detail.getId());
                    flowVO.setSourceId(detail.getSourceId());
                    flowVO.setSourceDetailId(detail.getSourceDetailId());
                    flowVO.setSettlePrice(detail.getPrice());
                    flowVO.setSettleTaxPrice(detail.getTaxPrice());
                    flowVO.setSettleMny(detail.getMny());
                    flowVO.setSettleTaxMny(detail.getTaxMny());
                    flowVO.setSettleTax(detail.getTax());
                    flowVOS.add(flowVO);
                }
                if (CollectionUtils.isNotEmpty(flowVOS)) {
                    storeApiVO.setDetail(flowVOS);
                    this.logger.info("\u751f\u6210\u8c03\u5dee\u91d1\u989d\u548c\u6210\u672c\u91d1\u989d\u5f00\u59cb\uff01" + JSONObject.toJSONString((Object)storeApiVO));
                    CommonResponse response = this.accountSettleApi.settlePass(storeApiVO);
                    if (!response.isSuccess()) {
                        throw new BusinessException("\u63d0\u4ea4\u751f\u6210\u8c03\u5dee\u91d1\u989d\u548c\u6210\u672c\u91d1\u989d\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
                    }
                    StoreApiVO data = (StoreApiVO)response.getData();
                    this.logger.info("\u63d0\u4ea4\u751f\u6210\u8c03\u5dee\u91d1\u989d\u548c\u6210\u672c\u91d1\u989d\u6210\u529f\uff01" + JSONObject.toJSONString((Object)data));
                    DifferentVO differentVO = this.getDifferent(entity, data);
                    CommonResponse<DifferentVO> differentVOCommonResponse = this.differentService.saveOrUpdate(differentVO);
                    if (!differentVOCommonResponse.isSuccess()) {
                        throw new BusinessException("\u751f\u6210\u8c03\u5dee\u5355\u5931\u8d25\uff01");
                    }
                    this.logger.info("\u751f\u6210\u8c03\u5dee\u5355\u6210\u529f\uff01" + JSONObject.toJSONString((Object)differentVOCommonResponse.getData()));
                    this.logger.info("\u751f\u6210\u8c03\u5dee\u5355\u5b50\u8868\u6210\u529f\uff01" + JSONObject.toJSONString((Object)((DifferentVO)differentVOCommonResponse.getData()).getDifferentDetailList()));
                }
            }
            if (entity.getContractId() != null && entity.getSignatureType() == 1) {
                ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
                contractEntity.setPerformanceStatus(PerformanceStatusEnum.\u5df2\u5c01\u8d26.getCode());
                this.contractService.saveOrUpdate((Object)contractEntity);
                this.logger.info("\u4fee\u6539\u5408\u540c\u72b6\u6001\uff01" + JSONObject.toJSONString((Object)((Object)contractEntity)));
            }
            this.service.updateContractPoolSettle(settlementVO, true);
            boolean pool = this.service.pushSettleToPool(settlementVO);
            if (!pool) {
                throw new BusinessException("\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25");
            }
            if (entity.getSignatureType() != null && entity.getSignatureType() == 1 && entity.getContractId() != null) {
                String linkUrl = entity.getSettlementType() == 0 ? (null == entity.getContractId() || 0L == entity.getContractId() ? this.BaseHost + "ejc-promaterial-frontend/#/settlementList/settlementNoCard?id=" + entity.getId() : this.BaseHost + "ejc-promaterial-frontend/#/settlementList/settlementCard?id=" + entity.getId()) : (null == entity.getContractId() || 0L == entity.getContractId() ? this.BaseHost + "ejc-promaterial-frontend/#/concreteSettlementList/settlementNoCard?id=" + entity.getId() : this.BaseHost + "ejc-promaterial-frontend/#/concreteSettlementList/settlementCard?id=" + entity.getId());
                ExecutionVO executionVO = this.service.targetCost((SettlementVO)BeanMapper.map((Object)((Object)entity), SettlementVO.class), linkUrl, entity.getSettlementType());
                this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
                CommonResponse response = this.executionApi.aggPush(executionVO);
                if (!response.isSuccess()) {
                    throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
                }
            }
            Boolean pushFlag = this.service.pushBillToSupCenter(entity, billTypeCode);
            this.logger.info("\u83b7\u53d6\u63a8\u9001\u4f9b\u65b9\u7ed3\u679c--" + pushFlag);
            if (!pushFlag.booleanValue()) {
                entity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
            } else {
                entity.setBillPushFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
            }
            this.service.updateById((Object)entity);
            this.service.costPush(entity);
            return CommonResponse.success((String)"\u5ba1\u6279\u901a\u8fc7\u903b\u8f91\u64cd\u4f5c\u5b8c\u6210");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        List list;
        CommonResponse res2 = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res2.isSuccess() + "----" + res2.getMsg());
        if (!res2.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u5f03\u5ba1\uff01");
        }
        SettlementEntity entity = (SettlementEntity)((Object)this.service.selectById(billId));
        if (entity.getSignStatus() == 1) {
            throw new BusinessException("\u5df2\u7b7e\u5b57\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        if (entity.getContractId() != null) {
            LambdaQueryWrapper lambda = new LambdaQueryWrapper();
            lambda.eq(SettlementEntity::getContractId, (Object)entity.getContractId());
            lambda.eq(SettlementEntity::getSettlementType, (Object)entity.getSettlementType());
            lambda.orderByDesc(BaseEntity::getCreateTime);
            list = this.service.list((Wrapper)lambda);
            SettlementEntity settlementEntity = (SettlementEntity)((Object)list.get(0));
            if (!entity.getId().equals(settlementEntity.getId())) {
                throw new BusinessException("\u53ea\u80fd\u64a4\u56de\u6700\u65b0\u7684\u7ed3\u7b97\u5355\uff01");
            }
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(DifferentEntity::getSettlementId, (Object)billId);
        wrapper.eq(BaseEntity::getDr, (Object)0);
        list = this.differentService.list((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            DifferentEntity different = (DifferentEntity)((Object)list.get(0));
            this.logger.info("\u8be5\u7ed3\u7b97\u5355\u72b6\u6001---{}", (Object)entity.getSettlementType());
            String BILL_TYPE = "";
            BILL_TYPE = entity.getSettlementType() == 1 ? CDBILL_TYPE : MDBILL_TYPE;
            CommonResponse res = this.billTypeApi.checkQuote(BILL_TYPE, different.getId());
            if (!res.isSuccess() || "1".equals(different.getProportionFlag())) {
                throw new BusinessException("\u8c03\u5dee\u5355\u88ab\u5f15\u7528\u4e0d\u80fd\u64a4\u56de\uff01");
            }
        }
        if (entity.getSignatureType() != null && entity.getSignatureType() == 1 && entity.getContractId() != null) {
            ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
            ExecutionVO executionVO = this.service.targetCost((SettlementVO)BeanMapper.map((Object)((Object)entity), SettlementVO.class), "", entity.getSettlementType());
            totalExecutionVOList.add(executionVO.getTotalVO());
            CommonResponse response1 = this.executionApi.aggDel(totalExecutionVOList);
            if (!response1.isSuccess()) {
                throw new BusinessException(response1.getMsg());
            }
        }
        this.logger.info("\u5165\u5e93\u5f03\u5ba1\u6821\u9a8c---");
        StoreApiVO storeApiVO = new StoreApiVO();
        storeApiVO.setSettleId(billId);
        CommonResponse response = this.accountSettleApi.settleRollback(storeApiVO);
        if (!response.isSuccess()) {
            throw new BusinessException(response.getMsg());
        }
        this.logger.info("\u5f03\u5ba1\u6821\u9a8c\u6210\u529f\uff01" + JSONObject.toJSONString((Object)response.getData()));
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        SettlementEntity entity = (SettlementEntity)((Object)this.service.selectById(billId));
        if (entity.getContractId() != null && entity.getSignatureType() == 1) {
            ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
            contractEntity.setPerformanceStatus(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
            this.contractService.saveOrUpdate((Object)contractEntity);
            this.logger.info("\u4fee\u6539\u5408\u540c\u72b6\u6001\uff01" + JSONObject.toJSONString((Object)((Object)contractEntity)));
        }
        this.service.updateContractPoolSettle((SettlementVO)BeanMapper.map((Object)((Object)entity), SettlementVO.class), false);
        this.logger.info("\u5220\u9664\u8c03\u5dee\u5355---");
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(DifferentEntity::getSettlementId, (Object)billId);
        this.differentService.remove((Wrapper)wrapper, false);
        boolean pool = this.service.delSettleFromPool(billId);
        if (!pool) {
            throw new BusinessException("\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff01");
        }
        if (BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus().equals(entity.getBillPushFlag())) {
            this.logger.info("\u4f9b\u65b9\u64a4\u56de---");
            this.logger.info("\u8be5\u7ed3\u7b97\u5355\u72b6\u6001---{}", (Object)entity.getSettlementType());
            CommonResponse<String> response = this.service.updatePushBill(entity, billTypeCode, "/ejc-supbusiness-web/openapi/settlement/delSettlement");
            if (!response.isSuccess()) {
                throw new BusinessException(response.getMsg());
            }
            entity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
            this.service.updateById((Object)entity);
            this.logger.info("\u4f9b\u65b9\u64a4\u56de\u6210\u529f---" + JSONObject.toJSONString((Object)((Object)entity)));
        }
        this.logger.info("\u5f03\u5ba1\u63a8\u9001\u6210\u672c---");
        this.logger.info("\u5220\u9664\u6210\u672c\u4e2d\u5fc3\u4e4b\u524d\u7684\u6570\u636e-\u7ed3\u7b97Id---{}", (Object)entity.getId());
        CommonResponse stringCommonResponse = this.costDetailApi.deleteSubject(entity.getId());
        this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)stringCommonResponse));
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException(stringCommonResponse.getMsg());
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{entity.getId()});
        updateWrapper.set(SettlementEntity::getRelationFlag, (Object)"0");
        this.service.update((Wrapper)updateWrapper);
        return CommonResponse.success();
    }

    private DifferentVO getDifferent(SettlementEntity settlement, StoreApiVO storeApiVO) {
        ArrayList<DifferentDetailVO> detailVOS = new ArrayList<DifferentDetailVO>();
        DifferentVO differentVO = (DifferentVO)BeanMapper.map((Object)((Object)settlement), DifferentVO.class);
        BigDecimal costMny = BigDecimal.ZERO;
        BigDecimal costTaxMny = BigDecimal.ZERO;
        BigDecimal costTax = BigDecimal.ZERO;
        BigDecimal diffMny = BigDecimal.ZERO;
        BigDecimal diffTaxMny = BigDecimal.ZERO;
        BigDecimal diffTax = BigDecimal.ZERO;
        StringBuffer materialTypeName = new StringBuffer();
        if (CollectionUtils.isNotEmpty((Collection)storeApiVO.getDetail())) {
            Map<Long, FlowVO> flowVOMap = storeApiVO.getDetail().stream().filter(t -> t.getSettleDetailId() != null).collect(Collectors.toMap(FlowVO::getSettleDetailId, item -> item, (v1, v2) -> v2));
            if (CollectionUtils.isNotEmpty(settlement.getSettlementDetailList())) {
                for (SettlementDetailEntity detail : settlement.getSettlementDetailList()) {
                    if (!flowVOMap.containsKey(detail.getId())) continue;
                    if (materialTypeName.length() > 0) {
                        materialTypeName.append("\u3001").append(detail.getMaterialTypeName());
                    } else {
                        materialTypeName.append(detail.getMaterialTypeName());
                    }
                    FlowVO flowVO = flowVOMap.get(detail.getId());
                    DifferentDetailVO differentDetailVO = (DifferentDetailVO)BeanMapper.map((Object)((Object)detail), DifferentDetailVO.class);
                    differentDetailVO.setId(null);
                    differentDetailVO.setRowState("add");
                    BigDecimal costMny1 = flowVO.getCostMny() == null ? BigDecimal.ZERO : flowVO.getCostMny();
                    BigDecimal costTaxMny1 = flowVO.getCostTaxMny() == null ? BigDecimal.ZERO : flowVO.getCostTaxMny();
                    BigDecimal costTax1 = flowVO.getCostTax() == null ? BigDecimal.ZERO : flowVO.getCostTax();
                    BigDecimal diffMny1 = flowVO.getDiffMny() == null ? BigDecimal.ZERO : flowVO.getDiffMny();
                    BigDecimal diffTaxMny1 = flowVO.getDiffTaxMny() == null ? BigDecimal.ZERO : flowVO.getDiffTaxMny();
                    BigDecimal diffTax1 = flowVO.getDiffTax() == null ? BigDecimal.ZERO : flowVO.getDiffTax();
                    differentDetailVO.setDetailDiffMny(diffMny1);
                    differentDetailVO.setDetailDiffTax(diffTax1);
                    differentDetailVO.setDetailDiffTaxMny(diffTaxMny1);
                    differentDetailVO.setDetailCostMny(costMny1);
                    differentDetailVO.setDetailCostTaxMny(costTaxMny1);
                    costMny = costMny.add(costMny1);
                    costTaxMny = costTaxMny.add(costTaxMny1);
                    costTax = costTax.add(costTax1);
                    diffMny = diffMny.add(diffMny1);
                    diffTaxMny = diffTaxMny.add(diffTaxMny1);
                    diffTax = diffTax.add(diffTax1);
                    detailVOS.add(differentDetailVO);
                }
            }
        }
        differentVO.setDifferentDetailList(detailVOS);
        differentVO.setId(null);
        differentVO.setBillCode(null);
        differentVO.setDifferentDate(new Date());
        differentVO.setDiffMny(diffMny);
        differentVO.setDiffTaxMny(diffTaxMny);
        differentVO.setDiffTax(diffTax);
        differentVO.setCostMny(costMny);
        differentVO.setCostTaxMny(costTaxMny);
        differentVO.setSettlementId(settlement.getId());
        differentVO.setSettlementCode(settlement.getBillCode());
        differentVO.setMaterialTypeName(materialTypeName.toString());
        differentVO.setProportionFlag("0");
        differentVO.setRelationFlag("0");
        this.logger.info("\u7ed3\u7b97\u5355\u5b9e\u4f53----" + JSONObject.toJSONString((Object)((Object)settlement)));
        this.logger.info("\u8c03\u5dee\u5355vo---" + JSONObject.toJSONString((Object)differentVO));
        List differentDetailList = differentVO.getDifferentDetailList();
        List idList = differentDetailList.stream().map(DifferentDetailVO::getMaterialId).collect(Collectors.toList());
        this.logger.info("\u6210\u672c\u79d1\u76ee\u63a8\u9001\u6570\u636e" + JSONObject.toJSONString(idList));
        CommonResponse response = this.shareMaterialApi.queryMaterialItemByIds(idList);
        if (!response.isSuccess()) {
            throw new BusinessException("\u6210\u672c\u79d1\u76ee\u67e5\u8be2\u5931\u8d25");
        }
        List data = (List)response.getData();
        for (DifferentDetailVO detailVO : differentDetailList) {
            for (MaterialVO vo : data) {
                if (!Objects.equals(detailVO.getMaterialId(), vo.getId())) continue;
                detailVO.setSubjectId(null == vo.getSubjectId() ? null : vo.getSubjectId());
                detailVO.setSubjectName(null == vo.getSubjectName() ? null : vo.getSubjectName());
            }
        }
        return differentVO;
    }
}

