package com.ejianc.business.promaterial.contract.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.promaterial.contract.bean.ContractChangeEntity;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.enums.BillTypeEnum;
import com.ejianc.business.promaterial.contract.enums.MaterialContractTypeEnum;
import com.ejianc.business.promaterial.contract.enums.SignatureStatusEnum;
import com.ejianc.business.promaterial.contract.service.IContractChangeService;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.api.ISignatureManageApi;
import com.ejianc.business.signaturemanage.vo.ContractVO;
import com.ejianc.business.signaturemanage.vo.SignMgrPreviewVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 合同文件管理控制
 *
 * @author CJ
 * @Description: 合同文件管理控制
 * @date 2021/11/26 14:16
 */
@RestController
@RequestMapping("/contractFileUpdate/")
public class ContractFileController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IContractService contractService;

    @Autowired
    private ISignatureManageApi signatureManageApi;
    @Autowired
    private ISignatureCommonApi signatureCommonApi;

    @Autowired
    private IContractChangeService changeService;

    /**
     * 合同附件信息更新
     *
     * @param updateData {
     *   billId 单据Id
     *   sourceType 单据业务类型
     *   billType 单据类型
     *   fileId 文件Id
     *   fileSize 文件大小（以B为单位）
     *   fileName 文件名称
     *   fileOnlinePath 文件在线预览地址
     *   imgServerPath 文件服务地址
     *   formatPathStr 文件格式化地址
     * }
     * @return
     */
    @PostMapping(value = "updateFileInfo")
    public CommonResponse<JSONObject> updateFileInfo(@RequestBody JSONObject updateData) {
        JSONObject resp = new JSONObject();

        ContractEntity contract = contractService.selectById(updateData.getLong("billId"));
        contract.setContractFileId(updateData.getLong("fileId"));
        contract.setContractFileHighlightId(updateData.getLong("fileId"));
        contract.setContractFilePath(updateData.getString("fileOnlinePath"));
        contract.setContractFileHighlightPath(updateData.getString("fileOnlinePath"));
        //将合同文件同步状态设置为已同步
        contract.setContractFileSyncFlag(true);
        contractService.saveOrUpdate(contract, false);

        resp.put("message", "合同文件信息更新成功");
        resp.put("billData", contract);
        return CommonResponse.success("合同文件信息更新成功！", resp);
    }

    /**
     * 获取合同签章完的文件信息
     *
     * @param billId 合同Id
     * @param billType 单据类型：contract-主合同/变更协议, contractChange-合同变更、协议变更
     * @return
     */
    @GetMapping(value = "getSignedFileInfo")
    public CommonResponse<JSONObject> getSignedFileInfo(@RequestParam(value = "billId") Long billId, @RequestParam(value = "billType") String billType) {
        JSONObject resp = new JSONObject();
        String contractBillTypeStr = "contract";
        ArrayList<ContractVO> cvs = new ArrayList<>();
        ContractVO cv = new ContractVO(); // 签章中的合同vo
        if(contractBillTypeStr.equals(billType)){
            ContractEntity entity = contractService.selectById(billId);
            Assert.notNull(entity, "查询不到主合同详情");
            cv.setContractId(entity.getId());
            cv.setContractName(entity.getContractName());
            cv.setSourceType(billType);
            cv.setBillType(BillTypeEnum.消耗材合同.getCode());
            if(MaterialContractTypeEnum.混凝土.getCode().equals(entity.getContractType())){
                cv.setBillType(BillTypeEnum.混凝土合同.getCode());
            }
        }
        else {
            // 变更
            // 查询合同详情
            ContractChangeEntity entity = changeService.selectById(billId);
            Assert.notNull(entity, "查询不到变更合同详情");
            cv.setContractId(entity.getId());
            cv.setContractName(entity.getContractName());
            cv.setSourceType(billType);
            cv.setBillType(BillTypeEnum.消耗材合同变更.getCode());
            if(MaterialContractTypeEnum.混凝土.getCode().equals(entity.getContractType())){
                cv.setBillType(BillTypeEnum.混凝土变更合同.getCode());
            }
        }
        cvs.add(cv);

//        CommonResponse<List<SignMgrPreviewVO>> signResp = signatureManageApi.previewContract(billId, Arrays.asList(new String[]{SignatureStatusEnum.已签章.getCode()}));
        CommonResponse<List<SignMgrPreviewVO>> signResp = signatureCommonApi.fetchSignedContract(cvs);
        if(!signResp.isSuccess()) {
            logger.error("获取单据id-{}，billType-{}签章文件信息失败: {}", billId, billType, signResp.getMsg());
            return CommonResponse.error("获取合同签章文件信息失败!");
        }

        List<SignMgrPreviewVO> fileList = signResp.getData();
        if(CollectionUtils.isEmpty(fileList)) {
            return CommonResponse.error("未获取到合同签章文件信息！");
        }

        SignMgrPreviewVO signedFileInfo = signResp.getData().get(0);
//        if("contract".equals(billType)) {
        if(contractBillTypeStr.equals(billType)){
            ContractEntity contract = contractService.selectById(billId);
            contract.setSignedFileId(signedFileInfo.getFileId());
            contractService.saveOrUpdate(contract, false);
        } else {
            ContractChangeEntity contractChange = changeService.selectById(billId);
            contractChange.setSignedFileId(signedFileInfo.getFileId());
            changeService.saveOrUpdate(contractChange, false);
        }

        resp.put("fileId", signedFileInfo.getFileId());
        resp.put("filePath", signedFileInfo.getFilePath());
        resp.put("fileTruePath", signedFileInfo.getTruePath());

        return CommonResponse.success("查询成功！", resp);
    }
    @GetMapping(value = "getBillDataJson")
    public CommonResponse<com.ejianc.business.promaterial.contract.vo.ContractVO> getBillDataJson(@RequestParam Long id) {
        ContractEntity contract = contractService.selectById(id);
        com.ejianc.business.promaterial.contract.vo.ContractVO vo = BeanMapper.map(contract, com.ejianc.business.promaterial.contract.vo.ContractVO.class);

        DecimalFormat priceFmt = new DecimalFormat("#,###.####");
        DecimalFormat mnyFmt = new DecimalFormat("#,##0.00");
        if(CollectionUtils.isNotEmpty(vo.getContractDetailList())) {
            vo.getContractDetailList().forEach(item -> {
                item.setDetailPriceStr(null != item.getPrice() ? priceFmt.format(item.getPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setDetailTaxPriceStr(null != item.getDetailTaxPrice() ? priceFmt.format(item.getDetailTaxPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setDetailMnyStr(null != item.getMoney() ? mnyFmt.format(item.getMoney()) : mnyFmt.format(BigDecimal.ZERO));
                item.setDetailTaxMnyStr(null != item.getDetailTaxMny() ? mnyFmt.format(item.getDetailTaxMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setDetailTaxStr(null != item.getDetailTax() ? mnyFmt.format(item.getDetailTax()) : mnyFmt.format(BigDecimal.ZERO));
                item.setDetailTaxRateStr(null != item.getDetailTaxRate() ? mnyFmt.format(item.getDetailTaxRate()) : mnyFmt.format(BigDecimal.ZERO));
                item.setDetailNumStr(null != item.getNum() ? priceFmt.format(item.getNum()) : priceFmt.format(BigDecimal.ZERO));
            });
        }
        if(CollectionUtils.isNotEmpty(vo.getContractFeeList())) {
            vo.getContractFeeList().forEach(item -> {
                item.setFreePriceStr(null != item.getFreePrice() ? priceFmt.format(item.getFreePrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setFreeTaxPriceStr(null != item.getFreeTaxPrice() ? priceFmt.format(item.getFreeTaxPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setFreeMnyStr(null != item.getFreeMoney() ? mnyFmt.format(item.getFreeMoney()) : mnyFmt.format(BigDecimal.ZERO));
                item.setFreeTaxMnyStr(null != item.getFreeTaxMny() ? mnyFmt.format(item.getFreeTaxMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setFreeTaxStr(null != item.getFreeTax() ? mnyFmt.format(item.getFreeTax()) : mnyFmt.format(BigDecimal.ZERO));
                item.setFreeNumStr(null != item.getFreeNum() ? priceFmt.format(item.getFreeNum()) : priceFmt.format(BigDecimal.ZERO));
                item.setFreeTaxRateStr(null != item.getFreeTaxRate() ? mnyFmt.format(item.getFreeTaxRate()) : mnyFmt.format(BigDecimal.ZERO));
            });
        }
        if(CollectionUtils.isNotEmpty(vo.getContractStageList())) {
            vo.getContractStageList().forEach(item -> {
                item.setStageScaleStr(null != item.getStageScale() ? mnyFmt.format(item.getStageScale()) : mnyFmt.format(BigDecimal.ZERO));
            });
        }
        if(CollectionUtils.isNotEmpty(vo.getContractClauseList())) {
            vo.getContractClauseList().forEach(item -> {
                /**
             * 是否必填 0否  1是
             */
                item.setNecessaryStatusStr(null != item.getNecessaryStatus() && item.getNecessaryStatus()==1  ?  "是":"否" );
            });
        }
        if(CollectionUtils.isNotEmpty(vo.getContractAdmixtureList())) {
            vo.getContractAdmixtureList().forEach(item -> {
                item.setPriceStr(null != item.getPrice() ? priceFmt.format(item.getPrice()) : priceFmt.format(BigDecimal.ZERO));
            });
        }
        return CommonResponse.success(vo);
    }
}
