package com.ejianc.business.promaterial.plan.controller;

import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import io.swagger.annotations.Api;
import com.ejianc.business.promaterial.plan.bean.MasterPlanChangeHisEntity;
import com.ejianc.business.promaterial.plan.service.IMasterPlanChangeHisService;
import com.ejianc.business.promaterial.plan.vo.MasterPlanChangeHisVO;

/**
 * 消耗材总计划变更记录
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("planChangeHis")
@Api(value = "消耗材总计划变更记录", tags = {"消耗材总计划变更记录"})
public class MasterPlanChangeHisController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IMasterPlanChangeHisService masterPlanChangeHisService;

    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MasterPlanChangeHisVO> queryDetail(@RequestParam(value = "id") Long id) {
        MasterPlanChangeHisVO vo = null;
        vo = masterPlanChangeHisService.queryDetail(id,true);
        return CommonResponse.success("查询物资总计划变更详情成功！", vo);
    }
}
