package com.ejianc.business.promaterial.reconciliation.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.promaterial.contract.bean.ContractDetailEntity;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.enums.ChangeTypeEnum;
import com.ejianc.business.promaterial.contract.enums.SignatureStatusEnum;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.contract.vo.ReferenceDetailVO;
import com.ejianc.business.promaterial.contract.vo.ReferenceMapVO;
import com.ejianc.business.promaterial.enums.BillPushStatusEnum;
import com.ejianc.business.promaterial.out.bean.OutStoreEntity;
import com.ejianc.business.promaterial.reconciliation.bean.ReconciliationCollectEntity;
import com.ejianc.business.promaterial.reconciliation.bean.ReconciliationDetailEntity;
import com.ejianc.business.promaterial.reconciliation.service.IReconciliationCollectService;
import com.ejianc.business.promaterial.reconciliation.service.IReconciliationDetailService;
import com.ejianc.business.promaterial.reconciliation.vo.ReconciliationCollectVO;
import com.ejianc.business.promaterial.reconciliation.vo.ReconciliationDetailVO;
import com.ejianc.business.promaterial.reconciliation.vo.ReconciliationVO;
import com.ejianc.business.promaterial.settlement.bean.SettlementEntity;
import com.ejianc.business.store.api.IAccountSettleApi;
import com.ejianc.business.tender.stuff.vo.StuffPicketageRefsupplierVO;
import com.ejianc.foundation.metadata.api.IMdApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.foundation.share.vo.SupplierProVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.kit.collection.ListUtil;
import jodd.util.ArraysUtil;
import net.bytebuddy.implementation.bytecode.Throw;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import com.ejianc.business.promaterial.reconciliation.bean.ReconciliationEntity;
import com.ejianc.business.promaterial.reconciliation.service.IReconciliationService;


/**
 * 对账单主表
 *
 * @author generator
 */
@Controller
@RequestMapping("reconciliation")
@Api(value = "对账单主表", tags = {"对账单主表"})
public class ReconciliationController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "DZ_CODE";//此处需要根据实际修改

    @Autowired
    private IReconciliationService service;
    @Autowired
    private IReconciliationDetailService detailService;
    @Autowired
    private IReconciliationCollectService collectService;
    @Autowired
    private IShareCooperateApi shareCooperateApi;

    @Autowired
    private IProSupplierApi proSupplierApi;

    @Value("${common.env.base-host}")
    private String BaseHost;
    @Autowired
    private IMdApi mdApi;
    @Autowired
    private IUserApi userApi;


    private static final String XHC_BILL_TYPE = "BT220310000000001";//此处需要根据实际修改
    private static final String HNT_BILL_TYPE = "BT220316000000003";//此处需要根据实际修改


    /**
     * 单据分享移动端前端路由地址
     */
    private final String mobileBillShareFrontUrl = "/ejc-supbusiness-mobile/#/proMaterial/reconciliation/card";

    @Autowired
    private SessionManager sessionManager;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ReconciliationVO> saveOrUpdate(@ApiParam(name = "saveOrUpdateVO", required = true) @RequestBody ReconciliationVO saveOrUpdateVO) {
        ReconciliationEntity entity = BeanMapper.map(saveOrUpdateVO, ReconciliationEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }
            else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //合同校验
        service.checkContract(entity);
        List<ReconciliationDetailVO> detailList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(saveOrUpdateVO.getDetailList())) {
            for (ReconciliationDetailVO detailVO : saveOrUpdateVO.getDetailList()) {
                if (detailVO.getId() != null) {
                    if ("del".equals(detailVO.getRowState())) {//删除
                        detailList.add(detailVO);
                    }
                }
            }
        }
        List<ReconciliationEntity> list;
        if (null == saveOrUpdateVO.getId() || saveOrUpdateVO.getId() == 0) {
            list = service.list(new QueryWrapper<ReconciliationEntity>().eq("contract_id", saveOrUpdateVO.getContractId()).in("bill_state", 0, 2, 4, 5).eq("dr", 0));
        }
        else {
            list = service.list(new QueryWrapper<ReconciliationEntity>().eq("contract_id", saveOrUpdateVO.getContractId()).in("bill_state", 0, 2, 4, 5).eq("dr", 0).ne("id", saveOrUpdateVO.getId()));
        }
        if (list.size() > 0) {
            throw new BusinessException(" 一个合同下只能有一张未生效的对账单");
        }

        //删除对账
        service.updateAccount(0, BeanMapper.map(saveOrUpdateVO, ReconciliationEntity.class), BeanMapper.mapList(detailList, ReconciliationDetailEntity.class));
        Map<String, Object> hashMap = new HashMap<>();
        hashMap.put("reconciliation_id", entity.getId());
        collectService.removeByMap(hashMap);
        entity.setMaterialName(entity.getDetailList().stream().map(ReconciliationDetailEntity::getMaterialName).collect(Collectors.joining(",")));
        entity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
        service.saveOrUpdate(entity, false);
        //更新对账信息
        service.updateAccount(1, entity, entity.getDetailList());
        ReconciliationVO vo = BeanMapper.map(entity, ReconciliationVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ReconciliationVO> queryDetail(@RequestParam Long id) {
        ReconciliationEntity entity = service.selectById(id);
        ReconciliationVO vo = BeanMapper.map(entity, ReconciliationVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    @ApiOperation("获取协同链接")
    @RequestMapping(value = "/getBillShareLink", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getBillShareLink(@RequestParam Long id) {
        ReconciliationEntity entity = service.selectById(id);
        String billTypeCode;
        if (entity.getReconciliationType() == 0) {
            billTypeCode = XHC_BILL_TYPE;
        }
        else {
            billTypeCode = HNT_BILL_TYPE;
        }
//        CommonResponse<SupplierProVO> supplierResp = proSupplierApi.getSupplierInfo(entity.getSupplierId());
//        if (!supplierResp.isSuccess()) {
//            logger.error("根据供应商主键-{}查询失败，{}", entity.getSupplierId(), supplierResp.getMsg());
//            return CommonResponse.error("单据获取供方信息失败，生成分享连接失败！");
//        }
//        SupplierProVO supplierVO = supplierResp.getData();
//        if(null!=supplierVO&&StringUtils.isNotEmpty(supplierVO.getSystemId())&&supplierVO.getCoordination()){
//        }else{
//            return CommonResponse.error("该供应商未开通协同权限，无法协同分享。");
//        }
        //校验供应商
        CommonResponse<Boolean> supplierResp = proSupplierApi.whetherSupplierCoo(entity.getSupplierId());
        if (!supplierResp.isSuccess()) {
            logger.error("根据供应商主键-{}查询失败，{}", entity.getSupplierId(), supplierResp.getMsg());
            return CommonResponse.error("单据获取供方信息失败，生成分享连接失败！");
        }
        Boolean flag = supplierResp.getData();
        if (!flag) {
            return CommonResponse.error("该供应商未开通协同权限，无法协同分享。");
        }

        if (BillPushStatusEnum.未成功推送.getStatus().equals(entity.getBillPushFlag())) {
            //查询该单据是否支持协同分享，则向供方协同服务推送该单据
            CommonResponse<CooperateVO> cooperateResp = shareCooperateApi.queryCooperateBybillTypeCode(billTypeCode);
            if (!cooperateResp.isSuccess()) {
                logger.error("根据单据类型-{}查询其协同配置信息失败, 不进行单据推送操作，{}", billTypeCode, cooperateResp.getMsg());
                return CommonResponse.error("单据推送供方失败，生成分享连接失败！");
            }
            else {
                //未曾成功推送单据，则先向供方推送单据
                boolean pushResult = service.pushBillToSupCenter(entity, billTypeCode);
                logger.info("获取推送供方结果--" + pushResult);
                if (!pushResult) {
                    logger.error("单据-{}推送给供应商supplierId-{}失败！", id, entity.getSupplierId());
                    return CommonResponse.error("单据推送供方失败，生成分享连接失败！");
                }
                else {
                    entity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
                    service.saveOrUpdate(entity, false);
                }
            }
        }
        return shareCooperateApi.getShareLink(id, billTypeCode, entity.getSupplierId().toString(), mobileBillShareFrontUrl, null);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ReconciliationVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ReconciliationVO vo : vos) {
                ReconciliationEntity entity = service.selectById(vo.getId());
                service.updateAccount(0, entity, entity.getDetailList());
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ReconciliationVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * 供方签字确认信息回写
     *
     * @param request
     * @return
     */
    @PostMapping(value = "/supSignSync")
    @ResponseBody
    public CommonResponse<String> supSignSync(HttpServletRequest request) {
        String msg = service.updateBillSupSignSyncInfo(request);
        if (StringUtils.isNotBlank(msg)) {
            return CommonResponse.error(msg);
        }
        return CommonResponse.success("签字状态回写成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ReconciliationVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("contractName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("reconciliationType", new Parameter(QueryParam.EQ, 0));

        if (!param.getParams().containsKey("orgId")) {
            /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
            UserContext userContextCache = sessionManager.getUserContext();
            //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
            String authOrgIds = userContextCache.getAuthOrgIds();
            List<OrgVO> orgVOList = null;
            if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
            }
            else {//pc端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                }
                else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            }
            else if (CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
            /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        }

        IPage<ReconciliationEntity> page = service.queryPage(param, false);
        IPage<ReconciliationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ReconciliationVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    @ApiOperation("查询消耗材列表")
    @RequestMapping(value = "/queryConcreteList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ReconciliationVO>> queryConcreteList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("contractName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("reconciliationType", new Parameter(QueryParam.EQ, 1));

        if (!param.getParams().containsKey("orgId")) {
            /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
            UserContext userContextCache = sessionManager.getUserContext();
            //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
            String authOrgIds = userContextCache.getAuthOrgIds();
            List<OrgVO> orgVOList = null;
            if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
            }
            else {//pc端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                }
                else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            }
            else if (CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
            /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        }

        IPage<ReconciliationEntity> page = service.queryPage(param, false);
        IPage<ReconciliationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ReconciliationVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("reconciliationType", new Parameter(QueryParam.EQ, 0));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ReconciliationEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<ReconciliationVO> vos = BeanMapper.mapList(list, ReconciliationVO.class);
//        vos.forEach(t -> t.setSignatureStatus(SignatureStatusEnum.getEnumByCode(t.getSignatureStatus()).getDescription()));
        vos.forEach(t -> t.setSignStatusName(t.getSignStatus() == 0 ? "未签字" : "已签字"));
        vos.forEach(t -> t.setBillStateName(BillStateEnum.getEnumByStateCode(t.getBillState()).getDescription()));
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", vos);
        ExcelExport.getInstance().export("Reconciliation-export.xlsx", beans, response);
    }

    @ApiOperation("混凝土导出")
    @RequestMapping(value = "/excelConcreteExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelConcreteExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("reconciliationType", new Parameter(QueryParam.EQ, 1));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ReconciliationEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<ReconciliationVO> vos = BeanMapper.mapList(list, ReconciliationVO.class);
        vos.forEach(t -> t.setSignatureStatus(SignatureStatusEnum.getEnumByCode(t.getSignatureStatus()).getDescription()));
        vos.forEach(t -> t.setSignStatusName(t.getSignStatus() == 0 ? "未签字" : "已签字"));
        vos.forEach(t -> t.setBillStateName(BillStateEnum.getEnumByStateCode(t.getBillState()).getDescription()));
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", vos);
        ExcelExport.getInstance().export("Reconciliation-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refReconciliationData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ReconciliationVO>> refReconciliationData(@RequestParam Integer
                                                                                 pageNumber, @RequestParam Integer pageSize,
                                                                         String condition,
                                                                         String searchObject,
                                                                         String searchText) {
        QueryParam param = new QueryParam();
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("materialName");
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1, 3)));
        if (StringUtils.isNotEmpty(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("contractId")) {
                Long contractId = Long.valueOf(conditionMap.get("contractId").toString());
                param.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
            }
            if (null != conditionMap.get("reconciliationType")) {
                Integer reconciliationType = Integer.valueOf(conditionMap.get("reconciliationType").toString());
                param.getParams().put("reconciliationType", new Parameter(QueryParam.EQ, reconciliationType));
            }
//            if(conditionMap.containsKey("effectiveDate")){
//                String effectiveDate =conditionMap.get("effectiveDate").toString();
//                param.getParams().put("DATE_FORMAT(reconciliation_date,\"%Y-%m-%d\")", new Parameter(QueryParam.LE, effectiveDate));
//            }
        }
        IPage<ReconciliationVO> page = service.queryData(param);
//        IPage<ReconciliationEntity> page = service.queryPage(param, false);
        IPage<ReconciliationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<ReconciliationVO> reconciliationVOS = BeanMapper.mapList(page.getRecords(), ReconciliationVO.class);
        for (ReconciliationVO vo : reconciliationVOS) {
            LambdaQueryWrapper<ReconciliationDetailEntity> lambd = new LambdaQueryWrapper<>();
            lambd.eq(ReconciliationDetailEntity::getDr, 0);
            lambd.eq(ReconciliationDetailEntity::getReconciliationId, vo.getId());
            List<ReconciliationDetailEntity> list = detailService.list(lambd);
            List<ReconciliationDetailVO> batchPlanDetailVOS = BeanMapper.mapList(list, ReconciliationDetailVO.class);
            vo.setDetailList(batchPlanDetailVOS);
        }
        pageData.setRecords(reconciliationVOS);


        return CommonResponse.success("查询参照数据成功！", pageData);
    }
    @ApiOperation("查询合同累计对账数量")
    @RequestMapping(value = "/queryReconciliationNum", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ReconciliationVO> queryReconciliationNum(@RequestParam Long id) {
        ReconciliationVO reconciliationVO = new ReconciliationVO();
        Integer size = service.list(new QueryWrapper<ReconciliationEntity>().eq("contract_id", id).in("bill_state",Arrays.asList(1,3)).eq("dr",0)).size();
        reconciliationVO.setTotalReconciliationNum(size);
        return CommonResponse.success("查询详情数据成功！", reconciliationVO);
    }







    /**
     * 查看引用代码开始------------------
     */

    @GetMapping(value = "/getReferenceMap")
    @ResponseBody
    public CommonResponse<List<ReferenceMapVO>> getReferenceMap(@RequestParam String type,
                                                                @RequestParam Long id) {
        //准备查询参数
//      Map<billTypeCode, selectSql>
        Map<String, String> queryParam = getQueryDataParam(id.toString());

        //查询匹配的数据
        CommonResponse<Map<String, List<JSONObject>>> dataResp = mdApi.queryDataList(queryParam);
        if(!dataResp.isSuccess()) {
            logger.error("根据合同id-{}获取引用单据信息列表失败{}", id, dataResp.getMsg());
            return CommonResponse.error("查询引用结算单的单据信息列表失败！");
        }

        //匹配数据转换
        List<ReferenceMapVO> resp = getReferenceMapData(dataResp.getData());

        return CommonResponse.success(resp);
    }

    private Map<String, String> getQueryDataParam(String id) {
        Map<String, String> queryParam = new HashMap<>();
        StringBuilder sp = new StringBuilder();

        //查询引用合同的验收单
//        sp.append("SELECT  id, create_user_code, create_time, bill_code, org_name,bill_state,check_all_tax_mny as mny  FROM `ejc_promaterial_check`\n" +
//                "where dr = 0 and contract_id =  ")
//                .append(id);
//        queryParam.put("BT220215000000006", sp.toString());
        //查询引用合同的领料出库
//        sp = new StringBuilder();
//        sp.append("SELECT id, create_user_code, create_time, bill_code, org_name,bill_state,total_tax_mny as mny FROM `ejc_prosub_oldjob_registration` where dr = 0 and contract_id = ")
//                .append(id);
//        queryParam.put("BT211230000000003", sp.toString());


        //查询引用合同的对账单
        sp = new StringBuilder();
        sp.append("SELECT  id, create_user_code, create_time, bill_code, org_name,bill_state,reconciliation_tax_mny as mny  FROM `ejc_promaterial_reconciliation`\n" +
                "where id in (select DISTINCT reconciliation_id from ejc_promaterial_reconciliation_detail where source_id =")
                .append(id)
                .append("  and dr = 0) and dr = 0 ");
        queryParam.put("BT220310000000001", sp.toString());

        //查询引用合同的采购结算单
        sp = new StringBuilder();
        sp.append("SELECT  id, create_user_code, create_time, bill_code, org_name,bill_state,settlement_tax_mny as mny  FROM `ejc_promaterial_settlement`\n" +
                "where id in (select DISTINCT settlement_id from ejc_promaterial_settlement_detail where source_id = ")
                .append(id)
                .append("  and dr = 0) and dr = 0 ");
        queryParam.put("BT220309000000003", sp.toString());

        //查询引用结算单的成本归集单列表
        sp = new StringBuilder();
        sp.append("select id, create_user_code, create_time, project_name AS bill_code, parent_org_name,bill_state,cost_mny as mny  from ejc_procost_share ")
                .append(" where id in (select DISTINCT share_id from ejc_procost_share_detail where source_id = ")
                .append(id).append(" and dr = 0) and dr = 0");
        queryParam.put("BT220316000000002", sp.toString());

        //查询引用合同的有合同付款申请
        sp = new StringBuilder();
        sp.append("SELECT id, create_user_code, create_time, bill_code, org_name,bill_state,apply_mny as mny FROM `ejc_payment_apply` where dr = 0 and contract_id = ")
                .append(id);
        queryParam.put("BT220223000000003", sp.toString());

        return queryParam;
    }



    private List<ReferenceMapVO> getReferenceMapData(Map<String, List<JSONObject>> data) {
        List<ReferenceMapVO> resp = new ArrayList<>();
        ReferenceMapVO tmp = null;
        ReferenceDetailVO tmpDetail = null;
        List<JSONObject> dataList = null;

        Set<String> userCodes = new HashSet<>();
        for(String billType : data.keySet()) {
            dataList = data.get(billType);
            if(CollectionUtils.isNotEmpty(dataList)) {
                String billName = "";
                String billUrl = "";
                switch (billType){
                    case "BT220215000000006":
                        billName = "验收单";
                        billUrl = "ejc-promaterial-frontend/#/check/card?id=";
                        break;
//                    case "BT211230000000003":
//                        billName = "领料出库";
//                        billUrl = "ejc-promaterial-frontend/#/registration/card?id=";
//                        break;
                    case "BT220310000000001":
                        billName = "对账单";
                        billUrl = "ejc-promaterial-frontend/#/reconciliation/card?id=";
                        break;
                    case "BT220309000000003":
                        billName = "采购结算单";
                        billUrl = "ejc-promaterial-frontend/#/settlementList/settlementCard?id=";
                        break;
                    case "BT220316000000002":
                        billName = "成本归集单";
                        billUrl = "ejc-share-frontend/#/costShare/card?id=";
                        break;
                    case "BT220223000000003":
                        billName = "有合同付款申请";
                        billUrl = "ejc-profinance-frontend/#/paymentList/contractCard?id=";
                        break;
                }

                tmp = new ReferenceMapVO();
                tmp.setId(billType); //数据唯一标识
                tmp.setModuleName(billName); //模块名称
                tmp.setReferenceNum(dataList.size()); //引用单据数量
                BigDecimal sumMny = new BigDecimal(0);
                for(JSONObject dataRow : dataList) {
                    tmpDetail = new ReferenceDetailVO();
                    tmpDetail.setId(dataRow.getString("id")); //数据唯一标识
                    tmpDetail.setBillCode(dataRow.getString("bill_code")); //单据编码
                    tmpDetail.setBillState(BillStateEnum.getEnumByStateCode(dataRow.getInteger("bill_state")).getDescription()); //单据审批状态
                    tmpDetail.setCreateTime(dataRow.getDate("create_time")); //制单时间
                    tmpDetail.setEmployeeName(dataRow.getString("create_user_code")); //制单人
                    tmpDetail.setModuleName(tmp.getModuleName()); //节点名称
                    tmpDetail.setOrgName(dataRow.getString("org_name")); //制单机构
                    tmpDetail.setMny(dataRow.getBigDecimal("mny")); //金额
                    //穿透详情页地址
                    tmpDetail.setDetailPcUrl(BaseHost + billUrl + tmpDetail.getId());
                    tmp.getDetailList().add(tmpDetail);
                    if(org.apache.commons.lang3.StringUtils.isNotBlank(tmpDetail.getEmployeeName())) {
                        userCodes.add(tmpDetail.getEmployeeName());
                    }

                    if (tmpDetail.getMny() != null) {
                        sumMny = sumMny.add(dataRow.getBigDecimal("mny"));
                    }

                }
                //单据的总金额
                tmp.setSumMny(sumMny);
                resp.add(tmp);
            }
        }

        //根据制单人编码查询制单人信息
        if(CollectionUtils.isNotEmpty(userCodes)) {
            CommonResponse<List<UserVO>> userResp = userApi.queryUserByUserCodes(userCodes.toArray(new String[userCodes.size()]));
            if(!userResp.isSuccess()) {
                logger.error("根据用户编码获取用户信息失败：{}", userResp.getMsg());
            } else {
                Map<String, UserVO> userMap = userResp.getData().stream().collect(Collectors.toMap(item -> item.getUserCode(), item -> item));
                resp.stream().forEach(item -> {
                    item.getDetailList().stream().forEach(detail -> {
                        if(userMap.containsKey(detail.getEmployeeName())) {
                            detail.setEmployeeName(userMap.get(detail.getEmployeeName()).getUserName());
                        }
                    });
                });
            }
        }

        return resp;
    }

    /**
     * 查看引用代码结束------------------
     */
}
