/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.contract.service.impl;

import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.bean.ContractFreezeEntity;
import com.ejianc.business.promaterial.contract.enums.MaterialContractTypeEnum;
import com.ejianc.business.promaterial.contract.mapper.ContractFreezeMapper;
import com.ejianc.business.promaterial.contract.service.IContractFreezeService;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.contract.vo.ContractFreezeVO;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="contractFreezeService")
public class ContractFreezeServiceImpl
extends BaseServiceImpl<ContractFreezeMapper, ContractFreezeEntity>
implements IContractFreezeService {
    private static final String BILL_CODE = "CONTRACT_FREEZE";
    private static final String CONCRETE_BILL_CODE = "CONTRACT_CONCRETE_FREEZE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IProjectSetApi projectSetApi;

    @Override
    public ContractFreezeVO save(ContractFreezeVO saveOrUpdateVO) {
        ContractFreezeEntity entity = (ContractFreezeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ContractFreezeEntity.class));
        if (null == entity.getContractId()) {
            throw new BusinessException("\u4e3b\u5408\u540c\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
        if (contractEntity == null) {
            throw new BusinessException("\u67e5\u8be2\u4e0d\u5230\u5408\u540c\uff01");
        }
        CommonResponse projectRes = this.projectSetApi.getProjectId(contractEntity.getProjectId());
        if (projectRes.isSuccess() && "16".equals(((ProjectPoolSetVO)projectRes.getData()).getCapitalStatus())) {
            throw new BusinessException("\u8be5\u9879\u76ee\u8d44\u91d1\u7ba1\u63a7\u72b6\u6001\u4e3a\u3010\u6210\u672c\u5173\u95e8\u3011\uff0c\u4e0d\u5141\u8bb8\u6b64\u64cd\u4f5c!");
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam;
            CommonResponse billCode;
            String billCodeStr = BILL_CODE;
            if (MaterialContractTypeEnum.\u6df7\u51dd\u571f.getCode().equals(contractEntity.getContractType())) {
                billCodeStr = CONCRETE_BILL_CODE;
            }
            if ((billCode = this.billCodeApi.generateBillCode(billCodeParam = BillCodeParam.build((String)billCodeStr, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO))).isSuccess()) {
                entity.setBillCode((String)billCode.getData());
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("contractId", new Parameter("eq", (Object)entity.getContractId()));
                queryParam.getParams().put("performanceStatus", new Parameter("eq", (Object)entity.getPerformanceStatus()));
                queryParam.getParams().put("billState", new Parameter("in", Arrays.asList(0, 2, 4, 5)));
                List list = super.queryList(queryParam);
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u672a\u751f\u6548\u7684\u51bb\u7ed3/\u89e3\u51bb\u5355\uff0c\u4e0d\u80fd\u518d\u6b21\u53d1\u8d77\uff01");
                }
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.contractService.checkContract(saveOrUpdateVO.getContractId(), saveOrUpdateVO.getId());
        super.saveOrUpdate((Object)entity, false);
        return (ContractFreezeVO)BeanMapper.map((Object)((Object)entity), ContractFreezeVO.class);
    }
}

