/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.plan.controller;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.promaterial.contract.enums.BillTypeEnum;
import com.ejianc.business.promaterial.plan.bean.MasterPlanChangeEntity;
import com.ejianc.business.promaterial.plan.bean.MasterPlanEntity;
import com.ejianc.business.promaterial.plan.service.IMasterPlanChangeService;
import com.ejianc.business.promaterial.plan.service.IMasterPlanDetailChangeService;
import com.ejianc.business.promaterial.plan.service.IMasterPlanService;
import com.ejianc.business.promaterial.plan.vo.MasterPlanChangeVO;
import com.ejianc.business.promaterial.plan.vo.MasterPlanVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"planChange"})
@Api(value="\u6d88\u8017\u6750\u603b\u8ba1\u5212\u53d8\u66f4", tags={"\u6d88\u8017\u6750\u603b\u8ba1\u5212\u53d8\u66f4"})
public class MasterPlanChangeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMasterPlanChangeService service;
    @Autowired
    private IMasterPlanService masterPlanService;
    @Autowired
    private IMasterPlanDetailChangeService masterPlanDetailChangeService;
    @Autowired
    private IExecutionApi executionApi;
    @Value(value="${common.env.base-host}")
    private String baseHost;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MasterPlanChangeVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody MasterPlanChangeVO planVo) {
        return this.service.saveOrUpdateMasterPlan(planVo, false);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MasterPlanChangeVO> queryDetail(@RequestParam Long id) {
        MasterPlanChangeVO vo = null;
        vo = this.service.queryDetail(id, true);
        return CommonResponse.success((String)"\u67e5\u8be2\u7269\u8d44\u603b\u8ba1\u5212\u8be6\u60c5\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MasterPlanChangeVO> vos) {
        MasterPlanChangeEntity masterChangeEntity = (MasterPlanChangeEntity)((Object)this.service.selectById(vos.get(0).getId()));
        if (CollectionUtils.isNotEmpty(vos)) {
            ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
            ArrayList<Object> masterPlanEntityList = new ArrayList<Object>();
            for (MasterPlanChangeVO masterPlanVO : vos) {
                MasterPlanChangeEntity masterPlanChangeEntity = (MasterPlanChangeEntity)((Object)this.service.selectById(masterPlanVO.getId()));
                String billType = masterPlanChangeEntity.getPlanType() == 0 ? BillTypeEnum.\u6d88\u8017\u6750\u603b\u8ba1\u5212\u53d8\u66f4.getCode() : BillTypeEnum.\u6df7\u51dd\u571f\u603b\u8ba1\u5212\u53d8\u66f4.getCode();
                ExecutionVO executionVO = this.masterPlanService.targetCost((MasterPlanVO)BeanMapper.map((Object)((Object)masterPlanChangeEntity), MasterPlanVO.class), "", billType, masterPlanChangeEntity.getPlanType());
                totalExecutionVOList.add(executionVO.getTotalVO());
                masterPlanEntityList.add(this.masterPlanService.selectById(masterPlanChangeEntity.getSourcePlanId()));
            }
            this.logger.info("\u76ee\u6807\u6210\u672c\u5220\u9664\u6570\u636e" + JSON.toJSONString(totalExecutionVOList));
            CommonResponse response = this.executionApi.aggDel(totalExecutionVOList);
            if (!response.isSuccess()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
            }
            for (MasterPlanEntity masterPlanEntity : masterPlanEntityList) {
                ExecutionVO executionVO1;
                String billType;
                String linkUrl;
                List masterPlanChangeEntityList = this.service.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"source_plan_id", (Object)masterPlanEntity.getId())).eq((Object)"dr", (Object)0)).orderByDesc((Object)"change_version"));
                if (masterPlanChangeEntityList.size() > 1) {
                    if (masterPlanEntity.getPlanType() == 0) {
                        linkUrl = this.baseHost + "ejc-promaterial-frontend/#/masterPlan/changeCard?id=" + masterPlanEntity.getId();
                        billType = BillTypeEnum.\u6d88\u8017\u6750\u603b\u8ba1\u5212\u53d8\u66f4.getCode();
                    } else {
                        linkUrl = this.baseHost + "ejc-promaterial-frontend/#/concreteMasterPlan/changeCard?id=" + masterPlanEntity.getId();
                        billType = BillTypeEnum.\u6df7\u51dd\u571f\u603b\u8ba1\u5212\u53d8\u66f4.getCode();
                    }
                    executionVO1 = this.masterPlanService.targetCost((MasterPlanVO)BeanMapper.map(masterPlanChangeEntityList.get(1), MasterPlanVO.class), linkUrl, billType, ((MasterPlanChangeEntity)((Object)masterPlanChangeEntityList.get(1))).getPlanType());
                } else {
                    MasterPlanEntity masterPlan = (MasterPlanEntity)((Object)this.masterPlanService.selectById(masterChangeEntity.getSourcePlanId()));
                    if (masterPlan.getPlanType() == 0) {
                        linkUrl = this.baseHost + "ejc-promaterial-frontend/#/masterPlan/card?id=" + masterPlan.getId();
                        billType = BillTypeEnum.\u6d88\u8017\u6750\u603b\u8ba1\u5212.getCode();
                    } else {
                        linkUrl = this.baseHost + "ejc-promaterial-frontend/#/concreteMasterPlan/card?id=" + masterPlan.getId();
                        billType = BillTypeEnum.\u6df7\u51dd\u571f\u603b\u8ba1\u5212.getCode();
                    }
                    executionVO1 = this.masterPlanService.targetCost((MasterPlanVO)BeanMapper.map((Object)((Object)masterPlan), MasterPlanVO.class), linkUrl, billType, masterPlan.getPlanType());
                }
                this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO1));
                CommonResponse response1 = this.executionApi.aggPush(executionVO1);
                if (response1.isSuccess()) continue;
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
            }
            this.service.deleteChangePlan(vos.stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/targetCostCtrl"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> targetCostCtrl(@RequestBody MasterPlanChangeVO masterPlanVo) {
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)this.service.targetCostCtrl(masterPlanVo));
    }

    @GetMapping(value={"/viewTargetCostCtrlInfo"})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> viewTargetCostCtrlInfo(@RequestParam(value="id") Long id) {
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)this.service.viewTargetCostCtrlInfo(id));
    }
}

