/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.plan.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.contract.enums.BillTypeEnum;
import com.ejianc.business.promaterial.plan.bean.MasterPlanEntity;
import com.ejianc.business.promaterial.plan.service.IMasterPlanChangeHisService;
import com.ejianc.business.promaterial.plan.service.IMasterPlanDetailService;
import com.ejianc.business.promaterial.plan.service.IMasterPlanService;
import com.ejianc.business.promaterial.plan.vo.MasterPlanChangeHisVO;
import com.ejianc.business.promaterial.plan.vo.MasterPlanContrastV0;
import com.ejianc.business.promaterial.plan.vo.MasterPlanDetailRefVO;
import com.ejianc.business.promaterial.plan.vo.MasterPlanExportVO;
import com.ejianc.business.promaterial.plan.vo.MasterPlanVO;
import com.ejianc.business.promaterial.plan.vo.PlanTypeEnum;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"masterPlan"})
@Api(value="\u6d88\u8017\u6750\u603b\u8ba1\u5212", tags={"\u6d88\u8017\u6750\u603b\u8ba1\u5212"})
public class MasterPlanController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IExecutionApi executionApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private IShareMaterialApi shareMaterialApi;
    @Autowired
    private SessionManager sessionManager;
    private static final String BILL_CODE = "MASTER_PLAN";
    @Autowired
    private IMasterPlanService service;
    @Autowired
    private IMasterPlanDetailService masterPlanDetailService;
    @Autowired
    private IMasterPlanChangeHisService masterPlanChangeHisService;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MasterPlanVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody MasterPlanVO masterPlanVo) {
        return this.service.saveOrUpdateMasterPlan(masterPlanVo, false);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MasterPlanVO> queryDetail(@RequestParam Long id) {
        MasterPlanVO vo = null;
        vo = this.service.queryDetail(id, true);
        return CommonResponse.success((String)"\u67e5\u8be2\u7269\u8d44\u603b\u8ba1\u5212\u8be6\u60c5\u6210\u529f\uff01", (Object)vo);
    }

    private List<MasterPlanChangeHisVO> loadChangeHisList(Long planId) {
        List<Object> resp = new ArrayList<MasterPlanChangeHisVO>();
        QueryWrapper hisQuery = new QueryWrapper();
        hisQuery.eq((Object)"source_plan_id", (Object)planId);
        hisQuery.orderByDesc((Object)"create_time");
        List list = this.masterPlanChangeHisService.list((Wrapper)hisQuery);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            resp = BeanMapper.mapList((Iterable)list, MasterPlanChangeHisVO.class);
        }
        return resp;
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MasterPlanVO> vos) {
        if (CollectionUtils.isNotEmpty(vos)) {
            ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
            for (MasterPlanVO masterPlanVO : vos) {
                MasterPlanEntity masterPlanEntity = (MasterPlanEntity)((Object)this.service.selectById(masterPlanVO.getId()));
                String billType = masterPlanEntity.getPlanType() == 0 ? BillTypeEnum.\u6d88\u8017\u6750\u603b\u8ba1\u5212.getCode() : BillTypeEnum.\u6df7\u51dd\u571f\u603b\u8ba1\u5212.getCode();
                ExecutionVO executionVO = this.service.targetCost((MasterPlanVO)BeanMapper.map((Object)((Object)masterPlanEntity), MasterPlanVO.class), "", billType, masterPlanEntity.getPlanType());
                totalExecutionVOList.add(executionVO.getTotalVO());
            }
            this.logger.info("\u76ee\u6807\u6210\u672c\u5220\u9664\u6570\u636e" + JSON.toJSONString(totalExecutionVOList));
            CommonResponse response = this.executionApi.aggDel(totalExecutionVOList);
            if (!response.isSuccess()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
            }
            List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(ids)) {
                this.service.removeByIds(ids);
            }
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MasterPlanVO>> queryList(@RequestBody QueryParam queryParam) {
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("planCode");
        queryParam.getParams().put("planType", new Parameter("eq", (Object)PlanTypeEnum.\u6d88\u8017\u6750.getCode()));
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (!queryParam.getParams().containsKey("orgId")) {
            UserContext userContextCache = this.sessionManager.getUserContext();
            String authOrgIds = userContextCache.getAuthOrgIds();
            List orgVOList = null;
            orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            ArrayList commonOrgIds = new ArrayList();
            ArrayList departmentIds = new ArrayList();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    departmentIds.add(org.getId());
                } else {
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                queryParam.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                queryParam.getParams().put("orgId", new Parameter("in", departmentIds));
            }
        }
        IPage page = this.service.queryPage(queryParam, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MasterPlanVO.class));
        return CommonResponse.success((String)"\u5206\u9875\u67e5\u8be2\u7269\u8d44\u603b\u8ba1\u5212\u5217\u8868\u6210\u529f", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @ApiOperation(value="\u6df7\u6ce5\u571f\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryConcreteList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MasterPlanVO>> queryConcreteList(@RequestBody QueryParam queryParam) {
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("planCode");
        queryParam.getParams().put("planType", new Parameter("eq", (Object)PlanTypeEnum.\u6df7\u6ce5\u571f.getCode()));
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (!queryParam.getParams().containsKey("orgId")) {
            UserContext userContextCache = this.sessionManager.getUserContext();
            String authOrgIds = userContextCache.getAuthOrgIds();
            List orgVOList = null;
            orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            ArrayList commonOrgIds = new ArrayList();
            ArrayList departmentIds = new ArrayList();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    departmentIds.add(org.getId());
                } else {
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                queryParam.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                queryParam.getParams().put("orgId", new Parameter("in", departmentIds));
            }
        }
        IPage page = this.service.queryPage(queryParam, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MasterPlanVO.class));
        return CommonResponse.success((String)"\u5206\u9875\u67e5\u8be2\u7269\u8d44\u603b\u8ba1\u5212\u5217\u8868\u6210\u529f", (Object)pageData);
    }

    public ComplexParam getPageQueryParam(Long orgId) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        if (null == orgId) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        CommonResponse childOrgResp = this.iOrgApi.findChildrenByParentId(orgId);
        ArrayList<Long> childIds = new ArrayList<Long>();
        childIds.addAll(((List)childOrgResp.getData()).stream().filter(org -> 5 == org.getOrgType()).map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isEmpty(childIds)) {
            childIds.add(1L);
        }
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("org_id", new Parameter("in", childIds));
        c1.getComplexParams().add(c2);
        return c1;
    }

    @ApiOperation(value="\u662f\u5426\u5b58\u5728\u603b\u8ba1\u5212")
    @GetMapping(value={"/projectPlanCheck"})
    @ResponseBody
    public CommonResponse<String> projectPlanCheck(@RequestParam(value="projectId") Long projectId, @RequestParam(value="billId", required=false) Long billId) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"project_id", (Object)projectId);
        query.eq((Object)"plan_type", (Object)PlanTypeEnum.\u6d88\u8017\u6750.getCode());
        MasterPlanEntity entityByProject = (MasterPlanEntity)((Object)this.service.getOne((Wrapper)query));
        if (!(null == entityByProject || null != billId && entityByProject.getId().equals(billId))) {
            return CommonResponse.error((String)"\u8be5\u9879\u76ee\u4e0b\u5df2\u5b58\u5728\u6d88\u8017\u6750\u603b\u8ba1\u5212\uff01");
        }
        return CommonResponse.success((String)"\u8be5\u9879\u76ee\u9002\u7528\u5f53\u524d\u603b\u8ba1\u5212\uff01");
    }

    @ApiOperation(value="\u662f\u5426\u5b58\u5728\u6df7\u6ce5\u571f\u603b\u8ba1\u5212")
    @GetMapping(value={"/projectConcretePlanCheck"})
    @ResponseBody
    public CommonResponse<String> projectConcretePlanCheck(@RequestParam(value="projectId") Long projectId, @RequestParam(value="billId", required=false) Long billId) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"project_id", (Object)projectId);
        query.eq((Object)"plan_type", (Object)PlanTypeEnum.\u6df7\u6ce5\u571f.getCode());
        MasterPlanEntity entityByProject = (MasterPlanEntity)((Object)this.service.getOne((Wrapper)query));
        if (!(null == entityByProject || null != billId && entityByProject.getId().equals(billId))) {
            return CommonResponse.error((String)"\u8be5\u9879\u76ee\u4e0b\u5df2\u5b58\u5728\u6df7\u51dd\u571f\u603b\u8ba1\u5212\uff01");
        }
        return CommonResponse.success((String)"\u8be5\u9879\u76ee\u9002\u7528\u5f53\u524d\u603b\u8ba1\u5212\uff01");
    }

    @ApiOperation(value="\u53c2\u7167\u90d1\u5dde\u4e00\u5efa\u7269\u8d44\u63a7\u5236")
    @RequestMapping(value={"/planMaterialListReferZzyj"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MasterPlanDetailRefVO>> planMaterialListReferZzyj(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        Page resp = new Page();
        QueryParam queryParam = new QueryParam();
        queryParam.setSearchText(searchText);
        queryParam.setSearchObject(searchObject);
        queryParam.getFuzzyFields().add("material_category_name");
        queryParam.getFuzzyFields().add("material_name");
        queryParam.getFuzzyFields().add("spec");
        queryParam.getOrderMap().put("id", "asc");
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setPageIndex(pageNumber.intValue());
        if (StringUtils.isBlank((CharSequence)condition)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u53c2\u6570condition\u4e2d\u7f3a\u5c11\u9879projectId\uff01");
        }
        Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
        if (null == conditionMap.get("projectId")) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u53c2\u6570condition\u4e2d\u7f3a\u5c11\u9879projectId\uff01");
        }
        if (null == conditionMap.get("planType")) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u53c2\u6570condition\u4e2d\u7f3a\u5c11\u9879planType\uff01");
        }
        if (null == conditionMap.get("postbytopictype") || !conditionMap.get("postbytopictype").equals(1)) {
            queryParam.getParams().put("materialId1", new Parameter("sql", (Object)"material_id is not null"));
        }
        ArrayList<Integer> approvedBillState = new ArrayList<Integer>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_id", conditionMap.get("projectId"));
        queryWrapper.eq((Object)"plan_type", conditionMap.get("planType"));
        approvedBillState.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        approvedBillState.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        queryWrapper.in((Object)"bill_state", approvedBillState);
        MasterPlanEntity entity = (MasterPlanEntity)((Object)this.service.getOne((Wrapper)queryWrapper));
        if (null == entity) {
            resp.setTotal(0L);
            resp.setSize((long)pageSize.intValue());
            resp.setCurrent((long)pageNumber.intValue());
            resp.setRecords(new ArrayList());
            resp.setPages(0L);
        } else {
            queryParam.getParams().put("materialMasterPlanId", new Parameter("eq", (Object)entity.getId()));
            CommonResponse categoryIdList = this.shareMaterialApi.queryUnenabledCategoryListId();
            if (categoryIdList.getCode() == 0) {
                List data = (List)categoryIdList.getData();
                queryParam.getParams().put("materialCategoryId", new Parameter("not_in", (Object)data));
            }
            IPage pageData = this.masterPlanDetailService.queryPage(queryParam, false);
            resp.setPages(pageData.getPages());
            resp.setCurrent(pageData.getCurrent());
            resp.setTotal(pageData.getTotal());
            resp.setSize(pageData.getSize());
            List dataList = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
                dataList = BeanMapper.mapList((Iterable)pageData.getRecords(), MasterPlanDetailRefVO.class);
            }
            resp.setRecords(dataList);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)resp);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/planMaterialListRefer"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MasterPlanDetailRefVO>> planMaterialListRefer(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        Page resp = new Page();
        QueryParam queryParam = new QueryParam();
        queryParam.setSearchText(searchText);
        queryParam.setSearchObject(searchObject);
        queryParam.getFuzzyFields().add("material_category_name");
        queryParam.getFuzzyFields().add("material_name");
        queryParam.getFuzzyFields().add("spec");
        queryParam.getOrderMap().put("id", "asc");
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setPageIndex(pageNumber.intValue());
        if (StringUtils.isBlank((CharSequence)condition)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u53c2\u6570condition\u4e2d\u7f3a\u5c11\u9879projectId\uff01");
        }
        Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
        if (null == conditionMap.get("projectId")) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u53c2\u6570condition\u4e2d\u7f3a\u5c11\u9879projectId\uff01");
        }
        if (null == conditionMap.get("planType")) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u53c2\u6570condition\u4e2d\u7f3a\u5c11\u9879planType\uff01");
        }
        if (null == conditionMap.get("postbytopictype") || !conditionMap.get("postbytopictype").equals(1)) {
            queryParam.getParams().put("materialId1", new Parameter("sql", (Object)"material_id is not null"));
        }
        ArrayList<Integer> approvedBillState = new ArrayList<Integer>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_id", conditionMap.get("projectId"));
        queryWrapper.eq((Object)"plan_type", conditionMap.get("planType"));
        approvedBillState.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        approvedBillState.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        queryWrapper.in((Object)"bill_state", approvedBillState);
        MasterPlanEntity entity = (MasterPlanEntity)((Object)this.service.getOne((Wrapper)queryWrapper));
        if (null == entity) {
            resp.setTotal(0L);
            resp.setSize((long)pageSize.intValue());
            resp.setCurrent((long)pageNumber.intValue());
            resp.setRecords(new ArrayList());
            resp.setPages(0L);
        } else {
            queryParam.getParams().put("materialMasterPlanId", new Parameter("eq", (Object)entity.getId()));
            IPage pageData = this.masterPlanDetailService.queryPage(queryParam, false);
            resp.setPages(pageData.getPages());
            resp.setCurrent(pageData.getCurrent());
            resp.setTotal(pageData.getTotal());
            resp.setSize(pageData.getSize());
            List dataList = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
                dataList = BeanMapper.mapList((Iterable)pageData.getRecords(), MasterPlanDetailRefVO.class);
            }
            resp.setRecords(dataList);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)resp);
    }

    @GetMapping(value={"/getContrastInfo"})
    @ResponseBody
    public CommonResponse<List<MasterPlanContrastV0>> getContrastInfo(@RequestParam(value="materialMasterPlanId") Long materialMasterPlanId, @RequestParam(value="oldMaterialMasterPlanId") Long oldMaterialMasterPlanId) {
        List<MasterPlanContrastV0> list = this.service.getContrastInfo(materialMasterPlanId, oldMaterialMasterPlanId);
        return CommonResponse.success((String)"\u83b7\u53d6\u5bf9\u6bd4\u6570\u636e\u6210\u529f\uff01", list);
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("planType", new Parameter("eq", (Object)PlanTypeEnum.\u6d88\u8017\u6750.getCode()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap beans = new HashMap();
        ArrayList<MasterPlanExportVO> voList = new ArrayList<MasterPlanExportVO>();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (MasterPlanEntity val : list) {
                MasterPlanExportVO vo = (MasterPlanExportVO)BeanMapper.map((Object)((Object)val), MasterPlanExportVO.class);
                if (val.getBillDate() != null) {
                    vo.setBillDate(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)val.getBillDate()));
                }
                switch (val.getChangeState()) {
                    case 0: {
                        vo.setChangeState("\u672a\u53d8\u66f4");
                        break;
                    }
                    case 1: {
                        vo.setChangeState("\u53d8\u66f4\u4e2d");
                        break;
                    }
                    case 2: {
                        vo.setChangeState("\u5df2\u53d8\u66f4");
                    }
                }
                vo.setBillState(BillStateEnum.getEnumByStateCode((Integer)val.getBillState()).getDescription());
                voList.add(vo);
            }
        }
        beans.put("records", voList);
        ExcelExport.getInstance().export("MasterPlan-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u6df7\u6ce5\u571f\u5bfc\u51fa")
    @RequestMapping(value={"/excelConcreteExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelConcreteExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("planType", new Parameter("eq", (Object)PlanTypeEnum.\u6df7\u6ce5\u571f.getCode()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap beans = new HashMap();
        ArrayList voList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            list.forEach(val -> {
                MasterPlanExportVO vo = (MasterPlanExportVO)BeanMapper.map((Object)val, MasterPlanExportVO.class);
                if (val.getBillDate() != null) {
                    vo.setBillDate(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)val.getBillDate()));
                }
                switch (val.getChangeState()) {
                    case 0: {
                        vo.setChangeState("\u672a\u53d8\u66f4");
                        break;
                    }
                    case 1: {
                        vo.setChangeState("\u53d8\u66f4\u4e2d");
                        break;
                    }
                    case 2: {
                        vo.setChangeState("\u5df2\u53d8\u66f4");
                    }
                }
                vo.setBillState(BillStateEnum.getEnumByStateCode((Integer)val.getBillState()).getDescription());
                voList.add(vo);
            });
        }
        beans.put("records", voList);
        ExcelExport.getInstance().export("ConcreteMasterPlan-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/targetCostCtrl"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> targetCostCtrl(@RequestBody MasterPlanVO masterPlanVo) {
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)this.service.targetCostCtrl(masterPlanVo));
    }

    @GetMapping(value={"/viewTargetCostCtrlInfo"})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> viewTargetCostCtrlInfo(@RequestParam(value="id") Long id) {
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)this.service.viewTargetCostCtrlInfo(id));
    }

    @RequestMapping(value={"/pushTargetCost"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> pushTargetCost(Long id) {
        return this.service.pushTargetCost(id);
    }
}

