package com.ejianc.business.promaterial.check.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.check.bean.CheckEntity;
import com.ejianc.business.promaterial.check.mapper.CheckMapper;
import com.ejianc.business.promaterial.check.service.ICheckService;
import com.ejianc.business.promaterial.check.service.impl.CheckBpmServiceImpl;
import com.ejianc.business.promaterial.check.service.impl.CheckServiceImpl;
import com.ejianc.business.promaterial.check.service.impl.ConcreteCheckBpmServiceImpl;
import com.ejianc.business.promaterial.check.vo.*;
import com.ejianc.business.promaterial.contract.vo.MaterialMnyVO;
import com.ejianc.business.promaterial.contract.vo.ReferenceDetailVO;
import com.ejianc.business.promaterial.contract.vo.ReferenceMapVO;
import com.ejianc.business.promaterial.enums.BillPushStatusEnum;
import com.ejianc.business.promaterial.different.vo.DifferentVO;
import com.ejianc.business.promaterial.settlement.vo.SettlementVO;
import com.ejianc.business.promaterial.utils.DateUtils;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.metadata.api.IMdApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.foundation.share.vo.SupplierProVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 消耗材-验收主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("check")
@Api(value = "消耗材-验收主表", tags = {"消耗材-验收主表"})
public class CheckController implements Serializable {
	private static final long serialVersionUID = 1L;
    @Autowired
    private IShareCooperateApi shareCooperateApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "XHC-CHECK-CODE";//此处需要根据实际修改
    private static final String BILL_TYPE = "BT220215000000006";//此处需要根据实际修改
    /**
     * 单据分享移动端前端路由地址
     */
    private final String mobileBillShareFrontUrl = "/ejc-supbusiness-mobile/#/proMaterial/check/card";
    ;

    @Autowired
    private ICheckService service;
    @Autowired
    private CheckServiceImpl serviceimpl;
    @Autowired
    private CheckBpmServiceImpl checkBpmService;
    @Autowired
    private ConcreteCheckBpmServiceImpl concreteCheckBpmService;
    @Autowired
    private IProSupplierApi proSupplierApi;
    private static final String PUSH_SAVE_URL = "/ejc-supbusiness-web/openapi/materialCheck/saveCheck";

    @Autowired
    ICommonBusinessService check;
    @Autowired
    private SessionManager sessionManager;

    @Value("${common.env.base-host}")
    private String BaseHost;
    @Autowired
    private IMdApi mdApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private CheckMapper checkMapper;


    @RequestMapping(value = "/test", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> test(@RequestParam Long id) {
//        CommonResponse<String> stringCommonResponse = check.afterApprovalProcessor(id, null, null);
        CommonResponse<String> stringCommonResponse = concreteCheckBpmService.afterApprovalProcessor(id, null, null);
        return stringCommonResponse;
    }
    @ApiOperation("同步目标成本接口")
    @RequestMapping(value = "/syncCost", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> syncCost(@RequestParam Long id) {
        CheckEntity checkEntity = service.syncCost(id);
        return CommonResponse.success("同步成功");
    }


    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CheckVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody CheckVO saveOrUpdateVO) {
        List<Long> usedIds = new ArrayList();
        List<Long> unuseIds = new ArrayList();
        List<CheckDetailVO> detailList = saveOrUpdateVO.getCheckDetailList();
        if (ListUtil.isNotEmpty(detailList)) {
            detailList.forEach(sub -> {
                if (null != sub.getSourceMainId()) {
                    if ("del".equals(sub.getRowState())) {
                        unuseIds.add(sub.getSourceMainId());
                    } else {
                        usedIds.add(sub.getSourceMainId());
                    }
                }
            });
        }
        CheckVO vo = service.saveOrUpdates(saveOrUpdateVO, false);

        serviceimpl.updSmartStore(usedIds,unuseIds);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    @ApiOperation("消耗材-更新合同和物资明细返回税率和单价")
    @RequestMapping(value = "/getRateAndPrice", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CheckVO> getRateAndPrice(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody CheckVO saveOrUpdateVO) {
        CheckVO vo = service.getRateAndPrice(saveOrUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    @ApiOperation("混凝土-自制合同验收逻辑-更新合同和物资明细返回税率和单价")
    @RequestMapping(value = "/hntgetRateAndPrice", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CheckVO> hntgetRateAndPrice(@RequestParam Long sourceDetailId) {
        CheckVO vo = service.hntgetRateAndPrice(sourceDetailId);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    @ApiOperation("混凝土-基于订单验收逻辑-更新合同和物资明细返回税率和单价")
    @RequestMapping(value = "/hntOrderRateAndPrice", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CheckVO> hntOrderRateAndPrice(@RequestParam Long sourceDetailId) {
        CheckVO vo = service.hntOrderRateAndPrice(sourceDetailId);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CheckVO> queryDetail(@RequestParam Long id) {
    	CheckEntity entity = service.selectById(id);
    	CheckVO vo = BeanMapper.map(entity, CheckVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryUnapprove", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> queryUnapprove(@RequestParam Long id) {
        CommonResponse<String> stringCommonResponse = check.afterAbstainingProcessor(id, null, null);
        logger.error("---弃审结果"+ stringCommonResponse);
        return stringCommonResponse;
    }

    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryApprove", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> queryApprove(@RequestParam Long id) {
        CommonResponse<String> stringCommonResponse = check.afterApprovalProcessor(id, null, null);
        logger.error("---审批结果"+ stringCommonResponse);
        return stringCommonResponse;
    }

    @ApiOperation("获取协同链接")
    @RequestMapping(value = "/getBillShareLink", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getBillShareLink(@RequestParam Long id) {
        CheckEntity entity = service.selectById(id);
        //校验供应商
        CommonResponse<Boolean> supplierResp = proSupplierApi.whetherSupplierCoo(entity.getSupplierId());
        if (!supplierResp.isSuccess()) {
            logger.error("根据供应商主键-{}查询失败，{}", entity.getSupplierId(), supplierResp.getMsg());
            return CommonResponse.error("获取供应商信息失败！");
        }
        Boolean flag = supplierResp.getData();
        if(!flag){
            return CommonResponse.error("该供应商未开通协同权限，无法协同验收。 请先到供应商库—生成协同账号再进行订单操作。");
        }

        // 没有推送成功，则需要重新推送数据
        if (BillPushStatusEnum.未成功推送.getStatus().equals(entity.getBillPushFlag())) {
            //查询该单据是否支持协同分享，则向供方协同服务推送该单据
            CommonResponse<CooperateVO> cooperateResp = shareCooperateApi.queryCooperateBybillTypeCode(BILL_TYPE);
            if (!cooperateResp.isSuccess()) {
                logger.error("根据单据类型-{}查询其协同配置信息失败, 不进行单据推送操作，{}", BILL_TYPE, cooperateResp.getMsg());
                return CommonResponse.error("单据推送供方失败，生成分享连接失败！");
            }
            else {
                //未曾成功推送单据，则先向供方推送单据
                //推送供方处理
                SupplierPushCheckVO supplierPushCheckVO = BeanMapper.map(entity, SupplierPushCheckVO.class);
                supplierPushCheckVO.setSourceId(entity.getId());
                List<SupplierPushCheckDetailVO> checkDetailList = supplierPushCheckVO.getCheckDetailList();
                for (SupplierPushCheckDetailVO supplierPushCheckDetailVO : checkDetailList) {
                    supplierPushCheckDetailVO.setSourceId(entity.getId());
                    supplierPushCheckDetailVO.setSourcedetailId(supplierPushCheckDetailVO.getId());
                    supplierPushCheckDetailVO.setId(null);
                }
                //设置单据当前系统信息
                CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
                if (!ejcCloudSystemCode.isSuccess()) {
                    return CommonResponse.error("获取当前系统编码失败" + ejcCloudSystemCode.getMsg());
                }
                //设置当前系统ID
                supplierPushCheckVO.setSystemId(ejcCloudSystemCode.getData());
                String dataInfo = JSONObject.toJSONString(supplierPushCheckVO);
                boolean pushResult = service
                        .pushBillToSupCenter(dataInfo, entity.getSupplierId(), entity.getId(), BILL_TYPE, cooperateResp
                                .getData(), PUSH_SAVE_URL);
                if (!pushResult) {
                    logger.error("单据-{}推送给供应商supplierId-{}失败！", id, entity.getSupplierId());
                    return CommonResponse.error("单据推送供方失败，生成分享连接失败！");
                }
                else {
                    entity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
                    service.saveOrUpdate(entity, false);
                }
            }
        }
        return shareCooperateApi
                .getShareLink(id, BILL_TYPE, entity.getSupplierId().toString(), mobileBillShareFrontUrl, null);
    }
    /**
     * 供方签字确认信息回写
     *
     * @param request
     * @return
     */
    @PostMapping(value = "/supSignSync")
    @ResponseBody
    public CommonResponse<String> supSignSync(HttpServletRequest request) {
        String msg = service.updateBillSupSignSyncInfo(request);
        if (StringUtils.isNotBlank(msg)) {
            return CommonResponse.error(msg);
        }
        return CommonResponse.success("签字状态回写成功！");
    }
    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CheckVO> vos) {
        service.deletes(vos);
        return CommonResponse.success("删除成功！");
    }
    @ApiOperation("根据明细信息填充数据,返回")
    @RequestMapping(value = "/getDetailListData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CheckVO> getDetailListData(@RequestBody CheckVO checkVO) {
        return CommonResponse.success("查询成功",service.getDetailListData(checkVO));
    }
    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/deletssse", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> deletesss(@RequestParam Long billId) {
        checkBpmService.afterApprovalProcessor(billId,null,"BILL_TYPE");
//        concreteCheckBpmService.afterApprovalProcessor(billId,null,"BT220224000000004");
        return null;
    }
//    @ApiOperation("批量删除单据")
//    @RequestMapping(value = "/deletesss1", method = RequestMethod.GET)
//    @ResponseBody
//    public CommonResponse<String> deletesss1(@RequestParam Long billId) {
////        checkBpmService.afterAbstainingProcessor(billId,null,null);
//        concreteCheckBpmService.afterAbstainingProcessor(billId,null,null);
//        return null;
//    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CheckVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("checkerName");
        fuzzyFields.add("checkDate");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("storeName");
        fuzzyFields.add("licensePlate");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));


        if (param.getParams().containsKey("hasContract")){
            //1 有合同 2 无合同
            String hasContract  = param.getParams().get("hasContract").getValue().toString();
            if (hasContract.equals("1")){
                param.getParams().put("contractId1", new Parameter(QueryParam.SQL,"contract_id is not null"));
            }
            if (hasContract.equals("2")){
                param.getParams().put("contractId1", new Parameter(QueryParam.SQL,"contract_id is  null"));
            }
            param.getParams().remove("hasContract");

        }

        List<OrgVO> orgVOList = null;
        if(!param.getParams().containsKey("orgId")){//PC端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if(5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if(CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if(CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
            /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        }
        IPage<CheckEntity> page = service.queryPage(param,false);
        IPage<CheckVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), CheckVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * 成本改造
     * 关联保存接口
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/pushCost", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CheckVO> pushCost(@RequestBody CheckVO checkVO) {
        return service.pushCost(checkVO);
    }
    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("checkerName");
        fuzzyFields.add("checkDate");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("storeName");
        fuzzyFields.add("licensePlate");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        if (param.getParams().containsKey("hasContract")){
            //1 有合同 2 无合同
            String hasContract  = param.getParams().get("hasContract").getValue().toString();
            if (hasContract.equals("1")){
                param.getParams().put("contractId1", new Parameter(QueryParam.SQL,"contract_id is not null"));
            }
            if (hasContract.equals("2")){
                param.getParams().put("contractId1", new Parameter(QueryParam.SQL,"contract_id is  null"));
            }
            param.getParams().remove("hasContract");

        }
        List<OrgVO> orgVOList = null;
        if(!param.getParams().containsKey("orgId")){//PC端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if(5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if(CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if(CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
            /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        }
        param.setPageIndex(1);
        param.setPageSize(-1);

        List<CheckEntity> list = service.queryList(param);
        List<CheckVO> listVo = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(list)){
            listVo = BeanMapper.mapList(list, CheckVO.class);
            listVo.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
//                入库方式，0-收料入库，1-直入直出
                if(vo.getStoreType() != null) {
                    vo.setStoreTypeName(vo.getStoreType() == 0 ? "收料入库" : "直入直出");
                }
                //验收来源，0-自制验收,1-发货验收
                if(vo.getSourceType() != null) {
                    vo.setSourceTypeName(vo.getSourceType() == 0 ? "自制验收" : "订单验收");
                }
                //仓库属性 1-自购材；2-甲供材
                if(vo.getAttrFlag() != null) {
                    vo.setAttrFlagName(vo.getAttrFlag() == 1 ? "自购材" : "甲供材");
                }
                //是否补录，0-否，1-是
                if(vo.getRecordFlag() != null) {
                    vo.setRecordFlagName(vo.getRecordFlag() == 0 ? "否" : "是");
                }
                // 签字状态：0-未签字,1-已签字
                if(vo.getSignStatus() != null) {
                    vo.setSignStatusName(vo.getSignStatus() == 0 ? "未签字" : "已签字");
                }
            });

        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", listVo);
        ExcelExport.getInstance().export("checkExport.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refCheckData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<CheckVO>> refCheckData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<CheckEntity> page = service.queryPage(param,false);
        IPage<CheckVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CheckVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    @RequestMapping(value = "/targetCostCtrl", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> targetCostCtrl(@RequestBody CheckVO checkVO) {
        return CommonResponse.success("目标成本控制成功！", service.targetCostCtrl(checkVO));
    }

    @GetMapping(value = "/viewTargetCostCtrlInfo")
    @ResponseBody
    public CommonResponse<ParamsCheckVO> viewTargetCostCtrlInfo(@RequestParam(value = "id") Long id) {
        return CommonResponse.success("目标成本控制成功！", service.viewTargetCostCtrlInfo(id));
    }
    /**
     * 单据管控-
     * @return
     */
    @RequestMapping(value = "/checkParams", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody CheckVO checkVO) {
        ParamsCheckVO paramsCheckVO = service.checkParams(checkVO,null);
        return CommonResponse.success("参数校验成功！",paramsCheckVO );
    }
    /**
     * 磅单验收
     * @return
     */
    @RequestMapping(value = "/queryDetailWeigh", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CheckVO> queryDetailWeigh(@RequestBody CheckVO vo) {
        CheckVO checkVO = service.queryDetailWeigh(vo);
        return CommonResponse.success("参数校验成功！",checkVO );
    }


    // 一建BI大屏-材料近30天进场情况
    @RequestMapping(value = "/queryMaterialMnyOfCheck", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<MaterialMnyVO>> queryMaterialMnyOfCheck(@RequestParam(value = "orgId", required = false) Long orgId) {
        return service.queryMaterialMnyOfCheck(orgId);
    }





    /**
     * 查看引用代码开始------------------
     */

    @GetMapping(value = "/getReferenceMap")
    @ResponseBody
    public CommonResponse<List<ReferenceMapVO>> getReferenceMap(@RequestParam String type,
                                                                @RequestParam Long id) {
        //准备查询参数
//      Map<billTypeCode, selectSql>
        Map<String, String> queryParam = getQueryDataParam(id.toString());

        //查询匹配的数据
        CommonResponse<Map<String, List<JSONObject>>> dataResp = mdApi.queryDataList(queryParam);
        if(!dataResp.isSuccess()) {
            logger.error("根据合同id-{}获取引用单据信息列表失败{}", id, dataResp.getMsg());
            return CommonResponse.error("查询引用结算单的单据信息列表失败！");
        }

        //匹配数据转换
        List<ReferenceMapVO> resp = getReferenceMapData(dataResp.getData());

        return CommonResponse.success(resp);
    }

    private Map<String, String> getQueryDataParam(String id) {
        Map<String, String> queryParam = new HashMap<>();
        StringBuilder sp = new StringBuilder();

        //查询引用合同的验收单
//        sp.append("SELECT  id, create_user_code, create_time, bill_code, org_name,bill_state,check_all_tax_mny as mny  FROM `ejc_promaterial_check`\n" +
//                "where dr = 0 and contract_id =  ")
//                .append(id);
//        queryParam.put("BT220215000000006", sp.toString());
        //查询引用合同的领料出库
//        sp = new StringBuilder();
//        sp.append("SELECT id, create_user_code, create_time, bill_code, org_name,bill_state,total_tax_mny as mny FROM `ejc_prosub_oldjob_registration` where dr = 0 and contract_id = ")
//                .append(id);
//        queryParam.put("BT211230000000003", sp.toString());


        //查询引用合同的对账单
        sp = new StringBuilder();
        sp.append("SELECT  id, create_user_code, create_time, bill_code, org_name,bill_state,reconciliation_tax_mny as mny  FROM `ejc_promaterial_reconciliation`\n" +
                "where id in (select DISTINCT reconciliation_id from ejc_promaterial_reconciliation_detail where source_id =")
                .append(id)
                .append("  and dr = 0) and dr = 0 ");
        queryParam.put("BT220310000000001", sp.toString());

        //查询引用合同的采购结算单
        sp = new StringBuilder();
        sp.append("SELECT  id, create_user_code, create_time, bill_code, org_name,bill_state,settlement_tax_mny as mny  FROM `ejc_promaterial_settlement`\n" +
                "where id in (select DISTINCT settlement_id from ejc_promaterial_settlement_detail where source_id = ")
                .append(id)
                .append("  and dr = 0) and dr = 0 ");
        queryParam.put("BT220309000000003", sp.toString());

        //查询引用结算单的成本归集单列表
        sp = new StringBuilder();
        sp.append("select id, create_user_code, create_time, project_name AS bill_code, parent_org_name,bill_state,cost_mny as mny  from ejc_procost_share ")
                .append(" where id in (select DISTINCT share_id from ejc_procost_share_detail where source_id = ")
                .append(id).append(" and dr = 0) and dr = 0");
        queryParam.put("BT220316000000002", sp.toString());

        //查询引用结算单的付款申请单列表
        sp = new StringBuilder();
        sp.append("select id, create_user_code, create_time, bill_code, parent_org_name,bill_state,payment_contract_flag,apply_mny as mny  from ejc_payment_apply ")
                .append("where id in (select DISTINCT pay_id from ejc_payment_apply_detail where source_id = ")
                .append(id).append(" and dr =0 ) and dr = 0");
        queryParam.put("BT220223000000003", sp.toString());

        return queryParam;
    }



    private List<ReferenceMapVO> getReferenceMapData(Map<String, List<JSONObject>> data) {
        List<ReferenceMapVO> resp = new ArrayList<>();
        ReferenceMapVO tmp = null;
        ReferenceDetailVO tmpDetail = null;
        List<JSONObject> dataList = null;

        Set<String> userCodes = new HashSet<>();
        for(String billType : data.keySet()) {
            dataList = data.get(billType);
            if(CollectionUtils.isNotEmpty(dataList)) {
                String billName = "";
                String billUrl = "";
                switch (billType){
                    case "BT220215000000006":
                        billName = "验收单";
                        billUrl = "ejc-promaterial-frontend/#/check/card?id=";
                        break;
//                    case "BT211230000000003":
//                        billName = "领料出库";
//                        billUrl = "ejc-promaterial-frontend/#/registration/card?id=";
//                        break;
                    case "BT220310000000001":
                        billName = "对账单";
                        billUrl = "ejc-promaterial-frontend/#/reconciliation/card?id=";
                        break;
                    case "BT220309000000003":
                        billName = "采购结算单";
                        billUrl = "ejc-promaterial-frontend/#/settlementList/settlementCard?id=";
                        break;
                    case "BT220316000000002":
                        billName = "成本归集单";
                        billUrl = "ejc-share-frontend/#/costShare/card?id=";
                        break;
                    case "BT220223000000003":
                        billName = "有合同付款申请";
                        billUrl = "ejc-profinance-frontend/#/paymentList/contractCard?id=";
                        break;
                }

                tmp = new ReferenceMapVO();
                tmp.setId(billType); //数据唯一标识
                tmp.setModuleName(billName); //模块名称
                tmp.setReferenceNum(dataList.size()); //引用单据数量
                BigDecimal sumMny = new BigDecimal(0);
                for(JSONObject dataRow : dataList) {
                    tmpDetail = new ReferenceDetailVO();
                    tmpDetail.setId(dataRow.getString("id")); //数据唯一标识
                    tmpDetail.setBillCode(dataRow.getString("bill_code")); //单据编码
                    tmpDetail.setBillState(BillStateEnum.getEnumByStateCode(dataRow.getInteger("bill_state")).getDescription()); //单据审批状态
                    tmpDetail.setCreateTime(dataRow.getDate("create_time")); //制单时间
                    tmpDetail.setEmployeeName(dataRow.getString("create_user_code")); //制单人
                    tmpDetail.setModuleName(tmp.getModuleName()); //节点名称
                    tmpDetail.setOrgName(dataRow.getString("org_name")); //制单机构
                    tmpDetail.setMny(dataRow.getBigDecimal("mny")); //金额
                    //穿透详情页地址
                    tmpDetail.setDetailPcUrl(BaseHost + billUrl + tmpDetail.getId());
                    tmp.getDetailList().add(tmpDetail);
                    if(org.apache.commons.lang3.StringUtils.isNotBlank(tmpDetail.getEmployeeName())) {
                        userCodes.add(tmpDetail.getEmployeeName());
                    }

                    if (tmpDetail.getMny() != null) {
                        sumMny = sumMny.add(dataRow.getBigDecimal("mny"));
                    }

                }
                //单据的总金额
                tmp.setSumMny(sumMny);
                resp.add(tmp);
            }
        }

        //根据制单人编码查询制单人信息
        if(CollectionUtils.isNotEmpty(userCodes)) {
            CommonResponse<List<UserVO>> userResp = userApi.queryUserByUserCodes(userCodes.toArray(new String[userCodes.size()]));
            if(!userResp.isSuccess()) {
                logger.error("根据用户编码获取用户信息失败：{}", userResp.getMsg());
            } else {
                Map<String, UserVO> userMap = userResp.getData().stream().collect(Collectors.toMap(item -> item.getUserCode(), item -> item));
                resp.stream().forEach(item -> {
                    item.getDetailList().stream().forEach(detail -> {
                        if(userMap.containsKey(detail.getEmployeeName())) {
                            detail.setEmployeeName(userMap.get(detail.getEmployeeName()).getUserName());
                        }
                    });
                });
            }
        }

        return resp;
    }

    /**
     * 查看引用代码结束------------------
     */


    //物资门户-履约情况
    @GetMapping(value = "/getMaterialDesktopData")
    @ResponseBody
    public CommonResponse<List<CheckDesktopDTO>> getMaterialDesktopData(@RequestParam Long projectId) {
        Date date = new Date();
        Calendar instance = Calendar.getInstance();
        instance.setTime(date);
        instance.set(Calendar.MONTH,0);
        instance.set(Calendar.DAY_OF_MONTH,1);
        //今年
        List<CheckVO> materialDataYear = checkMapper.getMaterialDesktopData(projectId, instance.getTime());
        //累计
        instance.set(Calendar.YEAR,2000);
        List<CheckVO> materialDataAll = checkMapper.getMaterialDesktopData(projectId, instance.getTime());
        List<CheckDesktopDTO> checkDesktopDTOS = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(materialDataYear)){
            CheckDesktopDTO checkDesktopDTO = new CheckDesktopDTO();
            checkDesktopDTO.setType("本年");
            for (CheckVO checkVO : materialDataYear) {
                switch (checkVO.getCheckType()) {
                    case "contract":
                        checkDesktopDTO.setContract(checkVO.getCheckAllMny());
                        break;
                    case "change":
                        checkDesktopDTO.setChange(checkVO.getCheckAllMny());
                        break;
                    case "check":
                        checkDesktopDTO.setCheck(checkVO.getCheckAllMny());
                        break;
                    case "finance":
                        checkDesktopDTO.setFinance(checkVO.getCheckAllMny());
                        break;
                    case "setlle":
                        checkDesktopDTO.setSettle(checkVO.getCheckAllMny());
                        break;
                    case "store":
                        checkDesktopDTO.setStore(checkVO.getCheckAllMny());
                        break;
                }
            }
            checkDesktopDTO.setFinanceRate(checkDesktopDTO.getFinance().divide(checkDesktopDTO.getSettle(),4,BigDecimal.ROUND_HALF_UP));
            checkDesktopDTOS.add(checkDesktopDTO);
        }
        if (CollectionUtils.isNotEmpty(materialDataAll)){
            CheckDesktopDTO checkDesktopDTO = new CheckDesktopDTO();
            checkDesktopDTO.setType("累计");
            for (CheckVO checkVO : materialDataAll) {
                switch (checkVO.getCheckType()) {
                    case "contract":
                        checkDesktopDTO.setContract(checkVO.getCheckAllMny());
                        break;
                    case "change":
                        checkDesktopDTO.setChange(checkVO.getCheckAllMny());
                        break;
                    case "check":
                        checkDesktopDTO.setCheck(checkVO.getCheckAllMny());
                        break;
                    case "finance":
                        checkDesktopDTO.setFinance(checkVO.getCheckAllMny());
                        break;
                    case "setlle":
                        checkDesktopDTO.setSettle(checkVO.getCheckAllMny());
                        break;
                    case "store":
                        checkDesktopDTO.setStore(checkVO.getCheckAllMny());
                        break;
                }
            }
            checkDesktopDTO.setFinanceRate(checkDesktopDTO.getFinance().divide(checkDesktopDTO.getSettle(),4,BigDecimal.ROUND_HALF_UP));
            checkDesktopDTOS.add(checkDesktopDTO);
        }

        return CommonResponse.success("查询成功！",checkDesktopDTOS);
    }

    //物资门户-获取
    @GetMapping(value = "/getCheckMnyTopFiveMaterialId")
    @ResponseBody
    public CommonResponse<List<CheckDetailVO>> getCheckMnyTopFiveMaterialId(@RequestParam Long projectId,@RequestParam String dateType) {
        Date date = new Date();
        Calendar instance = Calendar.getInstance();
        instance.setTime(date);
        if("last30Days".equals(dateType)){
            instance.add(Calendar.DATE,-30);
        }else if("thisYear".equals(dateType)){
            instance.set(Calendar.MONTH,0);
            instance.set(Calendar.DAY_OF_MONTH,1);
        }
        List<CheckDetailVO> checkMnyTopFiveMaterialId = checkMapper.getCheckMnyTopFiveMaterialId(projectId, instance.getTime());
        return CommonResponse.success("查询成功！",checkMnyTopFiveMaterialId);
    }
}
