package com.ejianc.business.promaterial.loss.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.promaterial.loss.bean.LossAnalysisDetailEntity;
/**
 * 损耗分析
 * 
 * @author generator
 * 
 */
 @TableName("ejc_promaterial_loss_analysis")
public class LossAnalysisEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 
    @TableField(value="org_id")
    private Long orgId; // 项目部id
    @TableField(value="org_name")
    private String orgName; // 
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="analysis_time")
    private Date analysisTime; // 分析时间
    @TableField(value="analysis_user_id")
    private Long analysisUserId; // 统计人员
    @TableField(value="analysis_user_name")
    private String analysisUserName; // 统计人员姓名
    @TableField(value="rebar_loss_rate")
    private BigDecimal rebarLossRate; // 钢筋损耗率
    @TableField(value="concrete_loss_rate")
    private BigDecimal concreteLossRate; // 混凝土损耗率
    @TableField(value="plan_num")
    private BigDecimal planNum; // 计划总量
    @TableField(value="actual_num")
    private BigDecimal actualNum; // 实际总量
    @TableField(value="bill_date")
    private Date billDate; // 业务日期
    @TableField(value="analysis_name")
    private String analysisName; // 分析主题
    
    @TableField(exist=false)
    @SubEntity(serviceName="lossAnalysisDetailService")
    private List<LossAnalysisDetailEntity> lossAnalysisDetailList = new ArrayList<>(); // 损耗分析明细


    public BigDecimal getPlanNum() {
        return planNum;
    }

    public void setPlanNum(BigDecimal planNum) {
        this.planNum = planNum;
    }

    public BigDecimal getActualNum() {
        return actualNum;
    }

    public void setActualNum(BigDecimal actualNum) {
        this.actualNum = actualNum;
    }

    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }

    public String getAnalysisName() {
        return analysisName;
    }

    public void setAnalysisName(String analysisName) {
        this.analysisName = analysisName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Date getAnalysisTime() {
        return analysisTime;
    }

    public void setAnalysisTime(Date analysisTime) {
        this.analysisTime = analysisTime;
    }
    public Long getAnalysisUserId() {
        return analysisUserId;
    }

    public void setAnalysisUserId(Long analysisUserId) {
        this.analysisUserId = analysisUserId;
    }
    public String getAnalysisUserName() {
        return analysisUserName;
    }

    public void setAnalysisUserName(String analysisUserName) {
        this.analysisUserName = analysisUserName;
    }
    public BigDecimal getRebarLossRate() {
        return rebarLossRate;
    }

    public void setRebarLossRate(BigDecimal rebarLossRate) {
        this.rebarLossRate = rebarLossRate;
    }
    public BigDecimal getConcreteLossRate() {
        return concreteLossRate;
    }

    public void setConcreteLossRate(BigDecimal concreteLossRate) {
        this.concreteLossRate = concreteLossRate;
    }
    

    public List<LossAnalysisDetailEntity> getLossAnalysisDetailList() {
        return lossAnalysisDetailList;
    }

    public void setLossAnalysisDetailList(List<LossAnalysisDetailEntity> lossAnalysisDetailList) {
        this.lossAnalysisDetailList = lossAnalysisDetailList;
    }
}
