/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.loss.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.loss.bean.LossAnalysisEntity;
import com.ejianc.business.promaterial.loss.service.ILossAnalysisService;
import com.ejianc.business.promaterial.loss.vo.LossAnalysisDetailVO;
import com.ejianc.business.promaterial.loss.vo.LossAnalysisVO;
import com.ejianc.business.promaterial.utils.DetailIndexExcelReaderZzyj;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"lossAnalysis"})
public class LossAnalysisController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "lossAnalysis_Code";
    @Autowired
    private ILossAnalysisService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<LossAnalysisVO> saveOrUpdate(@RequestBody LossAnalysisVO saveOrUpdateVO) {
        LossAnalysisEntity entity = (LossAnalysisEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, LossAnalysisEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        LossAnalysisVO vo = (LossAnalysisVO)BeanMapper.map((Object)((Object)entity), LossAnalysisVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<LossAnalysisVO> queryDetail(Long id) {
        LossAnalysisEntity entity = (LossAnalysisEntity)((Object)this.service.selectById(id));
        LossAnalysisVO vo = (LossAnalysisVO)BeanMapper.map((Object)((Object)entity), LossAnalysisVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<LossAnalysisVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (LossAnalysisVO lossAnalysisVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<LossAnalysisVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), LossAnalysisVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("LossAnalysis-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refLossAnalysisData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<LossAnalysisVO>> refLossAnalysisData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), LossAnalysisVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/downloadInfo"})
    @ResponseBody
    public void downloadMaterial(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"LossAnalysis-import.xlsx", (String)"\u793e\u4fdd\u8c03\u6574\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportMaterial"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportMaterial(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="companyId", required=true) Long companyId) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList successList = new ArrayList();
        ArrayList<LossAnalysisDetailVO> errorList = new ArrayList<LossAnalysisDetailVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List<List<String>> result = DetailIndexExcelReaderZzyj.readExcel(mf);
        if (result != null && result.size() > 0) {
            List<String> datas;
            int i;
            ArrayList<String> idCardList = new ArrayList<String>();
            for (i = 0; i < result.size(); ++i) {
                datas = result.get(i);
                idCardList.add(datas.get(1).trim());
            }
            for (i = 0; i < result.size(); ++i) {
                datas = result.get(i);
                LossAnalysisDetailVO lossAnalysisDetailVO = new LossAnalysisDetailVO();
                String partCode = datas.get(1).trim();
                String partName = datas.get(2).trim();
                String materialCategory = datas.get(3).trim();
                String materialCode = datas.get(4).trim();
                String materialName = datas.get(5).trim();
                String spec = datas.get(6).trim();
                String unit = datas.get(7).trim();
                lossAnalysisDetailVO.setPartCode(partCode);
                lossAnalysisDetailVO.setPartName(partName);
                lossAnalysisDetailVO.setMaterialCategory(materialCategory);
                lossAnalysisDetailVO.setMaterialCode(materialCode);
                lossAnalysisDetailVO.setMaterialName(materialName);
                lossAnalysisDetailVO.setSpec(spec);
                lossAnalysisDetailVO.setUnit(unit);
                try {
                    String planNum = datas.get(8);
                    lossAnalysisDetailVO.setPlanNum(StringUtils.isNotBlank((CharSequence)planNum) ? new BigDecimal(planNum) : null);
                }
                catch (Exception e) {
                    lossAnalysisDetailVO.setErrorMsg("\u8ba1\u5212\u7528\u91cf\u6570\u636e\u9519\u8bef\uff01");
                    errorList.add(lossAnalysisDetailVO);
                    continue;
                }
                try {
                    String lossNum = datas.get(9);
                    lossAnalysisDetailVO.setLossNum(StringUtils.isNotBlank((CharSequence)lossNum) ? new BigDecimal(lossNum) : null);
                }
                catch (Exception e) {
                    lossAnalysisDetailVO.setErrorMsg("\u8ba1\u5212\u635f\u8017\u6570\u636e\u9519\u8bef\uff01");
                    errorList.add(lossAnalysisDetailVO);
                    continue;
                }
                try {
                    String lossMny = datas.get(10);
                    lossAnalysisDetailVO.setLossMny(StringUtils.isNotBlank((CharSequence)lossMny) ? new BigDecimal(lossMny) : null);
                }
                catch (Exception e) {
                    lossAnalysisDetailVO.setErrorMsg("\u8ba1\u5212\u91d1\u989d\u6570\u636e\u9519\u8bef\uff01");
                    errorList.add(lossAnalysisDetailVO);
                    continue;
                }
                try {
                    String lossRate = datas.get(11);
                    lossAnalysisDetailVO.setLossRate(StringUtils.isNotBlank((CharSequence)lossRate) ? new BigDecimal(lossRate) : null);
                    continue;
                }
                catch (Exception e) {
                    lossAnalysisDetailVO.setErrorMsg("\u8ba1\u5212\u635f\u8017\u7387\u6570\u636e\u9519\u8bef\uff01");
                    errorList.add(lossAnalysisDetailVO);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }
}

