package com.ejianc.business.promaterial.pricelib.mapper;

import com.ejianc.business.promaterial.check.bean.CheckDetailEntity;
import com.ejianc.business.promaterial.check.bean.CheckEntity;
import com.ejianc.business.promaterial.check.bean.ConcreteCheckDetailEntity;
import com.ejianc.business.promaterial.check.bean.ConcreteCheckEntity;
import com.ejianc.business.promaterial.contract.bean.ContractDetailEntity;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.promaterial.pricelib.bean.PriceCheckEntity;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.Date;
import java.util.List;

/**
 * 价格库-验收明细
 * 
 * @author generator
 * 
 */
@Mapper
public interface PriceCheckMapper extends BaseCrudMapper<PriceCheckEntity> {
    @Select("select * from ejc_promaterial_check where create_time >= #{time} or update_time >= #{time}")
    List<CheckEntity> getCheckListByTime(@Param("time")Date time);
    @Select({
            "<script>",
            "select * from ejc_promaterial_check_detail where check_id in",
            "<foreach collection='checkIdList' item='checkId' open='(' separator=',' close=')'>",
            "#{checkId}",
            "</foreach>",
            "</script>"
    })
    List<CheckDetailEntity> getCheckDetailListByContractId(@Param("checkIdList")List<Long> checkIdList);

    @Delete("delete from ejc_promaterial_price_check where bill_state not in (1,3)")
    void delPriceContractByBillState();

    @Delete({
            "<script>",
            "delete from ejc_promaterial_price_check where id in",
            "<foreach collection='ids' item='id' open='(' separator=',' close=')'>",
            "#{id}",
            "</foreach>",
            "</script>"
    })
    void delPriceCheckByIds(@Param("ids") List<Long> ids);
    @Select("select * from ejc_promaterial_concrete_check where create_time >= #{time} or update_time >= #{time}")
    List<ConcreteCheckEntity> getConcreteCheckListByTime(@Param("time")Date time);
    @Select({
            "<script>",
            "select * from ejc_promaterial_concrete_check_detail where check_id in",
            "<foreach collection='checkIdList' item='checkId' open='(' separator=',' close=')'>",
            "#{checkId}",
            "</foreach>",
            "</script>"
    })
    List<ConcreteCheckDetailEntity> getConcreteCheckDetailListByContractId(@Param("checkIdList")List<Long> checkIdList);
}
