package com.ejianc.business.promaterial.out.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.promaterial.out.bean.OutStoreSubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 领料出库
 * 
 * @author generator
 * 
 */
 @TableName("ejc_promaterial_out_store")
public class OutStoreEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="bill_code")
    private String billCode; // 出库单号
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="out_date")
    private Date outDate; // 领料日期
    @TableField(value="store_id")
    private Long storeId; // 出库仓库id
    @TableField(value="store_name")
    private String storeName; // 出库仓库名称
    @TableField(value="material_names")
    private String materialNames; // 出库物资名称集合
    @TableField(value="out_num")
    private BigDecimal outNum; // 出库数量
    @TableField(value="out_mny")
    private BigDecimal outMny; // 出库金额
    @TableField(value="out_tax_mny")
    private BigDecimal outTaxMny; // 出库金额含税
    @TableField(value="use_for")
    private String useFor; // 用处
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="employee_id")
    private Long employeeId; // 经办人id
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_code")
    private String projectCode; // 所属项目编码
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="sub_contract_id")
    private Long subContractId; // 合同id
    @TableField(value="sub_contract_name")
    private String subContractName; // 合同名称
    @TableField(value="sub_supplier_name")
    private String subSupplierName; // 分包单位
    @TableField(value="sub_supplier_id")
    private Long subSupplierId; // 供应商id
    @TableField(value="sub_employee_name")
    private String subEmployeeName; // 分包负责人
    @TableField(value="sub_employee_mobile")
    private String subEmployeeMobile; // 分包负责人电话
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部上级组织Id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织编码
    @TableField(value="contract_code")
    private String contractCode; // 合同code
    @TableField(value="department_id")
    private Long departmentId; // 经办部门
    @TableField(value="department_name")
    private String departmentName; // 经办部门名称
    @TableField(value="sign_status")
    private Integer signStatus; // 签字状态，0-未签字,1-已签字
    @TableField(value="attr_flag")
    private Integer attrFlag; // 仓库属性 1-自购材；2-甲供材
    @TableField(value="relation_flag")
    private String relationFlag; // 关联状态(1:是，0：否)
    @TableField(value="proportion_flag")
    private String proportionFlag; // 分摊状态(1:是，0：否)
    @TableField(value="claim_type")
    private Integer claimType; // 领料方式，1-分包领料,2-内部领料


    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    /**
     * 供方经办人名称
     */
    @TableField(value = "sup_operator_name")
    private String supOperatorName;

    /**
     * 供方经办人手机号
     */
    @TableField(value = "sup_operator_phone")
    private String supOperatorPhone;
    /**
     * 供方经办人账号
     */
    @TableField(value = "sup_operator_user_code")
    private String supOperatorUserCode;

    /**
     * 供方经办人签字时间
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @TableField(value = "sup_operate_time")
    private Date supOperateTime;

    /**
     * 供方经办人签字文件id
     */
    @TableField(exist = false)
    private Long supOperateFileId;
    /**
     * 来源业务系统id
     */
    @TableField(exist = false)
    private String systemId;

    /**
     * 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
     */
    @TableField(value = "bill_push_flag")
    private String billPushFlag;
    
    @TableField(exist=false)
    @SubEntity(serviceName="outStoreSubService",pidName = "outStoreId")//此处有pid="xxx"，默认值pid="pid"
    private List<OutStoreSubEntity> outStoreSubList = new ArrayList<>(); // 领料出库明细

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Integer getClaimType() {
        return claimType;
    }

    public void setClaimType(Integer claimType) {
        this.claimType = claimType;
    }

    public String getBillPushFlag() {
        return billPushFlag;
    }

    public void setBillPushFlag(String billPushFlag) {
        this.billPushFlag = billPushFlag;
    }

    public String getRelationFlag() {
        return relationFlag;
    }

    public void setRelationFlag(String relationFlag) {
        this.relationFlag = relationFlag;
    }

    public String getProportionFlag() {
        return proportionFlag;
    }

    public void setProportionFlag(String proportionFlag) {
        this.proportionFlag = proportionFlag;
    }

    public Integer getAttrFlag() {
        return attrFlag;
    }

    public void setAttrFlag(Integer attrFlag) {
        this.attrFlag = attrFlag;
    }

    public Integer getSignStatus() {
        return signStatus;
    }

    public void setSignStatus(Integer signStatus) {
        this.signStatus = signStatus;
    }

    public String getSupOperatorName() {
        return supOperatorName;
    }

    public void setSupOperatorName(String supOperatorName) {
        this.supOperatorName = supOperatorName;
    }

    public String getSupOperatorPhone() {
        return supOperatorPhone;
    }

    public void setSupOperatorPhone(String supOperatorPhone) {
        this.supOperatorPhone = supOperatorPhone;
    }

    public String getSupOperatorUserCode() {
        return supOperatorUserCode;
    }

    public void setSupOperatorUserCode(String supOperatorUserCode) {
        this.supOperatorUserCode = supOperatorUserCode;
    }

    public Date getSupOperateTime() {
        return supOperateTime;
    }

    public void setSupOperateTime(Date supOperateTime) {
        this.supOperateTime = supOperateTime;
    }

    public Long getSupOperateFileId() {
        return supOperateFileId;
    }

    public void setSupOperateFileId(Long supOperateFileId) {
        this.supOperateFileId = supOperateFileId;
    }

    public String getSystemId() {
        return systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Date getOutDate() {
        return outDate;
    }

    public void setOutDate(Date outDate) {
        this.outDate = outDate;
    }
    public Long getStoreId() {
        return storeId;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }
    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }
    public String getMaterialNames() {
        return materialNames;
    }

    public void setMaterialNames(String materialNames) {
        this.materialNames = materialNames;
    }
    public BigDecimal getOutNum() {
        return outNum;
    }

    public void setOutNum(BigDecimal outNum) {
        this.outNum = outNum;
    }
    public BigDecimal getOutMny() {
        return outMny;
    }

    public void setOutMny(BigDecimal outMny) {
        this.outMny = outMny;
    }
    public BigDecimal getOutTaxMny() {
        return outTaxMny;
    }

    public void setOutTaxMny(BigDecimal outTaxMny) {
        this.outTaxMny = outTaxMny;
    }
    public String getUseFor() {
        return useFor;
    }

    public void setUseFor(String useFor) {
        this.useFor = useFor;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getSubContractId() {
        return subContractId;
    }

    public void setSubContractId(Long subContractId) {
        this.subContractId = subContractId;
    }
    public String getSubContractName() {
        return subContractName;
    }

    public void setSubContractName(String subContractName) {
        this.subContractName = subContractName;
    }
    public String getSubSupplierName() {
        return subSupplierName;
    }

    public void setSubSupplierName(String subSupplierName) {
        this.subSupplierName = subSupplierName;
    }
    public Long getSubSupplierId() {
        return subSupplierId;
    }

    public void setSubSupplierId(Long subSupplierId) {
        this.subSupplierId = subSupplierId;
    }
    public String getSubEmployeeName() {
        return subEmployeeName;
    }

    public void setSubEmployeeName(String subEmployeeName) {
        this.subEmployeeName = subEmployeeName;
    }
    public String getSubEmployeeMobile() {
        return subEmployeeMobile;
    }

    public void setSubEmployeeMobile(String subEmployeeMobile) {
        this.subEmployeeMobile = subEmployeeMobile;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    
    public List<OutStoreSubEntity> getOutStoreSubList() {
        return outStoreSubList;
    }

    public void setOutStoreSubList(List<OutStoreSubEntity> outStoreSubList) {
        this.outStoreSubList = outStoreSubList;
    }
}
