package com.ejianc.business.promaterial.settlement.mapper;

import com.ejianc.business.promaterial.settlement.vo.SettlementDetailVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.promaterial.settlement.bean.SettlementEntity;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.math.BigDecimal;
import java.util.List;

/**
 * 结算单主表
 * 
 * @author generator
 * 
 */
@Mapper
public interface SettlementMapper extends BaseCrudMapper<SettlementEntity> {
    List<SettlementDetailVO> getDetail(@Param("contractId") Long contractId,@Param("settlementId") Long settlementId);


    @Select("SELECT IFNUll(sum(settlement_tax_mny),0) mny FROM `ejc_promaterial_settlement`\n" +
            "where project_id = #{projectId} and supplier_id = #{supplierId}\n" +
            "and contract_id is null\n" +
            "and dr = 0 ")
    BigDecimal getSumMnyBySupplier(@Param("projectId") Long projectId,@Param("supplierId") Long supplierId);
}
