package com.ejianc.business.promaterial.check.warn;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.promaterial.check.bean.CheckEntity;
import com.ejianc.business.promaterial.check.mapper.CheckMapper;
import com.ejianc.business.promaterial.check.service.ICheckService;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/**
 * @author
 * @Description:
 * @date
 */
@RestController
@RequestMapping(value = "/checkWarn/")
public class CheckWarnController {
//       * * * 26 * ?
//       {"dispatchCode":"WARNING000088"}
//    dispatchWarningHandler
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private CheckMapper dutyMapper;
    @Autowired
    private IPushMessageApi pushMessageApi;
    static  String  PC_URL_EC = "/ejc-promaterial-frontend/#/check?projectId=";
    static  String  TEST_AGENTID = "1000038";
    static  String  TEST_SECRET = "0n0MCtZ1vNtJsKQWPIREQ1UNMM8BXDkQZat6nbRqGGE";
    static  String  PRO_AGENTID = "1000036";
    static  String  PRO_SECRET = "dBMuo3hXenzW-6B3U8BfscMDQWSr3ET1nfwUaqDPi40";



    @PostMapping(value = "queryExecution")
    public CommonResponse<List<JSONObject>> queryExecution(HttpServletRequest request) {
        logger.info("消息发送前1---------------->");
        List<CheckEntity> checkWarnList = dutyMapper.getCheckWarnList();
        logger.info("消息发送前2---------------->{}",checkWarnList.size());
        //发送消息
        if(CollectionUtils.isNotEmpty(checkWarnList)) {
            for (CheckEntity taskEntity : checkWarnList) {
                sendSys(taskEntity.getEmployeeId() + "", taskEntity.getProjectName(), taskEntity.getProjectName(), taskEntity.getProjectId());
                try {
                    //睡眠0.1s
                    Thread.currentThread().sleep(100);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        return CommonResponse.success("执行成功！");
    }
    public boolean sendSys(String receiverId,String name,String projectName,Long projectId){

        PushMsgParameter parameter = new PushMsgParameter();
        List<String> channel = new ArrayList<>();
        channel.add(PushMsgParameter.CHANNEL_TYPE_WEXINEE);//发送企业微信标志
        channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
        String[] receivers = {receiverId};
        parameter.setReceivers(receivers);// 收信人
        parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
        parameter.setMsgType("earlywarning");//预警消息
        parameter.setSubject(projectName+"项目上周验收单有"+name+"条为补录数据，后续请注意及时录入验收单！");// 标题
        parameter.setContent("内容");// 内容
        parameter.setPcUrl(PC_URL_EC);// pc端url
        parameter.setMobileUrl(PC_URL_EC);// 移动端url
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        JSONObject weixineeParams = new JSONObject();
        weixineeParams.put("agentid",PRO_AGENTID);//企业微信应用id
        weixineeParams.put("secret", PRO_SECRET);//企业微信secret
        weixineeParams.put("msgtype", "textcard");
        weixineeParams.put("title", "验收滞后提醒");
        weixineeParams.put("description", projectName+"项目上周验收单有"+name+"条为补录数据，后续请注意及时录入验收单！");
        weixineeParams.put("url", ("https://pms.zzyjjt.com/portal/sso/index?&userid="+receiverId+
                "&targeturl=https%3a%2f%2fpms.zzyjjt.com%2fejc-promaterial-frontend%2f%23%2fcheck%3fprojectId%3d%0a"+projectId));//移动端点击的url
        weixineeParams.put("btntxt", "点击查看");
        parameter.setWeixineeParams(weixineeParams);

        CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
        if (result.isSuccess()) {
            logger.info("消息发送成功---------------->,接收人:{}", Arrays.toString(receivers));

            return true;
        } else {
            logger.error("消息发送失败---------------->" + result.getMsg());
            return false;
        }
    }
}