package com.ejianc.business.proother.settle.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum DetailSourceTypeEnum {

    手动新增(0, "add"),
    定标结果(1, "targetResult");

    private Integer code;
    private String description;
    private static Map<Integer, DetailSourceTypeEnum> enumMap = new HashMap<>();

    DetailSourceTypeEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    static {
        enumMap = (Map) EnumSet.allOf(DetailSourceTypeEnum.class).stream().collect(Collectors.toMap(DetailSourceTypeEnum::getCode, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }

    public static DetailSourceTypeEnum getDescriptionByCode(Integer code) {
        return enumMap.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public static Map<Integer, DetailSourceTypeEnum> getEnumMap() {
        return enumMap;
    }

    public static void setEnumMap(Map<Integer, DetailSourceTypeEnum> enumMap) {
        DetailSourceTypeEnum.enumMap = enumMap;
    }
    }
