/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proother.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.proother.bean.ChangeDetailEntity;
import com.ejianc.business.proother.bean.ChangeEntity;
import com.ejianc.business.proother.bean.ChangeOtherCostEntity;
import com.ejianc.business.proother.bean.ContractClauseEntity;
import com.ejianc.business.proother.bean.ContractDetailEntity;
import com.ejianc.business.proother.bean.ContractEntity;
import com.ejianc.business.proother.bean.ContractOtherCostEntity;
import com.ejianc.business.proother.bean.ContractPaymentEntity;
import com.ejianc.business.proother.bean.RecordEntity;
import com.ejianc.business.proother.enums.ChangeStatusEnum;
import com.ejianc.business.proother.enums.DraftTypeEnum;
import com.ejianc.business.proother.enums.PerformanceStatusEnum;
import com.ejianc.business.proother.enums.SignatureStatusEnum;
import com.ejianc.business.proother.mapper.ChangeMapper;
import com.ejianc.business.proother.service.IChangeService;
import com.ejianc.business.proother.service.IContractClauseService;
import com.ejianc.business.proother.service.IContractPaymentService;
import com.ejianc.business.proother.service.IContractService;
import com.ejianc.business.proother.service.IRecordService;
import com.ejianc.business.proother.utils.TreeNodeBUtil;
import com.ejianc.business.proother.vo.ChangeCompareVO;
import com.ejianc.business.proother.vo.ChangeDetailVO;
import com.ejianc.business.proother.vo.ChangeVO;
import com.ejianc.business.proother.vo.ContractVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="changeService")
public class ChangeServiceImpl
extends BaseServiceImpl<ChangeMapper, ChangeEntity>
implements IChangeService {
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IChangeService changeService;
    @Autowired
    private IRecordService recordService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContractClauseService contractClauseService;
    @Autowired
    private IContractPaymentService contractPaymentService;
    @Autowired
    private ChangeMapper changeMapper;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    private final String CONTRACT_FILE_SOURCE_TYPE = "subContractFile";
    private final String CONTRACT_ATTACH_SOURCE_TYPE = "subContractBill";
    private final String LABORSUB_Bill_CODE = "BT220308000000001";
    private final String LABORSUB_RECORD_Bill_CODE = "BT220315000000002";

    @Override
    public ChangeVO queryDetailRecord(Long id) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(id));
        ChangeVO changeVO = new ChangeVO();
        changeVO.setId(id);
        changeVO.setBaseTaxMny(contractEntity.getBaseTaxMny() == null ? BigDecimal.ZERO : contractEntity.getBaseTaxMny());
        changeVO.setContractTaxMny(contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny());
        QueryParam param = new QueryParam();
        param.getParams().put("contract_id", new Parameter("eq", (Object)id));
        param.getParams().put("performance_status", new Parameter("eq", (Object)PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode()));
        param.getOrderMap().put("change_date", "desc");
        param.getOrderMap().put("create_time", "desc");
        Map resp = new HashMap();
        QueryWrapper wrapper = ChangeServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.select(new String[]{"sum(change_mny) as sumChangeMoney, count(*) as changeNum"});
        resp = super.getMap((Wrapper)wrapper);
        changeVO.setChangeList(BeanMapper.mapList((Iterable)this.queryList(param), ChangeVO.class));
        BigDecimal sumChangeMoney = null != resp.get("sumChangeMoney") ? new BigDecimal(resp.get("sumChangeMoney").toString()) : BigDecimal.ZERO;
        BigDecimal changeAmtRate = BigDecimal.ZERO;
        if (null != contractEntity.getBaseTaxMny() && contractEntity.getBaseTaxMny().compareTo(BigDecimal.ZERO) > 0) {
            changeAmtRate = sumChangeMoney.divide(contractEntity.getBaseTaxMny(), 8, 5).multiply(new BigDecimal(100));
        }
        changeVO.setAllChangeMny(sumChangeMoney);
        Long changeNum = (Long)resp.get("changeNum");
        changeVO.setChangeNum(Integer.valueOf(changeNum != null ? Integer.valueOf(String.valueOf(changeNum)) : 0));
        changeVO.setChangeMnyRate(changeAmtRate);
        changeVO.setSupplementFlag(contractEntity.getSupplementFlag());
        changeVO.setAddType(contractEntity.getAddType());
        changeVO.setContractType(contractEntity.getContractType());
        if (SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().equals(contractEntity.getSignatureStatus()) && (BillStateEnum.PASSED_STATE.getBillStateCode().equals(contractEntity.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(contractEntity.getBillState())) && !PerformanceStatusEnum.\u5df2\u89e3\u9664.getCode().equals(contractEntity.getPerformanceStatus()) && !PerformanceStatusEnum.\u5df2\u51bb\u7ed3.getCode().equals(contractEntity.getPerformanceStatus())) {
            changeVO.setEditFlag(this.editChangeFlag(id));
        } else {
            changeVO.setEditFlag(Boolean.valueOf(false));
        }
        return changeVO;
    }

    @Override
    public Boolean editChangeFlag(Long contractId) {
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(ChangeEntity::getContractId, (Object)contractId);
        lambda.and(l -> (LambdaQueryWrapper)((LambdaQueryWrapper)l.ne(ChangeEntity::getSignatureStatus, (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode())).or(c -> (LambdaQueryWrapper)c.notIn(ChangeEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()})));
        List changeList = super.list((Wrapper)lambda);
        if (changeList.size() > 0) {
            return false;
        }
        return true;
    }

    @Override
    public ChangeVO addConvertByConId(Long contractId, Long changeId) {
        HashMap orderMap = new HashMap();
        LinkedHashMap<String, String> orderParams = new LinkedHashMap<String, String>();
        orderParams.put("treeIndex", "asc");
        orderMap.put("detailList", orderParams);
        orderMap.put("otherCostList", orderParams);
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(contractId, orderMap));
        if (ChangeStatusEnum.\u53d8\u66f4\u4e2d.getCode().equals(contractEntity.getChangeStatus()) && null == changeId) {
            return this.queryDetail(contractEntity.getChangeId());
        }
        ChangeVO changeVO = (ChangeVO)BeanMapper.map((Object)((Object)contractEntity), ChangeVO.class);
        changeVO.setBillState(null);
        changeVO.setBeforeChangeMny(contractEntity.getContractMny());
        changeVO.setBeforeChangeTaxMny(contractEntity.getContractTaxMny());
        changeVO.setBeforeContractName(contractEntity.getContractName());
        changeVO.setChangeDraftType(DraftTypeEnum.\u4e0a\u4f20\u5408\u540c.getCode().toString());
        changeVO.setContractId(contractId);
        changeVO.setChangeVersion(Integer.valueOf(contractEntity.getChangeVersion() == null ? 1 : contractEntity.getChangeVersion() + 1));
        changeVO.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
        contractEntity.setChangingMny(BigDecimal.ZERO);
        contractEntity.setChangingTaxMny(BigDecimal.ZERO);
        changeVO.setCreateUserCode(null);
        changeVO.setCreateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setUpdateTime(null);
        changeVO.setChangeDate(new Date());
        changeVO.setId(null);
        changeVO.setCommitDate(null);
        changeVO.setCommitUserCode(null);
        changeVO.setCommitUserName(null);
        changeVO.setEffectiveDate(null);
        changeVO.setChangeFileId(null);
        changeVO.setChangeFilePath(null);
        this.resetSub(changeVO);
        return changeVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ChangeVO insertOrUpdate(ChangeVO changeVO) {
        List<ChangeDetailEntity> beforeDetails;
        ContractEntity contract = (ContractEntity)((Object)this.contractService.selectById(changeVO.getContractId()));
        if (CollectionUtils.isNotEmpty((Collection)changeVO.getAttachIds()) && null != contract.getContractFileId()) {
            changeVO.getAttachIds().remove(contract.getContractFileId());
        }
        ChangeEntity changeEntity = (ChangeEntity)((Object)BeanMapper.map((Object)changeVO, ChangeEntity.class));
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(ChangeEntity::getContractId, (Object)changeVO.getContractId());
        if (changeVO.getId() != null) {
            lambdachange.ne(BaseEntity::getId, (Object)changeVO.getId());
        }
        lambdachange.and(l -> (LambdaQueryWrapper)((LambdaQueryWrapper)l.ne(ChangeEntity::getSignatureStatus, (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode())).or(c -> (LambdaQueryWrapper)c.notIn(ChangeEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()})));
        int num = super.count((Wrapper)lambdachange);
        if (num > 0) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u53d8\u66f4\u5355!");
        }
        if (changeEntity.getId() == null) {
            changeEntity.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
            changeEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            changeEntity.setPerformanceStatus(PerformanceStatusEnum.\u672a\u7b7e\u8ba2.getCode());
            if (changeEntity.getChangeVersion() < 10) {
                changeEntity.setBillCode(changeEntity.getBillCode() + "10" + changeEntity.getChangeVersion());
            } else {
                changeEntity.setBillCode(changeEntity.getBillCode() + "1" + changeEntity.getChangeVersion());
            }
        }
        if (CollectionUtils.isNotEmpty(beforeDetails = changeEntity.getDetailList())) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (ChangeDetailEntity detail : beforeDetails) {
                if (null == changeVO.getId() || null == detail.getId()) {
                    detail.setId(IdWorker.getId());
                }
                idMap.put(detail.getTid(), detail.getId());
                detail.setParentId(null);
            }
            for (ChangeDetailEntity detail : beforeDetails) {
                if (!StringUtils.isNotEmpty((CharSequence)detail.getTpid())) continue;
                detail.setParentId((Long)idMap.get(detail.getTpid()));
            }
        }
        super.saveOrUpdate((Object)changeEntity, false);
        this.saveWriteContract(changeEntity);
        return this.queryDetail(changeEntity.getId());
    }

    @Override
    public ChangeVO queryDetail(Long id) {
        HashMap orderMap = new HashMap();
        LinkedHashMap<String, String> orderParams = new LinkedHashMap<String, String>();
        orderParams.put("treeIndex", "asc");
        orderMap.put("detailList", orderParams);
        orderMap.put("otherCostList", orderParams);
        ChangeEntity changeEntity = (ChangeEntity)((Object)super.selectById((Serializable)id, orderMap));
        ChangeVO changeVO = new ChangeVO();
        if (null != changeEntity) {
            changeVO = (ChangeVO)BeanMapper.map((Object)((Object)changeEntity), ChangeVO.class);
        }
        ArrayList<Long> srcTblIdList = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty((Collection)changeVO.getDetailList())) {
            for (ChangeDetailVO detail : changeVO.getDetailList()) {
                detail.setTid(detail.getId().toString());
                detail.setTpid(detail.getParentId() != null ? detail.getParentId().toString() : null);
                srcTblIdList.add(detail.getSrcTblId());
            }
            changeVO.setDetailList(TreeNodeBUtil.buildTree((List)changeVO.getDetailList()));
        }
        return changeVO;
    }

    @Override
    public CommonResponse<String> deleteById(Long changeBillId) {
        ChangeEntity entity = (ChangeEntity)((Object)super.selectById((Serializable)changeBillId));
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"contract_id", (Object)contractEntity.getId());
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.ne((Object)"id", (Object)changeBillId);
        int count = super.count((Wrapper)query);
        contractEntity.setChangeVersion(contractEntity.getChangeVersion() - 1);
        contractEntity.setChangeStatus(count > 0 ? ChangeStatusEnum.\u5df2\u53d8\u66f4.getCode() : ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
        contractEntity.setChangingMny(BigDecimal.ZERO);
        contractEntity.setChangingTaxMny(BigDecimal.ZERO);
        contractEntity.setChangeCode(null);
        contractEntity.setChangeId(null);
        contractEntity.setChangeDate(null);
        contractEntity.setChangeDraftType(null);
        contractEntity.setChangeContractSignatureStatus(null);
        contractEntity.setChangeFileId(null);
        contractEntity.setChangeContractName(null);
        this.contractService.update((Object)contractEntity, (Wrapper)new QueryWrapper().eq((Object)"id", (Object)contractEntity.getId()), false);
        super.removeById((Serializable)changeBillId, false);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public Map<String, Object> queryChangeCompare(Long id) {
        LinkedHashMap<String, String> orderByParams = new LinkedHashMap<String, String>();
        orderByParams.put("treeIndex", "asc");
        HashMap<String, LinkedHashMap<String, String>> orders = new HashMap<String, LinkedHashMap<String, String>>();
        orders.put("detailList", orderByParams);
        ChangeEntity changeEntity = (ChangeEntity)((Object)super.selectById((Serializable)id, orders));
        ChangeCompareVO changeCompareVO = (ChangeCompareVO)BeanMapper.map((Object)((Object)changeEntity), ChangeCompareVO.class);
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(changeEntity.getContractId()));
        ChangeCompareVO beforeChangeVO = new ChangeCompareVO();
        if (BillStateEnum.PASSED_STATE.getBillStateCode().equals(changeEntity.getBillState())) {
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)lambda.eq(RecordEntity::getChangeId, (Object)id)).eq(RecordEntity::getContractId, (Object)changeEntity.getContractId())).orderByDesc(BaseEntity::getCreateTime);
            List recordList = this.recordService.list((Wrapper)lambda);
            if (recordList != null && recordList.size() > 0 && recordList.get(0) != null) {
                beforeChangeVO = (ChangeCompareVO)BeanMapper.map(recordList.get(0), ChangeCompareVO.class);
            }
        } else {
            beforeChangeVO = (ChangeCompareVO)BeanMapper.map((Object)((Object)contractEntity), ChangeCompareVO.class);
        }
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        if (changeCompareVO != null && beforeChangeVO != null) {
            if (CollectionUtils.isNotEmpty((Collection)changeCompareVO.getDetailList())) {
                changeCompareVO.setDetailList(TreeNodeBUtil.buildTree(changeCompareVO.getDetailList().stream().filter(detail -> StringUtils.isNotBlank((CharSequence)detail.getChangeType())).collect(Collectors.toList())));
            }
            if (CollectionUtils.isNotEmpty((Collection)changeCompareVO.getOtherCostList())) {
                changeCompareVO.setOtherCostList(changeCompareVO.getOtherCostList().stream().filter(cost -> null != cost.getChangeType()).collect(Collectors.toList()));
            }
            if (CollectionUtils.isNotEmpty((Collection)changeCompareVO.getClauseList())) {
                changeCompareVO.setClauseList(changeCompareVO.getClauseList().stream().filter(clause -> null == clause.getBeforeClauseContent() || !clause.getBeforeClauseContent().equals(clause.getClauseContent())).collect(Collectors.toList()));
            }
            if (CollectionUtils.isNotEmpty((Collection)changeCompareVO.getPaymentList())) {
                changeCompareVO.setPaymentList(changeCompareVO.getPaymentList().stream().filter(payment -> null == payment.getBeforePaymentScale() || !payment.getBeforePaymentScale().equals(payment.getPaymentScale())).collect(Collectors.toList()));
            }
            returnMap.put("newData", changeCompareVO);
            returnMap.put("oldData", beforeChangeVO);
        }
        return returnMap;
    }

    private void saveWriteContract(ChangeEntity changeEntity) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(ContractEntity::getChangeId, (Object)changeEntity.getId());
        if (null != changeEntity.getChangeMny() && null != changeEntity.getChangeTax()) {
            updateWrapper.set(ContractEntity::getChangingMny, (Object)changeEntity.getChangeMny().subtract(changeEntity.getChangeTax()));
        }
        updateWrapper.set(ContractEntity::getChangingTaxMny, (Object)changeEntity.getChangeMny());
        updateWrapper.set(ContractEntity::getChangeCode, (Object)changeEntity.getBillCode());
        updateWrapper.set(ContractEntity::getChangeVersion, (Object)changeEntity.getChangeVersion());
        updateWrapper.set(ContractEntity::getChangeStatus, (Object)ChangeStatusEnum.\u53d8\u66f4\u4e2d.getCode());
        updateWrapper.set(ContractEntity::getChangeDate, (Object)changeEntity.getChangeDate());
        updateWrapper.set(ContractEntity::getChangeDraftType, (Object)changeEntity.getChangeDraftType());
        updateWrapper.set(ContractEntity::getChangeContractSignatureStatus, (Object)Integer.valueOf(changeEntity.getSignatureStatus()));
        updateWrapper.set(ContractEntity::getChangeFileId, (Object)changeEntity.getChangeFileId());
        updateWrapper.set(ContractEntity::getChangeContractName, (Object)changeEntity.getContractName());
        updateWrapper.eq(BaseEntity::getId, (Object)changeEntity.getContractId());
        this.contractService.update(this.contractService.selectById(changeEntity.getContractId()), (Wrapper)updateWrapper, false);
    }

    @Override
    public ChangeVO queryChangeRecord(Long contractId, Long changeId) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(contractId));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contract_id", new Parameter("eq", (Object)contractEntity.getId()));
        queryParam.getParams().put("change_id", new Parameter("eq", (Object)changeId));
        queryParam.getOrderMap().put("createTime", "desc");
        List recordList = this.recordService.queryList(queryParam);
        ChangeVO changeVO = new ChangeVO();
        if (CollectionUtils.isNotEmpty((Collection)recordList)) {
            changeVO = (ChangeVO)BeanMapper.map(recordList.get(0), ChangeVO.class);
        }
        if (changeVO != null) {
            this.resetSub(changeVO);
        }
        return changeVO;
    }

    private void resetSub(ChangeVO changeVO) {
        List payList;
        List changeClauseList;
        List changeDetailList = changeVO.getDetailList();
        if (CollectionUtils.isNotEmpty((Collection)changeDetailList)) {
            ArrayList srcTblIdList = new ArrayList();
            changeDetailList.forEach(changeDetailVO -> {
                changeDetailVO.setSrcTblId(changeDetailVO.getId());
                changeDetailVO.setBeforeChangeNum(changeDetailVO.getDetailNum());
                changeDetailVO.setBeforeChangePrice(changeDetailVO.getDetailPrice());
                changeDetailVO.setBeforeChangeRate(changeDetailVO.getDetailTaxRate());
                changeDetailVO.setTid(changeDetailVO.getId().toString());
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null ? changeDetailVO.getParentId().toString() : null);
                changeDetailVO.setRowState("edit");
                srcTblIdList.add(changeDetailVO.getSrcTblId());
            });
        }
        changeVO.setDetailList(TreeNodeBUtil.buildTree((List)changeDetailList));
        List changeOtherCostVOList = changeVO.getOtherCostList();
        if (CollectionUtils.isNotEmpty((Collection)changeOtherCostVOList)) {
            changeOtherCostVOList.forEach(changeOtherCostVO -> {
                changeOtherCostVO.setSrcTblId(changeOtherCostVO.getId());
                changeOtherCostVO.setBeforeChangeCostNum(changeOtherCostVO.getCostNum());
                changeOtherCostVO.setBeforeChangeCostPrice(changeOtherCostVO.getCostPrice());
                changeOtherCostVO.setBeforeChangeCostRate(changeOtherCostVO.getCostTaxRate());
                changeOtherCostVO.setRowState("edit");
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)(changeClauseList = changeVO.getClauseList()))) {
            changeClauseList.forEach(changeClauseVO -> {
                changeClauseVO.setRowState("add");
                changeClauseVO.setSrcTblId(changeClauseVO.getId());
                changeClauseVO.setBeforeClauseContent(changeClauseVO.getClauseContent());
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)(payList = changeVO.getPaymentList()))) {
            payList.forEach(item -> {
                item.setRowState("add");
                item.setSrcTblId(item.getId());
                item.setBeforePaymentScale(item.getPaymentScale());
            });
        }
    }

    @Override
    public CommonResponse<String> effectiveSaveWriteContract(Long changeBillId, String billTypeCode, Boolean commitState) {
        List<ContractOtherCostEntity> contractOtherCostList;
        List<ContractDetailEntity> contractDetailList;
        CommonResponse resp = null;
        ChangeEntity changeEntity = (ChangeEntity)((Object)this.changeService.selectById(changeBillId));
        if (commitState.booleanValue()) {
            changeEntity.setCommitDate(new Date());
            changeEntity.setCommitUserCode(this.sessionManager.getUserContext().getUserCode());
            changeEntity.setCommitUserName(this.sessionManager.getUserContext().getUserName());
        }
        this.logger.info("\u8fdb\u5165\u53d8\u66f4\u7ec8\u5ba1\uff01\u53d8\u66f4\u8868\u6570\u636e------------->: {}", (Object)JSONObject.toJSONString((Object)((Object)changeEntity)));
        ContractVO contractVO = this.contractService.queryDetail(changeEntity.getContractId());
        QueryWrapper countQuery = new QueryWrapper();
        countQuery.eq((Object)"contract_id", (Object)contractVO.getId());
        countQuery.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        int curRecordVersion = this.recordService.count((Wrapper)countQuery);
        HashMap contIdVersionMap = new HashMap();
        RecordEntity recordEntity = (RecordEntity)((Object)BeanMapper.map((Object)contractVO, RecordEntity.class));
        recordEntity.setContractId(recordEntity.getId());
        recordEntity.setChangeVersion(curRecordVersion + 1);
        recordEntity.setId(null);
        this.logger.info("\u53d8\u66f4\u524d\u4e3b\u5408\u540c\u6570\u636e: {}", (Object)JSONObject.toJSONString((Object)contractVO));
        this.logger.info("\u53d8\u66f4\u524d\u4e3b\u5408\u540c\u5b50\u8868detail\u6570\u636e: {}", (Object)JSONObject.toJSONString((Object)contractVO.getDetailList()));
        this.logger.info("\u8bb0\u5f55\u8868\u4ece\u4e3b\u5408\u540c\u8868\u590d\u5236\u7684\u6570\u636e: {}", (Object)JSONObject.toJSONString((Object)((Object)recordEntity)));
        this.logger.info("\u8bb0\u5f55\u8868\u4ece\u4e3b\u5408\u540c\u8868\u590d\u5236\u7684\u6570\u636e\u7684\u5b50\u8868detail\u6570\u636e: {}", (Object)JSONObject.toJSONString(recordEntity.getDetailList()));
        if (CollectionUtils.isNotEmpty(recordEntity.getDetailList())) {
            recordEntity.getDetailList().forEach(vo -> {
                contIdVersionMap.put(vo.getId(), vo.getVersion());
                vo.setSrcTableId(vo.getId());
                vo.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(recordEntity.getClauseList())) {
            recordEntity.getClauseList().forEach(vo -> {
                vo.setSrcTableId(vo.getId());
                vo.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(recordEntity.getOtherCostList())) {
            recordEntity.getOtherCostList().forEach(vo -> {
                vo.setSrcTableId(vo.getId());
                vo.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(recordEntity.getPaymentList())) {
            recordEntity.getPaymentList().forEach(vo -> {
                vo.setSrcTableId(vo.getId());
                vo.setId(null);
            });
        }
        this.logger.info("\u8bb0\u5f55\u8868\u4ece\u4e3b\u5408\u540c\u8868\u590d\u5236\u7684\u5b50\u8868detail\u6570\u636e\uff0c\u8bbe\u7f6eid\u540e\u7684\u503c: {}", (Object)JSONObject.toJSONString(recordEntity.getDetailList()));
        this.recordService.saveOrUpdate((Object)recordEntity, false);
        this.logger.info("\u5ba1\u6279-\u53d8\u66f4\u8bb0\u5f55\u8868\u4fdd\u5b58\u4e3b\u5408\u540c\u6570\u636e\u6210\u529f\uff01");
        String srcBillCode = "BT220308000000001";
        String targetBillCode = "BT220315000000002";
        resp = this.copyFile(contractVO.getId().toString(), srcBillCode, recordEntity.getId().toString(), targetBillCode, "subContractBill", true);
        if (resp != null) {
            this.logger.error("\u540c\u6b65\u539f\u5408\u540c\u9644\u4ef6\u5230\u8bb0\u5f55\u5355\u636e\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)JSONObject.toJSONString((Object)resp));
        }
        this.logger.info("\u66f4\u65b0\u53d8\u66f4\u6570\u636e\u5230\u4e3b\u5408\u540c\u8868,contractVO---------------->: {}", (Object)JSONObject.toJSONString((Object)contractVO));
        ContractEntity contractEntity = (ContractEntity)((Object)BeanMapper.map((Object)contractVO, ContractEntity.class));
        contractEntity.setContractName(changeEntity.getContractName());
        contractEntity.setFirstPartyId(changeEntity.getFirstPartyId());
        contractEntity.setFirstPartyName(changeEntity.getFirstPartyName());
        contractEntity.setSupplierId(changeEntity.getSupplierId());
        contractEntity.setSupplierName(changeEntity.getSupplierName());
        contractEntity.setSignDate(changeEntity.getSignDate());
        contractEntity.setSignPlace(changeEntity.getSignPlace());
        contractEntity.setTaxRate(changeEntity.getTaxRate());
        contractEntity.setDraftType(changeEntity.getDraftType());
        contractEntity.setContractFilePath(changeEntity.getContractFilePath());
        contractEntity.setContractFileId(changeEntity.getContractFileId());
        contractEntity.setContractTemplateId(changeEntity.getContractTemplateId());
        contractEntity.setContractTemplateName(changeEntity.getContractTemplateName());
        contractEntity.setContractFileVersionId(changeEntity.getContractFileVersionId());
        contractEntity.setContractFileVersion(changeEntity.getContractFileVersion());
        contractEntity.setProjectAddress(changeEntity.getProjectAddress());
        contractEntity.setQualifyId(changeEntity.getQualifyId());
        contractEntity.setQualifyName(changeEntity.getQualifyName());
        contractEntity.setQualifyCertifyNo(changeEntity.getQualifyCertifyNo());
        contractEntity.setQualifyLicenceIssuingAuthority(changeEntity.getQualifyLicenceIssuingAuthority());
        contractEntity.setQualifyGrantDate(changeEntity.getQualifyGrantDate());
        contractEntity.setQualifyValidTillDate(changeEntity.getQualifyValidTillDate());
        contractEntity.setSafetyProductionLicenseNo(changeEntity.getSafetyProductionLicenseNo());
        contractEntity.setSafetyCertifyGrantDate(changeEntity.getSafetyCertifyGrantDate());
        contractEntity.setSafetyCertifyValidTillDate(changeEntity.getSafetyCertifyValidTillDate());
        contractEntity.setProjectStartDate(changeEntity.getProjectStartDate());
        contractEntity.setPlannedFinishDate(changeEntity.getPlannedFinishDate());
        contractEntity.setContractDaysLimit(changeEntity.getContractDaysLimit());
        contractEntity.setFirstPartyProjectManagerId(changeEntity.getFirstPartyProjectManagerId());
        contractEntity.setFirstPartyProjectManagerLink(changeEntity.getFirstPartyProjectManagerLink());
        contractEntity.setFirstPartyProjectManagerName(changeEntity.getFirstPartyProjectManagerName());
        contractEntity.setFirstPartyProjectManagerPost(changeEntity.getFirstPartyProjectManagerPost());
        contractEntity.setSupplierProjectManagerId(changeEntity.getSupplierProjectManagerId());
        contractEntity.setSupplierProjectManagerIdCard(changeEntity.getSupplierProjectManagerIdCard());
        contractEntity.setSupplierProjectManagerLink(changeEntity.getSupplierProjectManagerLink());
        contractEntity.setSupplierProjectManagerName(changeEntity.getSupplierProjectManagerName());
        contractEntity.setSupplierProjectManagerPost(changeEntity.getSupplierProjectManagerPost());
        contractEntity.setContractTaxMny(changeEntity.getContractTaxMny());
        contractEntity.setContractMny(changeEntity.getContractMny());
        contractEntity.setContractTax(changeEntity.getContractTax());
        contractEntity.setSubContractTaxMny(changeEntity.getSubContractTaxMny());
        contractEntity.setSubContractMny(changeEntity.getSubContractMny());
        contractEntity.setSubContractTax(changeEntity.getSubContractTax());
        contractEntity.setOtherCostMny(changeEntity.getOtherCostMny());
        contractEntity.setOtherCostTaxMny(changeEntity.getOtherCostTaxMny());
        contractEntity.setOtherCostTaxMny(changeEntity.getOtherCostTaxMny());
        contractEntity.setChangeStatus(ChangeStatusEnum.\u5df2\u53d8\u66f4.getCode());
        contractEntity.setChangingMny(null);
        contractEntity.setChangingTaxMny(null);
        this.logger.info("1212-\u8fdb\u5165\u53d8\u66f4\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03------>\u5408\u540c\u63d0\u4ea4\uff0c\u7ebf\u4e0b\u7b7e\u8ba2\u76f4\u63a5\u4fee\u6539\u7b7e\u7ae0\u72b6\u6001");
        changeEntity.setSignatureStatus(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode());
        changeEntity.setPerformanceStatus(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
        changeEntity.setEffectiveDate(new Date());
        resp = this.copyFile(changeBillId.toString(), billTypeCode, contractEntity.getId().toString(), srcBillCode, "subChangeContractFile", false);
        if (resp != null) {
            this.logger.error("\u540c\u6b65\u53d8\u66f4\u9644\u4ef6\u5230\u539f\u5408\u540c\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)JSONObject.toJSONString((Object)resp));
        }
        this.changeService.saveOrUpdate((Object)changeEntity);
        this.logger.info("\u66f4\u65b0\u53d8\u66f4\u8868\u5408\u540c\u72b6\u6001\u548c\u6570\u636e,changeEntity---------->\uff1a {}", (Object)JSONObject.toJSONString((Object)((Object)changeEntity)));
        this.logger.info("\u66f4\u65b0\u53d8\u66f4\u8868\u6570\u636e\u5230\u4e3b\u5408\u540c\u5f00\u59cb----------->" + contractEntity.getChangeStatus());
        ContractEntity contractChangeEntity = (ContractEntity)((Object)BeanMapper.map((Object)((Object)changeEntity), ContractEntity.class));
        List<ChangeDetailEntity> changeDetailList = changeEntity.getDetailList();
        HashMap changDetailIdMap = new HashMap();
        HashMap changeParentIdMap = new HashMap();
        if (CollectionUtils.isNotEmpty(changeDetailList)) {
            changeDetailList.forEach(changeDetailEntity -> changDetailIdMap.put(changeDetailEntity.getId(), changeDetailEntity.getSrcTblId() != null ? changeDetailEntity.getSrcTblId() : IdWorker.getId()));
            changeDetailList.forEach(changeDetailEntity -> {
                if (changeDetailEntity.getParentId() != null) {
                    changeParentIdMap.put(changeDetailEntity.getId(), changDetailIdMap.get(changeDetailEntity.getParentId()));
                }
            });
        }
        if (CollectionUtils.isNotEmpty(contractDetailList = contractChangeEntity.getDetailList())) {
            Long contractBid = null;
            for (ContractDetailEntity contractDetailEntity : contractDetailList) {
                contractBid = (Long)changDetailIdMap.get(contractDetailEntity.getId());
                contractDetailEntity.setContractId(changeEntity.getContractId());
                contractDetailEntity.setChangeBid(contractDetailEntity.getId());
                if (null != contractDetailEntity.getParentId()) {
                    contractDetailEntity.setParentId((Long)changDetailIdMap.get(contractDetailEntity.getParentId()));
                }
                contractDetailEntity.setId(contractBid);
                contractDetailEntity.setVersion((Integer)contIdVersionMap.get(contractBid));
                contractDetailEntity.setChangeType(null);
            }
        }
        contractEntity.setDetailList(contractDetailList);
        List<ChangeOtherCostEntity> changeOtherCostList = changeEntity.getOtherCostList();
        HashMap changOtherCostIdMap = new HashMap();
        if (CollectionUtils.isNotEmpty(changeOtherCostList)) {
            changeOtherCostList.forEach(changeOtherCostEntity -> changOtherCostIdMap.put(changeOtherCostEntity.getId(), changeOtherCostEntity.getSrcTblId()));
        }
        if (CollectionUtils.isNotEmpty(contractOtherCostList = contractChangeEntity.getOtherCostList())) {
            Long contractBid = null;
            for (ContractOtherCostEntity contractOtherCostEntity : contractOtherCostList) {
                contractBid = (Long)changOtherCostIdMap.get(contractOtherCostEntity.getId());
                contractOtherCostEntity.setChangeBid(contractOtherCostEntity.getId());
                contractOtherCostEntity.setId(contractBid);
                contractOtherCostEntity.setVersion((Integer)contIdVersionMap.get(contractBid));
                contractOtherCostEntity.setContractId(contractEntity.getId());
            }
        }
        contractEntity.setOtherCostList(contractOtherCostList);
        List<ContractClauseEntity> contractClauseList = contractEntity.getClauseList();
        List<ContractClauseEntity> contractChangeClauseList = contractChangeEntity.getClauseList();
        if (CollectionUtils.isNotEmpty(contractClauseList)) {
            this.logger.info("\u5220\u9664\u5408\u540c\u6761\u6b3e\u5b50\u8868\u6570\u636e: {}", (Object)JSONObject.toJSONString(contractClauseList));
            this.contractClauseService.deleteByIds(contractClauseList.stream().map(BaseEntity::getId).collect(Collectors.toList()));
            contractChangeClauseList.forEach(clauseEntity -> {
                clauseEntity.setChangeBid(clauseEntity.getId());
                clauseEntity.setId(null);
                clauseEntity.setRowState("add");
                clauseEntity.setContractId(contractEntity.getId());
            });
        }
        contractEntity.setClauseList(contractChangeClauseList);
        List<ContractPaymentEntity> contractPayList = contractEntity.getPaymentList();
        List<ContractPaymentEntity> pList = contractChangeEntity.getPaymentList();
        if (CollectionUtils.isNotEmpty(contractPayList)) {
            this.logger.info("\u5220\u9664\u5408\u540c\u4ed8\u6b3e\u9636\u6bb5\u5b50\u8868\u6570\u636e: {}", (Object)JSONObject.toJSONString(contractPayList));
            this.contractPaymentService.deleteByIds(contractPayList.stream().map(BaseEntity::getId).collect(Collectors.toList()));
            pList.forEach(item -> {
                item.setChangeBid(item.getId());
                item.setId(null);
                item.setRowState("add");
                item.setContractId(contractEntity.getId());
            });
        }
        contractEntity.setPaymentList(pList);
        this.contractService.saveOrUpdate((Object)contractEntity, false);
        this.logger.info("\u66f4\u65b0\u5408\u540c\u8868\u6570\u636e\u6210\u529f,contractEntity---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)contractEntity)));
        return CommonResponse.success((String)"\u53d8\u66f4\u5355\u751f\u6548\uff0c\u56de\u5199\u5408\u540c\u6210\u529f\uff01");
    }

    @Override
    public List<ChangeDetailVO> selectUsefulByIds(List<Long> srcTblIdList) {
        return this.changeMapper.selectUsefulByIds(srcTblIdList);
    }

    private CommonResponse copyFile(String srcBillId, String srcBillTypeCode, String targetBillId, String targetBillTypeCode, String srcAttachSourceType, boolean copyContractFile) {
        CommonResponse copyContractFileResp;
        CommonResponse copyContractAttachResp = this.attachmentApi.copyFilesFromSourceBillToTargetBill(srcBillId, srcBillTypeCode, srcAttachSourceType, targetBillId, targetBillTypeCode, "subContractBill");
        if (!copyContractAttachResp.isSuccess()) {
            this.logger.info("\u540c\u6b65\u5408\u540c\u6587\u4ef6\u5931\u8d25--------------->srcBillId-{},srcBillTypeCode-{},srcSourceType-{},targetBillId-{},targetBillTypeCode-{},targetSourceType-{},\uff1a{}", new Object[]{srcBillId, srcBillTypeCode, "subContractBill", targetBillId, targetBillTypeCode, "subContractBill", copyContractAttachResp.getMsg()});
            this.logger.info("\u540c\u6b65\u9644\u4ef6\u7ba1\u7406\u4e2d\u7684\u9644\u4ef6\u5931\u8d25--------------->\u5931\u8d25\u4fe1\u606f------------>\uff1a{}", (Object)copyContractAttachResp.getMsg());
            return CommonResponse.error((String)("\u5ba1\u6279\u5931\u8d25\uff0c\u540c\u6b65\u9644\u4ef6\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + copyContractAttachResp.getMsg()));
        }
        if (copyContractFile && !(copyContractFileResp = this.attachmentApi.copyFilesFromSourceBillToTargetBill(srcBillId, srcBillTypeCode, "subContractFile", targetBillId, targetBillTypeCode, "subContractFile")).isSuccess()) {
            this.logger.info("\u540c\u6b65\u5408\u540c\u6587\u4ef6\u5931\u8d25--------------->srcBillId-{},srcBillTypeCode-{},srcSourceType-{},targetBillId-{},targetBillTypeCode-{},targetSourceType-{},\uff1a{}", new Object[]{srcBillId, srcBillTypeCode, "subContractFile", targetBillId, targetBillTypeCode, "subContractFile", copyContractFileResp.getMsg()});
            return CommonResponse.error((String)("\u5ba1\u6279\u5931\u8d25\uff0c\u540c\u6b65\u5408\u540c\u6587\u4ef6\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + copyContractFileResp.getMsg()));
        }
        return null;
    }
}

