/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proother.service.impl;

import com.ejianc.business.proother.bean.ContractEntity;
import com.ejianc.business.proother.enums.BillPushStatusEnum;
import com.ejianc.business.proother.enums.DraftTypeEnum;
import com.ejianc.business.proother.enums.PerformanceStatusEnum;
import com.ejianc.business.proother.enums.SignatureStatusEnum;
import com.ejianc.business.proother.service.IContractService;
import com.ejianc.business.proother.vo.ContractVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="contract")
public class ContractBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContractService contractService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private SessionManager sessionManager;

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        ContractEntity e = (ContractEntity)((Object)this.contractService.selectById(billId));
        if (!DraftTypeEnum.\u7ebf\u4e0b\u7b7e\u8ba2.getCode().toString().equals(e.getDraftType()) && null == e.getContractFileId()) {
            return CommonResponse.error((String)"\u8bf7\u7f16\u8f91\u5408\u540c\u6587\u4ef6\u5e76\u4fdd\u5b58\u540e\u518d\u6267\u884c\u6b64\u64cd\u4f5c\uff01");
        }
        UserContext userContext = this.sessionManager.getUserContext();
        e.setCommitDate(new Date());
        e.setCommitUserCode(userContext.getUserCode());
        e.setCommitUserName(userContext.getUserName());
        this.contractService.saveOrUpdate((Object)e, false);
        return CommonResponse.success((String)"\u5408\u540c\u5ba1\u6279\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        boolean pushResult;
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(billId));
        if (contractEntity != null) {
            if (DraftTypeEnum.\u7ebf\u4e0b\u7b7e\u8ba2.getCode().toString().equals(contractEntity.getDraftType())) {
                this.logger.info("\u5408\u540cid-{}\u4e3a\u7ebf\u4e0b\u7b7e\u8ba2\u76f4\u63a5\u4fee\u6539\u4e3a\u7b7e\u7ae0\u72b6\u6001\u5e76\u8bbe\u7f6e\u4e3a\u5c65\u7ea6\u4e2d", (Object)billId);
                contractEntity.setSignatureStatus(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode());
                contractEntity.setPerformanceStatus(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
                contractEntity.setEffectiveDate(new Date());
            } else if (null == contractEntity.getContractFileId()) {
                return CommonResponse.error((String)"\u8bf7\u7f16\u8f91\u5408\u540c\u6587\u4ef6\u5e76\u4fdd\u5b58\u540e\u518d\u6267\u884c\u6b64\u64cd\u4f5c\uff01");
            }
        }
        if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
            contractEntity.setCommitDate(new Date());
            contractEntity.setCommitUserCode(this.sessionManager.getUserContext().getUserCode());
            contractEntity.setCommitUserName(this.sessionManager.getUserContext().getUserName());
        }
        if (pushResult = this.contractService.pushContract((ContractVO)BeanMapper.map((Object)((Object)contractEntity), ContractVO.class))) {
            contractEntity.setBillPushFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
        } else {
            contractEntity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        }
        this.contractService.saveOrUpdate((Object)contractEntity);
        return CommonResponse.success((String)"\u5408\u540c\u5ba1\u6279\u56de\u8c03\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        ContractEntity contractEntitiy = (ContractEntity)((Object)this.contractService.selectById(billId));
        if (!SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode().equals(contractEntitiy.getSignatureStatus())) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u6709\u7b7e\u7ae0\u6d41\u7a0b\uff0c\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u5f03\u5ba1\uff01");
        }
        boolean delResult = this.contractService.delContractFromPool(contractEntitiy.getId());
        if (delResult) {
            contractEntitiy.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
            this.contractService.saveOrUpdate((Object)contractEntitiy, false);
        }
        return CommonResponse.success((String)"\u5f03\u5ba1/\u64a4\u56de\u524d\u6821\u9a8c\u56de\u8c03\u6210\u529f\uff01");
    }
}

