/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settle.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.proother.bean.ContractEntity;
import com.ejianc.business.proother.enums.PerformanceStatusEnum;
import com.ejianc.business.proother.service.IContractService;
import com.ejianc.business.settle.bean.SettleEntity;
import com.ejianc.business.settle.service.ISettleService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="settle")
public class SettleBpmServiceImpl
implements ICommonBusinessService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private ISettleService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IContractService contractService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        SettleEntity settleEntity = (SettleEntity)((Object)this.service.selectById(billId));
        if (settleEntity != null) {
            settleEntity.setEffectiveDate(new Date());
        }
        if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
            UserContext userContext = this.sessionManager.getUserContext();
            settleEntity.setCommitDate(new Date());
            settleEntity.setCommitUserCode(userContext.getUserCode());
            settleEntity.setCommitUserName(userContext.getUserName());
        }
        this.service.saveOrUpdate((Object)settleEntity, false);
        if (settleEntity.getSettleType() == 1) {
            QueryParam param = new QueryParam();
            param.getParams().put("id", new Parameter("eq", (Object)settleEntity.getContractId()));
            List contractEntities = this.contractService.queryList(param, false);
            ((ContractEntity)((Object)contractEntities.get(0))).setPerformanceStatus(PerformanceStatusEnum.\u5df2\u5c01\u8d26.getCode());
            this.logger.info("======\u5b8c\u5de5\u7ed3\u7b97\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03,\u5df2\u5c01\u8d26======,{}", (Object)JSONObject.toJSONString(contractEntities.get(0)));
            this.contractService.saveOrUpdate(contractEntities.get(0), false);
            return CommonResponse.success((String)"\u5b8c\u5de5\u7ed3\u7b97\u7ec8\u5ba1\u56de\u8c03\u6210\u529f\uff01");
        }
        return CommonResponse.success((String)"\u8fc7\u7a0b\u7ed3\u7b97\u7ec8\u5ba1\u56de\u8c03\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u5b8c\u5de5\u5355\u636ebillId-{}, state-{}, billTypeCode-{}\u64a4\u56de\u524d\u6821\u9a8c", new Object[]{billId, state, billTypeCode});
        SettleEntity settleEntity = (SettleEntity)((Object)this.service.selectById(billId));
        if (settleEntity == null) {
            return CommonResponse.error((String)"\u67e5\u8be2\u4e0d\u5230\u8be5\u5355\u636e\u4fe1\u606f\uff01");
        }
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u5f03\u5ba1/\u64a4\u56de\uff01");
        }
        if (settleEntity.getSettleType() == 1) {
            this.logger.info("\u5b8c\u5de5\u7ed3\u7b97\u5f03\u5ba1/\u64a4\u56de\u524d\u56de\u8c03\u7ed3\u7b97\u5b9e\u4f53\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)settleEntity), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
            QueryParam param = new QueryParam();
            param.getParams().put("id", new Parameter("eq", (Object)settleEntity.getContractId()));
            List contractEntities = this.contractService.queryList(param, false);
            ((ContractEntity)((Object)contractEntities.get(0))).setPerformanceStatus(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
            this.logger.info("======\u5b8c\u5de5\u7ed3\u7b97\u5f03\u5ba1\u524d\u56de\u8c03,\u4fee\u6539\u5408\u540c\u72b6\u6001\u4e3a\u5c65\u7ea6\u4e2d======,{}", (Object)JSONObject.toJSONString(contractEntities.get(0)));
            this.contractService.saveOrUpdate(contractEntities.get(0), false);
        }
        this.service.saveOrUpdate((Object)settleEntity, false);
        return CommonResponse.success((String)"\u5f03\u5ba1/\u64a4\u56de\u524d\u6821\u9a8c\u56de\u8c03\u6210\u529f\uff01");
    }
}

