/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proother.controller;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.api.ITemplateCategoryApi;
import com.ejianc.business.proother.bean.ChangeEntity;
import com.ejianc.business.proother.bean.ContractEntity;
import com.ejianc.business.proother.enums.ChangeStatusEnum;
import com.ejianc.business.proother.enums.PerformanceStatusEnum;
import com.ejianc.business.proother.enums.SignatureStatusEnum;
import com.ejianc.business.proother.service.IChangeService;
import com.ejianc.business.proother.service.IContractService;
import com.ejianc.business.proother.vo.ChangeVO;
import com.ejianc.business.proother.vo.ContractVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"change"})
public class ChangeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IChangeService service;
    @Autowired
    private IContractService contractService;
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Autowired
    private ITemplateCategoryApi templateCategoryApi;
    @Autowired
    private IExecutionApi executionApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ChangeVO> saveOrUpdate(@RequestBody ChangeVO saveorUpdateVO, HttpServletRequest req) {
        ChangeVO vo = this.service.insertOrUpdate(saveorUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ChangeVO> queryDetail(Long id) {
        ChangeVO vo = this.service.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ChangeVO> vos) {
        if (CollectionUtils.isNotEmpty(vos)) {
            ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
            ArrayList<Object> contractEntityList = new ArrayList<Object>();
            for (ChangeVO ChangeVO2 : vos) {
                ChangeEntity changeEntity = (ChangeEntity)((Object)this.service.selectById(ChangeVO2.getId()));
                ExecutionVO executionVO = this.service.targetCost((ChangeVO)BeanMapper.map((Object)((Object)changeEntity), ChangeVO.class), "", changeEntity.getContractType());
                totalExecutionVOList.add(executionVO.getTotalVO());
                contractEntityList.add(this.contractService.selectById(changeEntity.getContractId()));
            }
            this.logger.info("\u76ee\u6807\u6210\u672c\u5220\u9664\u6570\u636e" + JSON.toJSONString(totalExecutionVOList));
            CommonResponse response = this.executionApi.aggDel(totalExecutionVOList);
            if (!response.isSuccess()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
            }
            for (ContractEntity contractEntity : contractEntityList) {
                String linkUrl = this.BaseHost + "ejc-proother-frontend/#/contract/Card?id=" + contractEntity.getId();
                ExecutionVO executionVO = this.contractService.targetCost((ContractVO)BeanMapper.map((Object)((Object)contractEntity), ContractVO.class), linkUrl, contractEntity.getContractType());
                this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
                CommonResponse responses = this.executionApi.aggPush(executionVO);
                if (response.isSuccess()) continue;
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + responses.getMsg());
            }
        }
        return this.service.deleteById(vos.get(0).getId());
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ChangeVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        CommonResponse orgResp = this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (!orgResp.isSuccess()) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        param.getParams().put("orgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ChangeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryDetailRecord"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ChangeVO> queryDetailRecord(Long id) {
        ChangeVO vo = this.service.queryDetailRecord(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/addConvertByConId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ChangeVO> addConvertByConId(Long contractId, Long changeId) {
        ChangeVO vo = this.service.addConvertByConId(contractId, changeId);
        return CommonResponse.success((String)"\u65b0\u589e\u8f6c\u6362\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryChangeCompare"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Map> queryChangeCompare(Long id) {
        Map<String, Object> returnMap = this.service.queryChangeCompare(id);
        return CommonResponse.success((String)"\u65b0\u589e\u8f6c\u6362\u6570\u636e\u6210\u529f\uff01", returnMap);
    }

    @RequestMapping(value={"/queryChangeRecord"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ChangeVO> queryChangeRecord(Long contractId, Long changeId) {
        ChangeVO vo = this.service.queryChangeRecord(contractId, changeId);
        return CommonResponse.success((String)"\u53d8\u66f4\u8bb0\u5f55\u67e5\u8be2\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/changeSignatureProcess"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> changeSignatureProcess(Long id) {
        ChangeEntity changeEntity = (ChangeEntity)((Object)this.service.selectById(id));
        if (changeEntity != null) {
            changeEntity.setSignatureStatus(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().toString());
            changeEntity.setEffectiveDate(new Date());
            changeEntity.setPerformanceStatus(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode().toString());
            this.service.saveOrUpdate((Object)changeEntity);
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)changeEntity.getContractId());
            updateWrapper.set(ContractEntity::getChangeContractSignatureStatus, (Object)Integer.valueOf(changeEntity.getSignatureStatus()));
            updateWrapper.set(ContractEntity::getChangeStatus, (Object)ChangeStatusEnum.\u5df2\u53d8\u66f4.getCode());
            this.contractService.update(this.contractService.selectById(changeEntity.getContractId()), (Wrapper)updateWrapper, false);
        }
        return CommonResponse.success();
    }
}

