/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proother.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.proother.bean.ChangeEntity;
import com.ejianc.business.proother.bean.ContractEntity;
import com.ejianc.business.proother.enums.ChangeStatusEnum;
import com.ejianc.business.proother.enums.DraftTypeEnum;
import com.ejianc.business.proother.enums.PerformanceStatusEnum;
import com.ejianc.business.proother.enums.SignatureStatusEnum;
import com.ejianc.business.proother.service.IChangeService;
import com.ejianc.business.proother.service.IContractService;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="change")
public class ChangeBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IChangeService changeService;
    @Autowired
    private IContractService contractService;
    @Autowired
    private SessionManager sessionManager;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        ChangeEntity e = (ChangeEntity)((Object)this.changeService.selectById(billId));
        UserContext userContext = this.sessionManager.getUserContext();
        e.setCommitDate(new Date());
        e.setCommitUserCode(userContext.getUserCode());
        e.setCommitUserName(userContext.getUserName());
        this.changeService.saveOrUpdate((Object)e, false);
        return CommonResponse.success((String)"\u53d8\u66f4\u56de\u8c03\u5904\u7406\u5b8c\u6210\uff01");
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ChangeEntity changeEntity = (ChangeEntity)((Object)this.changeService.selectById(billId));
        this.logger.info("\u53d8\u66f4\u5355\u7ec8\u5ba1\u5ba1\u6279\u524d\u53d8\u66f4\u8868\u6570\u636e------------->: {}", (Object)JSONObject.toJSONString((Object)((Object)changeEntity)));
        if (null != changeEntity && !changeEntity.getBillState().equals(BillStateEnum.UNCOMMITED_STATE.getBillStateCode()) && !changeEntity.getBillState().equals(BillStateEnum.UNAPPROVED.getBillStateCode())) {
            return CommonResponse.error((String)"\u8be5\u5355\u636e\u5df2\u88ab\u4fee\u6539\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\uff01");
        }
        return CommonResponse.success((String)"\u53d8\u66f4\u5355\u7ec8\u5ba1\u5ba1\u6279\u524d\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ChangeEntity changeEntity = (ChangeEntity)((Object)this.changeService.selectById(billId));
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(changeEntity.getContractId()));
        if (null != contractEntity && !contractEntity.getPerformanceStatus().equals(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode())) {
            return CommonResponse.error((String)"\u5f53\u524d\u53d8\u66f4\u5408\u540c\u6240\u5c5e\u7684\u4e3b\u5408\u540c\u72b6\u6001\u4e0d\u662f\u5c65\u7ea6\u4e2d\uff0c\u8be5\u53d8\u66f4\u5408\u540c\u4e0d\u80fd\u8fdb\u884c\u63d0\u4ea4\u64cd\u4f5c\uff01");
        }
        Boolean commitState = false;
        if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
            commitState = true;
            changeEntity.setCommitDate(new Date());
            changeEntity.setCommitUserCode(this.sessionManager.getUserContext().getUserCode());
            changeEntity.setCommitUserName(this.sessionManager.getUserContext().getUserName());
        }
        if (DraftTypeEnum.\u7ebf\u4e0b\u7b7e\u8ba2.getCode().toString().equals(changeEntity.getChangeDraftType())) {
            return this.changeService.effectiveSaveWriteContract(billId, billTypeCode, commitState);
        }
        if (commitState.booleanValue()) {
            this.changeService.saveOrUpdate((Object)changeEntity);
        }
        contractEntity.setChangeStatus(ChangeStatusEnum.\u53d8\u66f4\u5355\u636e\u5ba1\u6279\u901a\u8fc7.getCode());
        this.contractService.saveOrUpdate((Object)contractEntity, false);
        this.logger.info("\u66f4\u65b0\u5408\u540c\u8868\u6570\u636e\u6210\u529f,contractEntity---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)contractEntity)));
        return CommonResponse.success((String)"\u5ba1\u6279\u56de\u8c03\u5408\u540c\u6210\u529f\uff01");
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.doBpmBack(billId, state, billTypeCode);
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.doBpmBack(billId, state, billTypeCode);
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> doBpmBack(Long billId, Integer state, String billTypeCode) {
        Object resp = null;
        ChangeEntity changeEntity = (ChangeEntity)((Object)this.changeService.selectById(billId));
        if (!SignatureStatusEnum.\u5f85\u7b7e\u7ae0.getCode().equals(changeEntity.getSignatureStatus())) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u6709\u7b7e\u7ae0\u6d41\u7a0b\uff0c\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        changeEntity.setCommitDate(null);
        changeEntity.setCommitUserCode(null);
        changeEntity.setCommitUserName(null);
        this.changeService.saveOrUpdate((Object)changeEntity);
        this.logger.info("\u64a4\u56de\u66f4\u65b0\u53d8\u66f4\u8868\u6570\u636e\u6210\u529f,contractEntity---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)changeEntity)));
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(changeEntity.getContractId()));
        contractEntity.setChangeStatus(ChangeStatusEnum.\u53d8\u66f4\u4e2d.getCode());
        this.contractService.saveOrUpdate((Object)contractEntity, false);
        this.logger.info("\u64a4\u56de\u66f4\u65b0\u5408\u540c\u8868\u6570\u636e\u6210\u529f,contractEntity---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)contractEntity)));
        return CommonResponse.success((String)"\u6267\u884c\u53d8\u66f4\u5355\u64a4\u56de\u56de\u8c03\u903b\u8f91\u6210\u529f\uff01");
    }
}

