/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settle.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.contractbase.pool.enums.SettleSourceTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.proother.bean.ChangeEntity;
import com.ejianc.business.proother.bean.ContractEntity;
import com.ejianc.business.proother.service.IChangeService;
import com.ejianc.business.proother.service.IContractService;
import com.ejianc.business.settle.bean.SettleEntity;
import com.ejianc.business.settle.enums.SettleTypeEnum;
import com.ejianc.business.settle.mapper.SettleMapper;
import com.ejianc.business.settle.service.ISettleDetailService;
import com.ejianc.business.settle.service.ISettleOtherService;
import com.ejianc.business.settle.service.ISettleService;
import com.ejianc.business.settle.vo.SettleRecordVO;
import com.ejianc.business.settle.vo.SettleVO;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="settleService")
public class SettleServiceImpl
extends BaseServiceImpl<SettleMapper, SettleEntity>
implements ISettleService {
    @Autowired
    private IChangeService changeService;
    @Autowired
    private SettleMapper settleMapper;
    @Autowired
    private IContractService contractService;
    @Autowired
    private ISettleDetailService detailService;
    @Autowired
    private ISettleOtherService otherService;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISettlePoolApi settlePoolApi;

    @Override
    public CommonResponse<SettleVO> queryUnusedContract(Long contractId, Date settleDate, Integer settleType) {
        SettleVO settleVO = new SettleVO();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(SettleEntity::getContractId, (Object)contractId);
        lambda.eq(SettleEntity::getSettleType, (Object)SettleTypeEnum.\u5b8c\u5de5.getCode());
        lambda.and(c -> (LambdaQueryWrapper)c.notIn(SettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()}));
        int resultCount = super.count((Wrapper)lambda);
        if (resultCount > 0) {
            return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c\u5df2\u8fdb\u884c\u5b8c\u5de5\u7ed3\u7b97\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u5408\u540c\u3002");
        }
        QueryWrapper contractQuery = new QueryWrapper();
        contractQuery.eq((Object)"contract_id", (Object)contractId);
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(contractId));
        if (null != contractEntity && null != contractEntity.getChangeId() && settleType == 1) {
            LambdaQueryWrapper changeContractLambda = new LambdaQueryWrapper();
            changeContractLambda.eq(BaseEntity::getId, (Object)contractEntity.getChangeId());
            changeContractLambda.and(c -> (LambdaQueryWrapper)c.in(ChangeEntity::getBillState, new Object[]{BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()}));
            int changeResultCount = this.changeService.count((Wrapper)changeContractLambda);
            if (changeResultCount > 0) {
                return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c\u6b63\u5728\u8fdb\u884c\u53d8\u66f4\uff0c\u4e0d\u53ef\u4ee5\u8fdb\u884c\u5b8c\u5de5\u7ed3\u7b97\uff01");
            }
        }
        LambdaQueryWrapper settleLambda = new LambdaQueryWrapper();
        settleLambda.eq(SettleEntity::getContractId, (Object)contractId);
        settleLambda.and(c -> (LambdaQueryWrapper)c.notIn(SettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()}));
        List resultList = super.list((Wrapper)settleLambda);
        if (resultList.size() > 0 && null != resultList.get(0)) {
            String settleTypeName = null != ((SettleEntity)((Object)resultList.get(0))).getSettleType() ? SettleTypeEnum.getDescriptionByCode((Integer)((SettleEntity)((Object)resultList.get(0))).getSettleType()).getDescription() : "";
            return CommonResponse.error((String)("\u5f53\u524d\u5408\u540c\u6709\u672a\u5ba1\u6279\u7684" + settleTypeName + "\u7ed3\u7b97\u5355\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u5408\u540c\u3002"));
        }
        QueryWrapper listQuery = new QueryWrapper();
        listQuery.eq((Object)"contract_id", (Object)contractId);
        listQuery.eq((Object)"settle_type", (Object)settleType);
        listQuery.in((Object)"bill_state", new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        listQuery.orderByDesc((Object)"create_time");
        List list = super.list((Wrapper)listQuery);
        BigDecimal settleScale = BigDecimal.ZERO;
        if (list.size() > 0) {
            settleVO.setSettleScale(((SettleEntity)((Object)list.get(0))).getTotalSettleScale() == null ? BigDecimal.ZERO : ((SettleEntity)((Object)list.get(0))).getTotalSettleScale());
            settleVO.setLastTaxMny(((SettleEntity)((Object)list.get(0))).getTotalTaxMny() == null ? BigDecimal.ZERO : ((SettleEntity)((Object)list.get(0))).getTotalTaxMny());
            settleVO.setLastMny(((SettleEntity)((Object)list.get(0))).getTotalMny() == null ? BigDecimal.ZERO : ((SettleEntity)((Object)list.get(0))).getTotalTaxMny());
        } else {
            settleVO.setLastTaxMny(BigDecimal.ZERO);
            settleVO.setLastMny(BigDecimal.ZERO);
            settleVO.setSettleScale(BigDecimal.ZERO);
        }
        return CommonResponse.success((String)"\u5f53\u524d\u5408\u540c\u53ef\u7528\uff01", (Object)settleVO);
    }

    @Override
    public SettleRecordVO queryDetailRecord(Long contractId, Integer settleType) {
        SettleEntity lastSettleRecord;
        SettleRecordVO settleRecordVO = new SettleRecordVO();
        ContractEntity contract = (ContractEntity)((Object)this.contractService.selectById(contractId));
        settleRecordVO.setContractId(contract.getId());
        settleRecordVO.setContractMny(contract.getContractMny());
        settleRecordVO.setContractTaxMny(contract.getContractTaxMny());
        settleRecordVO.setPerformanceStatus(contract.getPerformanceStatus());
        QueryWrapper listQuery = new QueryWrapper();
        listQuery.eq((Object)"contract_id", (Object)contractId);
        listQuery.in((Object)"bill_state", new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        listQuery.orderByDesc((Object)"create_time");
        List list = super.list((Wrapper)listQuery);
        List settleVOS = BeanMapper.mapList((Iterable)list, SettleVO.class);
        settleVOS.forEach(vo -> {
            if (vo.getSettleType() == 1) {
                vo.setSettleTypeStr("\u5b8c\u5de5\u7ed3\u7b97");
            } else if (vo.getSettleType() == 0) {
                vo.setSettleTypeStr("\u8fc7\u7a0b\u7ed3\u7b97");
            }
            if (vo.getTotalSettleScale() != null) {
                int i = vo.getTotalSettleScale().toString().indexOf(".");
                String substring = vo.getTotalSettleScale().toString().substring(0, i + 3);
                vo.setTotalSettleScaleStr(substring + '%');
            }
        });
        settleRecordVO.setSettleList(settleVOS);
        SettleEntity settleEntity = lastSettleRecord = CollectionUtils.isNotEmpty((Collection)list) ? (SettleEntity)((Object)list.get(0)) : null;
        if (lastSettleRecord != null) {
            settleRecordVO.setTotalSettleMny(lastSettleRecord.getTotalTaxMny());
            settleRecordVO.setSettleRatio(lastSettleRecord.getTotalSettleScale());
        } else {
            settleRecordVO.setTotalSettleMny(BigDecimal.ZERO);
            settleRecordVO.setSettleRatio(BigDecimal.ZERO);
        }
        settleRecordVO.setCanAddNewSettleFlag(StringUtils.isBlank((CharSequence)this.beforeNewSettleCheck(contractId, settleType)));
        return settleRecordVO;
    }

    @Override
    public String beforeNewSettleCheck(Long contractId, Integer settleType) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"contract_id", (Object)contractId);
        ((QueryWrapper)((QueryWrapper)query.and(q -> (QueryWrapper)((QueryWrapper)q.in((Object)"settle_type", new Object[]{SettleTypeEnum.\u8282\u70b9.getCode(), SettleTypeEnum.\u8fc7\u7a0b.getCode()})).in((Object)"bill_state", new Object[]{BillStateEnum.UNCOMMITED_STATE.getBillStateCode(), BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.UNAPPROVED.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()}))).or()).and(q -> (QueryWrapper)q.eq((Object)"settle_type", (Object)SettleTypeEnum.\u5b8c\u5de5));
        List billList = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)billList)) {
            if (SettleTypeEnum.\u5b8c\u5de5.getCode().equals(settleType)) {
                return "\u5408\u540c\u5df2\u7ecf\u751f\u6210\u4e86\u5b8c\u5de5\u7ed3\u7b97\uff0c\u4e0d\u53ef\u4ee5\u8fdb\u884c " + SettleTypeEnum.getDescriptionByCode((Integer)settleType) + "\u7ed3\u7b97";
            }
            return "\u6709\u672a\u751f\u6548\u7684\u8fc7" + SettleTypeEnum.getDescriptionByCode((Integer)SettleTypeEnum.\u8282\u70b9.getCode()) + "\u7b97\u5355\u636e\uff0c\u4e0d\u53ef\u4ee5\u8fdb\u884c" + SettleTypeEnum.getDescriptionByCode((Integer)settleType) + "\u7ed3\u7b97";
        }
        if (SettleTypeEnum.\u5b8c\u5de5.getCode().equals(settleType)) {
            StringBuffer sp = new StringBuffer();
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("contract_id", new Parameter("eq", (Object)contractId));
            queryParam.getParams().put("bill_state", new Parameter("eq", (Object)BillStateEnum.APPROVING_HAS_STATE));
            QueryWrapper contractQuery = new QueryWrapper();
            contractQuery.eq((Object)"contract_id", (Object)contractId);
            ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(contractId));
            if (null != contractEntity && null != contractEntity.getChangeId()) {
                LambdaQueryWrapper changeContractLambda = new LambdaQueryWrapper();
                changeContractLambda.eq(BaseEntity::getId, (Object)contractEntity.getChangeId());
                changeContractLambda.and(c -> (LambdaQueryWrapper)c.in(ChangeEntity::getBillState, new Object[]{BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()}));
                int changeResultCount = this.changeService.count((Wrapper)changeContractLambda);
                if (changeResultCount > 0) {
                    return "\u5f53\u524d\u5408\u540c\u6b63\u5728\u8fdb\u884c\u53d8\u66f4\uff0c\u4e0d\u53ef\u4ee5\u8fdb\u884c\u5b8c\u5de5\u7ed3\u7b97\uff01";
                }
            }
        }
        return null;
    }

    @Override
    public boolean pushSettleToPool(SettleVO settleVO) {
        SettlePoolVO poolVO = new SettlePoolVO();
        try {
            this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u81ea\u52a8\u8f6c\u6362\u5f00\u59cb");
            BeanConvertorUtil.convert((Object)settleVO, (Object)poolVO);
            this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u81ea\u52a8\u8f6c\u6362\u7ed3\u675f\uff0c\u4e0b\u9762\u5f00\u59cb\u624b\u52a8\u8f6c\u6362");
            this.convertSettleVOToSettlePoolVO(settleVO, poolVO);
            poolVO.setBillCodeUrl("/ejc-proother-frontend/#/settleList/card?id=" + settleVO.getId());
            CommonResponse res = this.settlePoolApi.saveOrUpdateSettle(poolVO);
            if (res.isSuccess()) {
                this.logger.info("\u7ed3\u7b97\u5355\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60\u6210\u529f\uff01\u7ed3\u7b97\u5355id-{}", (Object)settleVO.getId());
                return true;
            }
            this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}\uff0c{}", (Object)settleVO.getId(), (Object)res.getMsg());
        }
        catch (Exception e) {
            this.logger.error("\u5408\u540c-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c", (Object)settleVO.getId(), (Object)e);
        }
        return false;
    }

    private void convertSettleVOToSettlePoolVO(SettleVO settleVO, SettlePoolVO poolVO) {
        if (null == settleVO || null == poolVO) {
            this.logger.error("\u5c06\u7ed3\u7b97\u5355\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u539f\u56e0\uff1a\u7ed3\u7b97\u5355\u5bf9\u8c61\u4e3a\u7a7a\u6216\u7ed3\u7b97\u6c60\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u65e0\u6cd5\u8f6c\u6362\uff01");
            return;
        }
        this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u624b\u52a8\u8f6c\u6362\u5f00\u59cb");
        poolVO.setSourceType(settleVO.getSettleType() == 0 ? SettleSourceTypeEnum.\u5176\u4ed6\u652f\u51fa\u5408\u540c\u8fc7\u7a0b\u7ed3\u7b97.getCode() : SettleSourceTypeEnum.\u5176\u4ed6\u652f\u51fa\u5408\u540c\u6700\u7ec8\u7ed3\u7b97.getCode());
        poolVO.setSettleProperty(Integer.valueOf(0));
        poolVO.setUltimateFlag(settleVO.getSettleType() == 1 ? Integer.valueOf(0) : null);
        poolVO.setLastTaxMny(settleVO.getLastTaxMny());
        poolVO.setLastMny(settleVO.getLastMny());
        poolVO.setLastTax(this.getSubStractAbs(settleVO.getLastTaxMny(), settleVO.getLastMny()));
        poolVO.setContractType("otherOut");
        ContractEntity ce = (ContractEntity)((Object)this.contractService.selectById(settleVO.getContractId()));
        this.logger.info("\u7ed3\u7b97\u5355\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60\u8fc7\u7a0b\u4e2d\uff0c\u6839\u636e\u5408\u540cid\u67e5\u8be2\u5408\u540c\uff0c\u5408\u540cid-{}", (Object)settleVO.getContractId());
        if (ce == null) {
            this.logger.info("\u7ed3\u7b97\u5355\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60\u8fc7\u7a0b\u4e2d\uff0c\u6839\u636e\u5408\u540cid\u67e5\u8be2\u5408\u540c\uff0c\u5408\u540cid-{}\uff0c\u672a\u67e5\u8be2\u5230\u5408\u540c\u4fe1\u606f\uff0c\u6545\u7ed3\u7b97\u5355\u7684 \u4e3b\u5408\u540c/\u7532\u65b9/\u4e59\u65b9/\u7b7e\u8ba2\u65e5\u671f/\u521b\u5efa\u65f6\u95f4\u548c\u4eba\u5458/\u66f4\u65b0\u65f6\u95f4\u548c\u4eba\u5458 \u7b49\u4fe1\u606f\u65e0\u6cd5\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60", (Object)settleVO.getContractId());
            return;
        }
        poolVO.setMaiContractId(ce.getMainContractId());
        poolVO.setMaiContractName(ce.getMainContractName());
        poolVO.setMaiContractCode(ce.getMainContractCode());
        poolVO.setPartyaId(ce.getFirstPartyId());
        poolVO.setPartyaName(ce.getFirstPartyName());
        poolVO.setSignDate(ce.getSignDate());
        poolVO.setCreateTime(settleVO.getCreateTime());
        poolVO.setCreateUserCode(settleVO.getCreateUserCode());
        poolVO.setUpdateTime(settleVO.getUpdateTime());
        poolVO.setUpdateUserCode(settleVO.getUpdateUserCode());
        this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u624b\u52a8\u8f6c\u6362\u5b8c\u6210\uff0c\u4e0b\u9762\u5f00\u59cb\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60");
    }

    @Override
    public boolean delSettleFromPool(Long id) {
        SettlePoolVO spv = new SettlePoolVO();
        spv.setSourceId(id);
        CommonResponse res = this.settlePoolApi.deleteSettle(spv);
        if (res.isSuccess()) {
            this.logger.info("\u5c06\u7ed3\u7b97\u5355\u4ece\u7ed3\u7b97\u6c60\u4e2d\u5220\u9664\u6210\u529f\uff01\u7ed3\u7b97\u5355id-{}", (Object)id);
            return true;
        }
        this.logger.error("\u5c06\u7ed3\u7b97\u5355\u4ece\u7ed3\u7b97\u6c60\u4e2d\u5220\u9664\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}\uff0c{}", (Object)id, (Object)res.getMsg());
        return false;
    }

    private BigDecimal getSubStractAbs(BigDecimal a, BigDecimal b) {
        if (a == null || b == null) {
            return null;
        }
        BigDecimal subtract = a.subtract(b);
        if (subtract == null) {
            return null;
        }
        return subtract.abs();
    }

    @Override
    public ExecutionVO targetCost(SettleVO settleVO, String linkUrl) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        ArrayList detailList = new ArrayList();
        totalVO.setSourceId(settleVO.getId());
        totalVO.setTenantId(settleVO.getTenantId());
        totalVO.setBillCode(settleVO.getBillCode());
        totalVO.setOrgId(settleVO.getOrgId());
        totalVO.setBillType("BT220308000000001");
        totalVO.setBussinessType(BussinessTypeEnum.\u5176\u4ed6\u652f\u51fa\u5408\u540c.getCode());
        totalVO.setBillCategory(BillCategoryEnum.\u5408\u540c.getCode());
        if (settleVO.getProjectId() == null) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25,\u8bf7\u66f4\u6362\u9879\u76ee");
        }
        totalVO.setProjectId(settleVO.getProjectId());
        if (settleVO.getOrgId() == null) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25,\u8bf7\u66f4\u6362\u9879\u76ee");
        }
        totalVO.setOrgId(settleVO.getOrgId());
        totalVO.setMoney(settleVO.getMny());
        totalVO.setTaxMoney(settleVO.getTaxMny());
        totalVO.setLinkUrl(linkUrl);
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }
}

