package com.ejianc.business.proother.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 分包变更实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_proother_contract_change")
public class ChangeEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;


    /**
     * 定标结果Id
     */
    @TableField("target_result_id")
    private Long targetResultId;
    /**
     * 甲方经办人部门 名称
     */
    @TableField("department_name")
    private String departmentName;
    /**
     * 甲方经办人部门
     */
    @TableField("department_id")
    private Long departmentId;
    /**
     * 定标结果名称
     */
    @TableField("target_result_name")
    private String targetResultName;

    /**
     * 项目Id
     */
    @TableField("project_id")
    private Long projectId;

    /**
     * 项目名称
     */
    @TableField("project_name")
    private String projectName;

    /**
     * 合同编码
     */
    @TableField("bill_code")
    private String billCode;

    /**
     * 合同名称
     */
    @TableField("contract_name")
    private String contractName;

    /**
     * 合同类别Id
     */
    @TableField("contract_category_id")
    private Long contractCategoryId;

    /**
     * 合同类别名称
     */
    @TableField("contract_category_name")
    private String contractCategoryName;

    /**
     * 甲方Id
     */
    @TableField("first_party_id")
    private Long firstPartyId;

    /**
     * 甲方名称
     */
    @TableField("first_party_name")
    private String firstPartyName;

    /**
     * 供应商Id
     */
    @TableField("supplier_id")
    private Long supplierId;

    /**
     * 供应商名称
     */
    @TableField("supplier_name")
    private String supplierName;

    /**
     * 签订日期
     */
    @TableField("sign_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate;

    /**
     * 签约地点
     */
    @TableField("sign_place")
    private String signPlace;

    /**
     * 签章状态：1-待签章,2-待乙方签章,3-待甲方签章,4-已签章（已完成）,5-已退回（已拒签）,6-已撤回,7-已过期,8-其他已签章；  单据新增后默认为待签章
     */
    @TableField("signature_status")
    private String signatureStatus;

    /**
     * 合同履约状态：1、未签订；2、履约中；3、已终止；4、已作废 5、已冻结；   默认为未签定，签章状态为已签章时，状态自动更改为【履约中】。当合同存在生效的最终结算时，状态自动改为【已终止】
     */
    @TableField("performance_status")
    private String performanceStatus;

    /**
     * 经办人Id
     */
    @TableField("employee_id")
    private Long employeeId;

    /**
     * 经办人名称
     */
    @TableField("employee_name")
    private String employeeName;

    /**
     * 经办人电话
     */
    @TableField("employee_phone")
    private String employeePhone;

    /**
     * 乙方经办人
     */
    @TableField("supplier_employee")
    private String supplierEmployee;

    /**
     * 乙方经办人电话
     */
    @TableField("supplier_employee_phone")
    private String supplierEmployeePhone;

    /**
     * 工程地点
     */
    @TableField("project_address")
    private String projectAddress;

    /**
     * 合同税率
     */
    @TableField("tax_rate")
    private BigDecimal taxRate;

    /**
     * 质量标准Id
     */
    @TableField("quality_standard_id")
    private Long qualityStandardId;

    /**
     * 质量标准名称
     */
    @TableField("quality_standard_name")
    private String qualityStandardName;

    /**
     * 项目计税方式名称:简易计税、一般计税
     */
    @TableField("project_tax_calc_type")
    private String projectTaxCalcType;

    /**
     * 计价方式：1-可调单价、2-固定总价、3-成本加酬金；
     */
    @TableField("pricing_type")
    private String pricingType;

    /**
     * 起草方式：1、线上起草，2、上传合同，3、线下签订
     */
    @TableField("draft_type")
    private String draftType;

    /**
     * 合同附件路径
     */
    @TableField("contract_file_path")
    private String contractFilePath;

    /**
     * 合同附件Id
     */
    @TableField("contract_file_id")
    private Long contractFileId;

    /**
     * 合同模板Id
     */
    @TableField("contract_template_id")
    private Long contractTemplateId;

    /**
     * 合同模板名称
     */
    @TableField("contract_template_name")
    private String contractTemplateName;

    /**
     * 合同附件版本Id
     */
    @TableField("contract_file_version_id")
    private Long contractFileVersionId;

    /**
     * 合同附件版本
     */
    @TableField("contract_file_version")
    private Long contractFileVersion;

    /**
     * 资质id
     */
    @TableField("qualify_id")
    private Long qualifyId;

    /**
     * 资质名称
     */
    @TableField("qualify_name")
    private String qualifyName;

    /**
     * 资质证书编号
     */
    @TableField("qualify_certify_no")
    private String qualifyCertifyNo;

    /**
     * 资质证书发证机关
     */
    @TableField("qualify_licence_issuing_authority")
    private String qualifyLicenceIssuingAuthority;

    /**
     * 资质证书授予日期
     */
    @TableField("qualify_grant_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date qualifyGrantDate;

    /**
     * 资质证书有效期至
     */
    @TableField("qualify_valid_till_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date qualifyValidTillDate;

    /**
     * 安全生成许可证编号
     */
    @TableField("safety_production_license_no")
    private String safetyProductionLicenseNo;

    /**
     * 安全生产许可证授予日期
     */
    @TableField("safety_certify_grant_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date safetyCertifyGrantDate;

    /**
     * 安全许可证有效期至
     */
    @TableField("safety_certify_valid_till_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date safetyCertifyValidTillDate;

    /**
     * 开工日期
     */
    @TableField("project_start_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date projectStartDate;

    /**
     * 计划竣工日期
     */
    @TableField("planned_finish_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date plannedFinishDate;

    /**
     * 合同工期:合同工期=计划竣工日期-开工日期+1
     */
    @TableField("contract_days_limit")
    private Integer contractDaysLimit;

    /**
     * 甲方项目经理Id
     */
    @TableField("first_party_project_manager_id")
    private Long firstPartyProjectManagerId;

    /**
     * 甲方项目经理名称
     */
    @TableField("first_party_project_manager_name")
    private String firstPartyProjectManagerName;

    /**
     * 甲方项目经理联系电话
     */
    @TableField("first_party_project_manager_link")
    private String firstPartyProjectManagerLink;

    /**
     * 甲方项目经理职务
     */
    @TableField("first_party_project_manager_post")
    private String firstPartyProjectManagerPost;

    /**
     * 乙方项目经理Id
     */
    @TableField("supplier_project_manager_id")
    private Long supplierProjectManagerId;

    /**
     * 乙方项目经理名称
     */
    @TableField("supplier_project_manager_name")
    private String supplierProjectManagerName;

    /**
     * 乙方项目经理联系电话
     */
    @TableField("supplier_project_manager_link")
    private String supplierProjectManagerLink;

    /**
     * 乙方项目经理职务
     */
    @TableField("supplier_project_manager_post")
    private String supplierProjectManagerPost;

    /**
     * 乙方项目经理身份证号
     */
    @TableField("supplier_project_manager_id_card")
    private String supplierProjectManagerIdCard;

    /**
     * 合同金额（含税）
     */
    @TableField("contract_tax_mny")
    private BigDecimal contractTaxMny;

    /**
     * 合同金额（无税）
     */
    @TableField("contract_mny")
    private BigDecimal contractMny;

    /**
     * 合同税额
     */
    @TableField("contract_tax")
    private BigDecimal contractTax;

    /**
     * 分包金额（含税）
     */
    @TableField("sub_contract_tax_mny")
    private BigDecimal subContractTaxMny;

    /**
     * 分包金额（无税）
     */
    @TableField("sub_contract_mny")
    private BigDecimal subContractMny;

    /**
     * 分包税额
     */
    @TableField("sub_contract_tax")
    private BigDecimal subContractTax;

    /**
     * 其他金额（含税）
     */
    @TableField("other_cost_tax_mny")
    private BigDecimal otherCostTaxMny;

    /**
     * 其他金额（无税）
     */
    @TableField("other_cost_mny")
    private BigDecimal otherCostMny;

    /**
     * 其他税额
     */
    @TableField("other_cost_tax")
    private BigDecimal otherCostTax;

    /**
     * 单据状态
     */
    @TableField("bill_state")
    private Integer billState;

    /**
     * 提交日期
     */
    @TableField("commit_date")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date commitDate;

    /**
     * 提交人名称
     */
    @TableField("commit_user_name")
    private String commitUserName;

    /**
     * 提交人账号
     */
    @TableField("commit_user_code")
    private String commitUserCode;

    /**
     * 生效日期
     */
    @TableField("effective_date")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date effectiveDate;

    /**
     * 项目部Id
     */
    @TableField("org_id")
    private Long orgId;

    /**
     * 项目部名称
     */
    @TableField("org_name")
    private String orgName;

    /**
     * 项目部上级组织Id
     */
    @TableField("parent_org_id")
    private Long parentOrgId;

    /**
     * 项目部上级组织名称
     */
    @TableField("parent_org_name")
    private String parentOrgName;

    /**
     * 项目部上级组织编码
     */
    @TableField("parent_org_code")
    private String parentOrgCode;

    /**
     * 合同高亮附件路径
     */
    @TableField("contract_file_highlight_path")
    private String contractFileHighlightPath;

    /**
     * 合同高亮附件Id
     */
    @TableField("contract_file_highlight_id")
    private Long contractFileHighlightId;

    /**
     * 初始版本金额
     */
    @TableField("base_mny")
    private BigDecimal baseMny;

    /**
     * 初始版本(含税)金额
     */
    @TableField("base_tax_mny")
    private BigDecimal baseTaxMny;

    /**
     * 变更前金额
     */
    @TableField("before_change_mny")
    private BigDecimal beforeChangeMny;

    /**
     * 变更前金额（含税）
     */
    @TableField("before_change_tax_mny")
    private BigDecimal beforeChangeTaxMny;

    /**
     * 变更版本
     */
    @TableField("change_version")
    private Integer changeVersion;

    /**
     * 是否补充协议(1:是，0：否)
     */
    @TableField("supplement_flag")
    private Integer supplementFlag;

    /**
     * 主合同Id
     */
    @TableField("main_contract_id")
    private Long mainContractId;

    /**
     * 主合同编码
     */
    @TableField("main_contract_code")
    private String mainContractCode;

    /**
     * 主合同名称
     */
    @TableField("main_contract_name")
    private String mainContractName;

    /**
     * 合同ID
     */
    @TableField("contract_id")
    private Long contractId;

    /**
     * 变更前合同名称
     */
    @TableField("before_contract_name")
    private String beforeContractName;

    /**
     * 变更项：用、号隔开。如：数量、单价、税率、甲方、乙方；
     */
    @TableField("change_items")
    private String changeItems;

    /**
     * 经办人
     */
    @TableField("change_employee_id")
    private Long changeEmployeeId;

    /**
     * 经办人名称
     */
    @TableField("change_employee_name")
    private String changeEmployeeName;


    /**
     * 变更 甲方经办人部门 名称
     */
    @TableField("change_department_name")
    private String changeDepartmentName;
    /**
     * 变更 甲方经办人部门
     */
    @TableField("change_department_id")
    private Long changeDepartmentId;


    /**
     * 本次变更金额
     */
    @TableField("change_mny")
    private BigDecimal changeMny;

    /**
     * 本次变更比例
     */
    @TableField("change_scale")
    private BigDecimal changeScale;

    /**
     * 本次变更税额
     */
    @TableField("change_tax")
    private BigDecimal changeTax;

    /**
     * 变更原因描述
     */
    @TableField("change_reason")
    private String changeReason;

    /**
     * 变更起草方式：1-上传附件，2-线下签订，3-线下签订
     */
    @TableField("change_draft_type")
    private String changeDraftType;

    /**
     * 变更附件Id
     */
    @TableField("change_file_id")
    private Long changeFileId;

    /**
     * 变更附件路径
     */
    @TableField("change_file_path")
    private String changeFilePath;

    /**
     * 变更日期
     */
    @TableField("change_date")
    private Date changeDate;

    /**
     * 合同类型：分包合同-0，专业合同-1
     */
    @TableField("contract_type")
    private Integer contractType;

    /**
     * 合同新增方式：参照定标结果新增-0，直接新增-1
     */
    @TableField("add_type")
    private Integer addType;

    /**
     * 项目编码
     */
    @TableField("project_code")
    private String projectCode;

    /**
     * 项目部编码
     */
    @TableField("org_code")
    private String orgCode;

    /**
     * 分包变更明细实体
     */
    @TableField(exist = false)
    @SubEntity(serviceName = "changeDetailService", pidName = "changeId")
    private List<ChangeDetailEntity> detailList = new ArrayList<>();

    /**
     * 分包变更付款阶段实体
     */
    @TableField(exist = false)
    @SubEntity(serviceName = "changePaymentService", pidName = "changeId")
    private List<com.ejianc.business.proother.bean.ChangePaymentEntity> paymentList = new ArrayList<>();

    /**
     * 分包变更条款实体
     */
    @TableField(exist = false)
    @SubEntity(serviceName = "changeClauseService", pidName = "changeId")
    private List<ChangeClauseEntity> clauseList = new ArrayList<>();

    /**
     * 分包变更其他费用实体
     */
    @TableField(exist = false)
    @SubEntity(serviceName = "changeOtherCostService", pidName = "changeId")
    private List<com.ejianc.business.proother.bean.ChangeOtherCostEntity> otherCostList = new ArrayList<>();

    /**
     * 完成签章附件Id
     */
    @TableField("signed_file_id")
    private Long signedFileId;

    public String getChangeDepartmentName() {
        return changeDepartmentName;
    }

    public void setChangeDepartmentName(String changeDepartmentName) {
        this.changeDepartmentName = changeDepartmentName;
    }

    public Long getChangeDepartmentId() {
        return changeDepartmentId;
    }

    public void setChangeDepartmentId(Long changeDepartmentId) {
        this.changeDepartmentId = changeDepartmentId;
    }

    public Long getTargetResultId() {
        return targetResultId;
    }

    public void setTargetResultId(Long targetResultId) {
        this.targetResultId = targetResultId;
    }

    public String getTargetResultName() {
        return targetResultName;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public void setTargetResultName(String targetResultName) {
        this.targetResultName = targetResultName;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public Long getContractCategoryId() {
        return contractCategoryId;
    }

    public void setContractCategoryId(Long contractCategoryId) {
        this.contractCategoryId = contractCategoryId;
    }

    public String getContractCategoryName() {
        return contractCategoryName;
    }

    public void setContractCategoryName(String contractCategoryName) {
        this.contractCategoryName = contractCategoryName;
    }

    public Long getFirstPartyId() {
        return firstPartyId;
    }

    public void setFirstPartyId(Long firstPartyId) {
        this.firstPartyId = firstPartyId;
    }

    public String getFirstPartyName() {
        return firstPartyName;
    }

    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public String getSignPlace() {
        return signPlace;
    }

    public void setSignPlace(String signPlace) {
        this.signPlace = signPlace;
    }

    public String getSignatureStatus() {
        return signatureStatus;
    }

    public void setSignatureStatus(String signatureStatus) {
        this.signatureStatus = signatureStatus;
    }

    public String getPerformanceStatus() {
        return performanceStatus;
    }

    public void setPerformanceStatus(String performanceStatus) {
        this.performanceStatus = performanceStatus;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getEmployeePhone() {
        return employeePhone;
    }

    public void setEmployeePhone(String employeePhone) {
        this.employeePhone = employeePhone;
    }

    public String getSupplierEmployee() {
        return supplierEmployee;
    }

    public void setSupplierEmployee(String supplierEmployee) {
        this.supplierEmployee = supplierEmployee;
    }

    public String getSupplierEmployeePhone() {
        return supplierEmployeePhone;
    }

    public void setSupplierEmployeePhone(String supplierEmployeePhone) {
        this.supplierEmployeePhone = supplierEmployeePhone;
    }

    public String getProjectAddress() {
        return projectAddress;
    }

    public void setProjectAddress(String projectAddress) {
        this.projectAddress = projectAddress;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public Long getQualityStandardId() {
        return qualityStandardId;
    }

    public void setQualityStandardId(Long qualityStandardId) {
        this.qualityStandardId = qualityStandardId;
    }

    public String getQualityStandardName() {
        return qualityStandardName;
    }

    public void setQualityStandardName(String qualityStandardName) {
        this.qualityStandardName = qualityStandardName;
    }

    public String getProjectTaxCalcType() {
        return projectTaxCalcType;
    }

    public void setProjectTaxCalcType(String projectTaxCalcType) {
        this.projectTaxCalcType = projectTaxCalcType;
    }

    public String getPricingType() {
        return pricingType;
    }

    public void setPricingType(String pricingType) {
        this.pricingType = pricingType;
    }

    public String getDraftType() {
        return draftType;
    }

    public void setDraftType(String draftType) {
        this.draftType = draftType;
    }

    public String getContractFilePath() {
        return contractFilePath;
    }

    public void setContractFilePath(String contractFilePath) {
        this.contractFilePath = contractFilePath;
    }

    public Long getContractFileId() {
        return contractFileId;
    }

    public void setContractFileId(Long contractFileId) {
        this.contractFileId = contractFileId;
    }

    public Long getContractTemplateId() {
        return contractTemplateId;
    }

    public void setContractTemplateId(Long contractTemplateId) {
        this.contractTemplateId = contractTemplateId;
    }

    public String getContractTemplateName() {
        return contractTemplateName;
    }

    public void setContractTemplateName(String contractTemplateName) {
        this.contractTemplateName = contractTemplateName;
    }

    public Long getContractFileVersionId() {
        return contractFileVersionId;
    }

    public void setContractFileVersionId(Long contractFileVersionId) {
        this.contractFileVersionId = contractFileVersionId;
    }

    public Long getContractFileVersion() {
        return contractFileVersion;
    }

    public void setContractFileVersion(Long contractFileVersion) {
        this.contractFileVersion = contractFileVersion;
    }

    public Long getQualifyId() {
        return qualifyId;
    }

    public void setQualifyId(Long qualifyId) {
        this.qualifyId = qualifyId;
    }

    public String getQualifyName() {
        return qualifyName;
    }

    public void setQualifyName(String qualifyName) {
        this.qualifyName = qualifyName;
    }

    public String getQualifyCertifyNo() {
        return qualifyCertifyNo;
    }

    public void setQualifyCertifyNo(String qualifyCertifyNo) {
        this.qualifyCertifyNo = qualifyCertifyNo;
    }

    public String getQualifyLicenceIssuingAuthority() {
        return qualifyLicenceIssuingAuthority;
    }

    public void setQualifyLicenceIssuingAuthority(String qualifyLicenceIssuingAuthority) {
        this.qualifyLicenceIssuingAuthority = qualifyLicenceIssuingAuthority;
    }

    public Date getQualifyGrantDate() {
        return qualifyGrantDate;
    }

    public void setQualifyGrantDate(Date qualifyGrantDate) {
        this.qualifyGrantDate = qualifyGrantDate;
    }

    public Date getQualifyValidTillDate() {
        return qualifyValidTillDate;
    }

    public void setQualifyValidTillDate(Date qualifyValidTillDate) {
        this.qualifyValidTillDate = qualifyValidTillDate;
    }

    public String getSafetyProductionLicenseNo() {
        return safetyProductionLicenseNo;
    }

    public void setSafetyProductionLicenseNo(String safetyProductionLicenseNo) {
        this.safetyProductionLicenseNo = safetyProductionLicenseNo;
    }

    public Date getSafetyCertifyGrantDate() {
        return safetyCertifyGrantDate;
    }

    public void setSafetyCertifyGrantDate(Date safetyCertifyGrantDate) {
        this.safetyCertifyGrantDate = safetyCertifyGrantDate;
    }

    public Date getSafetyCertifyValidTillDate() {
        return safetyCertifyValidTillDate;
    }

    public void setSafetyCertifyValidTillDate(Date safetyCertifyValidTillDate) {
        this.safetyCertifyValidTillDate = safetyCertifyValidTillDate;
    }

    public Date getProjectStartDate() {
        return projectStartDate;
    }

    public void setProjectStartDate(Date projectStartDate) {
        this.projectStartDate = projectStartDate;
    }

    public Date getPlannedFinishDate() {
        return plannedFinishDate;
    }

    public void setPlannedFinishDate(Date plannedFinishDate) {
        this.plannedFinishDate = plannedFinishDate;
    }

    public Integer getContractDaysLimit() {
        return contractDaysLimit;
    }

    public void setContractDaysLimit(Integer contractDaysLimit) {
        this.contractDaysLimit = contractDaysLimit;
    }

    public Long getFirstPartyProjectManagerId() {
        return firstPartyProjectManagerId;
    }

    public void setFirstPartyProjectManagerId(Long firstPartyProjectManagerId) {
        this.firstPartyProjectManagerId = firstPartyProjectManagerId;
    }

    public String getFirstPartyProjectManagerName() {
        return firstPartyProjectManagerName;
    }

    public void setFirstPartyProjectManagerName(String firstPartyProjectManagerName) {
        this.firstPartyProjectManagerName = firstPartyProjectManagerName;
    }

    public String getFirstPartyProjectManagerLink() {
        return firstPartyProjectManagerLink;
    }

    public void setFirstPartyProjectManagerLink(String firstPartyProjectManagerLink) {
        this.firstPartyProjectManagerLink = firstPartyProjectManagerLink;
    }

    public String getFirstPartyProjectManagerPost() {
        return firstPartyProjectManagerPost;
    }

    public void setFirstPartyProjectManagerPost(String firstPartyProjectManagerPost) {
        this.firstPartyProjectManagerPost = firstPartyProjectManagerPost;
    }

    public Long getSupplierProjectManagerId() {
        return supplierProjectManagerId;
    }

    public void setSupplierProjectManagerId(Long supplierProjectManagerId) {
        this.supplierProjectManagerId = supplierProjectManagerId;
    }

    public String getSupplierProjectManagerName() {
        return supplierProjectManagerName;
    }

    public void setSupplierProjectManagerName(String supplierProjectManagerName) {
        this.supplierProjectManagerName = supplierProjectManagerName;
    }

    public String getSupplierProjectManagerLink() {
        return supplierProjectManagerLink;
    }

    public void setSupplierProjectManagerLink(String supplierProjectManagerLink) {
        this.supplierProjectManagerLink = supplierProjectManagerLink;
    }

    public String getSupplierProjectManagerPost() {
        return supplierProjectManagerPost;
    }

    public void setSupplierProjectManagerPost(String supplierProjectManagerPost) {
        this.supplierProjectManagerPost = supplierProjectManagerPost;
    }

    public String getSupplierProjectManagerIdCard() {
        return supplierProjectManagerIdCard;
    }

    public void setSupplierProjectManagerIdCard(String supplierProjectManagerIdCard) {
        this.supplierProjectManagerIdCard = supplierProjectManagerIdCard;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getContractTax() {
        return contractTax;
    }

    public void setContractTax(BigDecimal contractTax) {
        this.contractTax = contractTax;
    }

    public BigDecimal getSubContractTaxMny() {
        return subContractTaxMny;
    }

    public void setSubContractTaxMny(BigDecimal subContractTaxMny) {
        this.subContractTaxMny = subContractTaxMny;
    }

    public BigDecimal getSubContractMny() {
        return subContractMny;
    }

    public void setSubContractMny(BigDecimal subContractMny) {
        this.subContractMny = subContractMny;
    }

    public BigDecimal getSubContractTax() {
        return subContractTax;
    }

    public void setSubContractTax(BigDecimal subContractTax) {
        this.subContractTax = subContractTax;
    }

    public BigDecimal getOtherCostTaxMny() {
        return otherCostTaxMny;
    }

    public void setOtherCostTaxMny(BigDecimal otherCostTaxMny) {
        this.otherCostTaxMny = otherCostTaxMny;
    }

    public BigDecimal getOtherCostMny() {
        return otherCostMny;
    }

    public void setOtherCostMny(BigDecimal otherCostMny) {
        this.otherCostMny = otherCostMny;
    }

    public BigDecimal getOtherCostTax() {
        return otherCostTax;
    }

    public void setOtherCostTax(BigDecimal otherCostTax) {
        this.otherCostTax = otherCostTax;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getContractFileHighlightPath() {
        return contractFileHighlightPath;
    }

    public void setContractFileHighlightPath(String contractFileHighlightPath) {
        this.contractFileHighlightPath = contractFileHighlightPath;
    }

    public Long getContractFileHighlightId() {
        return contractFileHighlightId;
    }

    public void setContractFileHighlightId(Long contractFileHighlightId) {
        this.contractFileHighlightId = contractFileHighlightId;
    }

    public BigDecimal getBaseMny() {
        return baseMny;
    }

    public void setBaseMny(BigDecimal baseMny) {
        this.baseMny = baseMny;
    }

    public BigDecimal getBaseTaxMny() {
        return baseTaxMny;
    }

    public void setBaseTaxMny(BigDecimal baseTaxMny) {
        this.baseTaxMny = baseTaxMny;
    }

    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }

    public BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    public void setBeforeChangeTaxMny(BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }

    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }

    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }

    public Long getMainContractId() {
        return mainContractId;
    }

    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }

    public String getMainContractCode() {
        return mainContractCode;
    }

    public void setMainContractCode(String mainContractCode) {
        this.mainContractCode = mainContractCode;
    }

    public String getMainContractName() {
        return mainContractName;
    }

    public void setMainContractName(String mainContractName) {
        this.mainContractName = mainContractName;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getBeforeContractName() {
        return beforeContractName;
    }

    public void setBeforeContractName(String beforeContractName) {
        this.beforeContractName = beforeContractName;
    }

    public String getChangeItems() {
        return changeItems;
    }

    public void setChangeItems(String changeItems) {
        this.changeItems = changeItems;
    }

    public Long getChangeEmployeeId() {
        return changeEmployeeId;
    }

    public void setChangeEmployeeId(Long changeEmployeeId) {
        this.changeEmployeeId = changeEmployeeId;
    }

    public String getChangeEmployeeName() {
        return changeEmployeeName;
    }

    public void setChangeEmployeeName(String changeEmployeeName) {
        this.changeEmployeeName = changeEmployeeName;
    }

    public BigDecimal getChangeMny() {
        return changeMny;
    }

    public void setChangeMny(BigDecimal changeMny) {
        this.changeMny = changeMny;
    }

    public BigDecimal getChangeScale() {
        return changeScale;
    }

    public void setChangeScale(BigDecimal changeScale) {
        this.changeScale = changeScale;
    }

    public BigDecimal getChangeTax() {
        return changeTax;
    }

    public void setChangeTax(BigDecimal changeTax) {
        this.changeTax = changeTax;
    }

    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    public String getChangeDraftType() {
        return changeDraftType;
    }

    public void setChangeDraftType(String changeDraftType) {
        this.changeDraftType = changeDraftType;
    }

    public Long getChangeFileId() {
        return changeFileId;
    }

    public void setChangeFileId(Long changeFileId) {
        this.changeFileId = changeFileId;
    }

    public String getChangeFilePath() {
        return changeFilePath;
    }

    public void setChangeFilePath(String changeFilePath) {
        this.changeFilePath = changeFilePath;
    }

    public Date getChangeDate() {
        return changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }

    public Integer getContractType() {
        return contractType;
    }

    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }

    public Integer getAddType() {
        return addType;
    }

    public void setAddType(Integer addType) {
        this.addType = addType;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public List<ChangeDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<ChangeDetailEntity> detailList) {
        this.detailList = detailList;
    }

    public List<com.ejianc.business.proother.bean.ChangePaymentEntity> getPaymentList() {
        return paymentList;
    }

    public void setPaymentList(List<com.ejianc.business.proother.bean.ChangePaymentEntity> paymentList) {
        this.paymentList = paymentList;
    }

    public List<ChangeClauseEntity> getClauseList() {
        return clauseList;
    }

    public void setClauseList(List<ChangeClauseEntity> clauseList) {
        this.clauseList = clauseList;
    }

    public List<com.ejianc.business.proother.bean.ChangeOtherCostEntity> getOtherCostList() {
        return otherCostList;
    }

    public void setOtherCostList(List<com.ejianc.business.proother.bean.ChangeOtherCostEntity> otherCostList) {
        this.otherCostList = otherCostList;
    }

    public Long getSignedFileId() {
        return signedFileId;
    }

    public void setSignedFileId(Long signedFileId) {
        this.signedFileId = signedFileId;
    }
}
