package com.ejianc.business.settle.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.contractbase.api.ITemplateCategoryApi;
import com.ejianc.business.proother.bean.ContractEntity;
import com.ejianc.business.proother.enums.BillPushStatusEnum;
import com.ejianc.business.proother.enums.PerformanceStatusEnum;
import com.ejianc.business.proother.service.IContractService;
import com.ejianc.business.proother.vo.ContractVO;
import com.ejianc.business.settle.bean.SettleEntity;
import com.ejianc.business.settle.enums.SettleTypeEnum;
import com.ejianc.business.settle.service.ISettleService;
import com.ejianc.business.settle.vo.SettleVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Service("settle") 
public class SettleBpmServiceImpl implements ICommonBusinessService {
	private final Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IBillTypeApi billTypeApi;

	@Autowired
	private ISettleService service;
	@Autowired
	private SessionManager sessionManager;

	@Autowired
	private IContractService contractService;

	@Value("${common.env.base-host}")
	private String BaseHost;

	@Autowired
	private ITemplateCategoryApi templateCategoryApi;

	@Autowired
	private IExecutionApi executionApi;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		SettleEntity settleEntity = service.selectById(billId);
		if (settleEntity != null) {
			settleEntity.setEffectiveDate(new Date());
		}
		if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
			//直审时添加单据提交人等信息
			UserContext userContext = sessionManager.getUserContext();
			settleEntity.setCommitDate(new Date());
			settleEntity.setCommitUserCode(userContext.getUserCode());
			settleEntity.setCommitUserName(userContext.getUserName());
		}
		//推送结算池
		boolean poolRes = service.pushSettleToPool(BeanMapper.map(settleEntity, SettleVO.class));
		settleEntity.setPushPoolFlag(poolRes ? BillPushStatusEnum.推送成功.getStatus() : BillPushStatusEnum.未成功推送.getStatus());
		service.saveOrUpdate(settleEntity, false);
		if (settleEntity.getSettleType()==1){
			// 完工结算修改合同状态为已终止
			QueryParam param = new QueryParam();
			param.getParams().put("id", new Parameter(QueryParam.EQ, settleEntity.getContractId()));
			List<ContractEntity> contractEntities = contractService.queryList(param, false);
			contractEntities.get(0).setPerformanceStatus(PerformanceStatusEnum.已终止.getCode());
			logger.info("======完工结算终审审核完回调,已终止======,{}", JSONObject.toJSONString(contractEntities.get(0)));
			contractService.saveOrUpdate(contractEntities.get(0), false);

			//终审审核完最终结算单据推送目标成本  taxMny本期计算金额
			//根据合同ID查询已生效结算金额累计
			LambdaQueryWrapper<SettleEntity> lambda = new LambdaQueryWrapper<>();
			lambda.eq(SettleEntity::getContractId, settleEntity.getContractId());
			lambda.eq(SettleEntity::getDr,0);
			lambda.in(SettleEntity::getBillState,1,3);
			List<SettleEntity> entities = service.list(lambda);
			//本期结算金额
			BigDecimal sumTaxMny = BigDecimal.ZERO;//最终结算本期结算金额累计 含税
			BigDecimal sumMny = BigDecimal.ZERO;//无税
			if(CollectionUtils.isNotEmpty(entities)){
				for(SettleEntity settleEntity1:entities){
					sumTaxMny = ComputeUtil.safeAdd(sumTaxMny, settleEntity1.getTaxMny());
					sumMny = ComputeUtil.safeAdd(sumMny, settleEntity1.getMny());
				}
			}
			//查询合同金额
			LambdaQueryWrapper<ContractEntity> querylambda = new LambdaQueryWrapper<>();
			querylambda.eq(ContractEntity::getId, settleEntity.getContractId());
			querylambda.eq(ContractEntity::getDr,0);
			querylambda.in(ContractEntity::getBillState,1,3);
			List<ContractEntity> contractEntityList = contractService.list(querylambda);
			//查询合同只有一条 contractTaxMny合同金额(含税)
			BigDecimal sumConTaxMny = BigDecimal.ZERO;//推送含税金额
			BigDecimal sumConMny = BigDecimal.ZERO;//推送无税金额
			for(ContractEntity contractEntity:contractEntityList){
				contractEntity.getContractMny();//无税
				contractEntity.getContractMny();//含税
				sumConMny = ComputeUtil.safeSub(sumMny, contractEntity.getContractMny());
				sumConTaxMny = ComputeUtil.safeSub(sumTaxMny,contractEntity.getContractTaxMny());
			}
			//修改结算单金额
			settleEntity.setTaxMny(sumConTaxMny);
			settleEntity.setMny(sumConMny);
			//推送总金额执行表
			//目标成本推送
			String linkUrl = BaseHost+"ejc-proother-frontend/#/contract/Card?id="+settleEntity.getId();
			ExecutionVO executionVO = service.targetCost(BeanMapper.map(settleEntity, SettleVO.class),linkUrl);
			logger.info("目标成本推送数据"+ JSON.toJSONString(executionVO));
			CommonResponse<String> response = executionApi.aggPush(executionVO);
			if (!response.isSuccess()){
				throw new BusinessException("目标成本推送失败,"+response.getMsg());
			}
			return CommonResponse.success("完工结算终审回调成功！");
		}else {
			return CommonResponse.success("过程结算终审回调成功！");
		}



	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}
	private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {

		logger.info("完工单据billId-{}, state-{}, billTypeCode-{}撤回前校验", billId, state, billTypeCode);
		// 签章流程校验
		SettleEntity settleEntity = service.selectById(billId);
		if (settleEntity == null) {
			return CommonResponse.error("查询不到该单据信息！");
		}
		//合同是否被其他单据引用
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况" + res.isSuccess() + "----" + res.getMsg());
		if (!res.isSuccess()) {
			return CommonResponse.error("当前单据已被下游业务引用，不能弃审/撤回！");
		}
		//若当前合同有其他结算的自由态的结算单，也不能弃审/撤回！
		LambdaQueryWrapper<SettleEntity> settleLambda = new LambdaQueryWrapper<>();
		settleLambda.eq(SettleEntity::getContractId, settleEntity.getContractId());
		settleLambda.ne(SettleEntity::getId, billId);
		settleLambda.and(c -> c.notIn(SettleEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()));

		List<SettleEntity> resultList = service.list(settleLambda);
		if (resultList.size() > 0 && null != resultList.get(0)){
			String settleTypeName = (null != resultList.get(0).getSettleType()) ? SettleTypeEnum.getDescriptionByCode(resultList.get(0).getSettleType()).getDescription() : "";
			return CommonResponse.error("当前合同有未审批的" + settleTypeName + "结算单，不能弃审/撤回!");
		}

		//若当前结算单不是最新的，则不能弃审/撤回
		QueryParam param = new QueryParam();
		param.getParams().put("contract_id", new Parameter(QueryParam.EQ, settleEntity.getContractId()));
		param.getOrderMap().put("create_time", QueryParam.DESC);
		List<SettleEntity> settleList = service.queryList(param);
		logger.info("查询过程结算信息：contractId-" + settleEntity.getContractId());
		if (CollectionUtils.isNotEmpty(settleList) && null != settleList.get(0)){
			logger.info("查询最新的过程结算结果：{}", JSONObject.toJSONString(settleList.get(0), SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
			SettleEntity processSettle = settleList.get(0);
			logger.info("nodeSettle.id-" + processSettle.getId());
			logger.info("billId-" + billId);
			if (!processSettle.getId().equals(billId)){
				return CommonResponse.error("当前单据已有新的结算单，不能弃审/撤回！");
			}
		}
		// 从结算池中删除数据
		boolean unPushRes = service.delSettleFromPool(settleEntity.getId());
		if (unPushRes) {
			settleEntity.setPushPoolFlag(BillPushStatusEnum.未成功推送.getStatus());
		} else {
			logger.error("将过程结算单-{}从结算池删除失败！", settleEntity);
		}

		//如果是完工结算 就去修改合同状态
		if (settleEntity.getSettleType()==1){
			logger.info("完工结算弃审/撤回前回调结算实体信息为：{}", JSONObject.toJSONString(settleEntity, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
			// 完工结算撤回修改合同状态为履约中
			QueryParam qq = new QueryParam();
			qq.getParams().put("id", new Parameter(QueryParam.EQ, settleEntity.getContractId()));
			List<ContractEntity> contractEntities = contractService.queryList(qq, false);
			contractEntities.get(0).setPerformanceStatus(PerformanceStatusEnum.履约中.getCode());
			logger.info("======完工结算弃审前回调,修改合同状态为履约中======,{}", JSONObject.toJSONString(contractEntities.get(0)));
			contractService.saveOrUpdate(contractEntities.get(0), false);
		}else {
			//当前合同是否有最终结算
			LambdaQueryWrapper<SettleEntity> lambda = new LambdaQueryWrapper<>();
			lambda.eq(SettleEntity::getContractId, settleEntity.getContractId());
			lambda.eq(SettleEntity::getSettleType, SettleTypeEnum.完工.getCode());
			int resultCount = service.count(lambda);
			logger.info("查询最终结算信息：contractId-" + settleEntity.getContractId());
			logger.info("查询最终结算结果：resultCount-" + resultCount);
			if (resultCount > 0) {
				return CommonResponse.error("当前单据所用合同已被完工结算引用，不能弃审/撤回！");
			}
		}
		service.saveOrUpdate(settleEntity, false);
		return CommonResponse.success("弃审/撤回前校验回调成功！");
	}
}
