package com.ejianc.business.proother.service;


import com.ejianc.business.proother.bean.ContractEntity;
import com.ejianc.business.proother.vo.ContractVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;
import java.util.Map;

/**
 * 分包合同实体
 * 
 * @author generator
 * 
 */
public interface IContractService extends IBaseService<ContractEntity> {

ContractVO insertOrUpdate(ContractVO saveorUpdateVO, String authority, Boolean isControl);

    String getLinkUrl(ContractVO cv);
    // 校验  劳务/专业分包合同-补充协议  【合同金额】控【补充协议金额】  补充协议金额 > 合同金额*X%  提醒等级：1-不控制-none，2-提醒-warn，3-无法保存-alert，默认提醒
    ParamsCheckVO supplementMnyCtrl(ContractVO contractVO, Boolean flag);

    Map<String, Object> countContractAmount(QueryParam param);

    ContractVO queryDetail(Long id);

    ExecutionVO targetCost(ContractVO contractVO, String linkUrl, Integer contractType);
    /**
     * 查询当前合同下补充协议列表
     * @param id
     * @return
     */
    ContractVO querySupplementRecord(Long id);
    /**
     * 新增或者修改补充协议
     *
     * @param saveorUpdateVO
     * @return
     */
    ContractVO saveOrUpdateSupplement(ContractVO saveorUpdateVO, Boolean isControl);

    ContractVO addConvertByConId(Long contractId);

    Boolean addSupplementFlag(Long id);

    /**
     * 删除附件
     * @param fileId
     * @param authority
     * @return
     */
    Boolean delContractFile(Long fileId, String authority);

    /**
     * 批量删除
     * @param vos
     * @return
     */
    CommonResponse<String> deleteByIds(List<ContractVO> vos);

    /**
     * 合同推送合同池
     *
     * @param contract
     * @return
     */
    boolean pushContract(ContractVO contract);

    /**
     * 将合同从合同池删除
     *
     * @param id
     * @return
     */
    boolean delContractFromPool(Long id);

    /**
     * 删除当前合同的合同附件
     * @param id
     * @return
     */
    Integer deleteContractFileById(Long id);
}
