package com.ejianc.business.proother.controller;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.contract.relieve.service.IContractRelieveService;
import com.ejianc.business.contractbase.api.ITemplateCategoryApi;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.vo.TemplateCategoryVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.proother.bean.ContractDetailEntity;
import com.ejianc.business.proother.bean.ContractEntity;
import com.ejianc.business.proother.bean.ContractOtherCostEntity;
import com.ejianc.business.proother.enums.BillPushStatusEnum;
import com.ejianc.business.proother.enums.PerformanceStatusEnum;
import com.ejianc.business.proother.enums.SignatureStatusEnum;
import com.ejianc.business.proother.service.IContractDetailService;
import com.ejianc.business.proother.service.IContractOtherCostService;
import com.ejianc.business.proother.service.IContractService;
import com.ejianc.business.proother.util.ParamCtrlUtil;
import com.ejianc.business.proother.utils.TreeNodeBUtil;
import com.ejianc.business.proother.vo.ContractDetailVO;
import com.ejianc.business.proother.vo.ContractOtherCostVO;
import com.ejianc.business.proother.vo.ContractPaymentVO;
import com.ejianc.business.proother.vo.ContractVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springside.modules.nosql.redis.JedisTemplate;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;


/**
 * 分包合同实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("contract")
public class ContractController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IContractService service;

    @Autowired
    private IContractDetailService detailService;

    @Autowired
    private IContractOtherCostService otherCostService;

    @Autowired
    private IContractPoolApi contractPoolApi;

    //其他支出合同单据编码
    private final String OTHER_CONTRACT_Bill_CODE = "BT220308000000001";

    @Autowired
    private ITemplateCategoryApi templateCategoryApi;

    @Autowired
    private IContractRelieveService contractRelieveService;

    @Value("${common.env.base-host}")
    private String BaseHost;

    @Autowired
    private IExecutionApi executionApi;

    @Autowired
    private CacheManager cacheManager;
    private final String PUSH_POOL_PREFIX = "pushContract::";

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ContractVO> saveOrUpdate(@RequestBody ContractVO contractVO, HttpServletRequest req) {
        String authority = req.getHeader("authority");
        ContractVO vo = service.insertOrUpdate(contractVO, authority, false);
        return CommonResponse.success("保存成功！", vo);
    }

    /**
     * 根据合同Id查询合同文件管理信息
     *
     * @param contractId 合同Id
     * @return
     */
    @GetMapping(value = "/getContractFileMgrInfo")
    @ResponseBody
    public CommonResponse<JSONObject> getContractFileMgrInfo(@RequestParam(value = "contractId") Long contractId) {
        JSONObject resp = new JSONObject();
        ContractEntity contractEntity = service.selectById(contractId);
        CommonResponse<TemplateCategoryVO> categoryResp = templateCategoryApi.queryTmplCategoryById(contractEntity.getContractCategoryId());
        if(!categoryResp.isSuccess()) {
            logger.error("根据合同类别I的-{}查询对应合同类别信息失败, 原因：{}", contractEntity.getContractCategoryId(), categoryResp.getMsg());
            return CommonResponse.error("查询合同类别信息失败");
        }
        TemplateCategoryVO category = categoryResp.getData();
        resp.put("contactId", contractEntity.getId());
        resp.put("contractBillTypeCode", OTHER_CONTRACT_Bill_CODE);
        resp.put("contractCategoryId", category.getId());
        resp.put("boBillType", category.getBillTypeCode());

        return CommonResponse.success("查询成功！", resp);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractVO> queryDetail(Long id) {
        ContractVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ContractVO> vos) {
        return service.deleteByIds(vos);
    }

    /**
     * @Description 导出
     *
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        Map<String, Object> beans = new HashMap<>();
        param.setPageSize(-1);
        CommonResponse<JSONObject> commonResponse = pageList(param);
        List<ContractVO> contractVOList = new ArrayList<>();
        if (null != commonResponse.getData()){
            contractVOList = (List<ContractVO>) commonResponse.getData().get("records");
            if (null != contractVOList && contractVOList.size() > 0){
                contractVOList.forEach(c -> {
                    //设置合同履约状态：1、未签订；2、履约中；3、已终止；4、已作废；
                    // 默认为未签定，签章状态为已签章时，状态自动更改为【履约中】。
                    // 当合同存在生效的最终结算时，状态自动改为【已终止】
                    if(StringUtils.isBlank(c.getPerformanceStatus())) {
                        c.setPerformanceStatus(PerformanceStatusEnum.未签订.getDescription());
                    } else {
                        c.setPerformanceStatus(PerformanceStatusEnum.getEnumByCode(c.getPerformanceStatus()).getDescription());
                    }

                    //设置签章状态：1-待签章,2-待乙方签章,3-待甲方签章,4-已签章（已完成）,5-已退回（已拒签）,6-已撤回,7-已过期,8-其他；  单据新增后默认为待签章
                    if(StringUtils.isBlank(c.getSignatureStatus())) {
                        c.setSignatureStatus(SignatureStatusEnum.待签章.getDescription());
                    } else {
                        c.setSignatureStatus(SignatureStatusEnum.getEnumByCode(c.getSignatureStatus()).getDescription());
                    }

                    //流程状态
                    c.setBillStateName(BillStateEnum.getEnumByStateCode(c.getBillState()).getDescription());
                });
            }
        }
        beans.put("records", contractVOList);
        ExcelExport.getInstance().export("contract-export.xlsx", beans, response);
    }

    /**
     * 查询分页列表
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("firstPartyName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id",new Parameter("eq",InvocationInfoProxy.getTenantid()));


        //查询本下范围内日的合同
        Long orgId = InvocationInfoProxy.getOrgId();
        //若当前上下文为项目部，则根据项目部Id来进行查询
        if(OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if(!orgResp.isSuccess()) {
                logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                return CommonResponse.error("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();

        //设置排序：为了保证主合同与补充协议排列在一起，先用主合同创建时间排序
        if(param.getOrderMap().containsKey("createTime") && null != param.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", param.getOrderMap().get("createTime"));
        }else {
            orderMap.put("main_contract_create_date", QueryParam.DESC);
        }
        orderMap.put("supplement_flag", QueryParam.ASC);
        orderMap.put("create_time", QueryParam.DESC);
        param.setOrderMap(orderMap);
        IPage<ContractEntity> pageData= service.queryPage(param,false);

        //页面统计，查询原合同金额，现合同金额
        Map<String, Object> contractAmountMap = service.countContractAmount(param);
        JSONObject page = new JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), ContractVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        page.put("sumMnyMap", contractAmountMap);
        return CommonResponse.success("查询列表数据成功！",page);
    }

    /**
     * 合同参照查询
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/prosubContractRef",method = RequestMethod.GET)
    public CommonResponse<JSONObject> prosubContractRef(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        //设置模糊查询
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");

        if (null == condition || StringUtils.isBlank(condition)){
            return CommonResponse.error("查询失败，当前传入condition为空！");
        }
        Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);

        if (!(null != conditionMap.get("orgId") || null != conditionMap.get("projectId"))){
            return CommonResponse.error("当前传入项目id 或 组织id为空！");
        }
        if (null != conditionMap.get("orgId") && null == conditionMap.get("orgType")){
            return CommonResponse.error("当前传入组织类型为空！");
        }
//        if(null != conditionMap.get("contractType")) {
//            queryParam.getParams().put("contractType", new Parameter(QueryParam.EQ, conditionMap.get("contractType")));
//        }
        if(null != conditionMap.get("categoryId")) {
            //查询该分类下所有子分类
            CommonResponse<List<TemplateCategoryVO>> categoryVOResp = templateCategoryApi.querySelfAndChildById(Long.valueOf(conditionMap.get("categoryId").toString()));
            if(!categoryVOResp.isSuccess()) {
                return CommonResponse.error("获取合同类别信息失败！");
            }
            List<Long> categoryIds = categoryVOResp.getData().stream().map(item -> item.getId()).collect(Collectors.toList());
            switch (categoryIds.size()) {
                case 0:
                    JSONObject page = new JSONObject();
                    page.put("records", new ArrayList<>());
                    page.put("total", 0);
                    page.put("current", queryParam.getPageIndex());
                    page.put("size", queryParam.getPageSize());
                    page.put("pages", 0);
                    return CommonResponse.success("查询分包合同数据成功！", page);
                case 1:
                    queryParam.getParams().put("contractCategoryId", new Parameter(QueryParam.EQ, categoryIds.get(0)));
                    break;
                default:
                    queryParam.getParams().put("contractCategoryId", new Parameter(QueryParam.IN, categoryIds));
            }
        }

        if (null != conditionMap.get("projectId")){
            Long projectId  = Long.parseLong(conditionMap.get("projectId").toString());
            queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        }else {

            //查询本下范围内日的合同
            Long orgId = Long.parseLong(conditionMap.get("orgId").toString());
            //若当前上下文为项目部，则根据项目部Id来进行查询
            if(OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(conditionMap.get("orgType").toString()))) {
                queryParam.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
            } else {
                CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
                if(!orgResp.isSuccess()) {
                    logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                    return CommonResponse.error("查询失败，获取组织信息失败！");
                }
                queryParam.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                        orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }

        queryParam.getParams().put("performance_status", new Parameter(QueryParam.EQ, PerformanceStatusEnum.履约中.getCode()));
        queryParam.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));

        //设置排序：为了保证主合同与补充协议排列在一起，先用主合同创建时间排序
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        if(null != queryParam.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", queryParam.getOrderMap().get("createTime"));
        }else {
            orderMap.put("main_contract_create_date", QueryParam.DESC);
        }
        orderMap.put("supplement_flag", QueryParam.ASC);
        orderMap.put("create_time", QueryParam.DESC);
        queryParam.setOrderMap(orderMap);

        logger.info("分包合同查询参照-查询条件---------->" + JSONObject.toJSONString(queryParam.getParams()));
        IPage<ContractEntity> pageData= service.queryPage(queryParam,false);
        logger.info("分包合同查询参照-查询结果条数---------->" + pageData.getRecords().size());

        JSONObject page = new JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), ContractVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        return CommonResponse.success("查询分包合同数据成功！",page);
    }


    /**
     * 合同明细参照查询
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/proOtherContractDetailRef",method = RequestMethod.GET)
    public CommonResponse<JSONObject> proOtherContractDetailRef(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);

        if (null == condition || StringUtils.isBlank(condition)){
            return CommonResponse.error("查询失败，当前传入condition为空！");
        }
        Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
        if (null == conditionMap.get("contractId")){
            return CommonResponse.error("当前传入合同id为空！");
        }
//        String calcLastTotalNum = null != conditionMap.get("calcLastTotalNum") ? conditionMap.get("calcLastTotalNum").toString() : null;

        queryParam.getParams().put("contract_id", new Parameter(QueryParam.EQ, conditionMap.get("contractId")));
        queryParam.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));

        //设置只查询叶子节点清单
        queryParam.getParams().put("detail_price", new Parameter(QueryParam.NE, null));

        //设置排序：为了保证主合同与补充协议排列在一起，先用主合同创建时间排序
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("create_time", QueryParam.DESC);
        queryParam.setOrderMap(orderMap);

        logger.info("分包合同明细查询参照-查询条件---------->" + JSONObject.toJSONString(queryParam.getParams()));
        IPage<ContractDetailEntity> pageData= detailService.queryPage(queryParam,false);
        logger.info("分包合同明细查询参照-查询结果条数---------->" + pageData.getRecords().size());

        JSONObject page = new JSONObject();
        List<JSONObject> records = BeanMapper.mapList(pageData.getRecords(), JSONObject.class);
        List<Long> detailIds = new ArrayList<>();
        Map<Long, List<JSONObject>> detailHasParentMap = new HashMap<>();
        records.stream().forEach(item -> {
            detailIds.add(item.getLong("id"));
            if(null != item.get("parentId")) {
                if(null == detailHasParentMap.get(item.getLong("parentId"))) {
                    detailHasParentMap.put(item.getLong("parentId"), new ArrayList<>());
                }
                detailHasParentMap.get(item.getLong("parentId")).add(item);
            }
        });

        //查询清单的直接父级
        if (!detailHasParentMap.isEmpty()){
            List<ContractDetailEntity> parents = (List<ContractDetailEntity>) detailService.listByIds(new ArrayList<>(detailHasParentMap.keySet()));
            for(ContractDetailEntity parent : parents) {
                detailHasParentMap.get(parent.getId()).forEach(child -> child.put("pTag", parent.getDetailCode() + "-" + parent.getDetailName()));
            }
        }
//        //查询清单的累计计量
//        if("true".equals(calcLastTotalNum)&&!detailIds.isEmpty()) {
//            Map<Long, BigDecimal> calcResult = measureDetailService.queryLastWorkNumByIds(detailIds);
//            records.stream().forEach(r -> {
//                r.put("lastTotalNum", calcResult.get(r.getLong("id")));
//            });
//        }

        page.put("records", records);
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        return CommonResponse.success("查询分包合同明细数据成功！",page);
    }

    /**
     * 合同明细参照查询（合同按钮选择用）
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/contractDetailRef",method = RequestMethod.GET)
    public CommonResponse<List<ContractDetailVO>> contractDetailRef(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText) {
        List<ContractDetailVO> resList = new ArrayList<>();
        if (null == condition || StringUtils.isBlank(condition)){
            return CommonResponse.error("查询失败，当前传入condition为空！");
        }
        Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
        if (null == conditionMap.get("contractId")){
            return CommonResponse.error("当前传入合同id为空！");
        }
        ContractEntity contractEntity = service.selectById((Serializable) conditionMap.get("contractId"));
        if(null != contractEntity) {
            if (CollectionUtils.isNotEmpty(contractEntity.getDetailList())){
                List<ContractDetailVO> contractDetailList = BeanMapper.mapList(contractEntity.getDetailList(), ContractDetailVO.class);
                if (CollectionUtils.isNotEmpty(contractDetailList)) {
                    for (ContractDetailVO detail : contractDetailList) {
                        detail.setTid(detail.getId().toString());
                        detail.setTpid(detail.getParentId() != null ? detail.getParentId().toString() : null);
                    }
                    resList = TreeNodeBUtil.buildTree(contractDetailList);
                }
            }
        }
        logger.info("返回合同明细数据成功：", JSONObject.toJSONString(resList));
        return CommonResponse.success("查询参照数据成功！",resList);
    }


    /**
     * @param contractId 合同id
     * @return 合同子级list
     */
    @ResponseBody
    @RequestMapping(value = "/queryPayment",method = RequestMethod.GET)
    public CommonResponse<List<ContractPaymentVO>> queryPayment(
            @RequestParam(value = "contractId") String contractId){
        List<ContractPaymentVO> contractPayments = new ArrayList<>();
        ContractEntity contractEntity = service.selectById(contractId);
//        JSONObject jsonObject = new JSONObject();
        if(null != contractEntity) {
            if (CollectionUtils.isNotEmpty(contractEntity.getDetailList())){
                contractPayments = BeanMapper.mapList(contractEntity.getPaymentList(), ContractPaymentVO.class);

            }
        }
//        if (contractPayments.isEmpty()){
//            jsonObject.put("data",null);
//            return CommonResponse.success(jsonObject);
//        }
//        List<Map<String, Object>> list =new ArrayList();
//        contractPayments.forEach( payment->{
//            JSONObject o = (JSONObject) JSONObject.toJSON(payment);
//            o.put("text",payment.getPaymentName());
//            o.put("value",payment.getId());
//            list.add(o);
//        });
//        jsonObject.put("data",list);

        return CommonResponse.success("查询数据成功！",contractPayments);
    }

    /**
     * 付款阶段参照查询 后续删除
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/contractPaymentRef",method = RequestMethod.GET)
    public CommonResponse<List<ContractPaymentVO>> contractPaymentRef(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText) {
        List<ContractPaymentVO> contractPayments = new ArrayList<>();
        if (null == condition || StringUtils.isBlank(condition)){
            return CommonResponse.error("查询失败，当前传入condition为空！");
        }
        Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
        if (null == conditionMap.get("contractId")){
            return CommonResponse.error("当前传入合同id为空！");
        }
        ContractEntity contractEntity = service.selectById((Serializable) conditionMap.get("contractId"));
        if(null != contractEntity) {
            if (CollectionUtils.isNotEmpty(contractEntity.getDetailList())){
                contractPayments = BeanMapper.mapList(contractEntity.getPaymentList(), ContractPaymentVO.class);
            }
        }
        return CommonResponse.success("查询参照数据成功！",contractPayments);
    }


    /**
     * 查询当前合同下补充协议信息
     * @param id
     * @return
     */
    @RequestMapping(value = "/querySupplementRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractVO> querySupplementRecord(Long id) {
        ContractVO vo = service.querySupplementRecord(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * 新增或者修改补充协议
     *
     * @param supplement
     * @return
     */
    @RequestMapping(value = "/saveOrUpdateSupplement", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ContractVO> saveOrUpdateSupplement(@RequestBody ContractVO supplement) {
        if (supplement.getMainContractId() == null) {
            return CommonResponse.error("保存失败，主合同信息为空！");
        }
        return CommonResponse.success("查询详情数据成功！",service.saveOrUpdateSupplement(supplement, false));
    }

    /**
     * @Author
     * @Description  新增根据合同主键查询补充协议需要的主合同字段
     * @param contractId
     * @Return
     */
    @RequestMapping(value = "/addConvertByConId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractVO> addConvertByConId(Long contractId) {
        ContractVO vo = service.addConvertByConId(contractId);
        return CommonResponse.success("新增转换数据成功！",vo);
    }


    /**
     * @Author
     * @Description  判断当前合同是否能新增补充协议
     * @param
     * @Return
     * @return
     */
    @RequestMapping(value = "/addSupplementFlag", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> addSupplementFlag(Long id) {
        Boolean flag = service.addSupplementFlag(id);
        if (flag) {
            return CommonResponse.success("校验通过，该合同可以新增补充协议！");
        }
        return CommonResponse.error("当前合同存在未生效的补充协议，不能新增！");
    }

    /**
     * 判断当前合同能否新增合同解除单据
     * @param id 合同主键
     * @return boolean
     */
    @RequestMapping(value = "/addRelieveFlag", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> addRelieveFlag(Long id) {
        Boolean flag = contractRelieveService.isCanRelieve(id);
        return CommonResponse.success("校验该合同新增合同解除单据成功！", flag);
    }

    /**
     * 签章流程
     * @param
     * @return
     */
    @RequestMapping(value = "/signatureProcess", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> signatureProcess(Long id) {
        /*
            后期修改：签章流程暂定为点击就改为已签章
         */
        ContractEntity contractEntity = service.selectById(id);
        if (contractEntity != null){
            contractEntity.setSignatureStatus(SignatureStatusEnum.已签章.getCode());
            contractEntity.setPerformanceStatus(PerformanceStatusEnum.履约中.getCode());
            contractEntity.setEffectiveDate(new Date());
            service.saveOrUpdate(contractEntity);
        }
        return CommonResponse.success();
    }

    /**
     * 合同其他费用参照查询
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/prosubContractOtherCostRef",method = RequestMethod.GET)
    public CommonResponse<JSONObject> prosubContractOtherCostRef(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);

        if (null == condition || StringUtils.isBlank(condition)){
            return CommonResponse.error("查询失败，当前传入condition为空！");
        }
        Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
        if (null == conditionMap.get("contractId")){
            return CommonResponse.error("当前传入合同id为空！");
        }

        queryParam.getParams().put("contract_id", new Parameter(QueryParam.EQ, conditionMap.get("contractId")));
        queryParam.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));

        //设置排序：为了保证主合同与补充协议排列在一起，先用主合同创建时间排序
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("create_time", QueryParam.DESC);
        queryParam.setOrderMap(orderMap);

        logger.info("分包合同其他费用查询参照-查询条件---------->" + JSONObject.toJSONString(queryParam.getParams()));
        IPage<ContractOtherCostEntity> pageData= otherCostService.queryPage(queryParam,false);
        logger.info("分包合同其他费用查询参照-查询结果条数---------->" + pageData.getRecords().size());

        JSONObject page = new JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), ContractOtherCostVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        return CommonResponse.success("查询分包合同其他费用数据成功！",page);
    }

    @PostMapping(value = "/testPushContract")
    @ResponseBody
    public CommonResponse<ContractPoolVO> testPushContract(@RequestBody ContractVO contractVO) {
        ContractEntity contract = service.selectById(contractVO.getId());
        boolean pushContractResult = service.pushContract(BeanMapper.map(contract, ContractVO.class));
        if(pushContractResult) {
            return CommonResponse.success("合同数据推送合同池成功！");
        }

        return CommonResponse.error("合同数据推送合同池失败！");
    }

    @PostMapping(value = "/deleteContractFile")
    @ResponseBody
    public CommonResponse<Integer> deleteContractFile(@RequestBody ContractVO contractVO) {
        Integer contractVersion = service.deleteContractFileById(contractVO.getId());
        if(null != contractVersion && contractVersion.equals(-1)) {
            return CommonResponse.error("合同删除合同附件失败！");
        }
        return CommonResponse.success("合同删除合同附件成功！", contractVersion);
    }



    @RequestMapping(value = "/targetCostCtrl", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> targetCostCtrl(@RequestBody ContractVO contractVO, HttpServletRequest req) {
        ContractVO cv;
        if (null != contractVO.getSupplementFlag() && 1 == contractVO.getSupplementFlag()) {
            cv = service.saveOrUpdateSupplement(contractVO, true);
        } else {
            String authority = req.getHeader("authority");
            cv = service.insertOrUpdate(contractVO, authority, true);
        }

        String linkUrl = service.getLinkUrl(cv);
        ExecutionVO executionVO = service.targetCost(cv,linkUrl,cv.getContractType());
        logger.error("目标成本推送控制：{}" , JSONObject.toJSONString(executionVO, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
        if (!response.isSuccess()) {
            logger.error("目标成本参数控制失败，返回信息-{}", response.getMsg());
            response = new CommonResponse<ParamsCheckVO>();
            response.setData(new ParamsCheckVO());
        }
        ParamsCheckVO responseData = paramCheck(contractVO, response, false);
        return CommonResponse.success("参数校验成功！", responseData);
    }

    @GetMapping(value = "/viewTargetCostCtrlInfo")
    @ResponseBody
    public CommonResponse<ParamsCheckVO> viewTargetCostCtrlInfo(@RequestParam(value = "id") Long id) {
        ContractVO cv = service.queryDetail(id);
        String linkUrl = service.getLinkUrl(cv);
        //目标成本推送
        ExecutionVO executionVO = service.targetCost(cv, linkUrl, cv.getContractType());
        logger.error("目标成本推送控制：{}" , JSONObject.toJSONString(executionVO, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
        if (!response.isSuccess()) {
            logger.error("目标成本参数控制失败，返回信息-{}", response.getMsg());
            response = new CommonResponse<ParamsCheckVO>();
            response.setData(new ParamsCheckVO());
        }
        ParamsCheckVO responseData = paramCheck(cv, response, true);
        return CommonResponse.success("参数校验成功！", responseData);
    }

    /**
     * 合同推送合同池
     *
     * @return
     */
    @PostMapping(value = "/pushContractToPool")
    @ResponseBody
    public CommonResponse<ContractVO> pushContractToPool(@RequestBody ContractVO contractVO) {
        ContractEntity dbEntity = null;
        if(null != contractVO.getId()) {
            dbEntity = service.selectById(contractVO.getId());
        }
        if(dbEntity == null && StringUtils.isNotBlank(contractVO.getBillCode())) {
            QueryWrapper<ContractEntity> query = new QueryWrapper<>();
            query.eq("billCode", contractVO.getBillCode());
            query.eq("tenantId", InvocationInfoProxy.getTenantid());
            dbEntity = service.getOne(query);
        }

        if(dbEntity == null) {
            return CommonResponse.error("合同推送合同池失败，未找到匹配的合同！");
        }

        JedisTemplate jedisTemplate = cacheManager.getJedisTemplate();
        //校验当前合同是否正在进行同步操作
        String contractIdStr = jedisTemplate.get(PUSH_POOL_PREFIX + dbEntity.getId().toString());
        if(org.apache.commons.lang.StringUtils.isNotBlank(contractIdStr)) {
            return CommonResponse.error("当前单据数据已处于同步操作中，请勿重复操作！");
        }
        //校验通过，执行合同同步操作
        jedisTemplate.set(PUSH_POOL_PREFIX + dbEntity.getId().toString(), dbEntity.getId().toString());

        ContractVO vo = BeanMapper.map(dbEntity, ContractVO.class);

        ContractPoolVO data = new ContractPoolVO();
        try {
            BeanConvertorUtil.convert(vo, data);
            data.setSourceType(ContractTypeEnum.其他支出.getTypeCode());
            String cardType = vo.getAddType()==1?"otherSubCard":"otherSubDirectCard";
            data.setPcCardUrl("/ejc-proother-frontend/#/otherSubList/contractMultiCards?id="+vo.getId()+"&supplementFlag="+vo.getSupplementFlag()+"&cardType="+cardType+"&performanceStatus="+vo.getPerformanceStatus());
            CommonResponse<ContractPoolVO> transDataResp = contractPoolApi.saveOrUpdateContract(data);

            if(transDataResp.isSuccess()) {
                if(BillPushStatusEnum.未成功推送.getStatus().equals(dbEntity.getBillPushFlag())) {
                    dbEntity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
                    service.saveOrUpdate(dbEntity);
                }

                return CommonResponse.success("合同推送合同池成功", vo);
            } else {
                logger.error("合同-{}推送合同池失败，{}", JSONObject.toJSONString(contractVO), transDataResp.getMsg());
            }
        } catch (Exception e) {
            logger.error("合同-{}推送合同池失败，", JSONObject.toJSONString(contractVO), e);
        } finally {
            //删除合同同步控制标签
            jedisTemplate.del(PUSH_POOL_PREFIX + dbEntity.getId().toString());
        }

        return CommonResponse.error("合同推送合同池失败", vo);
    }

    /**
     * 参数控制
     * 其他支出合同-补充协议  【合同金额】控【补充协议金额】  集采合同不受该参数影响  补充协议金额 > 合同金额*X%  提醒等级：1-不控制-none，2-提醒-warn，3-无法保存-alert，默认提醒
     * 1、当该合同补充协议金额超过合同金额时，系统自动按设定方式控制；
     * 2、合同补充协议金额计算方式： 当前合同所有补充协议累计含税金额；
     * 3、合同金额：最新版本合同含税金额； 合同表： contractTaxMny
     *
     * @param contractVO
     * @param flag 是否是新增的数据：true是，false否
     * @return
     */
    private ParamsCheckVO paramCheck(ContractVO contractVO, CommonResponse<ParamsCheckVO> response, boolean flag) {
        ParamsCheckVO responseData = response.getData();
        String responseDataWarnType = responseData.getWarnType();
        int resWarnTypeInt = ParamCtrlUtil.getWarnTypeInt(responseDataWarnType, 2);
        if (null != contractVO.getSupplementFlag() && 1 == contractVO.getSupplementFlag()) {
            // 是补充协议
            // 校验  其他支出合同-补充协议  【合同金额】控【补充协议金额】  补充协议金额 > 合同金额*X%  提醒等级：1-不控制-none，2-提醒-warn，3-无法保存-alert，默认提醒
            ParamsCheckVO checkVO = service.supplementMnyCtrl(contractVO, flag);
            String warnType = checkVO.getWarnType();
            if (org.apache.commons.lang3.StringUtils.isNotBlank(warnType) && !"none".equals(warnType)) {
                // 如果【合同金额】控【补充协议金额】提醒等级高于目标成本提醒等级，使用前者的提醒等级
                int changeWarnTypeInt = ParamCtrlUtil.getWarnTypeInt(warnType, 2);
                if (changeWarnTypeInt > resWarnTypeInt) {
                    responseData.setWarnType(warnType);
                }
                List<ParamsCheckDsVO> list = checkVO.getDataSource();
                if (CollectionUtils.isNotEmpty(list)) {
                    responseData.getDataSource().addAll(list);
                }
            }
        }
        return responseData;
    }

}
