/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proother.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.proother.bean.ChangeEntity;
import com.ejianc.business.proother.bean.ContractEntity;
import com.ejianc.business.proother.enums.SignatureStatusEnum;
import com.ejianc.business.proother.service.IChangeService;
import com.ejianc.business.proother.service.IContractService;
import com.ejianc.business.signaturemanage.api.ISignatureManageApi;
import com.ejianc.business.signaturemanage.vo.SignMgrPreviewVO;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/contractFileUpdate/"})
public class ContractFileController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContractService contractService;
    @Autowired
    private ISignatureManageApi signatureManageApi;
    @Autowired
    private IChangeService changeService;

    @PostMapping(value={"updateFileInfo"})
    public CommonResponse<JSONObject> updateFileInfo(@RequestBody JSONObject updateData) {
        JSONObject resp = new JSONObject();
        ContractEntity contract = (ContractEntity)((Object)this.contractService.selectById(updateData.getLong("billId")));
        contract.setContractFileId(updateData.getLong("fileId"));
        contract.setContractFileHighlightId(updateData.getLong("fileId"));
        contract.setContractFilePath(updateData.getString("fileOnlinePath"));
        contract.setContractFileHighlightPath(updateData.getString("fileOnlinePath"));
        contract.setContractFileSyncFlag(true);
        this.contractService.saveOrUpdate((Object)contract, false);
        resp.put("message", (Object)"\u5408\u540c\u6587\u4ef6\u4fe1\u606f\u66f4\u65b0\u6210\u529f");
        resp.put("billData", (Object)contract);
        return CommonResponse.success((String)"\u5408\u540c\u6587\u4ef6\u4fe1\u606f\u66f4\u65b0\u6210\u529f\uff01", (Object)resp);
    }

    @GetMapping(value={"getSignedFileInfo"})
    public CommonResponse<JSONObject> getSignedFileInfo(@RequestParam(value="billId") Long billId, @RequestParam(value="billType") String billType) {
        JSONObject resp = new JSONObject();
        CommonResponse signResp = this.signatureManageApi.previewContract(billId, Arrays.asList(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()));
        if (!signResp.isSuccess()) {
            this.logger.error("\u83b7\u53d6\u5355\u636eid-{}\uff0cbillType-{}\u7b7e\u7ae0\u6587\u4ef6\u4fe1\u606f\u5931\u8d25: {}", new Object[]{billId, billType, signResp.getMsg()});
            return CommonResponse.error((String)"\u83b7\u53d6\u5408\u540c\u7b7e\u7ae0\u6587\u4ef6\u4fe1\u606f\u5931\u8d25!");
        }
        List fileList = (List)signResp.getData();
        if (CollectionUtils.isEmpty((Collection)fileList)) {
            return CommonResponse.error((String)"\u4e3a\u83b7\u53d6\u5230\u5408\u540c\u7b7e\u7ae0\u6587\u4ef6\u4fe1\u606f\uff01");
        }
        SignMgrPreviewVO signedFileInfo = (SignMgrPreviewVO)((List)signResp.getData()).get(0);
        if ("contract".equals(billType)) {
            ContractEntity contract = (ContractEntity)((Object)this.contractService.selectById(billId));
            contract.setSignedFileId(signedFileInfo.getFileId());
            this.contractService.saveOrUpdate((Object)contract, false);
        } else {
            ChangeEntity contractChange = (ChangeEntity)((Object)this.changeService.selectById(billId));
            contractChange.setSignedFileId(signedFileInfo.getFileId());
            this.changeService.saveOrUpdate((Object)contractChange, false);
        }
        resp.put("fileId", (Object)signedFileInfo.getFileId());
        resp.put("filePath", (Object)signedFileInfo.getFilePath());
        resp.put("fileTruePath", (Object)signedFileInfo.getTruePath());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
    }
}

