/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settle.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.proother.enums.BillPushStatusEnum;
import com.ejianc.business.proother.vo.ContractVO;
import com.ejianc.business.settle.bean.SettleDetailEntity;
import com.ejianc.business.settle.bean.SettleEntity;
import com.ejianc.business.settle.bean.SettleOtherEntity;
import com.ejianc.business.settle.service.ISettleDetailService;
import com.ejianc.business.settle.service.ISettleOtherService;
import com.ejianc.business.settle.service.ISettleService;
import com.ejianc.business.settle.vo.SettleDetailVO;
import com.ejianc.business.settle.vo.SettleOtherVO;
import com.ejianc.business.settle.vo.SettleRecordVO;
import com.ejianc.business.settle.vo.SettleVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springside.modules.nosql.redis.JedisTemplate;

@RestController
@RequestMapping(value={"settle"})
public class SettleController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ISettleDetailService detailService;
    @Autowired
    private ISettleOtherService otherService;
    private static final String BILL_CODE = "OTH_SET";
    @Autowired
    private ISettleService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ISettlePoolApi settlePoolApi;
    @Autowired
    private CacheManager cacheManager;
    private final String PUSH_POOL_PREFIX = "pushContractSettle::";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SettleVO> saveOrUpdate(@RequestBody SettleVO saveOrUpdateVO) {
        SettleEntity entity = (SettleEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SettleEntity.class));
        if (entity.getId() == null) {
            if (StringUtils.isBlank((CharSequence)entity.getBillCode())) {
                BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
                CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                entity.setBillCode((String)billCode.getData());
            } else if (this.checkSameBillCode((ContractVO)BeanMapper.map((Object)((Object)entity), ContractVO.class)).booleanValue()) {
                throw new BusinessException("\u7f16\u7801\u91cd\u590d\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        } else {
            SettleEntity oldSettleEntity = (SettleEntity)((Object)this.service.selectById(entity.getId()));
            if (StringUtils.isBlank((CharSequence)entity.getBillCode())) {
                entity.setBillCode(oldSettleEntity.getBillCode());
            } else if (this.checkSameBillCode((ContractVO)BeanMapper.map((Object)((Object)entity), ContractVO.class)).booleanValue()) {
                throw new BusinessException("\u7f16\u7801\u91cd\u590d\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        SettleVO vo = (SettleVO)BeanMapper.map((Object)((Object)entity), SettleVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    private Boolean checkSameBillCode(ContractVO contractVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(SettleEntity::getBillCode, (Object)contractVO.getBillCode());
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        if (null != contractVO.getId() && contractVO.getId() > 0L) {
            lambda.ne(BaseEntity::getId, (Object)contractVO.getId());
        }
        return this.service.list((Wrapper)lambda).size() > 0;
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SettleVO> queryDetail(Long id) {
        SettleEntity entity = (SettleEntity)((Object)this.service.selectById(id));
        SettleVO vo = (SettleVO)BeanMapper.map((Object)((Object)entity), SettleVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SettleVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SettleVO settleVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(SettleVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SettleVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List settleVOS = BeanMapper.mapList((Iterable)page.getRecords(), SettleVO.class);
        settleVOS.forEach(vo -> {
            if (vo.getSettleType() == 1) {
                vo.setSettleTypeStr("\u5b8c\u5de5\u7ed3\u7b97");
            } else if (vo.getSettleType() == 0) {
                vo.setSettleTypeStr("\u8fc7\u7a0b\u7ed3\u7b97");
            }
        });
        pageData.setRecords(settleVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List voList = BeanMapper.mapList((Iterable)list, SettleVO.class);
        voList.forEach(vo -> {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            if (vo.getSettleType() == 1) {
                vo.setSettleTypeStr("\u5b8c\u5de5\u7ed3\u7b97");
            } else if (vo.getSettleType() == 0) {
                vo.setSettleTypeStr("\u8fc7\u7a0b\u7ed3\u7b97");
            }
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("settle-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSettleData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SettleVO>> refSettleData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SettleVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ResponseBody
    @RequestMapping(value={"/queryUnusedContract"}, method={RequestMethod.POST})
    public CommonResponse<SettleVO> queryUnusedContract(@RequestBody SettleVO settleVO) {
        return this.service.queryUnusedContract(settleVO.getContractId(), settleVO.getSettleDate(), settleVO.getSettleType());
    }

    @RequestMapping(value={"/refSettleOtherData"}, method={RequestMethod.GET})
    public CommonResponse<IPage<SettleOtherVO>> refOtherData(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchObject", required=false) String searchObject, @RequestParam(value="searchText", required=false) String searchText) {
        Integer settleType = null;
        Long contractId = null;
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            this.logger.info("condition\uff1a{}", (Object)_con);
            settleType = Integer.valueOf(_con.getString("settleType"));
            contractId = Long.valueOf(_con.getString("contractId"));
        }
        Page pg = new Page((long)pageNumber.intValue(), (long)pageSize.intValue());
        IPage<SettleOtherEntity> page = this.otherService.selectPageOther((Page<SettleOtherEntity>)pg, settleType, contractId);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SettleOtherVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refSettleDetailData"}, method={RequestMethod.GET})
    public CommonResponse<IPage<SettleDetailVO>> refDetailData(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchObject", required=false) String searchObject, @RequestParam(value="searchText", required=false) String searchText) {
        Integer settleType = null;
        Long contractId = null;
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            this.logger.info("condition\uff1a{}", (Object)_con);
            settleType = Integer.valueOf(_con.getString("settleType"));
            contractId = Long.valueOf(_con.getString("contractId"));
        }
        Page pg = new Page((long)pageNumber.intValue(), (long)pageSize.intValue());
        IPage<SettleDetailEntity> page = this.detailService.selectPageDetail((Page<SettleDetailEntity>)pg, settleType, contractId, searchText);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SettleDetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @GetMapping(value={"/queryDetailRecord"})
    public CommonResponse<SettleRecordVO> queryDetailRecord(@RequestParam(value="id") Long id, @RequestParam(value="settleType") Integer settleType) {
        SettleRecordVO vo = this.service.queryDetailRecord(id, settleType);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/mnyCtrl"}, method={RequestMethod.POST})
    public CommonResponse<ParamsCheckVO> mnyCtrl(@RequestBody SettleVO settleVO) {
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)this.service.mnyCtrl(settleVO, false));
    }

    @RequestMapping(value={"/mnyCtrlById"}, method={RequestMethod.GET})
    public CommonResponse<ParamsCheckVO> mnyCtrlById(@RequestParam(value="id") Long id) {
        SettleEntity settle = (SettleEntity)((Object)this.service.selectById(id));
        if (settle == null) {
            return CommonResponse.error((String)"\u7ed3\u7b97\u5355\u4e0d\u5b58\u5728\uff01");
        }
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)this.service.mnyCtrl((SettleVO)BeanMapper.map((Object)((Object)settle), SettleVO.class), true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/pushSettleToPool"})
    public CommonResponse<SettleVO> pushSettleToPool(@RequestBody SettleVO settleVO) {
        CommonResponse res;
        SettleVO vo;
        SettleEntity dbEntity;
        JedisTemplate jedisTemplate;
        block10: {
            jedisTemplate = this.cacheManager.getJedisTemplate();
            dbEntity = null;
            if (null != settleVO.getId()) {
                dbEntity = (SettleEntity)((Object)this.service.selectById(settleVO.getId()));
            }
            if (dbEntity == null && StringUtils.isNotBlank((CharSequence)settleVO.getBillCode())) {
                QueryWrapper query = new QueryWrapper();
                query.eq((Object)"billCode", (Object)settleVO.getBillCode());
                query.eq((Object)"tenantId", (Object)InvocationInfoProxy.getTenantid());
                dbEntity = (SettleEntity)((Object)this.service.getOne((Wrapper)query));
            }
            if (dbEntity == null) {
                return CommonResponse.error((String)"\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff0c\u672a\u627e\u5230\u5339\u914d\u7684\u7ed3\u7b97\u5355\uff01");
            }
            String contractIdStr = jedisTemplate.get("pushContractSettle::" + dbEntity.getId().toString());
            if (StringUtils.isNotBlank((CharSequence)contractIdStr)) {
                return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u6570\u636e\u5df2\u5904\u4e8e\u540c\u6b65\u64cd\u4f5c\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff01");
            }
            jedisTemplate.set("pushContractSettle::" + dbEntity.getId().toString(), dbEntity.getId().toString());
            vo = (SettleVO)BeanMapper.map((Object)((Object)dbEntity), SettleVO.class);
            SettlePoolVO poolVO = new SettlePoolVO();
            this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u81ea\u52a8\u8f6c\u6362\u5f00\u59cb");
            BeanConvertorUtil.convert((Object)vo, (Object)poolVO);
            this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u81ea\u52a8\u8f6c\u6362\u7ed3\u675f\uff0c\u4e0b\u9762\u5f00\u59cb\u624b\u52a8\u8f6c\u6362");
            this.service.convertSettleVOToSettlePoolVO(vo, poolVO);
            poolVO.setBillCodeUrl("/ejc-proother-frontend/#/settleList/card?id=" + vo.getId());
            res = this.settlePoolApi.saveOrUpdateSettle(poolVO);
            if (!res.isSuccess()) break block10;
            this.logger.info("\u7ed3\u7b97\u5355\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60\u6210\u529f-{}!", (Object)JSONObject.toJSONString((Object)vo));
            if (BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus().equals(dbEntity.getPushPoolFlag())) {
                dbEntity.setPushPoolFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
                this.service.saveOrUpdate((Object)dbEntity);
            }
            CommonResponse commonResponse = CommonResponse.success((String)"\u7ed3\u7b97\u5355\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60\u6210\u529f", (Object)vo);
            jedisTemplate.del(new String[]{"pushContractSettle::" + dbEntity.getId().toString()});
            return commonResponse;
        }
        try {
            this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355{}\uff0c{}", (Object)JSONObject.toJSONString((Object)vo), (Object)res.getMsg());
        }
        catch (Exception e) {
            try {
                this.logger.error("\u7ed3\u7b97\u5355-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c", (Object)JSONObject.toJSONString((Object)vo), (Object)e);
            }
            catch (Throwable throwable) {
                jedisTemplate.del(new String[]{"pushContractSettle::" + dbEntity.getId().toString()});
                throw throwable;
            }
            jedisTemplate.del(new String[]{"pushContractSettle::" + dbEntity.getId().toString()});
        }
        jedisTemplate.del(new String[]{"pushContractSettle::" + dbEntity.getId().toString()});
        return CommonResponse.error((String)"\u7ed3\u7b97\u5355\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60\u5931\u8d25", (Object)vo);
    }
}

