package com.ejianc.business.contract.relieve.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.contract.relieve.bean.ContractRelieveEntity;
import com.ejianc.business.contract.relieve.mapper.ContractRelieveMapper;
import com.ejianc.business.contract.relieve.service.IContractRelieveService;
import com.ejianc.business.proother.vo.ContractVO;
import com.ejianc.business.settle.bean.SettleEntity;
import com.ejianc.business.settle.service.ISettleService;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 合同解除实体
 *
 * @author generator
 */
@Service("contractRelieveService")
public class ContractRelieveServiceImpl extends BaseServiceImpl<ContractRelieveMapper, ContractRelieveEntity> implements IContractRelieveService {
    @Autowired
    private IContractRelieveService service;

    @Autowired
    private ISettleService settleService;

    /**
     * 根据合同编号查询是否可以新增合同解除单据
     *
     * @param contractId 合同id
     * @return Boolean 是否可以新增
     */
    @Override
    public Boolean isCanRelieve(Long contractId) {
        // 添加校验
        QueryParam param = new QueryParam();
        param.getParams().put("contract_id", new Parameter(QueryParam.EQ, contractId));
        List<ContractRelieveEntity> list = service.queryList(param);
        return list.isEmpty();
    }

    @Override
    public ExecutionVO targetCost(ContractVO contractVO, String linkUrl, Integer contractType){
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        List<DetailExecutionVO> detailList = new ArrayList<>();
        totalVO.setSourceId(contractVO.getId());
        totalVO.setTenantId(contractVO.getTenantId());
        totalVO.setBillCode(contractVO.getBillCode());
        totalVO.setBillType("BT220308000000001");
        totalVO.setBussinessType(BussinessTypeEnum.其他支出合同.getCode());
        totalVO.setBillCategory(BillCategoryEnum.合同.getCode());
        totalVO.setProjectId(contractVO.getProjectId());
        totalVO.setOrgId(contractVO.getOrgId());
        LambdaQueryWrapper<SettleEntity> processQuery = new LambdaQueryWrapper<>();
        processQuery.eq(SettleEntity::getContractId, contractVO.getId());
        processQuery.in(SettleEntity::getBillState,1,3);
        processQuery.eq(SettleEntity::getDr,0);
        processQuery.eq(SettleEntity::getSettleType,0);
        List<SettleEntity> processEntity = settleService.list(processQuery); // 过程结算
        BigDecimal sumMonthMny = BigDecimal.ZERO;//过程 本期结算金额(无税)
        BigDecimal sumMonthTaxMny = BigDecimal.ZERO;//过程 本期结算金额
        for (SettleEntity monthVo : processEntity){
            sumMonthMny = ComputeUtil.safeAdd(sumMonthMny, monthVo.getMny());
            sumMonthTaxMny = ComputeUtil.safeAdd(sumMonthTaxMny, monthVo.getTaxMny());
        }
        LambdaQueryWrapper<SettleEntity> quarterQuery = new LambdaQueryWrapper<>();
        quarterQuery.eq(SettleEntity::getContractId, contractVO.getId());
        quarterQuery.in(SettleEntity::getBillState,1,3);
        quarterQuery.eq(SettleEntity::getDr,0);
        quarterQuery.eq(SettleEntity::getSettleType,1);
        List<SettleEntity> quarterEntity = settleService.list(quarterQuery); // 完工结算
        BigDecimal sumQuarterMny = BigDecimal.ZERO;//完工 本期结算金额(无税)
        BigDecimal sumQuarterTaxMny = BigDecimal.ZERO;//完工 本期结算金额
        for (SettleEntity quarterVo : quarterEntity){
            sumQuarterMny = ComputeUtil.safeAdd(sumQuarterMny, quarterVo.getMny());
            sumQuarterTaxMny = ComputeUtil.safeAdd(sumQuarterTaxMny, quarterVo.getTaxMny());
        }
        if (sumQuarterMny.compareTo(sumMonthMny) == 1){ //  完工 本期结算金额(无税) > 过程 本期结算金额(无税)
            // 总计划金额无税 = 完工 本期结算金额(无税) - 合同金额（无税）
            totalVO.setMoney(sumQuarterMny.subtract(contractVO.getContractMny()));
        }else {
            // 总计划金额无税 = 过程 本期结算金额(无税) - 合同金额（无税）
            totalVO.setMoney(sumMonthMny.subtract(contractVO.getContractMny()));
        }
        if (sumQuarterTaxMny.compareTo(sumMonthTaxMny) == 1){ //  完工 本期结算金额 > 过程 本期结算金额
            //总计划金额 = 完工 本期结算金额 - 合同金额（含税）
            totalVO.setTaxMoney(sumQuarterTaxMny.subtract(contractVO.getContractTaxMny()));
        }else {
            //总计划金额 = 过程 本期结算金额 - 合同金额（含税）
            totalVO.setTaxMoney(sumMonthTaxMny.subtract(contractVO.getContractTaxMny()));
        }
        totalVO.setLinkUrl(linkUrl);
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }
}
