package com.ejianc.business.settle.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.contractbase.pool.enums.SettleSourceTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.proother.bean.ChangeEntity;
import com.ejianc.business.proother.bean.ContractEntity;
import com.ejianc.business.proother.service.IChangeService;
import com.ejianc.business.proother.service.IContractService;
import com.ejianc.business.settle.bean.SettleDetailEntity;
import com.ejianc.business.settle.bean.SettleEntity;
import com.ejianc.business.settle.bean.SettleOtherEntity;
import com.ejianc.business.settle.enums.SettleTypeEnum;
import com.ejianc.business.settle.mapper.SettleMapper;
import com.ejianc.business.settle.service.ISettleDetailService;
import com.ejianc.business.settle.service.ISettleOtherService;
import com.ejianc.business.settle.service.ISettleService;
import com.ejianc.business.settle.vo.SettleRecordVO;
import com.ejianc.business.settle.vo.SettleVO;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.vo.*;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 结算实体
 *
 * @author generator
 */
@Service("settleService")
public class SettleServiceImpl extends BaseServiceImpl<SettleMapper, SettleEntity> implements ISettleService {

    @Autowired
    private IChangeService changeService;

    @Autowired
    private SettleMapper settleMapper;

    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IContractService contractService;
    @Autowired
    private ISettleDetailService detailService;
    @Autowired
    private ISettleOtherService otherService;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISettlePoolApi settlePoolApi;

    // 其他支出合同结算
    private static final String PRO_OTHER_CHECK_PARAM_NAME = "P-C4JSb946";

    @Autowired
    private IParamConfigApi paramConfigApi;

    @Override
    public CommonResponse<SettleVO> queryUnusedContract(Long contractId, Date settleDate, Integer settleType) {
        SettleVO settleVO = new SettleVO();
        //若当前合同有完工结算单子 或 当前合同有其他未生效的结算单子 则不能添加新的结算单
        LambdaQueryWrapper<SettleEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(SettleEntity::getContractId, contractId);
        lambda.eq(SettleEntity::getSettleType, SettleTypeEnum.完工.getCode());
        lambda.and(c -> c.notIn(SettleEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()));
        int resultCount = super.count(lambda);
        if (resultCount > 0) {
            return CommonResponse.error("当前合同已进行完工结算，请选择其他合同。");
        }
        QueryWrapper<ContractEntity> contractQuery = new QueryWrapper<>();
        contractQuery.eq("contract_id", contractId);
        ContractEntity contractEntity = contractService.selectById(contractId);
        if (null != contractEntity && null != contractEntity.getChangeId() && settleType == 1) {
            LambdaQueryWrapper<ChangeEntity> changeContractLambda = new LambdaQueryWrapper<>();
            changeContractLambda.eq(ChangeEntity::getId, contractEntity.getChangeId());
            changeContractLambda.and(c -> c.in(ChangeEntity::getBillState, BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()));
            int changeResultCount = changeService.count(changeContractLambda);
            if (changeResultCount > 0) {
                return CommonResponse.error("当前合同正在进行变更，不可以进行完工结算！");
            }
        }

        LambdaQueryWrapper<SettleEntity> settleLambda = new LambdaQueryWrapper<>();
        settleLambda.eq(SettleEntity::getContractId, contractId);
        settleLambda.and(c -> c.notIn(SettleEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()));

        List<SettleEntity> resultList = super.list(settleLambda);

        if (resultList.size() > 0 && null != resultList.get(0)) {
            String settleTypeName = (null != resultList.get(0).getSettleType()) ? SettleTypeEnum.getDescriptionByCode(resultList.get(0).getSettleType()).getDescription() : "";
            return CommonResponse.error("当前合同有未审批的" + settleTypeName + "结算单，请选择其他合同。");
        }

//        //设置最小可用结算日期
//        Date resultDate = settleMapper.selectMaxSettleDate(contractId);
//        if (null == resultDate) {
//            resultDate = null != settleDate ? settleDate : new Date();
//            settleVO.setMinSettleDate(null);
//        } else {
//            //如果页面日期大于当前查询出最大日期，则返回页面日期，否则返回最大日期加1
//            resultDate = DateUtils.addDays(resultDate, 1);
//            settleVO.setMinSettleDate(resultDate);
//            if (null != settleDate && settleDate.compareTo(resultDate) > 0) {
//                resultDate = settleDate;
//            }
//        }
//        settleVO.setSettleDate(resultDate);
        //查询当前合同结算金额 已提交的
        QueryWrapper<SettleEntity> listQuery = new QueryWrapper<>();
        listQuery.eq("contract_id", contractId);
        listQuery.eq("settle_type", settleType);
        listQuery.in("bill_state", BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        listQuery.orderByDesc("create_time");
        List<SettleEntity> list = super.list(listQuery);
        BigDecimal settleScale = BigDecimal.ZERO;
        //设置 已结算数据
        if (list.size() > 0) {
            settleVO.setSettleScale(list.get(0).getTotalSettleScale() == null ? BigDecimal.ZERO : list.get(0).getTotalSettleScale());
            settleVO.setLastTaxMny(list.get(0).getTotalTaxMny() == null ? BigDecimal.ZERO : list.get(0).getTotalTaxMny());
            settleVO.setLastMny(list.get(0).getTotalMny() == null ? BigDecimal.ZERO : list.get(0).getTotalTaxMny());
        } else {
            settleVO.setLastTaxMny(BigDecimal.ZERO);
            settleVO.setLastMny(BigDecimal.ZERO);
            settleVO.setSettleScale(BigDecimal.ZERO);
        }
        return CommonResponse.success("当前合同可用！", settleVO);
    }

    @Override
    public SettleRecordVO queryDetailRecord(Long contractId, Integer settleType) {
        SettleRecordVO settleRecordVO = new SettleRecordVO();

        ContractEntity contract = contractService.selectById(contractId);
        settleRecordVO.setContractId(contract.getId());
        settleRecordVO.setContractMny(contract.getContractMny());
        settleRecordVO.setContractTaxMny(contract.getContractTaxMny());
        settleRecordVO.setPerformanceStatus(contract.getPerformanceStatus());

        QueryWrapper<SettleEntity> listQuery = new QueryWrapper<>();
        listQuery.eq("contract_id", contractId);
//        listQuery.eq("settle_type", settleType);
        listQuery.in("bill_state", BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        listQuery.orderByDesc("create_time");
        List<SettleEntity> list = super.list(listQuery);
        List<SettleVO> settleVOS = BeanMapper.mapList(list, SettleVO.class);
        settleVOS.forEach(vo -> {
            if (vo.getSettleType() == 1) {
                vo.setSettleTypeStr("完工结算");
            } else if (vo.getSettleType() == 0) {
                vo.setSettleTypeStr("过程结算");
            }
            if (vo.getTotalSettleScale() != null) {
                int i = vo.getTotalSettleScale().toString().indexOf(".");
                String substring = vo.getTotalSettleScale().toString().substring(0, i + 3);
                vo.setTotalSettleScaleStr(substring + '%');

            }
        });
        settleRecordVO.setSettleList(settleVOS);
        //取第一条数据计算累计结算金额 与比例
        SettleEntity lastSettleRecord = CollectionUtils.isNotEmpty(list) ? list.get(0) : null;
        if (lastSettleRecord != null) {
            settleRecordVO.setTotalSettleMny(lastSettleRecord.getTotalTaxMny());
            settleRecordVO.setSettleRatio(lastSettleRecord.getTotalSettleScale());
            //检测是否可以创建新的结算单
        } else {
            settleRecordVO.setTotalSettleMny(BigDecimal.ZERO);
            settleRecordVO.setSettleRatio(BigDecimal.ZERO);
        }
        settleRecordVO.setCanAddNewSettleFlag(StringUtils.isBlank(beforeNewSettleCheck(contractId, settleType)));
        return settleRecordVO;
    }


    /**
     * 校验逻辑
     * <p>
     * 节点结算：
     * 2）判断是否有未生效的过程结算、节点结算单子，如果有不可以进行过程结算（一个合同只可以有一个未生效的节点结算单据）
     * 3）判断是否有完工结算单据，不管有生效还是未生效的，只要产生，都不可以进行节点结算
     * <p>
     * 过程结算：
     * 1）判断是否有未生效的过程结算、节点结算单子，如果有不可以进行过程结算（一个合同只可以有一个未生效的过程结算单据）
     * 2）是否有完工结算单据，不管有生效还是未生效的，只要产生，都不可以进行过程结算
     * <p>
     * 完工结算：
     * 1）是否有出库单没有进行领料结算，如果有，不可以进行完工结算
     * 2）是否有未生效的分包计量、领料结算、零工登记、奖罚单的单据，如果有，不可以进行完工结算
     * 3）判断是否有未生效的过程结算、节点结算单子，如果有不可以进行完工结算（一个合同只可以有一个未生效的过程结算单据）
     * 4）是否有完工结算单据，不管有生效还是未生效的，只要产生，都不可以进行完工结算
     *
     * @param contractId
     * @param settleType
     * @return
     */
    @Override
    public String beforeNewSettleCheck(Long contractId, Integer settleType) {
        QueryWrapper<SettleEntity> query = new QueryWrapper<>();
        query.eq("contract_id", contractId);
        query.and(q -> q.in("settle_type", SettleTypeEnum.节点.getCode(), SettleTypeEnum.过程.getCode())
                .in("bill_state", BillStateEnum.UNCOMMITED_STATE.getBillStateCode(),
                        BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(),
                        BillStateEnum.UNAPPROVED.getBillStateCode(),
                        BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode())
        ).or().and(q -> q.eq("settle_type", SettleTypeEnum.完工));

        List<SettleEntity> billList = super.list(query);
        if (CollectionUtils.isNotEmpty(billList)) {
            if (SettleTypeEnum.完工.getCode().equals(settleType)) {
                return "合同已经生成了完工结算，不可以进行 " + SettleTypeEnum.getDescriptionByCode(settleType) + "结算";
            } else {
                return "有未生效的过" + SettleTypeEnum.getDescriptionByCode(SettleTypeEnum.节点.getCode()) + "算单据，不可以进行" + SettleTypeEnum.getDescriptionByCode(settleType) + "结算";
            }
        }

        if (SettleTypeEnum.完工.getCode().equals(settleType)) {
            //TODO 1、是否有出库单没有进行领料结算，如果有，不可以进行完工结算
            //2、是否有未生效的分包计量、领料结算、零工登记、奖罚单的单据，如果有，不可以进行完工结算
            StringBuffer sp = new StringBuffer();
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("contract_id", new Parameter(QueryParam.EQ, contractId));
            queryParam.getParams().put("bill_state", new Parameter(QueryParam.EQ, BillStateEnum.APPROVING_HAS_STATE));
            QueryWrapper<ContractEntity> contractQuery = new QueryWrapper<>();
            contractQuery.eq("contract_id", contractId);
            ContractEntity contractEntity = contractService.selectById(contractId);
            if (null != contractEntity && null != contractEntity.getChangeId()) {
                LambdaQueryWrapper<ChangeEntity> changeContractLambda = new LambdaQueryWrapper<>();
                changeContractLambda.eq(ChangeEntity::getId, contractEntity.getChangeId());
                changeContractLambda.and(c -> c.in(ChangeEntity::getBillState, BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()));
                int changeResultCount = changeService.count(changeContractLambda);
                if (changeResultCount > 0) {
                    return "当前合同正在进行变更，不可以进行完工结算！";
                }
            }
        }

        return null;
    }

    //推送至结算池
    @Override
    public boolean pushSettleToPool(SettleVO settleVO) {
        SettlePoolVO poolVO = new SettlePoolVO();
        try {
            logger.info("结算单对象 -> 结算池对象自动转换开始");
            BeanConvertorUtil.convert(settleVO, poolVO);
            logger.info("结算单对象 -> 结算池对象自动转换结束，下面开始手动转换");
            // 个别字段需要手动封装
            convertSettleVOToSettlePoolVO(settleVO, poolVO);
            poolVO.setBillCodeUrl("/ejc-proother-frontend/#/settleList/card?id=" + settleVO.getId());
            CommonResponse<SettlePoolVO> res = settlePoolApi.saveOrUpdateSettle(poolVO);
            if (res.isSuccess()) {
                logger.info("结算单推送至结算池成功！结算单id-{}", settleVO.getId());
                return true;
            } else {
                logger.error("结算单推送合同池失败！结算单id-{}，{}", settleVO.getId(), res.getMsg());
            }
        } catch (Exception e) {
            logger.error("合同-{}推送合同池失败，", settleVO.getId(), e);
        }
        return false;
    }

    @Override
    public void convertSettleVOToSettlePoolVO(SettleVO settleVO, SettlePoolVO poolVO) {
        if (null == settleVO || null == poolVO) {
            logger.error("将结算单推送至结算池失败！原因：结算单对象为空或结算池对象为空，结算单对象 -> 结算池对象无法转换！");
            return;
        }
        logger.info("结算单对象 -> 结算池对象手动转换开始");
        poolVO.setSourceType(settleVO.getSettleType() == 0 ? SettleSourceTypeEnum.其他支出合同过程结算.getCode() : SettleSourceTypeEnum.其他支出合同最终结算.getCode());
        poolVO.setSettleProperty(0);// 属性类型：支出
        poolVO.setUltimateFlag(settleVO.getSettleType() == 1 ? 0 : null);// 是否最终结算：否
        poolVO.setLastTaxMny(settleVO.getLastTaxMny());// 累计结算金额（含税）
        poolVO.setLastMny(settleVO.getLastMny());// 累计结算金额（无税）
        poolVO.setLastTax(getSubStractAbs(settleVO.getLastTaxMny(), settleVO.getLastMny()));// 累计结算税额
        poolVO.setContractType("otherOut");
        ContractEntity ce = contractService.selectById(settleVO.getContractId());
        logger.info("结算单推送至结算池过程中，根据合同id查询合同，合同id-{}", settleVO.getContractId());
        if (ce == null) {
            logger.info("结算单推送至结算池过程中，根据合同id查询合同，合同id-{}，未查询到合同信息，故结算单的 主合同/甲方/乙方/签订日期/创建时间和人员/更新时间和人员 等信息无法推送至结算池", settleVO.getContractId());
            return;
        }
        // 主合同
        poolVO.setMaiContractId(ce.getMainContractId());
        poolVO.setMaiContractName(ce.getMainContractName());
        poolVO.setMaiContractCode(ce.getMainContractCode());
        // 甲方
        poolVO.setPartyaId(ce.getFirstPartyId());
        poolVO.setPartyaName(ce.getFirstPartyName());
        // 签订日期
        poolVO.setSignDate(ce.getSignDate());
        // 创建时间和人员 使用 结算单的创建时间和人员
        poolVO.setCreateTime(settleVO.getCreateTime());
        poolVO.setCreateUserCode(settleVO.getCreateUserCode());
        // 更新时间和人员 使用 结算单的更新时间和人员
        poolVO.setUpdateTime(settleVO.getUpdateTime());
        poolVO.setUpdateUserCode(settleVO.getUpdateUserCode());
        logger.info("结算单对象 -> 结算池对象手动转换完成，下面开始推送至结算池");
    }

    // 从结算池中删除数据
    @Override
    public boolean delSettleFromPool(Long id) {
        SettlePoolVO spv = new SettlePoolVO();
        spv.setSourceId(id);

        CommonResponse<SettlePoolVO> res = settlePoolApi.deleteSettle(spv);
        if (res.isSuccess()) {
            logger.info("将结算单从结算池中删除成功！结算单id-{}", id);
            return true;
        }

        logger.error("将结算单从结算池中删除失败！结算单id-{}，{}", id, res.getMsg());
        return false;
    }

    /**
     * 计算差值
     *
     * @param a 变量a
     * @param b 变量b
     * @return 差值的绝对值，当其中一个变量为null时 或 计算出来的差值为null时 返回null
     */
    private BigDecimal getSubStractAbs(BigDecimal a, BigDecimal b) {
        if (a == null || b == null) {
            return null;
        }
        BigDecimal subtract = a.subtract(b);
        if (subtract == null) {
            return null;
        }
        return subtract.abs();
    }

    @Override
    public ExecutionVO targetCost(SettleVO settleVO, String linkUrl) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        List<DetailExecutionVO> detailList = new ArrayList<>();
        totalVO.setSourceId(settleVO.getId());
        totalVO.setTenantId(settleVO.getTenantId());
        totalVO.setBillCode(settleVO.getBillCode());
        totalVO.setOrgId(settleVO.getOrgId());
        totalVO.setBillType("BT220308000000001");
        totalVO.setBussinessType(BussinessTypeEnum.其他支出合同.getCode());
        totalVO.setBillCategory(BillCategoryEnum.合同.getCode());
        if (settleVO.getProjectId() == null) {
            throw new BusinessException("目标成本推送失败,请更换项目");
        } else {
            totalVO.setProjectId(settleVO.getProjectId());
        }
        if (settleVO.getOrgId() == null) {
            throw new BusinessException("目标成本推送失败,请更换项目");
        } else {
            totalVO.setOrgId(settleVO.getOrgId());
        }
        totalVO.setMoney(settleVO.getMny()); //总计划金额无税
        totalVO.setTaxMoney(settleVO.getTaxMny()); //总计划金额
        totalVO.setLinkUrl(linkUrl);
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }


    @Override
    public ParamsCheckVO mnyCtrl(SettleVO settleVO, Boolean flag) {

        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();

        CommonResponse<BillParamVO> billParamByCode = paramConfigApi.getBillParamByCode(PRO_OTHER_CHECK_PARAM_NAME);
        if (!billParamByCode.isSuccess() || null == billParamByCode.getData()) {
//            logger.info("获取控制参数配置失败！");
//            throw new BusinessException("获取控制参数配置失败！");
            return paramsCheckVO;
        }
        BillParamVO billParamVO = billParamByCode.getData();

        // 控制规则值
        BigDecimal roleValue = billParamVO.getRoleValue();

        // 默认控制方式为提醒
        if (1 == billParamVO.getControlType()) {
            paramsCheckVO.setWarnType(paramsArray[1]);
        } else {
            paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
        }

        if (!"none".equals(paramsCheckVO.getWarnType())) {
            // 金额计算

            // 最新版本合同金额，最新的合同金额
            ContractEntity contract = contractService.selectById(settleVO.getContractId());
            if (null == contract) {
                logger.info("获取合同信息失败！");
                throw new BusinessException("获取合同信息失败！");
            }

            // 本次月度结算金额
            BigDecimal taxMny = settleVO.getTaxMny();
            // 含本次累计月度结算金额
            BigDecimal totalTaxMny = this.getLastTaxMny(settleVO.getContractId(), taxMny, flag);
            // 合同金额
            BigDecimal contractTaxMny = this.getContractTaxMny(contract.getContractTaxMny(), roleValue);

            // 控制金额
            if (totalTaxMny.compareTo(contractTaxMny) > 0) {
                // 超结金额
                BigDecimal overTaxMny = this.getOverTaxMny(totalTaxMny, contractTaxMny);

                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                paramsCheckDsVO.setWarnItem("合同超结");
                paramsCheckDsVO.setWarnName("累计结算金额大于合同金额");

                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("本次结算金额：").append(taxMny.setScale(2, RoundingMode.DOWN)).append("，含本次累计结算金额：").append(totalTaxMny.setScale(2, RoundingMode.DOWN))
                        .append("，合同金额*").append(roleValue).append("%：").append(contractTaxMny.setScale(2, RoundingMode.DOWN)).append("。超结金额：").append(overTaxMny.setScale(2, RoundingMode.DOWN));

                paramsCheckDsVO.setContent(String.valueOf(stringBuffer));
                checkDsVOS.add(paramsCheckDsVO);
                paramsCheckVO.setDataSource(checkDsVOS);
            } else {
                paramsCheckVO.setWarnType(paramsArray[0]);
            }
        }

        return paramsCheckVO;
    }


    /**
     * 获取含本期累计结算金额
     *
     * @param contractId 合同id
     * @param taxMny     本期结算金额
     * @return 含本期累计结算金额
     */
    @Override
    public BigDecimal getLastTaxMny(Long contractId, BigDecimal taxMny, Boolean flag) {
        Assert.notNull(contractId, "合同id不能为空");
        Assert.notNull(taxMny, "本期结算金额不能为空");

        ArrayList<Integer> billState = new ArrayList<>();
        billState.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billState.add(BillStateEnum.PASSED_STATE.getBillStateCode());

        QueryWrapper<SettleEntity> qw = new QueryWrapper<>();
        qw.eq("contract_id", contractId);
        qw.in("bill_state", billState);
        List<SettleEntity> settles = super.list(qw);

        if (CollectionUtils.isEmpty(settles)) {
            return taxMny;
        }

        // 查看预警标识
        if (Boolean.TRUE.equals(flag)) {
            taxMny = BigDecimal.ZERO;
        }
        return settles.stream().map(SettleEntity::getTaxMny).reduce(taxMny, BigDecimal::add);
    }

    /**
     * 获取超结金额
     *
     * @param totalTaxMny    含本期累计结算金额
     * @param contractTaxMny 合同金额
     * @return 超结金额
     */
    @Override
    public BigDecimal getOverTaxMny(BigDecimal totalTaxMny, BigDecimal contractTaxMny) {
        // 判空断言
        Assert.notNull(totalTaxMny, "含本期累计结算金额不能为空");
        Assert.notNull(contractTaxMny, "合同金额不能为空");

        return totalTaxMny.subtract(contractTaxMny);
    }

    /**
     * 计算合同金额
     *
     * @param contractTaxMny 合同金额
     * @param roleValue      控制规则值
     * @return 合同金额
     */
    @Override
    public BigDecimal getContractTaxMny(BigDecimal contractTaxMny, BigDecimal roleValue) {
        // 判空断言
        Assert.notNull(contractTaxMny, "合同金额不能为空");
        Assert.notNull(roleValue, "控制规则值不能为空");

        return contractTaxMny.multiply(roleValue.divide(BigDecimal.valueOf(100), 2, RoundingMode.HALF_UP));
    }

    @Override
    public void costPush(SettleEntity settleEntity) {
        logger.info("开始costPush");
        String newRelationFlag = associatedFlag(settleEntity);
        //更新是否关联
        LambdaUpdateWrapper<SettleEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(SettleEntity::getId, settleEntity.getId());
        updateWrapper.set(SettleEntity::getRelationFlag, newRelationFlag);//(1:是，0：否)
        super.update(updateWrapper);
        //判断之前的单据是否关联
        String oldRelationFlag = settleEntity.getRelationFlag();
        if ("1".equals(oldRelationFlag)) {
            if ("1".equals(newRelationFlag)) {
                saveCost(settleEntity);
            }
            if (!"1".equals(newRelationFlag)) {
                //删除成本中心之前的数据
                logger.info("删除成本中心之前的数据-领料出库Id---{}",settleEntity.getId());
                CommonResponse<String> commonResponse = costDetailApi.deleteSubject(settleEntity.getId());
                logger.info("结果"+ JSONObject.toJSONString(commonResponse));
                if(!commonResponse.isSuccess()){
                    throw new BusinessException(commonResponse.getMsg());
                }
            }
        }
        //之前未关联
        if ("0".equals(oldRelationFlag)) {
            if ("1".equals(newRelationFlag)) {
                //税率
                saveCost(settleEntity);
            }
        }
    }
    @Override
    public void costDeletePush(SettleEntity settleEntity) {
        logger.info("弃审推送成本---");
        logger.info("删除成本中心之前的数据-结算单Id---{}",settleEntity.getId());
        CommonResponse<String> stringCommonResponse = costDetailApi.deleteSubject(settleEntity.getId());
        logger.info("结果"+ JSONObject.toJSONString(stringCommonResponse));
        if(!stringCommonResponse.isSuccess()){
            throw new BusinessException(stringCommonResponse.getMsg());
        }
        //更新是否关联
        LambdaUpdateWrapper<SettleEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(SettleEntity::getId, settleEntity.getId());
        updateWrapper.set(SettleEntity::getRelationFlag, "0");//(1:是，0：否)
        super.update(updateWrapper);
    }

    @Override
    public CommonResponse<SettleVO> pushCost(SettleVO settleVO) {
        SettleEntity settleEntity = baseMapper.selectById(settleVO.getId());
        if (CollectionUtils.isNotEmpty(settleVO.getDetailList())) {
            List<SettleDetailEntity> storeSubEntityList = BeanMapper.mapList(settleVO.getDetailList(), SettleDetailEntity.class);
            settleEntity.setDetailList(storeSubEntityList);
        }

        if (CollectionUtils.isNotEmpty(settleVO.getOtherList())) {
            List<SettleOtherEntity> otherEntities = BeanMapper.mapList(settleVO.getOtherList(), SettleOtherEntity.class);
            settleEntity.setOtherList(otherEntities);
        }
        super.saveOrUpdate(settleEntity, false);
        //推送数据
        costPush(settleEntity);
        return CommonResponse.success(BeanMapper.map(settleEntity, SettleVO.class));
    }

    /**
     * 是否可以关联实际成本
     *
     * @param settleEntity 结算实体
     * @return
     */
    private String associatedFlag(SettleEntity settleEntity) {
        List<SettleDetailEntity> detailList = settleEntity.getDetailList();
        List<SettleOtherEntity> otherList = settleEntity.getOtherList();
        String newRelationFlag = "1";
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(detailList)) {
            for (SettleDetailEntity detailEntity : detailList) {
                if (null == detailEntity.getDetailWbsId() || null == detailEntity.getDetailSubjectId()) {
                    newRelationFlag = "0";
                    break;
                }
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(otherList)) {
            for (SettleOtherEntity otherEntity : otherList) {
                if (null == otherEntity.getOtherWbsId() || null == otherEntity.getOtherSubjectId()) {
                    newRelationFlag = "0";
                    break;
                }

            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(otherList) &&
                com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(detailList)
        ) {
            newRelationFlag = "0";
        }
        return newRelationFlag;
    }


    private void saveCost(SettleEntity settleEntity) {
        logger.info("推送结算实体："+JSONObject.toJSONString(settleEntity));
        List<CostDetailVO> costDetailVOList = new ArrayList<>();
        List<SettleDetailEntity> detailList = settleEntity.getDetailList();
        List<SettleOtherEntity> otherList = settleEntity.getOtherList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(detailList)){
            for (SettleDetailEntity detailEntity:detailList){
                if (detailEntity.getSettleNum()!=null){
                    CostDetailVO costDetailVO = new CostDetailVO();
                    costDetailVO.setSubjectId(detailEntity.getDetailSubjectId());
                    costDetailVO.setSubjectCode(detailEntity.getDetailSubjectCode());
                    costDetailVO.setSubjectName(detailEntity.getDetailSubjectName());
                    costDetailVO.setWbsId(detailEntity.getDetailWbsId());
                    costDetailVO.setWbsCode(detailEntity.getDetailWbsCode());
                    costDetailVO.setWbsName(detailEntity.getDetailWbsName());
                    costDetailVO.setSourceId(detailEntity.getSettleId());
                    costDetailVO.setSourceDetailId(detailEntity.getId());


                    costDetailVO.setHappenTaxMny(detailEntity.getSettleTaxMny());
                    costDetailVO.setHappenMny(detailEntity.getSettleMny());
                    costDetailVO.setSourceTabType("SET_OTHER_DETAIL");
                    if (settleEntity.getSettleType()==1){
                        costDetailVO.setSourceType("FIN_OTHER_DE");
                    }
                    if (settleEntity.getSettleType()==0){
                        costDetailVO.setSourceType("PRO_OTHER_DE");
                    }
                    costDetailVO.setHappenDate(detailEntity.getSettleDate());
                    costDetailVO.setCreateUserName(detailEntity.getCreateUserCode());
                    costDetailVO.setProjectId(detailEntity.getProjectId());
                    costDetailVOList.add(costDetailVO);
                }

            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(otherList)){
            for (SettleOtherEntity otherEntity:otherList){
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(otherEntity.getOtherSubjectId());
                costDetailVO.setSubjectCode(otherEntity.getOtherSubjectCode());
                costDetailVO.setSubjectName(otherEntity.getOtherSubjectName());
                costDetailVO.setWbsId(otherEntity.getOtherWbsId());
                costDetailVO.setWbsCode(otherEntity.getOtherWbsCode());
                costDetailVO.setWbsName(otherEntity.getOtherWbsName());
                costDetailVO.setSourceId(otherEntity.getSettleId());
                costDetailVO.setSourceDetailId(otherEntity.getId());
                costDetailVO.setHappenTaxMny(otherEntity.getTaxMny());
                costDetailVO.setHappenMny(otherEntity.getMny());
                costDetailVO.setHappenDate(otherEntity.getCreateTime());
                costDetailVO.setCreateUserName(otherEntity.getCreateUserCode());
                if (settleEntity.getSettleType()==1){
                    costDetailVO.setSourceType("FIN_OTHER_OT");
                }
                if (settleEntity.getSettleType()==0){
                    costDetailVO.setSourceType("PRO_OTHER_OT");
                }

                costDetailVO.setSourceTabType("SET_OTHER_OTHER");
                costDetailVO.setProjectId(otherEntity.getProjectId());
                costDetailVOList.add(costDetailVO);
            }
        }
        //成本中心
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(costDetailVOList)) {
            logger.info("推送数据--------"+JSONObject.toJSONString(costDetailVOList));
            CommonResponse<String> stringCommonResponse = costDetailApi.saveSubject(costDetailVOList);
            logger.info("推送结果--------"+JSONObject.toJSONString(stringCommonResponse));
            if (stringCommonResponse.isSuccess()) {
            } else {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }
}
