package com.ejianc.business.proother.relieve.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.proother.relieve.bean.ContractRelieveEntity;
import com.ejianc.business.proother.relieve.service.IContractRelieveService;
import com.ejianc.business.proother.relieve.service.IRelieveSignatureService;
import com.ejianc.business.proother.relieve.vo.ContractRelieveVO;
import com.ejianc.business.proother.contract.bean.ContractEntity;
import com.ejianc.business.proother.enums.PerformanceStatusEnum;
import com.ejianc.business.proother.enums.SignatureStatusEnum;
import com.ejianc.business.proother.contract.service.IContractService;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * @author baipengyan
 */
@Service("relieveSignatureService")
public class RelieveSignatureServiceImpl implements IRelieveSignatureService {

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Value("${contract.relieveContract}")
    private String relieveContract;

    @Autowired
    private IContractRelieveService service;

    @Autowired
    private IContractService contractService;

    @Value("${common.env.base-host}")
    private String BaseHost;

    @Autowired
    private IExecutionApi executionApi;

    /**
     * 更新合同解除单据签章状态和合同状态
     *
     * @param id              合同解除单据id
     * @param signatureStatus 签章状态
     * @param refCode         唯一标识
     * @return 结果数据
     */
    @Override
    public CommonResponse<String> relieveContract(Long id, String signatureStatus, String refCode) {
        logger.info("更新合同解除单据签章状态和合同状态，入参--id；{}，signatureStatus：{}，refCode：{}", id, signatureStatus, refCode);
        // 判断是否是合同解除标识
        if (refCode.equals(relieveContract)) {
            ContractRelieveEntity contractRelieveEntity = service.selectById(id);
            contractRelieveEntity.setSignatureStatus(signatureStatus);

            // 查询合同的信息
            ContractEntity contractEntity = contractService.selectById(contractRelieveEntity.getContractId());
            if (contractEntity == null) {
                throw new BusinessException("查询不到可修改状态的合同！");
            }
            logger.info("即将修改的合同信息--{}", JSONObject.toJSONString(contractEntity));
            // 签章状态：4-已签章，履约中允许解除（冻结及其他状态不能解除）
            if (SignatureStatusEnum.已签章.getCode().equals(signatureStatus) && PerformanceStatusEnum.履约中.getCode().equals(contractEntity.getPerformanceStatus())) {
                // 更新合同解除单据生效时间
                contractRelieveEntity.setEffectiveDate(new Date());
                // 更新合同状态为已作废
                contractEntity.setPerformanceStatus(PerformanceStatusEnum.已封账.getCode());
                contractService.saveOrUpdate(contractEntity, false);
                logger.info("合同已作废！");

                // 解除单生效->推送目标成本
                String linkUrl = BaseHost+"ejc-proother-frontend/#/contractRelieve/Card?id=" + contractRelieveEntity.getId();
                ExecutionVO executionVO = service.targetCost(BeanMapper.map(contractRelieveEntity, ContractRelieveVO.class),linkUrl);
                logger.info("目标成本推送数据"+ JSON.toJSONString(executionVO));
                CommonResponse<String> response = executionApi.aggPush(executionVO);
                if (!response.isSuccess()){
                    throw new BusinessException("目标成本推送失败,"+response.getMsg());
                }
            }
            service.saveOrUpdate(contractRelieveEntity, false);
            return CommonResponse.success("合同解除单据签章状态更新成功！");
        } else {
            return CommonResponse.error("合同解除单据签章状态更新失败！");
        }
    }
}
