package com.ejianc.business.proother.freeze.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.proother.freeze.bean.FreezeEntity;
import com.ejianc.business.proother.freeze.service.IFreezeService;
import com.ejianc.business.proother.contract.bean.ContractEntity;
import com.ejianc.business.proother.enums.PerformanceStatusEnum;
import com.ejianc.business.proother.contract.service.IContractService;
import com.ejianc.business.proother.contract.vo.ContractVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

@Service("freeze")
public class FreezeBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private SessionManager sessionManager;
	@Autowired
	private IFreezeService service;

	@Autowired
	private IContractService contractService;

	@Autowired
	private IBillTypeApi billTypeApi;

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		FreezeEntity e = service.selectById(billId);
		UserContext userContext = sessionManager.getUserContext();
		e.setCommitDate(new Date());
		e.setCommitUserCode(userContext.getUserCode());
		e.setCommitUserName(userContext.getUserName());
		logger.info("======提交完回调======,{}", JSONObject.toJSONString(e));
		service.saveOrUpdate(e, false);
		return CommonResponse.success("冻结解冻审批回调处理成功");
	}
	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		FreezeEntity e = service.selectById(billId);
		UserContext userContext = sessionManager.getUserContext();
		e.setCommitDate(new Date());
		e.setCommitUserCode(userContext.getUserCode());
		e.setCommitUserName(userContext.getUserName());
		logger.info("======提交完回调======,{}", JSONObject.toJSONString(e));
		service.saveOrUpdate(e, false);
		return CommonResponse.success("冻结解冻审批回调处理成功");
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//修改合同状态
		logger.info("afterApprovalProcessor 终审审核完回调 触发");
		FreezeEntity entity = service.selectById(billId);
		if (entity != null){
			entity.setEffectiveDate(new Date());
			service.saveOrUpdate(entity, false);
			QueryParam param = new QueryParam();
			param.getParams().put("id", new Parameter(QueryParam.EQ, entity.getContractId()));
			logger.error("合同查询参数"+JSONObject.toJSONString(param));
			List<ContractEntity> contractEntities = contractService.queryList(param, false);
			if(entity.getPerformanceStatus()==5){
				//当前是冻结的
				contractEntities.get(0).setPerformanceStatus(PerformanceStatusEnum.已冻结.getCode());
			}else if (entity.getPerformanceStatus()==2){
				//当前是解冻的
				contractEntities.get(0).setPerformanceStatus(PerformanceStatusEnum.履约中.getCode());
			}
			logger.error("终审审核完回调"+JSONObject.toJSONString(contractEntities.get(0)));
			contractService.saveOrUpdate(contractEntities.get(0), false);
			ContractVO contractVO = contractService.queryDetail(contractEntities.get(0).getId());
			logger.error("终审审核完回调 contractVO:"+JSONObject.toJSONString(contractVO));
		}
		return CommonResponse.success("合同冻结/解冻 终审审核完回调处理成功!！");
	}
	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	}
	private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
		//判断当前冻结单是否最新的冻结单，如果是才可撤回
		FreezeEntity entity = service.selectById(billId);
		if (null != entity && null != entity.getContractId()){
			FreezeEntity freezeEntity = service.selectMaxDateFreeze(entity.getContractId());
			logger.info("当前审批中的冻结单结果：entity-->", JSONObject.toJSONString(entity, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
			logger.info("查询最新的冻结单结果：freezeEntity-->", JSONObject.toJSONString(freezeEntity, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
			if (null != freezeEntity && freezeEntity.getCreateTime().compareTo(entity.getCreateTime()) > 0){
				return CommonResponse.error("当前单据不是最新单据，不能撤回或弃审！");
			}
		}

		//合同是否被其他单据引用
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况" + res.isSuccess() + "----" + res.getMsg());
		if (!res.isSuccess()) {
			return CommonResponse.error("当前单据已被下游业务引用，不能弃审！");
		}
        //撤回时把合同状态改为履约中
        if (null != entity && null != entity.getContractId()){
            ContractEntity contractEntity = contractService.selectById(entity.getContractId());
            contractEntity.setPerformanceStatus(PerformanceStatusEnum.履约中.getCode());
            logger.info("撤回时修改合同状态" + JSONObject.toJSONString(contractEntity, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
            contractService.saveOrUpdate(contractEntity, false);
        }

		return CommonResponse.success("弃审/撤回前校验回调成功！");
	}


}
