/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proother.freeze.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.proother.contract.bean.ContractEntity;
import com.ejianc.business.proother.contract.service.IContractService;
import com.ejianc.business.proother.contract.vo.ContractVO;
import com.ejianc.business.proother.freeze.bean.FreezeEntity;
import com.ejianc.business.proother.freeze.service.IFreezeService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="freeze")
public class FreezeBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IFreezeService service;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IBillTypeApi billTypeApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        FreezeEntity e = (FreezeEntity)((Object)this.service.selectById(billId));
        UserContext userContext = this.sessionManager.getUserContext();
        e.setCommitDate(new Date());
        e.setCommitUserCode(userContext.getUserCode());
        e.setCommitUserName(userContext.getUserName());
        this.logger.info("======\u63d0\u4ea4\u5b8c\u56de\u8c03======,{}", (Object)JSONObject.toJSONString((Object)((Object)e)));
        this.service.saveOrUpdate((Object)e, false);
        return CommonResponse.success((String)"\u51bb\u7ed3\u89e3\u51bb\u5ba1\u6279\u56de\u8c03\u5904\u7406\u6210\u529f");
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        FreezeEntity e = (FreezeEntity)((Object)this.service.selectById(billId));
        UserContext userContext = this.sessionManager.getUserContext();
        e.setCommitDate(new Date());
        e.setCommitUserCode(userContext.getUserCode());
        e.setCommitUserName(userContext.getUserName());
        this.logger.info("======\u63d0\u4ea4\u5b8c\u56de\u8c03======,{}", (Object)JSONObject.toJSONString((Object)((Object)e)));
        this.service.saveOrUpdate((Object)e, false);
        return CommonResponse.success((String)"\u51bb\u7ed3\u89e3\u51bb\u5ba1\u6279\u56de\u8c03\u5904\u7406\u6210\u529f");
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("afterApprovalProcessor \u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03 \u89e6\u53d1");
        FreezeEntity entity = (FreezeEntity)((Object)this.service.selectById(billId));
        if (entity != null) {
            entity.setEffectiveDate(new Date());
            this.service.saveOrUpdate((Object)entity, false);
            QueryParam param = new QueryParam();
            param.getParams().put("id", new Parameter("eq", (Object)entity.getContractId()));
            this.logger.error("\u5408\u540c\u67e5\u8be2\u53c2\u6570" + JSONObject.toJSONString((Object)param));
            List contractEntities = this.contractService.queryList(param, false);
            if (entity.getPerformanceStatus() == 5) {
                ((ContractEntity)((Object)contractEntities.get(0))).setPerformanceStatus(ContractPerformanceStateEnum.\u5df2\u51bb\u7ed3.getStateCode());
            } else if (entity.getPerformanceStatus() == 2) {
                ((ContractEntity)((Object)contractEntities.get(0))).setPerformanceStatus(ContractPerformanceStateEnum.\u5c65\u7ea6\u4e2d.getStateCode());
            }
            this.logger.error("\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03" + JSONObject.toJSONString(contractEntities.get(0)));
            this.contractService.saveOrUpdate(contractEntities.get(0), false);
            ContractVO contractVO = this.contractService.queryDetail(((ContractEntity)((Object)contractEntities.get(0))).getId());
            this.logger.error("\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03 contractVO:" + JSONObject.toJSONString((Object)contractVO));
        }
        return CommonResponse.success((String)"\u5408\u540c\u51bb\u7ed3/\u89e3\u51bb \u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03\u5904\u7406\u6210\u529f!\uff01");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        FreezeEntity entity = (FreezeEntity)((Object)this.service.selectById(billId));
        if (null != entity && null != entity.getContractId()) {
            FreezeEntity freezeEntity = this.service.selectMaxDateFreeze(entity.getContractId());
            this.logger.info("\u5f53\u524d\u5ba1\u6279\u4e2d\u7684\u51bb\u7ed3\u5355\u7ed3\u679c\uff1aentity-->", (Object)JSONObject.toJSONString((Object)((Object)entity), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
            this.logger.info("\u67e5\u8be2\u6700\u65b0\u7684\u51bb\u7ed3\u5355\u7ed3\u679c\uff1afreezeEntity-->", (Object)JSONObject.toJSONString((Object)((Object)freezeEntity), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
            if (null != freezeEntity && freezeEntity.getCreateTime().compareTo(entity.getCreateTime()) > 0) {
                return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u4e0d\u662f\u6700\u65b0\u5355\u636e\uff0c\u4e0d\u80fd\u64a4\u56de\u6216\u5f03\u5ba1\uff01");
            }
        }
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u5f03\u5ba1\uff01");
        }
        if (null != entity && null != entity.getContractId()) {
            ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
            contractEntity.setPerformanceStatus(ContractPerformanceStateEnum.\u5c65\u7ea6\u4e2d.getStateCode());
            this.logger.info("\u64a4\u56de\u65f6\u4fee\u6539\u5408\u540c\u72b6\u6001" + JSONObject.toJSONString((Object)((Object)contractEntity), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
            this.contractService.saveOrUpdate((Object)contractEntity, false);
        }
        return CommonResponse.success((String)"\u5f03\u5ba1/\u64a4\u56de\u524d\u6821\u9a8c\u56de\u8c03\u6210\u529f\uff01");
    }
}

