/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proother.contract.service.impl;

import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.proother.contract.bean.ChangeEntity;
import com.ejianc.business.proother.contract.bean.ContractEntity;
import com.ejianc.business.proother.contract.service.IChangeService;
import com.ejianc.business.proother.contract.service.IContractAsyncService;
import com.ejianc.business.proother.contract.service.IContractService;
import com.ejianc.business.proother.enums.DraftTypeEnum;
import com.ejianc.business.proother.enums.ProotherBillTypeEnum;
import com.ejianc.business.signaturemanage.vo.InitSignatoryVO;
import com.ejianc.business.signaturemanage.vo.InitSignatureVO;
import com.ejianc.business.signaturemanage.vo.OldSignatoryVO;
import com.ejianc.business.signaturemanage.vo.SealInfoVO;
import com.ejianc.business.signaturemanage.vo.WatermarkVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Recover;
import org.springframework.retry.annotation.Retryable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service(value="ContractAsyncService")
public class ContractAsyncServiceImpl
implements IContractAsyncService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Value(value="${qiyuesuo.contract.categoryId}")
    private Long categoryId;
    @Autowired
    private IContractService service;
    @Autowired
    private IChangeService changeService;

    @Override
    @Async(value="commonTask")
    @Retryable(maxAttempts=3, backoff=@Backoff(delay=2000L, multiplier=1.5), stateful=true)
    public void fetchWatermarkAttachment(HashMap<String, String> headers, WatermarkVO watermarkVO) {
        this.logger.info("\u5f02\u6b65\u83b7\u53d6\u6c34\u5370\u6587\u4ef6\u9644\u4ef6\u4fe1\u606f\u5f00\u59cb\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)watermarkVO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        Stopwatch start = Stopwatch.createStarted();
        String body = ((HttpRequest)HttpRequest.post((String)(this.BaseHost + "ejc-signaturemanage-web/common/fetchWatermarkAttachment")).addHeaders(headers)).body(JSON.toJSONString((Object)watermarkVO)).timeout(60000).execute().body();
        AttachmentVO attachmentVO = (AttachmentVO)JSON.parseObject((String)body, AttachmentVO.class);
        this.logger.info("\u5f02\u6b65\u83b7\u53d6\u6c34\u5370\u6587\u4ef6\u9644\u4ef6\u4fe1\u606f\u7ed3\u675f\uff0c\u8bf7\u6c42\u7b7e\u7ae0\u4e2d\u5fc3\u8017\u65f6\u300c{}\u300d\u79d2\uff0c\u6587\u4ef6\u4e2d\u5fc3\u7684\u6c34\u5370\u6587\u4ef6\u4fe1\u606f\uff1a{}", (Object)start.stop().elapsed(TimeUnit.SECONDS), (Object)JSON.toJSONString((Object)attachmentVO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        start.reset().start();
        boolean flag = false;
        if (ProotherBillTypeEnum.\u5176\u4ed6\u652f\u51fa\u5408\u540c.getBillTypeCode().equals(watermarkVO.getBillType())) {
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.eq((Object)"id", (Object)watermarkVO.getBillId());
            updateWrapper.set((Object)"watermark_contract_file_id", (Object)attachmentVO.getId());
            flag = this.service.update((Wrapper)updateWrapper);
            ContractEntity entity = (ContractEntity)((Object)this.service.getById(watermarkVO.getBillId()));
            this.sendSignature(entity.getDraftType(), watermarkVO.getBillId(), entity.getBillCode(), entity.getContractName(), entity.getWatermarkContractFileId(), watermarkVO.getBillType(), headers);
        } else if (ProotherBillTypeEnum.\u5176\u4ed6\u5408\u540c\u53d8\u66f4.getBillTypeCode().equals(watermarkVO.getBillType())) {
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.eq((Object)"id", (Object)watermarkVO.getBillId());
            updateWrapper.set((Object)"watermark_contract_file_id", (Object)attachmentVO.getId());
            flag = this.changeService.update((Wrapper)updateWrapper);
            ChangeEntity entity = (ChangeEntity)((Object)this.changeService.getById(watermarkVO.getBillId()));
            this.sendSignature(entity.getDraftType(), watermarkVO.getBillId(), entity.getBillCode(), entity.getContractName(), entity.getWatermarkContractFileId(), watermarkVO.getBillType(), headers);
        }
        if (flag) {
            this.logger.info("\u83b7\u53d6\u6c34\u5370\u6587\u4ef6\u9644\u4ef6\u4fe1\u606f\u5e76\u66f4\u65b0\u5408\u540c\u6210\u529f\uff0c\u5199\u5165\u6570\u636e\u5e93\u8017\u65f6\u300c{}\u300d\u79d2\uff0c\u5408\u540cid\uff1a{}\uff0c\u539f\u5408\u540c\u6587\u4ef6id\uff1a{}\uff0c\u6c34\u5370\u5408\u540c\u6587\u4ef6id\uff1a{}", new Object[]{start.stop().elapsed(TimeUnit.SECONDS), watermarkVO.getBillId(), watermarkVO.getFileId(), attachmentVO.getId()});
        }
    }

    @Recover
    public void recordWatermark(Exception e, HashMap<String, String> headers, WatermarkVO watermarkVO) {
        this.logger.error("\u83b7\u53d6\u6c34\u5370\u6587\u4ef6\u9644\u4ef6\u4fe1\u606f\u5e76\u66f4\u65b0\u5408\u540c\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)watermarkVO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
    }

    public void sendSignature(String draftType, Long billId, String billCode, String contractName, Long watermarkContractFileId, String billType, HashMap<String, String> headers) {
        this.logger.info("\u53e6\u884c\u7b7e\u7f72\u5408\u540c\u8fdb\u5165\u65e0\u5916\u89c2\u7b7e\u7ae0\u6d41\u7a0b\uff01-------------------------------------------");
        if (DraftTypeEnum.\u7ebf\u4e0b\u7b7e\u8ba2.getCode().equals(draftType) || DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349\u4e0d\u4f7f\u7528\u7535\u5b50\u7b7e\u7ae0.getCode().equals(draftType)) {
            this.logger.info("\u53e6\u884c\u7b7e\u7f72\u5408\u540c\u8fdb\u5165\u65e0\u5916\u89c2\u7b7e\u7ae0\u6d41\u7a0b \uff01draftType :{}-------------------------------------------", (Object)draftType);
            InitSignatureVO initSignatureVO = new InitSignatureVO();
            initSignatureVO.setBillId(billId);
            initSignatureVO.setBillType(billType);
            initSignatureVO.setBillCode(billCode);
            initSignatureVO.setContractName(contractName);
            initSignatureVO.setBillRefCode("proSubContract");
            initSignatureVO.setBillDocId(watermarkContractFileId);
            initSignatureVO.setBillDocumentName(contractName);
            initSignatureVO.setTenantName("\u90d1\u5dde\u4e00\u5efa\u96c6\u56e2\u6709\u9650\u516c\u53f8");
            initSignatureVO.setCategoryId(this.categoryId);
            ArrayList<InitSignatoryVO> list = new ArrayList<InitSignatoryVO>();
            ArrayList<SealInfoVO> sealList = new ArrayList<SealInfoVO>();
            SealInfoVO sealInfoVO = new SealInfoVO();
            sealInfoVO.setSignActionType("CORPORATE");
            sealInfoVO.setName("\u4f01\u4e1a\u7b7e\u7ae0");
            sealInfoVO.setSealSignOrder(Integer.valueOf(1));
            ArrayList<OldSignatoryVO> signatoryList = new ArrayList<OldSignatoryVO>();
            OldSignatoryVO oldSignatoryVO = new OldSignatoryVO();
            oldSignatoryVO.setSignatureName("\u5b59\u6653\u4e00");
            oldSignatoryVO.setSignatureId(Long.valueOf(1502571539046862850L));
            oldSignatoryVO.setSignatureContact("16637272109");
            signatoryList.add(oldSignatoryVO);
            sealInfoVO.setSignatoryVOList(signatoryList);
            sealList.add(sealInfoVO);
            InitSignatoryVO initSignatoryVO = new InitSignatoryVO();
            initSignatoryVO.setTenantName("\u90d1\u5dde\u4e00\u5efa\u96c6\u56e2\u6709\u9650\u516c\u53f8");
            initSignatoryVO.setTenantType("COMPANY");
            initSignatoryVO.setSignatureType(Integer.valueOf(0));
            initSignatoryVO.setSignOrder(Integer.valueOf(1));
            initSignatoryVO.setSignatureList(sealList);
            list.add(initSignatoryVO);
            initSignatureVO.setSignMgrSignatoryEntities(list);
            String body = ((HttpRequest)HttpRequest.post((String)(this.BaseHost + "ejc-signaturemanage-web/api/signaturemanage/sendSignatureZzyj")).addHeaders(headers)).body(JSON.toJSONString((Object)initSignatureVO)).timeout(60000).execute().body();
            this.logger.info("\u53e6\u884c\u7b7e\u7f72\u5408\u540c\u65e0\u5916\u89c2\u7b7e\u7ae0\u6d41\u7a0b\u7ed3\u675f,body:{} \uff01", (Object)body);
        }
    }
}

